package com.biz.crm.tpm.business.scheme.forecast.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.DetailedForecastRequestVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoRefreshDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.SchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastAutoRefreshDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.SchemeForecastService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.bizunited.nebula.script.context.InvokeProxyContext;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 * 方案预测定时刷新
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-16
 */
@Slf4j
@Service
public class SchemeForecastAutoRefreshXxlJob {

    @Autowired(required = false)
    private SchemeForecastService schemeForecastService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    /**
     * 方案预测定时刷新，每天同步一次
     */
    public void autoRefresh() {
        log.info("=====>     方案预测定时刷新[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        String yearMonthDay = DateUtil.getDate(DateUtil.DEFAULT_YEAR_MONTH_DAY);
        String key1 = SchemeForecastConstants.REFRESH_PAGE_KEY + yearMonthDay;
        try {
            Pageable page = PageRequest.of(1, 2000);
            int index = 1;
            if (redisService.hasKey(SchemeForecastConstants.REFRESH_LOCK_KEY)) {
                Object o = redisService.get(SchemeForecastConstants.REFRESH_LOCK_KEY);
                String msg = "方案预测定时刷新进行中！开始时间：" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            String nowDateTime = DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN);
            //锁1个小时自然解锁
            redisService.set(SchemeForecastConstants.REFRESH_LOCK_KEY, nowDateTime, 60 * 60);
            SchemeForecastAutoRefreshDto dto = new SchemeForecastAutoRefreshDto();
            dto.setNowDateTime(nowDateTime);
            Long total = schemeForecastService.findAutoRefreshCount(dto);
            while (true) {
                List<String> list = schemeForecastService.findAutoRefreshDataList(page, dto);
                log.info("方案预测定时刷新：总数[{}]第[{}]页查询到[{}]条数据！", total, index, list.size());
                if (CollectionUtils.isEmpty(list)) {
                    break;
                }
                try {
                    String uuid = UUID.randomUUID().toString().replace("-", "");
                    redisService.hSet(SchemeForecastConstants.REFRESH_IDS_KEY, uuid, JSON.toJSONString(list), 60 * 60 * 48);//定时任务每天跑，缓存2天够了
                    MqMessageVo mqMessageVo = new MqMessageVo();
                    mqMessageVo.setMsgBody(uuid);
                    mqMessageVo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                    mqMessageVo.setTag(ActivityPlanPassMqTagConstant.SCHEME_FORECAST_REFRESH);
                    rocketMqProducer.sendMqMsg(mqMessageVo);
                    Page<DetailedForecastRequestVo> result = new Page<>();
                    result.setTotal(list.size());
                    result.setCurrent(page.getPageNumber());
                    result.setSize(page.getPageSize());
                    redisService.set(key1, JSONObject.toJSONString(result), 60 * 60 * 72);
                    Thread.sleep(200);
                } catch (Exception e) {
                    e.printStackTrace();
                    log.error("方案预测定时刷新发送MQ失败！总数[{}]第[{}]页,{}", total, index, e.getMessage());
                }
                index++;
                page = PageRequest.of(index, 2000);
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error("方案预测定时刷新异常：" + e.getMessage(), e);
        }
        log.info("=====>     方案预测定时刷新[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
