package com.biz.crm.tpm.business.scheme.forecast.local.service.internal;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.scheme.forecast.local.model.SchemeForecastImportsVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.SchemeForecastService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.*;

/**
 * @author youjun
 * @date 2022年11月10日 15:49
 */
@Slf4j
@Component
public class SchemeForecastImportsProcess implements ImportProcess<SchemeForecastImportsVo> {
    @Resource
    private SchemeForecastService schemeForecastService;

    @Resource
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, SchemeForecastImportsVo> data,
                                        TaskGlobalParamsVo paramsVo,
                                        Map<String, Object> params) {
        Validate.notEmpty(data, "导入数据不能为空！");

        List<SchemeForecastDto> importList = this.validate(data);

        schemeForecastService.importSave(importList);
        return null;
    }

    /**
     * 校验并转换数据
     *
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto>
     * @author youjun
     * @date 2022/11/10 9:58
     **/
    private List<SchemeForecastDto> validate(LinkedHashMap<Integer, SchemeForecastImportsVo> data) {
        List<SchemeForecastImportsVo> schemeForecastImportsVos = new ArrayList<>(data.values());

        // TODO:根据配置表校验
        schemeForecastImportsVos.forEach(importsVo -> {

        });
        Collection<SchemeForecastDto> schemeForecastDtoList = nebulaToolkitService.copyCollectionByWhiteList(schemeForecastImportsVos, SchemeForecastImportsVo.class, SchemeForecastDto.class, LinkedHashSet.class, ArrayList.class);
        return new ArrayList<>(schemeForecastDtoList);
    }

    @Override
    public Class<SchemeForecastImportsVo> findCrmExcelVoClass() {
        return SchemeForecastImportsVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "TPM_SCHEME_FORECAST";
    }

    @Override
    public String getTemplateName() {
        return "TPM方案预测导入";
    }
}
