package com.biz.crm.tpm.business.scheme.forecast.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.SchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastAutoCreateDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.SchemeForecastService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * <p>
 * 方案测定时刷新展示状态
 * 更新showFlag字段，默认未Y，不展示更新为N
 * 1、主体要求不展示已关闭的明细，把明细对应的预测数据showFlag更新为N
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-16
 */
@Slf4j
@Service
public class SchemeForecastShowFlagRefreshXxlJob {

    @Autowired(required = false)
    private SchemeForecastService schemeForecastService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    /**
     * 细案预测定时刷新展示状态任务，7点开始个小时执行一次，默认检查更新时间3天内的活动
     */
    public void autoRefresh() {
        log.info("=====>    方案预测定时刷新展示状态[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        try {
            if (redisService.hasKey(SchemeForecastConstants.REFRESH_SHOW_FLAG_KEY)) {
                Object o = redisService.get(SchemeForecastConstants.REFRESH_SHOW_FLAG_KEY);
                String msg = "方案预测定时刷新展示状态进行中！开始时间：" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            String nowDateTime = DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN);
            //锁10分钟自然解锁
            redisService.set(SchemeForecastConstants.REFRESH_SHOW_FLAG_KEY, nowDateTime, 60 * 10);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_DATE_ALL_PATTERN);

            SchemeForecastAutoCreateDto dto = new SchemeForecastAutoCreateDto();
            dto.setModifyBeginDateTime(LocalDateTime.now().plusDays(-3).format(formatter));
            dto.setTenantCode(TenantUtils.getTenantCode());
            try {
                dto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
                Long count = schemeForecastService.autoUpdateShowFLag(dto);
                log.info("方案预测定时刷新展示状态===》主体===》{}", count);
            } catch (Exception e) {
                log.error("方案预测定时刷新展示状态===》主体===》异常：" + e.getMessage(), e);
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error("方案预测定时补创建异常：" + e.getMessage(), e);
        }
        log.info("=====>    方案预测定时刷新展示状态[{}] end    <=====", DateUtil.dateStrNowAll());
    }
}
