package com.biz.crm.tpm.business.scheme.forecast.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.YesOrNoEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.TpmHeadSchemeForecastRepository;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmHeadSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.log.TpmHeadSchemeForecastLogEventDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeStatusEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.event.TpmHeadSchemeForecastLogEventListener;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-10
 */
@Slf4j
@Component
public class TpmHeadSchemeForecastAsync {

    @Autowired(required = false)
    private TpmHeadSchemeForecastRepository tpmHeadSchemeForecastRepository;

    @Autowired(required = false)
    private VariableService variableService;

    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Transactional(rollbackFor = Exception.class)
    public void insert(TpmHeadSchemeForecastDto dto) {
        TpmHeadSchemeForecastEntity forecastEntity = this.nebulaToolkitService.copyObjectByWhiteList(dto, TpmHeadSchemeForecastEntity.class, null, null);


        String schemeForecastCode = generateCodeService.generateCode(TpmHeadSchemeForecastConstants.FORECAST_CODE_PREFIX, 1, 6, 2, TimeUnit.DAYS).get(0);
        forecastEntity.setSchemeForecastCode(schemeForecastCode);
        forecastEntity.setTenantCode(TenantUtils.getTenantCode());
        forecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        forecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        forecastEntity.setShowFlag(YesOrNoEnum.YES.getCode());
        forecastEntity.setStatus(TpmHeadSchemeStatusEnum.NONE.getCode());
        forecastEntity.setOnlyKey(this.packageOnlyKey(forecastEntity, null));
        forecastEntity.setHeadProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        forecastEntity.setRegionProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        this.tpmHeadSchemeForecastRepository.saveOrUpdate(forecastEntity);

        // 日志新增
        TpmHeadSchemeForecastLogEventDto logEventDto = new TpmHeadSchemeForecastLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<TpmHeadSchemeForecastLogEventListener, TpmHeadSchemeForecastLogEventDto> onCreate =
                TpmHeadSchemeForecastLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, DetailedForecastLogEventListener.class, onCreate);
    }

    /**
     * onlyKey生成
     *
     * @param entity
     * @return
     */
    public String packageOnlyKey(TpmHeadSchemeForecastEntity entity, String timeStamp) {
        if (StringUtils.isEmpty(timeStamp)) {
            timeStamp = "";
        }
        return DigestUtils.md5Hex(entity.getSchemeCode() + entity.getSchemeItemCode() + entity.getSalesRegionCode() + timeStamp);
    }

    /**
     * 新增数据
     *
     * @param schemeForecastDto
     * @param item
     * @param loginUser
     */
    @Async("asyncThread")
    public void createData(TpmHeadSchemeForecastDto schemeForecastDto, ActivityPlanItemDto item, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
//        1035559 【全环境-bug】主体方案预测表问题
        schemeForecastDto.setEstimatedWriteOffAmount(BigDecimal.ZERO);
        log.info("主体方案预测：方案编码[{}]明细编码[{}]新增计算", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode());
        if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditType())) {
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(schemeForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(schemeForecastDto.getBusinessUnitCode());
            dto.setAuditType(item.getAuditType());
            dto.setSalesOrgCodes(schemeForecastDto.getSalesOrgCode());
            dto.setActivityFormCode(schemeForecastDto.getActivityFormCode());
            dto.setActivityTypeCode(schemeForecastDto.getActivityTypeCode());
            dto.setWriteOffMethod(schemeForecastDto.getWriteOffMethod());
            List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), schemeForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                this.setParam(formulaMainVoList.get(0), schemeForecastDto, calDto);
            } else {
                schemeForecastDto.setAuditFormulaCode(null);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditType())) {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = auditFormulaMainService.findByCode(item.getAuditConditionCode());
            } catch (Exception e) {
                log.error("主体方案预测：方案编码[" + schemeForecastDto.getSchemeCode() + "]明细编码[" + schemeForecastDto.getSchemeItemCode() + "]新增计算" + e.getMessage(), e);
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, schemeForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
            this.setParam(auditFormulaMainVo, schemeForecastDto, calDto);
        } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(item.getAuditType())) {
            schemeForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
            schemeForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
        }
        if (StringUtils.isNotEmpty(schemeForecastDto.getRelatePlanItemCode())){
            ActivityPlanItemVo headPlanItem = activityPlanItemSdkService.findListByPlanItemCode(schemeForecastDto.getRelatePlanItemCode());
            if (null != headPlanItem){
                schemeForecastDto.setRelatePlanHeadFeeAmount(headPlanItem.getHeadFeeAmount());
                schemeForecastDto.setRelatePlanDepartmentFeeAmount(headPlanItem.getDepartmentFeeAmount());
            }
        }
        this.insert(schemeForecastDto);
    }

    @Async("asyncThread")
    @Transactional(rollbackFor = Exception.class)
    public void refreshUpdate(TpmHeadSchemeForecastEntity entity, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        TpmHeadSchemeForecastDto oldDto = nebulaToolkitService.copyObjectByWhiteList(entity, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);
        TpmHeadSchemeForecastDto dto = nebulaToolkitService.copyObjectByWhiteList(entity, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);
        this.refreshCal(dto);
        entity.setWriteOffConditions(dto.getWriteOffConditions());
        entity.setWriteOffFormula(dto.getWriteOffFormula());
        entity.setWriteOffConditionValue(dto.getWriteOffConditionValue());
        entity.setWriteOffFormulaValue(dto.getWriteOffFormulaValue());
        entity.setEstimatedWriteOffAmount(dto.getEstimatedWriteOffAmount());
        entity.setAuditFormulaCode(dto.getAuditFormulaCode());
        entity.setCalEx(dto.getCalEx());
        entity.setCalParam(dto.getCalParam());
        entity.setHeadFeeAmount(dto.getHeadFeeAmount());
        entity.setDepartmentFeeAmount(dto.getDepartmentFeeAmount());
        if (StringUtils.isEmpty(entity.getOnlyKey())) {
            entity.setOnlyKey(this.packageOnlyKey(entity, null));
        }
        this.tpmHeadSchemeForecastRepository.updateById(entity);

        // 日志编辑
        TpmHeadSchemeForecastLogEventDto logEventDto = new TpmHeadSchemeForecastLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<TpmHeadSchemeForecastLogEventListener, TpmHeadSchemeForecastLogEventDto> onUpdate =
                TpmHeadSchemeForecastLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, DetailedForecastLogEventListener.class, onUpdate);
    }


    /**
     * 更新
     *
     * @param forecastDto
     */
    public void refreshCal(TpmHeadSchemeForecastDto forecastDto) {
        log.info("主体方案预测：方案编码[{}]明细编码[{}]更新计算", forecastDto.getSchemeCode(), forecastDto.getSchemeItemCode());

        forecastDto.setWriteOffConditions("");
        forecastDto.setWriteOffConditionValue("");
        forecastDto.setWriteOffFormula("");
        forecastDto.setWriteOffFormulaValue("");
        forecastDto.setEstimatedWriteOffAmount(BigDecimal.ZERO);
        forecastDto.setCalEx("");
        forecastDto.setCalParam("");

        if (!TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(forecastDto.getAuditType())) {
            AuditFormulaMainVo auditFormulaMainVo = null;
            try {
                auditFormulaMainVo = auditFormulaMainService.findByCode(forecastDto.getAuditFormulaCode());
            } catch (Exception e) {
                log.error("主体方案预测：方案编码[" + forecastDto.getSchemeCode() + "]明细编码[" + forecastDto.getSchemeItemCode() + "]更新计算异常！" + e.getMessage(), e);
            }
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(forecastDto.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(forecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(forecastDto.getBusinessUnitCode());
                dto.setAuditType(forecastDto.getAuditType());
                dto.setSalesOrgCodes(forecastDto.getSalesOrgCode());
                dto.setActivityFormCode(forecastDto.getActivityFormCode());
                dto.setActivityTypeCode(forecastDto.getActivityTypeCode());
                dto.setCustomerTypes(forecastDto.getRtmMode());
                dto.setFirstChannel(forecastDto.getFirstChannelCode());
                dto.setSecondChannel(forecastDto.getSecondChannelCode());
                dto.setWriteOffMethod(forecastDto.getWriteOffMethod());
                List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                    auditFormulaMainVo = formulaMainVoList.get(0);
                } else {
                    forecastDto.setAuditFormulaCode(null);
                }
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, forecastDto, forecastDto.getAuditType());
            this.setParam(auditFormulaMainVo, forecastDto, calDto);
        }
    }

    /**
     * 公式计算请求参数构建
     * paramMap 参数说明：
     * productCode：产品编码
     * productCode：产品编码
     * yearMonthStr：年月
     * terminalCode：门店编码
     * terminalName：门店名称
     * productBrandCode：品牌编码
     * productBrandName：品牌名称
     * productCategoryCode：大类编码
     * productCategoryName：大类名称
     * productItemCode：品项编码
     * productItemName：品项名称
     * activitiesDetailCode：活动明细编码
     * region：区域
     * channelCode：渠道编码
     * channelName：渠道名称
     * planItemCode：方案活动明细编码、促销规划明细编码、分子公司活动细案明细编码
     * detailPlanItemCode：活动细案明细编码
     *
     * @param auditFormulaMainVo
     * @param schemeForecastDto
     * @param auditType
     * @return
     */
    public CalculateDto buildCalParam(AuditFormulaMainVo auditFormulaMainVo, TpmHeadSchemeForecastDto schemeForecastDto, String auditType) {
        if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty(auditFormulaMainVo.getAuditFormulaInfoVoList())) {
            CalculateDto dto = new CalculateDto();
            dto.setCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setCustomerCode(schemeForecastDto.getCustomerCode());
            dto.setCustomerErpCode(schemeForecastDto.getCustomerErpCode());
            dto.setCustomerName(schemeForecastDto.getCustomerName());
            dto.setBusinessFormatCode(schemeForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(schemeForecastDto.getBusinessUnitCode());
            dto.setActivityTypeCode(schemeForecastDto.getActivityTypeCode());
            dto.setActivityTypeName(schemeForecastDto.getActivityTypeName());
            dto.setActivityFormCode(schemeForecastDto.getActivityFormCode());
            dto.setActivityFormName(schemeForecastDto.getActivityFormName());
            dto.setStartTimeOrDate(schemeForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(schemeForecastDto.getActivityEndTime());
            dto.setFormulaInfoDtoList(this.copyFormulaInfoList(auditFormulaMainVo.getAuditFormulaInfoVoList()));
            dto.setAuditType(auditType);
            dto.setSalesOrgCode(schemeForecastDto.getSalesOrgCode());
            dto.setSalesOrgErpCode(schemeForecastDto.getSalesOrgErpCode());
            dto.setSalesOrganizationCode(schemeForecastDto.getSalesInstitutionCode());
            dto.setSalesOrganizationErpCode(schemeForecastDto.getSalesInstitutionName());
            dto.setSalesRegionCode(schemeForecastDto.getSalesRegionCode());
            dto.setSalesRegionErpCode(schemeForecastDto.getSalesRegionErpCode());
            dto.setSalesGroupCode(schemeForecastDto.getSalesGroupCode());
            dto.setSalesGroupErpCode(schemeForecastDto.getSalesOrgErpCode());
            dto.setProductCode(schemeForecastDto.getProductCode());
            dto.setYearMonthLy(schemeForecastDto.getYearMonthStr());
            dto.setStoresCode(schemeForecastDto.getTerminalCode());
            dto.setBrandCode(schemeForecastDto.getProductBrandCode());
            dto.setCategoryCode(schemeForecastDto.getProductCategoryCode());
            dto.setItemCode(schemeForecastDto.getProductItemCode());
            dto.setPlanItemCode(schemeForecastDto.getSchemeItemCode());
            dto.setActivityOrgCode(schemeForecastDto.getRegion());
            dto.setActivityOrgName(schemeForecastDto.getRegionName());
            dto.setRetailBusinessmanCode(schemeForecastDto.getSystemCode());
            dto.setRetailBusinessmanName(schemeForecastDto.getSystemName());
            dto.setActivityTypeCode(schemeForecastDto.getActivityTypeCode());
            dto.setActivityFormCode(schemeForecastDto.getActivityFormCode());
            dto.setSecondChannelCode(schemeForecastDto.getSecondChannelCode());
            if (Objects.nonNull(schemeForecastDto.getActivityStartTime())) {
                String date = DateUtil.format(schemeForecastDto.getActivityStartTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
                //长度为10满足yyyy-MM-dd
                if (date.length() == 10) {
                    dto.setDate(DateUtil.parse(date, DateUtil.DEFAULT_YEAR_MONTH_DAY));
                }
                //长度为19满足yyyy-MM-dd HH:mm:ss
                else if (date.length() == 19) {
                    dto.setDate(DateUtil.parse(date, DateUtil.DEFAULT_DATE_ALL_PATTERN));
                }
            }

            dto.setDealerCode(schemeForecastDto.getCustomerErpCode());
            dto.setChannel(schemeForecastDto.getChannelCode());
            dto.setStartTimeOrDate(schemeForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(schemeForecastDto.getActivityEndTime());
            dto.setFirstChannelCode(schemeForecastDto.getFirstChannelCode());
            dto.setSecondChannelCode(schemeForecastDto.getSecondChannelCode());
            dto.setHeadBudgetItemCode(schemeForecastDto.getHeadBudgetItemCode());
            dto.setMonthBudgetCode(schemeForecastDto.getMonthBudgetCode());
            dto.setCusCreateTime(schemeForecastDto.getCusCreateTime());
            dto.setDistributionChannel(schemeForecastDto.getDistributionChannelCode());

            return dto;
        } else {
            log.info("主体方案预测：核销条件为空");
        }
        return null;
    }

    /**
     * 公式参数计算组装
     *
     * @param auditFormulaMainVo
     * @param schemeForecastDto
     * @param calDto
     */
    public void setParam(AuditFormulaMainVo auditFormulaMainVo, TpmHeadSchemeForecastDto schemeForecastDto, CalculateDto calDto) {
        if (Objects.isNull(calDto)) {
            return;
        }
        schemeForecastDto.setCalEx("");
        List<CalculateVo> calculateVos = Lists.newArrayList();
        try {
            calculateVos = variableService.orCalculateConditionAndExpression(Lists.newArrayList(calDto));
        } catch (Exception ex) {
            ex.printStackTrace();
            if (StringUtils.isNotEmpty(ex.getMessage())) {
                int length = Math.min(ex.getMessage().length(), 200);
                schemeForecastDto.setCalEx(ex.getMessage().substring(0, length));
            } else {
                schemeForecastDto.setCalEx("NPE");
            }
            log.error("主体方案预测：方案编码[{}]明细编码[{}]计算失败：{}", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode(), ex.getMessage());
        }

        //公式条件满足的计算结果
        AtomicReference<String> filterCondition = new AtomicReference<>();
        List<CalculateVo> filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        if (filterVos.size() > 1) {
            log.error("主体方案预测：核销公式编码 [" + auditFormulaMainVo.getAuditFormulaCode() + "] 计算结果：多个核销公式条件同时满足！");
        } else if (CollectionUtils.isNotEmpty(filterVos)) {
            filterCondition.set(filterVos.get(0).getFormulaConditionName());
        }
        //预估核销金额
        BigDecimal estimatedWriteOffAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = filterVos.get(0).getFormulaValue();
        } else {
            log.info("主体方案预测：方案编码[{}]明细编码[{}]未满足公式任何条件，默认预核销金额为0！", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode());
        }

        //变量对应的值
        Map<String, BigDecimal> variableValueMap = new HashMap<>();
        calculateVos.forEach(v -> {
            if (Objects.nonNull(v.getVariableValueMap())) {
                variableValueMap.putAll(v.getVariableValueMap());
            }
        });

        List<String> variableCodeList = new ArrayList<>();
        for (CalculateVo calculateVo : calculateVos) {
            if (Objects.nonNull(calculateVo.getVariableValueMap())) {
                variableCodeList.addAll(calculateVo.getVariableValueMap().keySet());
            }
        }

        //核销变量编码-名称映射
        Map<String, String> variableNameMap = variableService.getVariableMap(VariableFunctionEnum.AUDIT.getCode(), variableCodeList);

        //核销条件取值
        Map<String, String> conditionValueMap = new HashMap<>();
        //核销公式取值
        Map<String, String> formulaValueMap = new HashMap<>();
        auditFormulaMainVo.getAuditFormulaInfoVoList()
//                .stream().filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .forEach(formula -> {
                    //核销条件
                    Set<String> formulaCondition = MathUtil.getFormulaReplace(formula.getAuditFormulaCondition());
                    formulaCondition.forEach(v -> {
                        if (conditionValueMap.containsKey(v)) {
                            return;
                        }
                        if (variableValueMap.containsKey(v)) {
                            conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                            return;
                        }
                        conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                    });
                    //核销公式
                    Set<String> auditFormula = MathUtil.getFormulaReplace(formula.getAuditFormula());
                    auditFormula.forEach(v -> {
                        if (formulaValueMap.containsKey(v)) {
                            return;
                        }
                        if (variableValueMap.containsKey(v)) {
                            formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                            return;
                        }
                        formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                    });
                });
        schemeForecastDto.setCalParam(JSON.toJSONString(calDto));
        schemeForecastDto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
        schemeForecastDto.setWriteOffConditions(auditFormulaMainVo.getAuditFormulaInfoVoList().stream()
                .filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .map(AuditFormulaInfoVo::getAuditFormulaConditionName).filter(Objects::nonNull)
                .collect(Collectors.joining(" , ")));
        schemeForecastDto.setWriteOffFormula(auditFormulaMainVo.getAuditFormulaInfoVoList().stream()
                .filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .map(AuditFormulaInfoVo::getAuditFormulaName).filter(Objects::nonNull)
                .collect(Collectors.joining(" , ")));
        schemeForecastDto.setWriteOffConditionValue(String.join(" , ", conditionValueMap.values()));
        schemeForecastDto.setWriteOffFormulaValue(String.join(" , ", formulaValueMap.values()));
        schemeForecastDto.setEstimatedWriteOffAmount(estimatedWriteOffAmount);
    }

    public List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        List<FormulaInfoDto> list = new ArrayList<>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }

    public void deleteBySchemeItemCode(String planItemCode) {
        this.tpmHeadSchemeForecastRepository.deleteBySchemeItemCode(planItemCode);
    }
}
