package com.biz.crm.tpm.business.scheme.forecast.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.business.common.sdk.vo.FileVo;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.MarketingApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.MarketingApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.report.service.SalesApprovalService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.MarketingApprovalVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.MonthBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastFileEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastWorkflowEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.TpmHeadSchemeForecastRepository;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.TpmVerticalSchemeForecastFileRepository;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.TpmHeadSchemeForecastWorkflowRepository;
import com.biz.crm.tpm.business.scheme.forecast.local.util.TpmHeadSchemeForecastUtil;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmHeadSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.log.TpmHeadSchemeForecastLogEventDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeStatusEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeWorkflowTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.event.TpmHeadSchemeForecastLogEventListener;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmHeadSchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastActivityDetailPlanVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastUploadFileVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-09
 */
@Slf4j
@Service
public class TpmHeadSchemeForecastServiceImpl implements TpmHeadSchemeForecastService {

    @Autowired(required = false)
    private TpmHeadSchemeForecastRepository tpmHeadSchemeForecastRepository;

    @Autowired(required = false)
    private TpmHeadSchemeForecastUtil tpmHeadSchemeForecastUtil;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;

    @Autowired(required = false)
    private ProcessBatchBusinessService processBatchBusinessService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private TpmHeadSchemeForecastWorkflowRepository tpmHeadSchemeForecastWorkflowRepository;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastFileRepository tpmVerticalSchemeForecastFileRepository;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private SalesApprovalService salesApprovalService;

    @Autowired(required = false)
    private MarketingApprovalService marketingApprovalService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Transactional
    @Override
    public void edit(TpmHeadSchemeForecastDto dto) {
        Validate.notBlank(dto.getId(), "数据主键ID为空");
        Validate.notNull(dto.getActivityDelayEndTime(), "活动结束延期时间为空");
        Validate.notNull(dto.getActualAuditAmount(), "实际核销金额为空");
        List<TpmHeadSchemeForecastEntity> list = this.tpmHeadSchemeForecastRepository.findByIds(Lists.newArrayList(dto.getId()));
        Validate.notEmpty(list, "数据不存在");
        TpmHeadSchemeForecastEntity forecastEntity = list.get(0);
        TpmHeadSchemeForecastDto oldDto = nebulaToolkitService.copyObjectByWhiteList(forecastEntity, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);
        Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastEntity.getHeadProcessStatus()),
                "方案明细[%s]当前总部审批状态[%s]不允许上传资料", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getHeadProcessStatus()));
        Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastEntity.getRegionProcessStatus()),
                "方案明细[%s]当前大区审批状态[%s]不允许上传资料", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getRegionProcessStatus()));
        Validate.isTrue(!StringUtils.equals(TpmHeadSchemeStatusEnum.CONFIRMED.getCode(), forecastEntity.getStatus()),
                "方案明细[%s]已确认，不允许上传资料！", forecastEntity.getSchemeItemCode());

        forecastEntity.setActivityDelayEndTime(dto.getActivityDelayEndTime());
        forecastEntity.setActualAuditAmount(dto.getActualAuditAmount());
        this.tpmHeadSchemeForecastRepository.updateById(forecastEntity);

        TpmHeadSchemeForecastDto newDto = nebulaToolkitService.copyObjectByWhiteList(forecastEntity, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);
        TpmHeadSchemeForecastLogEventDto logEventDto = new TpmHeadSchemeForecastLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer<TpmHeadSchemeForecastLogEventListener, TpmHeadSchemeForecastLogEventDto> onUpdate =
                TpmHeadSchemeForecastLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, TpmHeadSchemeForecastLogEventListener.class, onUpdate);
    }

    /**
     * 编辑扣减预算编码
     *
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void editMonthBudgetCodeDeduction(TpmHeadSchemeForecastDto dto) {
        Validate.notBlank(dto.getId(), "数据主键ID为空");
        List<TpmHeadSchemeForecastEntity> list = this.tpmHeadSchemeForecastRepository.findByIds(Lists.newArrayList(dto.getId()));
        Validate.notEmpty(list, "数据不存在");
        TpmHeadSchemeForecastEntity forecastEntity = list.get(0);

        TpmHeadSchemeForecastDto oldDto = nebulaToolkitService.copyObjectByWhiteList(forecastEntity, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);
        forecastEntity.setMonthBudgetCodeDeduction(dto.getMonthBudgetCodeDeduction());
        this.tpmHeadSchemeForecastRepository.updateById(forecastEntity);

        TpmHeadSchemeForecastDto newDto = nebulaToolkitService.copyObjectByWhiteList(forecastEntity, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);
        TpmHeadSchemeForecastLogEventDto logEventDto = new TpmHeadSchemeForecastLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(newDto);
        SerializableBiConsumer<TpmHeadSchemeForecastLogEventListener, TpmHeadSchemeForecastLogEventDto> onUpdate =
                TpmHeadSchemeForecastLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, TpmHeadSchemeForecastLogEventListener.class, onUpdate);
    }

    @Transactional
    @Override
    public String uploadFile(TpmHeadSchemeForecastUploadFileDto dto) {
        Validate.notEmpty(dto.getId(), "请选择数据");
        this.tpmVerticalSchemeForecastFileRepository.removeByForecastId(Lists.newArrayList(dto.getId()));
        List<TpmHeadSchemeForecastEntity> forecastEntities = this.tpmHeadSchemeForecastRepository.findByIds(Lists.newArrayList(dto.getId()));
        Validate.notEmpty(forecastEntities, "数据不存在");
        TpmHeadSchemeForecastEntity forecastEntity = forecastEntities.get(0);
        Validate.isTrue(StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), forecastEntity.getHeadProcessStatus()),
                "方案明细[%s]当前总部审批状态[%s]不允许上传资料", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getHeadProcessStatus()));
        Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastEntity.getRegionProcessStatus()),
                "方案明细[%s]当前大区审批状态[%s]不允许上传资料", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getRegionProcessStatus()));
        Validate.isTrue(!StringUtils.equals(TpmHeadSchemeStatusEnum.CONFIRMED.getCode(), forecastEntity.getStatus()),
                "方案明细[%s]已确认，不允许上传资料！", forecastEntity.getSchemeItemCode());
        if (!CollectionUtils.isEmpty(dto.getFileVos())) {
            List<TpmHeadSchemeForecastFileEntity> fileEntityList = (List<TpmHeadSchemeForecastFileEntity>) nebulaToolkitService.copyCollectionByWhiteList(dto.getFileVos(), FileVo.class, TpmHeadSchemeForecastFileEntity.class, HashSet.class, ArrayList.class);
            for (TpmHeadSchemeForecastFileEntity fileEntity : fileEntityList) {
                fileEntity.setSchemeForecastId(forecastEntity.getId());
                fileEntity.setSchemeForecastCode(forecastEntity.getSchemeForecastCode());
                fileEntity.setSchemeCode(forecastEntity.getSchemeCode());
                fileEntity.setSchemeItemCode(forecastEntity.getSchemeItemCode());
                fileEntity.setYearMonthLy(forecastEntity.getYearMonthLy());
                fileEntity.setYearMonthStr(forecastEntity.getYearMonthStr());
                fileEntity.setTenantCode(TenantUtils.getTenantCode());
            }
            this.tpmVerticalSchemeForecastFileRepository.saveBatch(fileEntityList);
        }

        //发起流程
        if (Objects.nonNull(dto.getProcessBusiness())) {
            TpmHeadSchemeForecastWorkflowEntity workflowEntity = tpmHeadSchemeForecastUtil.buildWorkflowEntity(forecastEntity, TpmHeadSchemeWorkflowTypeEnum.REGION);

            ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
            processBusinessDto.setBusinessCode(TpmHeadSchemeForecastConstants.PROCESS_NAME_HEAD_SCHEME_FORECAST);
            processBusinessDto.setBusinessNo(workflowEntity.getId());
            ProcessBusinessVo processBusinessVo = processBusinessService.processStart(processBusinessDto);

            workflowEntity.setProcessNo(processBusinessVo.getProcessNo());
            this.tpmHeadSchemeForecastWorkflowRepository.save(workflowEntity);
            this.tpmHeadSchemeForecastRepository.updateProcessStatus(
                    ProcessStatusEnum.COMMIT.getDictCode(),
                    processBusinessVo.getProcessNo(),
                    TpmHeadSchemeWorkflowTypeEnum.REGION.getCode(),
                    Arrays.asList(dto.getId()));

            return processBusinessVo.getProcessNo();
        }
        return null;
    }

    @Transactional
    @Override
    public String submit(TpmHeadSchemeForecastSubmitDto dto, TpmHeadSchemeWorkflowTypeEnum workflowTypeEnum) {
        Validate.notEmpty(dto.getIdList(), "请选择提交流程的数据");
        List<TpmHeadSchemeForecastEntity> forecastEntities = this.tpmHeadSchemeForecastRepository.findByIds(dto.getIdList());
        Validate.notEmpty(forecastEntities, "不存在的预测,请检查数据是否存在");
        List<TpmHeadSchemeForecastWorkflowEntity> list = this.tpmHeadSchemeForecastWorkflowRepository.findByForecastId(dto.getIdList(), workflowTypeEnum.getCode());
        List<String> filterIdList = list.stream().map(TpmHeadSchemeForecastWorkflowEntity::getSchemeForecastId).collect(Collectors.toList());

        List<TpmHeadSchemeForecastWorkflowEntity> workflowEntityList = new ArrayList<>();
        List<String> ids = new ArrayList<>();
        forecastEntities.forEach(forecastEntity -> {
            ids.add(forecastEntity.getId());
            if (StringUtils.equals(TpmHeadSchemeWorkflowTypeEnum.HEAD.getCode(), workflowTypeEnum.getCode())) {
                //总部只要审批成功了，就不能再次发起审批了
                Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), forecastEntity.getHeadProcessStatus()),
                        "方案明细[%s]当前总部审批状态[%s]不允许提交流程", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getHeadProcessStatus()));
                Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastEntity.getHeadProcessStatus()),
                        "方案明细[%s]当前总部审批状态[%s]不允许提交流程", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getHeadProcessStatus()));
                Validate.isTrue(!StringUtils.equals(TpmHeadSchemeStatusEnum.CONFIRMED.getCode(), forecastEntity.getStatus()),
                        "方案明细[%s]已确认！不允许提交流程", forecastEntity.getSchemeItemCode());
            } else {
                //大区可以多次发起 前提是总部审批通过、不在审批中、未确认
                Validate.isTrue(StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), forecastEntity.getHeadProcessStatus()),
                        "方案明细[%s]当前总部审批状态[%s]不允许提交流程", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getHeadProcessStatus()));
                Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastEntity.getHeadProcessStatus()),
                        "方案明细[%s]当前大区审批状态[%s]不允许提交流程", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getRegionProcessStatus()));
                Validate.isTrue(!filterIdList.contains(forecastEntity.getId()),
                        "方案明细[%s]已二次审批，不允许再次提交流程", forecastEntity.getSchemeItemCode());
                Validate.isTrue(!StringUtils.equals(TpmHeadSchemeStatusEnum.CONFIRMED.getCode(), forecastEntity.getStatus()),
                        "方案明细[%s]已确认！不允许提交流程", forecastEntity.getSchemeItemCode());
            }
            TpmHeadSchemeForecastWorkflowEntity workflowEntity = tpmHeadSchemeForecastUtil.buildWorkflowEntity(forecastEntity, workflowTypeEnum);
            workflowEntityList.add(workflowEntity);
        });

        List<String> businessNoList = workflowEntityList.stream().map(TpmHeadSchemeForecastWorkflowEntity::getId).collect(Collectors.toList());

        ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
        processBusinessDto.setBusinessNoList(businessNoList);
        processBusinessDto.setBusinessCode(TpmHeadSchemeForecastConstants.PROCESS_NAME_HEAD_SCHEME_FORECAST);
        //批量提交-业务编码设置为uuid
        String businessNo = UUID.randomUUID().toString().replace("-", "");
        processBusinessDto.setBusinessNo(businessNo);
        ProcessBusinessVo processBusinessVo = processBatchBusinessService.processStart(processBusinessDto);
        Validate.notBlank(processBusinessVo.getProcessNo(), "未生成流程，流程编号为空");

        for (TpmHeadSchemeForecastWorkflowEntity workflowEntity : workflowEntityList) {
            workflowEntity.setProcessNo(processBusinessVo.getProcessNo());
        }
        this.tpmHeadSchemeForecastWorkflowRepository.saveBatch(workflowEntityList);

        this.tpmHeadSchemeForecastRepository.updateProcessStatus(
                ProcessStatusEnum.COMMIT.getDictCode(),
                processBusinessVo.getProcessNo(),
                workflowTypeEnum.getCode(),
                ids);
        return processBusinessVo.getProcessNo();
    }

    @Override
    public void updateAuditAmount(List<String> idList) {
        Validate.notEmpty(idList, "请求入参不能为空,请检查");
        List<TpmHeadSchemeForecastEntity> forecastEntities = this.tpmHeadSchemeForecastRepository.findByIds(idList);
        Validate.notEmpty(forecastEntities, "不存在的预测,请检查数据是否存在");
        forecastEntities.forEach(forecastEntity -> {
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), forecastEntity.getHeadProcessStatus()),
                    "方案明细[%s]当前总部审批状态[%s]不允许更新", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getHeadProcessStatus()));
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastEntity.getHeadProcessStatus()),
                    "方案明细[%s]当前总部审批状态[%s]不允许更新", forecastEntity.getSchemeItemCode(), ProcessStatusEnum.getStatusNameByKey(forecastEntity.getHeadProcessStatus()));
            Validate.isTrue(!StringUtils.equals(TpmHeadSchemeStatusEnum.CONFIRMED.getCode(), forecastEntity.getStatus()),
                    "方案明细[%s]已确认！", forecastEntity.getSchemeItemCode());
        });
        MqMessageVo mqMessageVo = new MqMessageVo();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        List<String> ids = forecastEntities.stream().map(TpmHeadSchemeForecastEntity::getId).distinct().collect(Collectors.toList());
        redisService.hSet(TpmHeadSchemeForecastConstants.REFRESH_IDS_KEY, uuid, JSON.toJSONString(ids), 60 * 60 * 48);//定时任务每天跑，缓存2天够了
        mqMessageVo.setMsgBody(uuid);
        mqMessageVo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag(ActivityPlanPassMqTagConstant.TPM_HEAD_SCHEME_FORECAST_REFRESH);
        rocketMqProducer.sendMqMsg(mqMessageVo);
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.notNull(idList, "请选择数据");
        List<TpmHeadSchemeForecastEntity> list = tpmHeadSchemeForecastRepository.findByIds(idList);
        Validate.notEmpty(list, "不存在的预测,请检查数据是否存在");
        Map<String, Long> workflowPassNumMap = tpmHeadSchemeForecastWorkflowRepository.countPassNum(idList, ProcessStatusEnum.PASS.getDictCode());
        list.forEach(e -> {
//            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), e.getHeadProcessStatus()),
//                    "方案明细[%s]当前总部审批状态[%s]不允许删除", ProcessStatusEnum.COMMIT.getValue());
//            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), e.getHeadProcessStatus()),
//                    "方案明细[%s]当前总部审批状态[%s]不允许删除", ProcessStatusEnum.PASS.getValue());
//            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), e.getRegionProcessStatus()),
//                    "方案明细[%s]当前大区审批状态[%s]不允许删除", ProcessStatusEnum.COMMIT.getValue());
//            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), e.getRegionProcessStatus()),
//                    "方案明细[%s]当前大区审批状态[%s]不允许删除", ProcessStatusEnum.PASS.getValue());
            Validate.isTrue(!StringUtils.equals(TpmHeadSchemeStatusEnum.CONFIRMED.getCode(), e.getStatus()),
                    "方案明细[%s]已确认，不允许删除", e.getSchemeItemCode());
            Validate.isTrue(workflowPassNumMap.getOrDefault(e.getId(), 0L) == 0, "方案明细[%s]已有审批通过记录，不允许删除", e.getSchemeItemCode());
        });
        this.tpmHeadSchemeForecastRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public void confirm(List<String> idList) {
        Validate.notNull(idList, "请选择数据");
        List<TpmHeadSchemeForecastEntity> list = tpmHeadSchemeForecastRepository.findByIds(idList);
        Validate.notEmpty(list, "不存在的预测,请检查数据是否存在");
        list.forEach(e -> {
            TpmHeadSchemeForecastDto oldDto = nebulaToolkitService.copyObjectByWhiteList(e, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);
            Validate.isTrue(StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), e.getHeadProcessStatus()), "方案明细[%s]未审批通过，不允许确认", e.getSchemeItemCode());
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), e.getRegionProcessStatus()), "方案明细[%s]审批中，不允许确认", e.getSchemeItemCode());
            Validate.isTrue(!StringUtils.equals(TpmHeadSchemeStatusEnum.CONFIRMED.getCode(), e.getStatus()), "方案明细[%s]已确认，不允许重复确认", e.getSchemeItemCode());
        });
        confirmList(list);
    }

    @Transactional
    public void confirmList(List<TpmHeadSchemeForecastEntity> list) {
        //判断总部核销金额小于大区核销金额时，则提示“总部核销金额小于大区核销金额，请选择大区预算”
        Set<String> relatePlanItemCodes = list.stream().map(e -> e.getSchemeItemCode()).collect(Collectors.toSet());
        List<ActivityDetailPlanItemVo> detailPlanItemVoList = activityDetailPlanItemSdkService.findByRelatePlanItemCodes(relatePlanItemCodes);
        Map<String, List<ActivityDetailPlanItemVo>> detailPlanItemVoMap = detailPlanItemVoList.stream().collect(Collectors.groupingBy(e -> e.getRelatePlanItemCode()));

        List<ActivityPlanItemDto> activityPlanItemDtoList = new ArrayList<>();
        List<TpmHeadSchemeForecastLogEventDto> eventDtoList = new ArrayList<>();
        List<OperateMonthBudgetDto> budgetOperateList = new ArrayList<>();
        List<String> monthCodeList = new ArrayList<>();
        list.forEach(e -> {
            TpmHeadSchemeForecastDto oldDto = nebulaToolkitService.copyObjectByWhiteList(e, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);

            List<ActivityDetailPlanItemVo> itemVoList = detailPlanItemVoMap.get(e.getSchemeItemCode());
            Validate.isTrue(!CollectionUtils.isEmpty(itemVoList), "方案明细[%s]未找到", e.getSchemeItemCode());
            //大区核销金额
            BigDecimal auditAmountRegion = itemVoList.stream().map(e1 -> e1.getAlreadyEndCaseHeadFeeAmount()).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            //总部核销金额
            BigDecimal auditAmountHead = Optional.ofNullable(e.getActualAuditAmount()).orElse(e.getEstimatedWriteOffAmount());
            //总部申请金额
            BigDecimal feeAmountHead = Optional.ofNullable(e.getHeadFeeAmount()).orElse(BigDecimal.ZERO);
            //扣减金额
            BigDecimal amountDeduction = BigDecimal.ZERO;
            if (auditAmountHead.compareTo(auditAmountRegion) < 0) {
                Validate.isTrue(StringUtils.isNotBlank(e.getMonthBudgetCodeDeduction()), "方案明细[%s]，总部核销金额小于大区核销金额，请选择大区预算", e.getSchemeItemCode());

                //1、总部核销金额≤大区核销金额≤总部申请金额：补扣大区预算：大区核销金额-总部核销金额
                //2、大区核销金额≥总部核销金额≥总部申请金额：补扣大区预算：大区核销金额-总部申请金额
                //3、大区核销金额≥总部申请金额≥总部核销金额：补扣大区预算：大区核销金额-总部核销金额
                //4、记录扣减金额在月度预算调整字段，并更新冻结后可用余额及累计可用余额
                if ((auditAmountHead.compareTo(auditAmountRegion) <= 0 && auditAmountRegion.compareTo(feeAmountHead) <= 0) ||
                        (auditAmountRegion.compareTo(feeAmountHead) >= 0 && feeAmountHead.compareTo(auditAmountHead) >= 0)) {
                    amountDeduction = auditAmountRegion.subtract(auditAmountHead);
                } else if (auditAmountRegion.compareTo(auditAmountHead) >= 0 && auditAmountHead.compareTo(feeAmountHead) >= 0) {
                    amountDeduction = auditAmountRegion.subtract(feeAmountHead);
                }

                BigDecimal hasDeductionAmount = Optional.ofNullable(e.getDeductionAmount()).orElse(BigDecimal.ZERO);
                if (amountDeduction.compareTo(hasDeductionAmount) > 0){
                    OperateMonthBudgetDto monthBudgetDto = new OperateMonthBudgetDto();
                    monthBudgetDto.setMonthBudgetCode(e.getMonthBudgetCodeDeduction());
                    monthBudgetDto.setOperationAmount(amountDeduction.subtract(hasDeductionAmount));
                    monthBudgetDto.setOperationType(BudgetOperationTypeEnum.DEDUCTION.getCode());
                    monthBudgetDto.setBusinessCode(e.getSchemeForecastCode());
                    monthBudgetDto.setBudgetType(MonthBudgetTypeEnum.MONTH_BUDGET.getCode());
                    budgetOperateList.add(monthBudgetDto);
                    monthCodeList.add(e.getMonthBudgetCodeDeduction());
                }
                e.setDeductionAmount(amountDeduction);
            }

            e.setStatus(TpmHeadSchemeStatusEnum.CONFIRMED.getCode());
            TpmHeadSchemeForecastDto newDto = nebulaToolkitService.copyObjectByWhiteList(e, TpmHeadSchemeForecastDto.class, HashSet.class, ArrayList.class);
            TpmHeadSchemeForecastLogEventDto logEventDto = new TpmHeadSchemeForecastLogEventDto();
            logEventDto.setOriginal(oldDto);
            logEventDto.setNewest(newDto);
            eventDtoList.add(logEventDto);

            if (e.getActivityEndTime().getTime() != e.getActivityDelayEndTime().getTime()) {
                ActivityPlanItemDto itemDto = new ActivityPlanItemDto();
                itemDto.setPlanCode(e.getSchemeCode());
                itemDto.setPlanItemCode(e.getSchemeItemCode());
                itemDto.setActivityEndDate(e.getActivityDelayEndTime());
                activityPlanItemDtoList.add(itemDto);
            }
        });
        this.tpmHeadSchemeForecastRepository.updateBatchById(list);

        //活动结束时间延期
        if (!CollectionUtils.isEmpty(activityPlanItemDtoList)) {
            this.activityPlanSdkService.updateActivityDelayEndTime(activityPlanItemDtoList);
        }

        //预算扣减
        if (!CollectionUtils.isEmpty(monthCodeList)) {
            try {
                monthBudgetLockService.lock(monthCodeList, TimeUnit.SECONDS, 10);
                monthBudgetService.operateBudget(budgetOperateList);
            } finally {
                monthBudgetLockService.unLock(monthCodeList);
            }
        }

        // 日志更新
        for (TpmHeadSchemeForecastLogEventDto logEventDto : eventDtoList) {
            SerializableBiConsumer<TpmHeadSchemeForecastLogEventListener, TpmHeadSchemeForecastLogEventDto> onUpdate =
                    TpmHeadSchemeForecastLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish(logEventDto, TpmHeadSchemeForecastLogEventListener.class, onUpdate);
        }

        //同步已确认数据的实际核销金额到方案预测跟踪表
        if (!CollectionUtils.isEmpty(relatePlanItemCodes)) {
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(JSONObject.toJSONString(relatePlanItemCodes));
            mqMessageVo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(ActivityPlanPassMqTagConstant.CONFIRM_ITEM_CREATE_CLOSE_RECORD_DETAIL);
            rocketMqProducer.sendMqMsg(mqMessageVo,10);
        }
    }

    @Override
    @Transactional
    public void completeCallback(String processNo, String processStatus) {
        Validate.notBlank(processNo, "流程编码[processNo]为空");
        Validate.notBlank(processStatus, "审批状态[processStatus]为空");
        List<TpmHeadSchemeForecastWorkflowEntity> workflowEntityList = this.tpmHeadSchemeForecastWorkflowRepository.findByProcessNo(processNo);
        Validate.notEmpty(workflowEntityList, "流程发起记录不存在");
        //批量提交的提交对象类型一定一样，取第一条就可以
        TpmHeadSchemeForecastWorkflowEntity workflowEntity = workflowEntityList.get(0);

        List<TpmHeadSchemeForecastEntity> list = this.tpmHeadSchemeForecastRepository.findByProcessNo(processNo, workflowEntity.getWorkflowType());
        List<ActivityPlanItemDto> activityPlanItemDtoList = new ArrayList<>();
        List<String> ids = new ArrayList<>();
        for (TpmHeadSchemeForecastEntity forecastEntity : list) {
            ids.add(forecastEntity.getId());
            if (forecastEntity.getActivityEndTime().getTime() != forecastEntity.getActivityDelayEndTime().getTime()) {
                ActivityPlanItemDto itemDto = new ActivityPlanItemDto();
                itemDto.setPlanCode(forecastEntity.getSchemeCode());
                itemDto.setPlanItemCode(forecastEntity.getSchemeItemCode());
                itemDto.setActivityEndDate(forecastEntity.getActivityDelayEndTime());
                activityPlanItemDtoList.add(itemDto);
            }
        }
        //活动结束时间延期
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            if (!CollectionUtils.isEmpty(activityPlanItemDtoList) && StringUtils.equals(TpmHeadSchemeWorkflowTypeEnum.HEAD.getCode(), workflowEntity.getWorkflowType())) {
                this.activityPlanSdkService.updateActivityDelayEndTime(activityPlanItemDtoList);
            }
            this.tpmHeadSchemeForecastWorkflowRepository.updateProcessStatus(processStatus, processNo, workflowEntity.getWorkflowType());
        } else {
            this.tpmHeadSchemeForecastWorkflowRepository.removeByForecastId(ids);
        }

        this.tpmHeadSchemeForecastRepository.updateProcessStatus(processStatus, processNo, workflowEntity.getWorkflowType(), ids);
    }

    @Override
    public List<String> findAutoCreateDataList(TpmHeadSchemeForecastAutoCreateDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return tpmHeadSchemeForecastRepository.findAutoCreateDataList(dto);
    }

    @Override
    public Long findAutoRefreshCount(TpmHeadSchemeForecastAutoRefreshDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return tpmHeadSchemeForecastRepository.findAutoRefreshDataCount(dto);
    }

    /**
     * 定时任务更新查询待更新数据id
     *
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public List<String> findAutoRefreshDataList(Pageable pageable, TpmHeadSchemeForecastAutoRefreshDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 2000));
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return tpmHeadSchemeForecastRepository.findAutoRefreshDataList(pageable, dto);
    }

    @Override
    public Page<TpmHeadSchemeForecastVo> findByForecasts(Pageable pageable, TpmHeadSchemeForecastDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new TpmHeadSchemeForecastDto();
        }
        Page<TpmHeadSchemeForecastVo> page = tpmHeadSchemeForecastRepository.findByForecasts(pageable, dto);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return page;
        }
        //扩展表字段组装
        List<String> idList = page.getRecords().stream().map(TpmHeadSchemeForecastVo::getId).collect(Collectors.toList());
        List<TpmHeadSchemeForecastEntity> entityList = this.tpmHeadSchemeForecastRepository.findByIds(idList);
        Map<String, TpmHeadSchemeForecastEntity> map = entityList.stream().collect(Collectors.toMap(TpmHeadSchemeForecastEntity::getId, Function.identity()));
        for (TpmHeadSchemeForecastVo vo : page.getRecords()) {
            if (!map.containsKey(vo.getId())) {
                continue;
            }
            TpmHeadSchemeForecastEntity forecastEntity = map.get(vo.getId());
            vo.setWriteOffConditions(forecastEntity.getWriteOffConditions());
            vo.setWriteOffConditionValue(forecastEntity.getWriteOffConditionValue());
            vo.setWriteOffFormula(forecastEntity.getWriteOffFormula());
            vo.setWriteOffFormulaValue(forecastEntity.getWriteOffFormulaValue());
            vo.setCalEx(forecastEntity.getCalEx());

            vo.setProductCode(forecastEntity.getProductCode());
            vo.setProductName(forecastEntity.getProductName());

            vo.setTerminalCode(forecastEntity.getTerminalCode());
            vo.setTerminalName(forecastEntity.getTerminalName());
        }
        return page;
    }

    @Override
    public TpmHeadSchemeForecastVo findById(String id) {
        Validate.notBlank(id, "请选择数据");
        List<TpmHeadSchemeForecastEntity> entityList = this.tpmHeadSchemeForecastRepository.findByIds(Lists.newArrayList(id));
        Validate.notEmpty(entityList, "数据不存在");
        return nebulaToolkitService.copyObjectByWhiteList(entityList.get(0), TpmHeadSchemeForecastVo.class, HashSet.class, ArrayList.class);
    }

    /**
     * 资料详情
     *
     * @param id
     * @return
     */
    @Override
    public TpmHeadSchemeForecastUploadFileVo findFileById(String id) {
        Validate.notBlank(id, "请选择数据");
        List<TpmHeadSchemeForecastFileEntity> fileEntities = this.tpmVerticalSchemeForecastFileRepository.findBySchemeForecastId(id);

        TpmHeadSchemeForecastUploadFileVo schemeForecast = new TpmHeadSchemeForecastUploadFileVo();
        schemeForecast.setId(id);

        if (!CollectionUtils.isEmpty(fileEntities)) {
            List<FileVo> list = new ArrayList<>();
            fileEntities.forEach(e -> {
                FileVo vo = new FileVo();
                vo.setFileCode(e.getFileCode());
                vo.setOriginalFileName(e.getOriginalFileName());

                list.add(vo);
            });
            schemeForecast.setFileVos(list);
        }
        return schemeForecast;
    }

    @Override
    public List<TpmHeadSchemeForecastActivityDetailPlanVo> findActivityDetailPlanById(String id) {
        Validate.notBlank(id, "请选择数据");
        List<TpmHeadSchemeForecastEntity> entities = this.tpmHeadSchemeForecastRepository.findByIds(Lists.newArrayList(id));
        Validate.notEmpty(entities, "数据不存在");
        TpmHeadSchemeForecastEntity forecastEntity = entities.get(0);

        return findActivityDetailPlan(forecastEntity.getSchemeItemCode());
    }

    @Override
    public List<TpmHeadSchemeForecastVo> findByPlanItemCodes(List<String> planItemCodes) {
        if(CollectionUtils.isEmpty(planItemCodes)){
            return Lists.newArrayList();
        }
        List<TpmHeadSchemeForecastEntity> tpmHeadSchemeForecastEntities = this.tpmHeadSchemeForecastRepository.findByPlanItemCodes(planItemCodes);
        if(CollectionUtils.isEmpty(tpmHeadSchemeForecastEntities)){
            return Lists.newArrayList();
        }
        Collection<TpmHeadSchemeForecastVo> tpmHeadSchemeForecastVos = this.nebulaToolkitService.copyCollectionByWhiteList(tpmHeadSchemeForecastEntities, TpmHeadSchemeForecastEntity.class, TpmHeadSchemeForecastVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<TpmHeadSchemeForecastVo>) tpmHeadSchemeForecastVos;
    }

    public List<TpmHeadSchemeForecastActivityDetailPlanVo> findActivityDetailPlan(String planItemCode) {
        List<TpmHeadSchemeForecastActivityDetailPlanVo> voList = new ArrayList<>();

        //查询销售费用批复表、行销费用批复表
        Pageable pageable = PageRequest.of(1, 20000);
        MarketingApprovalDto dto1 = new MarketingApprovalDto();
        dto1.setRelatePlanItemCode(planItemCode);
        Page<MarketingApprovalVo> pageResultM = this.marketingApprovalService.findAllConditions(pageable, dto1);
        if (!CollectionUtils.isEmpty(pageResultM.getRecords())) {
            List<MarketingApprovalVo> records = pageResultM.getRecords();
            Collection<TpmHeadSchemeForecastActivityDetailPlanVo> list = nebulaToolkitService.copyCollectionByWhiteList(records, MarketingApprovalVo.class, TpmHeadSchemeForecastActivityDetailPlanVo.class, HashSet.class, ArrayList.class);
            voList.addAll(new ArrayList<>(list));
        }
        SalesApprovalDto dto2 = new SalesApprovalDto();
        dto2.setRelatePlanItemCode(planItemCode);
        Page<SalesApprovalVo> pageResultA = this.salesApprovalService.findAllConditions(pageable, dto2);
        if (!CollectionUtils.isEmpty(pageResultA.getRecords())) {
            List<SalesApprovalVo> records = pageResultA.getRecords();
            Collection<TpmHeadSchemeForecastActivityDetailPlanVo> list = nebulaToolkitService.copyCollectionByWhiteList(records, SalesApprovalVo.class, TpmHeadSchemeForecastActivityDetailPlanVo.class, HashSet.class, ArrayList.class);
            voList.addAll(new ArrayList<>(list));
        }

        return voList;
    }

    @Override
    public void updateAuditReduceAmount(List<String> detailPlanItemCodeList) {
        List<ActivityDetailPlanBudgetVo> detailPlanItemBudgetList = activityDetailPlanItemSdkService.findBudgetByCodes(detailPlanItemCodeList);
        if(CollectionUtils.isEmpty(detailPlanItemBudgetList)){
            return;
        }
        List<String> planItemCodeList = detailPlanItemBudgetList.stream().map(ActivityDetailPlanBudgetVo::getRelatePlanItemCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(planItemCodeList)){
            return;
        }

        List<TpmHeadSchemeForecastEntity> headSchemeForecastEntities = tpmHeadSchemeForecastRepository.findByPlanItemCodesHasBudget(planItemCodeList);
        if (CollectionUtils.isEmpty(headSchemeForecastEntities)){
            return;
        }
        //这里只处理已经确认了的方案预测表数据，做补扣
        List<TpmHeadSchemeForecastEntity> list = headSchemeForecastEntities.stream().filter(item -> TpmHeadSchemeStatusEnum.CONFIRMED.getCode().equals(item.getStatus())).collect(Collectors.toList());
        if(CollectionUtils.isEmpty(list)){
            return;
        }
        confirmList(list);
    }

}
