package com.biz.crm.tpm.business.scheme.forecast.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DeatailedForecastConstants;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastAutoCreateDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmVerticalSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastAutoCreateDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmVerticalSchemeForecastService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * <p>
 * 垂直大区方案兑付定时创建
 * 因发版等其他原因导致未正常生成垂直大区方案兑付数据重新生成
 * 默认检查更新时间3天内的活动
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-16
 */
@Slf4j
@Service
public class TpmVerticalSchemeForecastAutoCreateXxlJob {

    @Autowired(required = false)
    private DetailedForecastService detailedForecastService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastService tpmVerticalSchemeForecastService;

    /**
     * 垂直大区方案兑付定时创建任务，7点开始1个小时执行一次，默认检查更新时间3天内的活动
     */
    @DynamicTaskService(cornExpression = "0 0 7/1 * * ?", taskDesc = "垂直大区方案兑付定时补创建任务")
    public void autoCreate() {
        log.info("=====>    垂直大区方案兑付定时补创建任务[{}] start    <=====", DateUtil.dateStrNowAll());
        loginUserService.refreshAuthentication(null);
        try {
            if (redisService.hasKey(TpmVerticalSchemeForecastConstants.CREATE_KEY)) {
                Object o = redisService.get(TpmVerticalSchemeForecastConstants.CREATE_KEY);
                String msg = "垂直大区方案兑付定时补创建进行中！开始时间：" + o.toString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
            String nowDateTime = DateUtil.getDate(DateUtil.DEFAULT_DATE_ALL_PATTERN);
            //锁30分钟自然解锁
            redisService.set(TpmVerticalSchemeForecastConstants.CREATE_KEY, nowDateTime, 60 * 30);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DateUtil.DEFAULT_DATE_ALL_PATTERN);

            TpmVerticalSchemeForecastAutoCreateDto dto = new TpmVerticalSchemeForecastAutoCreateDto();
            dto.setModifyBeginDateTime(LocalDateTime.now().plusDays(-300).format(formatter));
            try {
                List<String> list = tpmVerticalSchemeForecastService.findAutoCreateDataList(dto);
                log.info("垂直大区方案兑付定时补创建===》{}", list.size());
                this.sendMq(dto.getBusinessUnitCode(), list);
            } catch (Exception e) {
                log.error("垂直大区方案兑付定时补创建===》异常：" + e.getMessage(), e);
            }
        } catch (RuntimeException e) {
            e.printStackTrace();
            log.error("垂直大区方案兑付定时补创建异常：" + e.getMessage(), e);
        }
        log.info("=====>    垂直大区方案兑付定时补创建[{}] end    <=====", DateUtil.dateStrNowAll());
    }

    public void sendMq(String businessUnitCode, List<String> list) {
        Lists.partition(list, 50).forEach(codes -> {
            try {
                MqMessageVo mqMessageVo = new MqMessageVo();
                mqMessageVo.setMsgBody(JSONObject.toJSONString(codes));
                mqMessageVo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
                mqMessageVo.setTag(ActivityPlanPassMqTagConstant.PASS_TPM_VERTICAL_SCHEME_FORECAST);
                log.info("垂直大区方案兑付定时补创建===>单元[{}]发送MQ===>{}条", businessUnitCode, codes.size());
                rocketMqProducer.sendMqMsg(mqMessageVo);
                Thread.sleep(200);
            } catch (Exception e) {
                log.error("垂直大区方案兑付定时补创建===>单元[" + businessUnitCode + "]发送MQ异常：" + e.getMessage() + " ===> " + JSONObject.toJSONString(codes), e);
            }
        });
    }
}
