package com.biz.crm.tpm.business.scheme.forecast.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastBudgetCashEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.TpmVerticalSchemeForecastBudgetCashRepository;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.TpmVerticalSchemeForecastRepository;
import com.biz.crm.tpm.business.scheme.forecast.local.util.TpmVerticalSchemeForecastUtil;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmVerticalSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmVerticalSchemeCashOperateTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmVerticalSchemeStatusEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmVerticalSchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashConfirmVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBatchBusinessService;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import liquibase.pro.packaged.E;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-09
 */
@Slf4j
@Service
public class TpmVerticalSchemeForecastServiceImpl implements TpmVerticalSchemeForecastService {

    @Autowired(required = false)
    private TpmVerticalSchemeForecastRepository tpmVerticalSchemeForecastRepository;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastBudgetCashRepository tpmVerticalSchemeForecastBudgetCashRepository;

    @Autowired(required = false)
    private TpmVerticalSchemeForecastUtil tpmVerticalSchemeForecastUtil;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required = false)
    private ProcessBatchBusinessService processBatchBusinessService;

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RocketMqProducer rocketMqProducer;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Override
    public void updateAuditAmount(List<String> idList) {
        Validate.notEmpty(idList, "请求入参不能为空,请检查");
        List<TpmVerticalSchemeForecastEntity> forecastEntities = this.tpmVerticalSchemeForecastRepository.findByIds(idList);
        Validate.notEmpty(forecastEntities, "不存在的实例,请检查数据是否存在");
        forecastEntities.forEach(forecastEntity -> {
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), forecastEntity.getProcessStatus()),
                    "当前审批状态[%s]不允许更新", ProcessStatusEnum.PASS.getValue());
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastEntity.getProcessStatus()),
                    "当前审批状态[%s]不允许更新", ProcessStatusEnum.COMMIT.getValue());
            Validate.isTrue(!StringUtils.equals(TpmVerticalSchemeStatusEnum.CONFIRMED.getCode(), forecastEntity.getStatus()),
                    "方案明细编码[%s]已确认！", forecastEntity.getSchemeItemCode());
        });
        MqMessageVo mqMessageVo = new MqMessageVo();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        List<String> ids = forecastEntities.stream().map(TpmVerticalSchemeForecastEntity::getId).distinct().collect(Collectors.toList());
        redisService.hSet(TpmVerticalSchemeForecastConstants.REFRESH_IDS_KEY, uuid, JSON.toJSONString(ids), 60 * 60 * 48);//定时任务每天跑，缓存2天够了
        mqMessageVo.setMsgBody(uuid);
        mqMessageVo.setTopic(ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag(ActivityPlanPassMqTagConstant.TPM_VERTICAL_SCHEME_FORECAST_REFRESH);
        rocketMqProducer.sendMqMsg(mqMessageVo);
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.notNull(idList, "请选择数据");
        List<TpmVerticalSchemeForecastEntity> list = tpmVerticalSchemeForecastRepository.findByIds(idList);
        list.forEach(e -> {
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), e.getProcessStatus()),
                    "当前审批状态[%s]不允许删除", ProcessStatusEnum.PASS.getValue());
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), e.getProcessStatus()),
                    "当前审批状态[%s]不允许删除", ProcessStatusEnum.COMMIT.getValue());
        });
        this.tpmVerticalSchemeForecastRepository.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void confirm(TpmVerticalSchemeForecastBudgetCashConfirmDto dto) {

        tpmVerticalSchemeForecastUtil.validateConfirmData(dto);

        TpmVerticalSchemeForecastBudgetCashConfirmVo vo = this.findConfirmDetail(dto.getId(), null);
        TpmVerticalSchemeForecastVo forecastVo = vo.getForecastVo();

        Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), forecastVo.getProcessStatus()),
                "当前审批状态[%s]不允许确认", ProcessStatusEnum.PASS.getValue());
        Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastVo.getProcessStatus()),
                "当前审批状态[%s]不允许确认", ProcessStatusEnum.COMMIT.getValue());

        List<TpmVerticalSchemeForecastBudgetCashEntity> budgetCashEntityList = tpmVerticalSchemeForecastUtil.buildBudgetCashEntityList(dto, vo);
        ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
        if (null != processBusinessDto){
            //提交流程了才冻结数据
            tpmVerticalSchemeForecastUtil.unOrFrozenBudget(forecastVo, budgetCashEntityList, BudgetOperationTypeEnum.FREEZE, false);
        }
        this.tpmVerticalSchemeForecastBudgetCashRepository.removeByForecastId(dto.getId());
        this.tpmVerticalSchemeForecastBudgetCashRepository.saveBatch(budgetCashEntityList);
        tpmVerticalSchemeForecastRepository.updateConfirmStatusAndAmount(dto.getId(), BooleanEnum.TRUE.getCapital(), dto.getEstimatedWriteOffAmount());

        if (null != processBusinessDto) {
            processBusinessDto.setBusinessCode(TpmVerticalSchemeForecastConstants.PROCESS_NAME_VERTICAL_SCHEME_FORECAST);
            processBusinessDto.setBusinessNo(forecastVo.getSchemeForecastCode());
            ProcessBusinessVo processBusinessVo = processBusinessService.processStart(processBusinessDto);

            this.tpmVerticalSchemeForecastRepository.updateProcessStatus(forecastVo.getSchemeForecastCode(), ProcessStatusEnum.COMMIT.getDictCode(), processBusinessVo.getProcessNo(), null);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void confirmBatch(TpmVerticalSchemeForecastBudgetCashConfirmDto dto) {
        List<TpmVerticalSchemeForecastEntity> forecastEntityList = this.tpmVerticalSchemeForecastRepository.listByIds(dto.getIds());
        Validate.isTrue(!CollectionUtils.isEmpty(forecastEntityList), "方案预测不存在，请刷新列表");
        List<TpmVerticalSchemeForecastVo> forecastVoList = (List<TpmVerticalSchemeForecastVo>) nebulaToolkitService.copyCollectionByWhiteList(forecastEntityList, TpmVerticalSchemeForecastEntity.class,TpmVerticalSchemeForecastVo.class, HashSet.class, ArrayList.class);

        Map<String,TpmVerticalSchemeForecastBudgetCashConfirmVo> confirmVoMap = Maps.newHashMap();
        for (TpmVerticalSchemeForecastVo forecastVo : forecastVoList) {
            TpmVerticalSchemeForecastBudgetCashConfirmVo vo = new TpmVerticalSchemeForecastBudgetCashConfirmVo();
            vo.setEstimatedWriteOffAmount(forecastVo.getEstimatedWriteOffAmount());
            vo.setForecastVo(forecastVo);
            vo.setId(forecastVo.getId());
            confirmVoMap.put(forecastVo.getId(),vo);
        }

        List<TpmVerticalSchemeForecastBudgetCashEntity> cashEntityList = tpmVerticalSchemeForecastBudgetCashRepository.findByForecastCondition(null, null, null, null,dto.getIds());
        Map<String, List<TpmVerticalSchemeForecastBudgetCashEntity>> budgetCashMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(cashEntityList)) {
            budgetCashMap = cashEntityList.stream().collect(Collectors.groupingBy(TpmVerticalSchemeForecastBudgetCashEntity::getSchemeForecastId));
            for (Map.Entry<String, List<TpmVerticalSchemeForecastBudgetCashEntity>> entry : budgetCashMap.entrySet()) {
                TpmVerticalSchemeForecastBudgetCashConfirmVo cashConfirmVo = confirmVoMap.get(entry.getKey());
                if (null == cashConfirmVo){
                    continue;
                }
                List<TpmVerticalSchemeForecastBudgetCashVo> cashVoList = (List<TpmVerticalSchemeForecastBudgetCashVo>) nebulaToolkitService.copyCollectionByWhiteList(entry.getValue(), TpmVerticalSchemeForecastBudgetCashEntity.class, TpmVerticalSchemeForecastBudgetCashVo.class, HashSet.class, ArrayList.class);
                cashConfirmVo.setBudgetCashVoList(cashVoList);
            }
        }


        List<String> businessNoList = Lists.newArrayList();
        List<String> noCashList = Lists.newArrayList();
        for (Map.Entry<String, TpmVerticalSchemeForecastBudgetCashConfirmVo> entry : confirmVoMap.entrySet()) {
            TpmVerticalSchemeForecastBudgetCashConfirmVo vo = entry.getValue();
            TpmVerticalSchemeForecastVo forecastVo = vo.getForecastVo();
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), forecastVo.getProcessStatus()),
                    "当前审批状态[%s]不允许提交审批", ProcessStatusEnum.PASS.getValue());
            Validate.isTrue(!StringUtils.equals(ProcessStatusEnum.COMMIT.getDictCode(), forecastVo.getProcessStatus()),
                    "当前审批状态[%s]不允许确认", ProcessStatusEnum.COMMIT.getValue());

            List<TpmVerticalSchemeForecastBudgetCashEntity> budgetCashEntityList = budgetCashMap.get(forecastVo.getId());
            if (CollectionUtils.isEmpty(budgetCashEntityList)){
//                throw new RuntimeException("垂直方案预测["+forecastVo.getSchemeForecastCode()+"]无兑付明细！");
                noCashList.add(forecastVo.getSchemeItemCode());
            }
        }

        if (!CollectionUtils.isEmpty(noCashList)){
            //有没有做手动确认的，自动生成一下
            List<TpmVerticalSchemeForecastBudgetCashVo> newBudgetCashVos = tpmVerticalSchemeForecastBudgetCashRepository.findBudgetListByPlanItemCode(noCashList);
            Map<String, List<TpmVerticalSchemeForecastBudgetCashVo>> newBudgetCashMap = newBudgetCashVos.stream().collect(Collectors.groupingBy(TpmVerticalSchemeForecastBudgetCashVo::getPlanItemCode));

            List<TpmVerticalSchemeForecastBudgetCashEntity> saveCashList = Lists.newArrayList();
            for (Map.Entry<String, TpmVerticalSchemeForecastBudgetCashConfirmVo> entry : confirmVoMap.entrySet()) {
                TpmVerticalSchemeForecastBudgetCashConfirmVo vo = entry.getValue();
                TpmVerticalSchemeForecastVo forecastVo = vo.getForecastVo();

                List<TpmVerticalSchemeForecastBudgetCashVo> newBudgetCashList = newBudgetCashMap.get(forecastVo.getSchemeItemCode());
                if (!CollectionUtils.isEmpty(newBudgetCashList)){
                    vo.setBudgetCashVoList(newBudgetCashList);
                    List<TpmVerticalSchemeForecastBudgetCashDto> newBudgetCashDtoList = (List<TpmVerticalSchemeForecastBudgetCashDto>) nebulaToolkitService.copyCollectionByWhiteList(newBudgetCashList, TpmVerticalSchemeForecastBudgetCashVo.class, TpmVerticalSchemeForecastBudgetCashDto.class, HashSet.class, ArrayList.class);
                    newBudgetCashDtoList.forEach(item -> item.setConfirmAmount(item.getActFrozenAmount()));
                    dto.setBudgetCashDtoList(newBudgetCashDtoList);
                    List<TpmVerticalSchemeForecastBudgetCashEntity> budgetCashEntityList = tpmVerticalSchemeForecastUtil.buildBudgetCashEntityList(dto, vo);
                    saveCashList.addAll(budgetCashEntityList);
                }
            }

            if (!CollectionUtils.isEmpty(saveCashList)){
                this.tpmVerticalSchemeForecastBudgetCashRepository.saveBatch(saveCashList);
                budgetCashMap.putAll(saveCashList.stream().collect(Collectors.groupingBy(TpmVerticalSchemeForecastBudgetCashEntity::getSchemeForecastId)));
            }
        }

        for (Map.Entry<String, TpmVerticalSchemeForecastBudgetCashConfirmVo> entry : confirmVoMap.entrySet()) {
            TpmVerticalSchemeForecastBudgetCashConfirmVo vo = entry.getValue();
            TpmVerticalSchemeForecastVo forecastVo = vo.getForecastVo();
            List<TpmVerticalSchemeForecastBudgetCashEntity> budgetCashEntityList = budgetCashMap.get(forecastVo.getId());
            //提交流程了才冻结数据
            tpmVerticalSchemeForecastUtil.unOrFrozenBudget(forecastVo, budgetCashEntityList, BudgetOperationTypeEnum.FREEZE, false);
            businessNoList.add(forecastVo.getSchemeForecastCode());
        }

        ProcessBusinessDto processBusinessDto = dto.getProcessBusiness();
        processBusinessDto.setBusinessCode(TpmVerticalSchemeForecastConstants.PROCESS_NAME_BATCH_VERTICAL_SCHEME_FORECAST);
        processBusinessDto.setBusinessNo(UUID.randomUUID().toString().replace("-", ""));
        processBusinessDto.setBusinessNoList(businessNoList);
        ProcessBusinessVo processBusinessVo = processBatchBusinessService.processStart(processBusinessDto);

        this.tpmVerticalSchemeForecastRepository.updateProcessStatus(businessNoList, ProcessStatusEnum.COMMIT.getDictCode(), processBusinessVo.getProcessNo(), null);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void completeCallback(String businessNo, String processStatus) {
        Validate.notBlank(businessNo, "业务编码[businessNo]为空");
        Validate.notBlank(processStatus, "审批状态[processStatus]为空");
        String status = TpmVerticalSchemeStatusEnum.NONE.getCode();
        if (StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), processStatus)) {
            status = TpmVerticalSchemeStatusEnum.CONFIRMED.getCode();
        } else {
            TpmVerticalSchemeForecastBudgetCashConfirmVo confirmDetail = this.findConfirmDetail(null, businessNo);
            TpmVerticalSchemeForecastVo forecastVo = confirmDetail.getForecastVo();
            List<TpmVerticalSchemeForecastBudgetCashEntity> budgetCashEntityList = (List<TpmVerticalSchemeForecastBudgetCashEntity>) nebulaToolkitService.copyCollectionByWhiteList(confirmDetail.getBudgetCashVoList(), TpmVerticalSchemeForecastBudgetCashVo.class, TpmVerticalSchemeForecastBudgetCashEntity.class, HashSet.class, ArrayList.class);
            tpmVerticalSchemeForecastUtil.unOrFrozenBudget(forecastVo, budgetCashEntityList, BudgetOperationTypeEnum.UNFREEZE, false);
        }

        this.tpmVerticalSchemeForecastRepository.updateProcessStatus(businessNo, processStatus, null, status);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void completeCallbackBatch(List<String> businessNoList, String processStatus) {
        Validate.isTrue(!CollectionUtils.isEmpty(businessNoList), "业务编码[businessNoList]为空");
        Validate.notBlank(processStatus, "审批状态[processStatus]为空");
        String status = TpmVerticalSchemeStatusEnum.NONE.getCode();
        if (StringUtils.equals(ProcessStatusEnum.PASS.getDictCode(), processStatus)) {
            status = TpmVerticalSchemeStatusEnum.CONFIRMED.getCode();
        } else {
            List<TpmVerticalSchemeForecastEntity> forecastEntityList = this.tpmVerticalSchemeForecastRepository.findBySchemeForecastCodes(businessNoList);
            Validate.isTrue(!CollectionUtils.isEmpty(forecastEntityList), "方案预测不存在");
            List<TpmVerticalSchemeForecastVo> forecastVoList = (List<TpmVerticalSchemeForecastVo>) nebulaToolkitService.copyCollectionByWhiteList(forecastEntityList, TpmVerticalSchemeForecastEntity.class,TpmVerticalSchemeForecastVo.class, HashSet.class, ArrayList.class);

            List<String> ids = forecastEntityList.stream().map(TpmVerticalSchemeForecastEntity::getId).collect(Collectors.toList());
            List<TpmVerticalSchemeForecastBudgetCashEntity> cashEntityList = tpmVerticalSchemeForecastBudgetCashRepository.findByForecastCondition(null, null, null, null,ids);
            Map<String, List<TpmVerticalSchemeForecastBudgetCashEntity>> budgetCashMap = cashEntityList.stream().collect(Collectors.groupingBy(TpmVerticalSchemeForecastBudgetCashEntity::getSchemeForecastId));
            for (TpmVerticalSchemeForecastVo forecastVo : forecastVoList) {
                List<TpmVerticalSchemeForecastBudgetCashEntity> budgetCashEntityList = budgetCashMap.get(forecastVo.getId());
                tpmVerticalSchemeForecastUtil.unOrFrozenBudget(forecastVo, budgetCashEntityList, BudgetOperationTypeEnum.UNFREEZE, false);
            }
        }
        this.tpmVerticalSchemeForecastRepository.updateProcessStatus(businessNoList, processStatus, null, status);
    }

    @Override
    public TpmVerticalSchemeForecastBudgetCashConfirmVo findConfirmDetail(String id, String code) {
        Validate.isTrue(StringUtils.isNotEmpty(id) || StringUtils.isNotEmpty(code), "缺少必要查询参数");

        TpmVerticalSchemeForecastEntity forecastEntity = this.tpmVerticalSchemeForecastRepository.getByIdOrCode(id, code);
        Validate.notNull(forecastEntity, "方案预测不存在，请刷新列表");
        TpmVerticalSchemeForecastVo forecastVo = nebulaToolkitService.copyObjectByWhiteList(forecastEntity, TpmVerticalSchemeForecastVo.class, HashSet.class, ArrayList.class);

        TpmVerticalSchemeForecastBudgetCashConfirmVo vo = new TpmVerticalSchemeForecastBudgetCashConfirmVo();
        vo.setEstimatedWriteOffAmount(forecastEntity.getEstimatedWriteOffAmount());
        vo.setForecastVo(forecastVo);
        vo.setId(forecastEntity.getId());

        List<TpmVerticalSchemeForecastBudgetCashEntity> cashEntityList = tpmVerticalSchemeForecastBudgetCashRepository.findByForecastCondition(forecastEntity.getId(), null, null, null);
        if (!CollectionUtils.isEmpty(cashEntityList)) {
            List<TpmVerticalSchemeForecastBudgetCashVo> cashVoList = (List<TpmVerticalSchemeForecastBudgetCashVo>) nebulaToolkitService.copyCollectionByWhiteList(cashEntityList, TpmVerticalSchemeForecastBudgetCashEntity.class, TpmVerticalSchemeForecastBudgetCashVo.class, HashSet.class, ArrayList.class);
            vo.setBudgetCashVoList(cashVoList);
            return vo;
        }

        List<TpmVerticalSchemeForecastBudgetCashVo> budgetCashVos = tpmVerticalSchemeForecastBudgetCashRepository.findBudgetListByPlanItemCode(forecastVo.getSchemeItemCode());
        budgetCashVos.forEach(budgetCashVo -> {
            budgetCashVo.setSchemeForecastId(forecastVo.getId());
            budgetCashVo.setSchemeForecastCode(forecastVo.getSchemeForecastCode());
            budgetCashVo.setSchemeCode(forecastVo.getSchemeCode());
            budgetCashVo.setSchemeItemCode(forecastVo.getSchemeItemCode());
            budgetCashVo.setConfirmAmount(forecastVo.getEstimatedWriteOffAmount());
            budgetCashVo.setUsedAmount(BigDecimal.ZERO);
            budgetCashVo.setDetailCode(budgetCashVo.getDetailCode());
            budgetCashVo.setBalanceAmount(budgetCashVo.getConfirmAmount());
            budgetCashVo.setOverFrozenAmount(BigDecimal.ZERO);
        });
        vo.setBudgetCashVoList(budgetCashVos);
        return vo;
    }

    @Override
    public List<String> findAutoCreateDataList(TpmVerticalSchemeForecastAutoCreateDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return tpmVerticalSchemeForecastRepository.findAutoCreateDataList(dto);
    }

    @Override
    public Long findAutoRefreshCount(TpmVerticalSchemeForecastAutoRefreshDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return tpmVerticalSchemeForecastRepository.findAutoRefreshDataCount(dto);
    }

    /**
     * 定时任务更新查询待更新数据id
     *
     * @param pageable
     * @param dto
     * @return
     */
    @Override
    public List<String> findAutoRefreshDataList(Pageable pageable, TpmVerticalSchemeForecastAutoRefreshDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 2000));
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return tpmVerticalSchemeForecastRepository.findAutoRefreshDataList(pageable, dto);
    }

    @Override
    public Page<TpmVerticalSchemeForecastBudgetCashVo> findCashPage(Pageable pageable, TpmVerticalSchemeForecastBudgetCashQueryDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 2000));
        dto.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(dto.getTenantCode(), "未获取到租户号！");
        return tpmVerticalSchemeForecastBudgetCashRepository.findCashPage(pageable, dto);
    }

    @Override
    public List<String> lock(List<String> keys, TimeUnit timeUnit, int lockTime, int waitedTime) {
        Validate.notEmpty(keys, "加锁对象key为空");
        if (Objects.isNull(timeUnit)) {
            timeUnit = TimeUnit.SECONDS;
        }
        if (lockTime == 0) {
            lockTime = 60 * 2;
        }
        if (waitedTime == 0) {
            waitedTime = 3;
        }
        List<String> lockedKeys = new ArrayList<>();
        try {
            for (String key : keys) {
                String lockKey = TpmVerticalSchemeForecastConstants.FORECAST_CASH_LOCK_KEY + key;
                boolean locked = redisLockService.tryLock(lockKey, timeUnit, lockTime, waitedTime);
                Validate.isTrue(locked, "当前兑付明细正在被操作，请稍后...");
                lockedKeys.add(lockKey);
            }
        } finally {
            if (lockedKeys.size() != keys.size()) {
                lockedKeys.forEach(key -> redisLockService.unlock(key));
            }
        }
        return lockedKeys;
    }

    @Transactional
    @Override
    public void operate(List<TpmVerticalSchemeForecastBudgetCashOperateDto> dtoList, boolean doSave) {
        Validate.notEmpty(dtoList, "兑付明细操作明细为空");
        dtoList.forEach(dto -> {
            Validate.notEmpty(dto.getDetailCode(), "兑付明细编码为空");
            Validate.notEmpty(dto.getOperateType(), "兑付明细操作类型为空");
            Validate.notNull(dto.getOperateAmount(), "兑付明细操作金额为空");
        });

        List<String> detailCodeList = dtoList.stream().map(TpmVerticalSchemeForecastBudgetCashOperateDto::getDetailCode).collect(Collectors.toList());
        List<TpmVerticalSchemeForecastBudgetCashEntity> cashEntityList = tpmVerticalSchemeForecastBudgetCashRepository.findBudgetListByDetailCodes(detailCodeList);
        Map<String, TpmVerticalSchemeForecastBudgetCashEntity> map = cashEntityList.stream().collect(Collectors.toMap(TpmVerticalSchemeForecastBudgetCashEntity::getDetailCode, v -> v, (v1, v2) -> v2));

        for (TpmVerticalSchemeForecastBudgetCashOperateDto dto : dtoList) {
            Validate.notNull(map.get(dto.getDetailCode()), "兑付明细[%s]不存在", dto.getDetailCode());
            TpmVerticalSchemeForecastBudgetCashEntity entity = map.get(dto.getDetailCode());

            BigDecimal balanceAmount = entity.getBalanceAmount();
            BigDecimal usedAmount = entity.getUsedAmount();
            balanceAmount = Objects.isNull(balanceAmount) ? BigDecimal.ZERO : entity.getConfirmAmount();
            balanceAmount = Objects.isNull(balanceAmount) ? BigDecimal.ZERO : balanceAmount;
            usedAmount = Objects.isNull(usedAmount) ? BigDecimal.ZERO : usedAmount;

            if (StringUtils.equals(TpmVerticalSchemeCashOperateTypeEnum.use.getCode(), dto.getOperateType())) {
                Validate.isTrue(balanceAmount.compareTo(dto.getOperateAmount()) >= 0, "兑付明细[%s]余额不足，当前余额[%s]", dto.getDetailCode(), balanceAmount);
                entity.setBalanceAmount(entity.getBalanceAmount().subtract(dto.getOperateAmount()));
                entity.setUsedAmount(entity.getUsedAmount().add(dto.getOperateAmount()));
            } else if (StringUtils.equals(TpmVerticalSchemeCashOperateTypeEnum.back.getCode(), dto.getOperateType())) {
                Validate.isTrue(usedAmount.compareTo(dto.getOperateAmount()) >= 0, "兑付明细[%s]退回金额超过已使用金额，当前已使用金额[%s]", dto.getDetailCode(), usedAmount);
                entity.setBalanceAmount(entity.getBalanceAmount().add(dto.getOperateAmount()));
                entity.setUsedAmount(entity.getUsedAmount().subtract(dto.getOperateAmount()));
            } else {
                throw new RuntimeException("兑付明细[" + dto.getDetailCode() + "]操作类型错误");
            }
        }
        if (doSave) {
            this.tpmVerticalSchemeForecastBudgetCashRepository.updateBatchById(map.values());
        }
    }

    @Override
    public void unLock(List<String> lockedKeys) {
        Validate.notEmpty(lockedKeys, "解锁对象key为空");
        lockedKeys.forEach(lockKey -> redisLockService.unlock(lockKey));
    }

    @Override
    public List<TpmVerticalSchemeForecastBudgetCashVo> findDetailListByConditions(TpmVerticalSchemeForecastBudgetCashDto cashDto) {
        return tpmVerticalSchemeForecastBudgetCashRepository.findDetailListByConditions(cashDto);
    }

}
