package com.biz.crm.tpm.business.scheme.forecast.local.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.service.TpmCustomerSummaryConfigureService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.log.DetailedForecastLogEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastLogEventListener;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.util.MathUtil;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.SchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.repository.SchemeForecastRepository;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.log.SchemeForecastLogEventDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.event.SchemeForecastLogEventListener;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.VariableFunctionEnum;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-25
 */
@Slf4j
@Component
public class ActivityDetailPlanPassSchemeForecastUtil {

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Autowired
    private AuditFormulaMainService auditFormulaMainService;

    @Autowired(required = false)
    private VariableService variableService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private SchemeForecastRepository schemeForecastRepository;

    @Autowired(required = false)
    private TpmCustomerSummaryConfigureService tpmCustomerSummaryConfigureService;

    /**
     * onlyKey生成
     *
     * @param entity
     * @return
     */
    public String packageOnlyKey(SchemeForecastEntity entity, String timeStamp) {
        if (StringUtils.isEmpty(timeStamp)) {
            timeStamp = "";
        }
        return DigestUtils.md5Hex(entity.getSchemeCode() + entity.getSchemeItemCode() + timeStamp);
    }

    @Transactional(rollbackFor = Exception.class)
    public void insert(SchemeForecastDto schemeForecastDto) {
        SchemeForecastEntity schemeForecastEntity = this.nebulaToolkitService.copyObjectByWhiteList(schemeForecastDto, SchemeForecastEntity.class, null, null);
        schemeForecastEntity.setTenantCode(TenantUtils.getTenantCode());
        schemeForecastEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        schemeForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        schemeForecastEntity.setShowFlag(YesOrNoEnum.YES.getCode());
        schemeForecastEntity.setOnlyKey(this.packageOnlyKey(schemeForecastEntity, null));
        // 日志新增
        SchemeForecastLogEventDto logEventDto = new SchemeForecastLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(schemeForecastDto);
        SerializableBiConsumer<SchemeForecastLogEventListener, SchemeForecastLogEventDto> onCreate =
                SchemeForecastLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, SchemeForecastLogEventListener.class, onCreate);
        this.schemeForecastRepository.saveOrUpdate(schemeForecastEntity);
    }

    /**
     * 主体
     *
     * @param schemeForecastDto
     * @param item
     * @param loginUser
     */
    @Async("asyncThread")
    public void buildUnit1Param(SchemeForecastDto schemeForecastDto, ActivityPlanItemDto item, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        log.info("方案编码[{}]明细编码[{}]方案预测主体新增", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode());
        if (StringUtils.isNotEmpty(schemeForecastDto.getAuditType())) {
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(schemeForecastDto.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(schemeForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(schemeForecastDto.getBusinessUnitCode());
                dto.setAuditType(schemeForecastDto.getAuditType());
                dto.setSalesOrgCodes(schemeForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(schemeForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(schemeForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(schemeForecastDto.getRtmMode());
                dto.setFirstChannel(schemeForecastDto.getFirstChannelCode());
                dto.setSecondChannel(schemeForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(schemeForecastDto.getCustomerAccount());
                dto.setDisplayNumber(schemeForecastDto.getDisplayNumber());
                List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                    CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), schemeForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                    this.setParam(formulaMainVoList.get(0), schemeForecastDto, calDto);
                } else {
                    schemeForecastDto.setAuditFormulaCode(null);
                }
            } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(schemeForecastDto.getAuditType())) {
                AuditFormulaMainVo auditFormulaMainVo = auditFormulaMainService.findByCode(schemeForecastDto.getAuditFormulaCode());
                CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, schemeForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
                this.setParam(auditFormulaMainVo, schemeForecastDto, calDto);
            } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(schemeForecastDto.getAuditType())) {
                schemeForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
                schemeForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
            }
        }
        this.insert(schemeForecastDto);
    }


    /**
     * 垂直
     *
     * @param schemeForecastDto
     * @param item
     * @param loginUser
     */
    @Async("asyncThread")
    public void buildUnit3Param(SchemeForecastDto schemeForecastDto, ActivityPlanItemDto item, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        log.info("方案编码[{}]方案明细编码[{}]方案预测垂直新增", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode());
        if (StringUtils.isNotEmpty(schemeForecastDto.getAuditType())) {
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(schemeForecastDto.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(schemeForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(schemeForecastDto.getBusinessUnitCode());
                dto.setAuditType(schemeForecastDto.getAuditType());
                dto.setSalesOrgCodes(schemeForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(schemeForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(schemeForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(schemeForecastDto.getRtmMode());
                dto.setFirstChannel(schemeForecastDto.getFirstChannelCode());
                dto.setSecondChannel(schemeForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(schemeForecastDto.getCustomerAccount());
                dto.setDisplayNumber(schemeForecastDto.getDisplayNumber());
                List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                    CalculateDto calDto = this.buildCalParam(formulaMainVoList.get(0), schemeForecastDto, TpmAuditTypeEnum.AUDITTYPE1.getCode());
                    this.setParam(formulaMainVoList.get(0), schemeForecastDto, calDto);
                } else {
                    schemeForecastDto.setAuditFormulaCode(null);
                }
            } else if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(schemeForecastDto.getAuditType())) {
                AuditFormulaMainVo auditFormulaMainVo = auditFormulaMainService.findByCode(schemeForecastDto.getAuditFormulaCode());
                CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, schemeForecastDto, TpmAuditTypeEnum.AUDITTYPE2.getCode());
                this.setParam(auditFormulaMainVo, schemeForecastDto, calDto);
            } else if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(schemeForecastDto.getAuditType())) {
                schemeForecastDto.setWriteOffConditions(TpmAuditTypeEnum.AUDITTYPE3.getValue());
                schemeForecastDto.setEstimatedWriteOffAmount(item.getFeeAmount());
            }
        }
        this.insert(schemeForecastDto);
    }

    @Async("asyncThread")
    @Transactional(rollbackFor = Exception.class)
    public void refreshUpdate(SchemeForecastEntity entity, UserIdentity loginUser) {
        loginUserService.refreshAuthentication(loginUser);
        SchemeForecastDto dto = nebulaToolkitService.copyObjectByWhiteList(entity, SchemeForecastDto.class, HashSet.class, ArrayList.class);
        this.refreshCal(dto);
        entity.setWriteOffConditions(dto.getWriteOffConditions());
        entity.setWriteOffFormula(dto.getWriteOffFormula());
        entity.setWriteOffConditionValue(dto.getWriteOffConditionValue());
        entity.setWriteOffFormulaValue(dto.getWriteOffFormulaValue());
        entity.setEstimatedWriteOffAmount(dto.getEstimatedWriteOffAmount());
        entity.setWriteOffPremise(dto.getWriteOffPremise());
        entity.setAuditFormulaCode(dto.getAuditFormulaCode());
        entity.setCalEx(dto.getCalEx());
        entity.setCalParam(dto.getCalParam());
        entity.setOverBudgetRemark(dto.getOverBudgetRemark());
        entity.setOverBudgetFailAmount(dto.getOverBudgetFailAmount());
        entity.setOverBudgetSuccess(dto.getOverBudgetSuccess());
        entity.setHeadFeeAmount(dto.getHeadFeeAmount());
        entity.setDepartmentFeeAmount(dto.getDepartmentFeeAmount());
        if (StringUtils.isEmpty(entity.getOnlyKey())) {
            entity.setOnlyKey(this.packageOnlyKey(entity, null));
        }
        this.schemeForecastRepository.updateById(entity);
    }

    /**
     * 更新
     *
     * @param schemeForecastDto
     */
    public void refreshCal(SchemeForecastDto schemeForecastDto) {
        log.info("方案编码[{}]方案明细编码[{}]方案预测更新计算", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode());

        schemeForecastDto.setWriteOffConditions("");
        schemeForecastDto.setWriteOffConditionValue("");
        schemeForecastDto.setWriteOffFormula("");
        schemeForecastDto.setWriteOffFormulaValue("");
        schemeForecastDto.setWriteOffPremise("");
        schemeForecastDto.setEstimatedWriteOffAmount(null);
        schemeForecastDto.setCalEx("");
        schemeForecastDto.setCalParam("");
        schemeForecastDto.setOverBudgetRemark("");
        if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(schemeForecastDto.getAuditType())) {
            if (StringUtils.equals(BusinessUnitEnum.HEADQUARTERS.getCode(), schemeForecastDto.getBusinessUnitCode())
                    || StringUtils.equals(BusinessUnitEnum.VERTICAL.getCode(), schemeForecastDto.getBusinessUnitCode())) {
                List<ActivityPlanItemVo> detailPlanItemVos = activityPlanItemSdkService.listByItemCodeList(Lists.newArrayList(schemeForecastDto.getSchemeItemCode()));
                Validate.notEmpty(detailPlanItemVos, "方案编码[%s]方案明细编码[%s]数据不存在！", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode());
                schemeForecastDto.setEstimatedWriteOffAmount(detailPlanItemVos.get(0).getFeeAmount());
                schemeForecastDto.setHeadFeeAmount(detailPlanItemVos.get(0).getHeadFeeAmount());
                schemeForecastDto.setDepartmentFeeAmount(detailPlanItemVos.get(0).getDepartmentFeeAmount());
            }
        } else {
            AuditFormulaMainVo auditFormulaMainVo = auditFormulaMainService.findByCode(schemeForecastDto.getAuditFormulaCode());
            if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(schemeForecastDto.getAuditType())) {
                AuditFormulaMainDto dto = new AuditFormulaMainDto();
                dto.setBusinessFormatCode(schemeForecastDto.getBusinessFormatCode());
                dto.setBusinessUnitCode(schemeForecastDto.getBusinessUnitCode());
                dto.setAuditType(schemeForecastDto.getAuditType());
                dto.setSalesOrgCodes(schemeForecastDto.getSaleOrgCode());
                dto.setActivityFormCode(schemeForecastDto.getActivityFormCode());
                dto.setActivityTypeCode(schemeForecastDto.getActivityTypeCode());
                dto.setCustomerTypes(schemeForecastDto.getRtmMode());
                dto.setFirstChannel(schemeForecastDto.getFirstChannelCode());
                dto.setSecondChannel(schemeForecastDto.getSecondChannelCode());
                dto.setCustomerAccount(schemeForecastDto.getCustomerAccount());
                dto.setDisplayNumber(schemeForecastDto.getDisplayNumber());
                List<AuditFormulaMainVo> formulaMainVoList = auditFormulaMainService.findListByDto(dto);
                formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty(e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                    //上面查核销公式的时候会处理，默认取第一条公式不为空的就可以了
                    auditFormulaMainVo = formulaMainVoList.get(0);
                } else {
                    schemeForecastDto.setAuditFormulaCode(null);
                }
            }
            CalculateDto calDto = this.buildCalParam(auditFormulaMainVo, schemeForecastDto, schemeForecastDto.getAuditType());
            this.setParam(auditFormulaMainVo, schemeForecastDto, calDto);
        }
    }

    /**
     * 公式计算请求参数构建
     * paramMap 参数说明：
     * productCode：产品编码
     * productCode：产品编码
     * yearMonthStr：年月
     * terminalCode：门店编码
     * terminalName：门店名称
     * productBrandCode：品牌编码
     * productBrandName：品牌名称
     * productCategoryCode：大类编码
     * productCategoryName：大类名称
     * productItemCode：品项编码
     * productItemName：品项名称
     * activitiesDetailCode：活动明细编码
     * region：区域
     * channelCode：渠道编码
     * channelName：渠道名称
     * planItemCode：方案活动明细编码、促销规划明细编码、分子公司活动细案明细编码
     * detailPlanItemCode：活动细案明细编码
     *
     * @param auditFormulaMainVo
     * @param schemeForecastDto
     * @param auditType
     * @return
     */
    public CalculateDto buildCalParam(AuditFormulaMainVo auditFormulaMainVo, SchemeForecastDto schemeForecastDto, String auditType) {
        if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty(auditFormulaMainVo.getAuditFormulaInfoVoList())) {
            CalculateDto dto = new CalculateDto();
            dto.setCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setCustomerCode(schemeForecastDto.getCustomerCode());
            dto.setCustomerErpCode(schemeForecastDto.getCustomerErpCode());
            dto.setCustomerName(schemeForecastDto.getCustomer());
            dto.setBusinessFormatCode(schemeForecastDto.getBusinessFormatCode());
            dto.setBusinessUnitCode(schemeForecastDto.getBusinessUnitCode());
            dto.setActivityTypeCode(schemeForecastDto.getActivityTypeCode());
            dto.setActivityTypeName(schemeForecastDto.getActivityTypeName());
            dto.setActivityFormCode(schemeForecastDto.getActivityFormCode());
            dto.setActivityFormName(schemeForecastDto.getActivityFormName());
            dto.setStartTimeOrDate(schemeForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(schemeForecastDto.getActivityEndTime());
            dto.setFormulaInfoDtoList(this.copyFormulaInfoList(auditFormulaMainVo.getAuditFormulaInfoVoList()));
            dto.setAuditType(auditType);
            dto.setSalesOrgCode(schemeForecastDto.getSaleOrgCode());
            dto.setSalesOrgErpCode(schemeForecastDto.getSalesOrgErpCode());
            dto.setSalesOrganizationCode(schemeForecastDto.getSalesInstitutionCode());
            dto.setSalesOrganizationErpCode(schemeForecastDto.getSalesInstitutionErpCode());
            dto.setSalesRegionCode(schemeForecastDto.getSalesRegionCode());
            dto.setSalesRegionErpCode(schemeForecastDto.getSalesRegionErpCode());
            dto.setSalesGroupCode(schemeForecastDto.getSalesOrgCode());
            dto.setSalesGroupErpCode(schemeForecastDto.getSalesOrgErpCode());
            dto.setProductCode(schemeForecastDto.getProductCode());
            dto.setYearMonthLy(schemeForecastDto.getYearMonthStr());
            dto.setStoresCode(schemeForecastDto.getTerminalCode());
            dto.setBrandCode(schemeForecastDto.getProductBrandCode());
            dto.setCategoryCode(schemeForecastDto.getProductCategoryCode());
            dto.setItemCode(schemeForecastDto.getProductItemCode());
            dto.setPlanItemCode(schemeForecastDto.getSchemeItemCode());
            dto.setActivityOrgCode(schemeForecastDto.getRegion());
            dto.setActivityOrgName(schemeForecastDto.getRegionName());
            dto.setRetailBusinessmanCode(schemeForecastDto.getSystemCode());
            dto.setRetailBusinessmanName(schemeForecastDto.getSystemName());
            dto.setActivityTypeCode(schemeForecastDto.getActivityTypeCode());
            dto.setActivityFormCode(schemeForecastDto.getActivityFormCode());
            dto.setPersonCode(schemeForecastDto.getPersonCode());
            dto.setIdentityCard(schemeForecastDto.getIdentityCard());
            dto.setSecondChannelCode(schemeForecastDto.getSecondChannelCode());
            if (Objects.nonNull(schemeForecastDto.getActivityStartTime())) {
                String date = DateUtil.format(schemeForecastDto.getActivityStartTime(), DateUtil.DEFAULT_YEAR_MONTH_DAY);
                //长度为10满足yyyy-MM-dd
                if (date.length() == 10) {
                    dto.setDate(DateUtil.parse(date, DateUtil.DEFAULT_YEAR_MONTH_DAY));
                }
                //长度为19满足yyyy-MM-dd HH:mm:ss
                else if (date.length() == 19) {
                    dto.setDate(DateUtil.parse(date, DateUtil.DEFAULT_DATE_ALL_PATTERN));
                }
            }
            dto.setDealerCode(schemeForecastDto.getCustomerErpCode());
            dto.setChannel(schemeForecastDto.getChannelCode());
            dto.setStartTimeOrDate(schemeForecastDto.getActivityStartTime());
            dto.setEndTimeOrDate(schemeForecastDto.getActivityEndTime());
            dto.setPersonIdCard(schemeForecastDto.getIdentityCard());
            dto.setFirstChannelCode(schemeForecastDto.getFirstChannelCode());
            dto.setSecondChannelCode(schemeForecastDto.getSecondChannelCode());
            dto.setHeadBudgetItemCode(schemeForecastDto.getHeadBudgetItemCode());
            dto.setMonthBudgetCode(schemeForecastDto.getMonthBudgetCode());
            dto.setSpecification(schemeForecastDto.getFormDescription());
            dto.setIsTemporary(schemeForecastDto.getIsTemporary());
            dto.setCusCreateTime(schemeForecastDto.getCusCreateTime());
            dto.setDistributionChannel(schemeForecastDto.getDistributionChannelCode());

            //合并客户编码-主体
            if (StringUtils.isNotEmpty(dto.getCustomerCode()) && BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())) {
                Map<String, Set<String>> map = tpmCustomerSummaryConfigureService.configureIncludeMap(Lists.newArrayList(dto.getCustomerCode()));
                if (map.containsKey(dto.getCustomerCode())) {
                    dto.setCustomerCodeList(map.get(dto.getCustomerCode()));
                } else {
                    dto.setCustomerCodeList(Sets.newHashSet(dto.getCustomerCode()));
                }
            }
            return dto;
        } else {
            log.info("方案预测=====》核销条件为空");
        }
        return null;
    }

    /**
     * 公式参数计算组装
     *
     * @param auditFormulaMainVo
     * @param schemeForecastDto
     * @param calDto
     */
    public void setParam(AuditFormulaMainVo auditFormulaMainVo, SchemeForecastDto schemeForecastDto, CalculateDto calDto) {
        if (Objects.isNull(calDto)) {
            return;
        }
        schemeForecastDto.setCalEx("");
        List<CalculateVo> calculateVos = Lists.newArrayList();
        try {
            calculateVos = variableService.orCalculateConditionAndExpression(Lists.newArrayList(calDto));
        } catch (Exception ex) {
            ex.printStackTrace();
            if (StringUtils.isNotEmpty(ex.getMessage())) {
                int length = Math.min(ex.getMessage().length(), 200);
                schemeForecastDto.setCalEx(ex.getMessage().substring(0, length));
            } else {
                schemeForecastDto.setCalEx("NPE");
            }
            log.error("方案编码[{}]方案明细编码[{}]方案预测计算失败：{}", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode(), ex.getMessage());
        }

        //公式条件满足的计算结果
        AtomicReference<String> filterCondition = new AtomicReference<>();
        List<CalculateVo> filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        if (filterVos.size() > 1) {
            log.error("核销公式编码 [" + auditFormulaMainVo.getAuditFormulaCode() + "] 计算结果：多个核销公式条件同时满足！");
        } else if (CollectionUtils.isNotEmpty(filterVos)) {
            filterCondition.set(filterVos.get(0).getFormulaConditionName());
        }
        //预估核销金额
        BigDecimal estimatedWriteOffAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = filterVos.get(0).getFormulaValue();
        } else {
            log.info("方案编码[{}]方案明细编码[{}]未满足公式任何条件，默认预核销金额为0！", schemeForecastDto.getSchemeCode(), schemeForecastDto.getSchemeItemCode());
        }

        //变量对应的值
        Map<String, BigDecimal> variableValueMap = new HashMap<>();
        calculateVos.forEach(v -> {
            if (Objects.nonNull(v.getVariableValueMap())) {
                variableValueMap.putAll(v.getVariableValueMap());
            }
        });

        List<String> variableCodeList = new ArrayList<>();
        for (CalculateVo calculateVo : calculateVos) {
            if (Objects.nonNull(calculateVo.getVariableValueMap())) {
                variableCodeList.addAll(calculateVo.getVariableValueMap().keySet());
            }
        }

        //核销变量编码-名称映射
        Map<String, String> variableNameMap = variableService.getVariableMap(VariableFunctionEnum.AUDIT.getCode(), variableCodeList);

        //核销条件取值
        Map<String, String> conditionValueMap = new HashMap<>();
        //核销公式取值
        Map<String, String> formulaValueMap = new HashMap<>();
        //可核销前提
        List<String> canAuditPreList = new ArrayList<>();
        auditFormulaMainVo.getAuditFormulaInfoVoList()
//                .stream().filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .forEach(formula -> {
                    //核销条件
                    Set<String> formulaCondition = MathUtil.getFormulaReplace(formula.getAuditFormulaCondition());
                    formulaCondition.forEach(v -> {
                        if (conditionValueMap.containsKey(v)) {
                            return;
                        }
                        if (variableValueMap.containsKey(v)) {
                            conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                            return;
                        }
                        conditionValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                    });
                    //核销公式
                    Set<String> auditFormula = MathUtil.getFormulaReplace(formula.getAuditFormula());
                    auditFormula.forEach(v -> {
                        if (formulaValueMap.containsKey(v)) {
                            return;
                        }
                        if (variableValueMap.containsKey(v)) {
                            formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : " + variableValueMap.get(v).toString());
                            return;
                        }
                        formulaValueMap.put(v, variableNameMap.getOrDefault(v, v) + " : ");
                        //查不到数据先默认达标
                        canAuditPreList.add(variableNameMap.getOrDefault(v, v) + "达标");
                    });
                });
        schemeForecastDto.setCalParam(JSON.toJSONString(calDto));
        schemeForecastDto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
        schemeForecastDto.setWriteOffConditions(auditFormulaMainVo.getAuditFormulaInfoVoList().stream()
                .filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .map(AuditFormulaInfoVo::getAuditFormulaConditionName).filter(Objects::nonNull)
                .collect(Collectors.joining(" , ")));
        schemeForecastDto.setWriteOffFormula(auditFormulaMainVo.getAuditFormulaInfoVoList().stream()
                .filter(e -> StringUtils.equals(e.getAuditFormulaConditionName(), filterCondition.get()))
                .map(AuditFormulaInfoVo::getAuditFormulaName).filter(Objects::nonNull)
                .collect(Collectors.joining(" , ")));
        schemeForecastDto.setWriteOffConditionValue(String.join(" , ", conditionValueMap.values()));
        schemeForecastDto.setWriteOffFormulaValue(String.join(" , ", formulaValueMap.values()));
        schemeForecastDto.setEstimatedWriteOffAmount(estimatedWriteOffAmount);
        schemeForecastDto.setWriteOffPremise(String.join(" , ", canAuditPreList));
    }

    public List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        List<FormulaInfoDto> list = new ArrayList<>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }
}
