package com.biz.crm.tpm.business.scheme.forecast.local.util;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedPredictionTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 活动方案推方案预测参数构建
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-18
 */
public class ActivitySchemePlanPassSchemeForecastBuilder {

    /**
     * 主体、垂直
     *
     * @param activityPlanDto
     * @param item
     * @param regionMap
     * @param feeBelongMap
     * @param customerVo
     * @param salesOrgAllParentVo
     * @return
     */
    public static SchemeForecastDto buildUnit1Dto(ActivityPlanDto activityPlanDto,
                                                  ActivityPlanItemDto item,
                                                  Map<String, String> regionMap,
                                                  Map<String, String> feeBelongMap,
                                                  CustomerVo customerVo,
                                                  SalesOrgAllParentVo salesOrgAllParentVo) {
        SchemeForecastDto schemeForecastDto = new SchemeForecastDto();
        schemeForecastDto.setDetailedPredictionType(EnableStatusEnum.ENABLE.getCode());
        schemeForecastDto.setBusinessFormatCode(activityPlanDto.getBusinessFormatCode());
        schemeForecastDto.setBusinessUnitCode(activityPlanDto.getBusinessUnitCode());
        schemeForecastDto.setSchemeCode(activityPlanDto.getPlanCode());
        schemeForecastDto.setSchemeItemCode(item.getPlanItemCode());
        schemeForecastDto.setSchemeName(activityPlanDto.getPlanName());
        schemeForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        schemeForecastDto.setActivityTypeName(item.getActivityTypeName());
        schemeForecastDto.setActivityFormCode(item.getActivityFormCode());
        schemeForecastDto.setActivityFormName(item.getActivityFormName());
        schemeForecastDto.setActivityStartTime(item.getActivityBeginDate());
        schemeForecastDto.setActivityEndTime(item.getActivityEndDate());
        schemeForecastDto.setSystemCode(item.getSystemCode());
        schemeForecastDto.setSystemName(item.getSystemName());
        schemeForecastDto.setAuditFormulaCode(item.getAuditConditionCode());
        schemeForecastDto.setAuditType(item.getAuditType());
        schemeForecastDto.setProductCode(item.getProductCode());
        schemeForecastDto.setProductName(item.getProductName());
        schemeForecastDto.setProductBrandCode(item.getProductBrandCode());
        schemeForecastDto.setProductBrandName(item.getProductBrandName());
        schemeForecastDto.setProductCategoryCode(item.getProductCategoryCode());
        schemeForecastDto.setProductCategoryName(item.getProductCategoryName());
        schemeForecastDto.setProductItemCode(item.getProductItemCode());
        schemeForecastDto.setProductItemName(item.getProductItemName());
        schemeForecastDto.setTerminalCode(item.getTerminalCode());
        schemeForecastDto.setTerminalName(item.getTerminalName());
        schemeForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        schemeForecastDto.setActivityTypeName(item.getActivityTypeName());
        schemeForecastDto.setActivityFormCode(item.getActivityFormCode());
        schemeForecastDto.setActivityFormName(item.getActivityFormName());
        schemeForecastDto.setFirstChannelCode(item.getFirstChannelCode());
        schemeForecastDto.setFirstChannelName(item.getFirstChannelName());
        schemeForecastDto.setSecondChannelCode(item.getSecondChannelCode());
        schemeForecastDto.setSecondChannelName(item.getSecondChannelName());
        schemeForecastDto.setIdentityCard("");
        schemeForecastDto.setPersonCode("");
        schemeForecastDto.setSchemeCode(activityPlanDto.getPlanCode());
        schemeForecastDto.setSchemeItemCode(item.getPlanItemCode());
        schemeForecastDto.setApplyAmount(item.getFeeAmount());
        schemeForecastDto.setDepartmentFeeAmount(item.getDepartmentFeeAmount());
        schemeForecastDto.setHeadFeeAmount(item.getHeadFeeAmount());

        if (Objects.nonNull(item.getFeeYearMonth())) {
            schemeForecastDto.setYearMonthStr(DateFormatUtils.format(item.getFeeYearMonth(), "yyyy-MM"));
        }

        //客户
        schemeForecastDto.setCustomer(item.getCustomerName());
        schemeForecastDto.setCustomerCode(item.getCustomerCode());
        if (Objects.nonNull(customerVo)) {
            schemeForecastDto.setCustomerErpCode(customerVo.getErpCode());
            schemeForecastDto.setChannelCode(customerVo.getCustomerChannelCode());
            schemeForecastDto.setChannelName(customerVo.getCustomerChannelName());
        }
        //销售组织
        schemeForecastDto.setSaleOrgCode(item.getActivityOrgCode());
        schemeForecastDto.setSaleOrgName(item.getActivityOrgName());
        if (Objects.nonNull(salesOrgAllParentVo)) {
            schemeForecastDto.setSaleOrgErpCode(salesOrgAllParentVo.getCurrSalesOrgVo().getErpCode());
            schemeForecastDto.setSalesInstitutionCode(salesOrgAllParentVo.getSalesInstitutionCode());
            schemeForecastDto.setSalesInstitutionErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
            schemeForecastDto.setSalesInstitutionName(salesOrgAllParentVo.getSalesInstitutionName());
            schemeForecastDto.setSalesRegionCode(salesOrgAllParentVo.getSalesDepartCode());
            schemeForecastDto.setSalesRegionErpCode(salesOrgAllParentVo.getSalesDepartErpCode());
            schemeForecastDto.setSalesRegionName(salesOrgAllParentVo.getSalesDepartName());
            schemeForecastDto.setSalesOrgCode(salesOrgAllParentVo.getSalesGroupCode());
            schemeForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getSalesGroupErpCode());
            schemeForecastDto.setSalesOrgName(salesOrgAllParentVo.getSalesGroupName());
        }
        //预算
        schemeForecastDto.setBudgetCode(item.getHeadMonthBudgetCode());
        if (!CollectionUtils.isEmpty(item.getBudgetShares())) {
            List<String> feeBelongCodes = item.getBudgetShares().stream().filter(e -> StringUtils.isNotEmpty(e.getFeeBelongCode())).map(ActivityPlanBudgetDto::getFeeBelongCode).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(feeBelongCodes)) {
                List<String> feeBelongNames = new ArrayList<>();
                feeBelongCodes.forEach(code -> feeBelongNames.add(feeBelongMap.getOrDefault(code, "")));
                schemeForecastDto.setFeeBelongCode(String.join(",", feeBelongCodes));
                schemeForecastDto.setFeeBelongName(String.join(",", feeBelongNames));
            }
        }
        //状态
        if (StringUtils.equals("Y", item.getIsClose())) {
            schemeForecastDto.setDetailedPredictionType(DetailedPredictionTypeEnum.CLOSED.getDictCode());
        } else {
            schemeForecastDto.setDetailedPredictionType(DetailedPredictionTypeEnum.NORMAL.getDictCode());
        }
        //区域
        schemeForecastDto.setRegion(item.getRegion());
        schemeForecastDto.setPlanOrgCode(item.getRegion());
        if (StringUtils.isNotEmpty(item.getRegion())) {
            schemeForecastDto.setRegionName(regionMap.get(item.getRegion()));
            schemeForecastDto.setPlanOrgName(regionMap.get(item.getRegion()));
        }
        return schemeForecastDto;
    }
}
