package com.biz.crm.tpm.business.scheme.forecast.local.util;

import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmHeadSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>
 * 活动方案主体方案预测
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-18
 */
public class TpmHeadSchemeForecastBuilder {

    /**
     * @param activityPlanDto
     * @param item
     * @param regionMap
     * @param customerVo
     * @param salesOrgAllParentVo
     * @return
     */
    public static TpmHeadSchemeForecastDto buildDto(ActivityPlanDto activityPlanDto,
                                                        ActivityPlanItemDto item,
                                                        Map<String, String> regionMap,
                                                        CustomerVo customerVo,
                                                        SalesOrgAllParentVo salesOrgAllParentVo) {
        TpmHeadSchemeForecastDto schemeForecastDto = new TpmHeadSchemeForecastDto();
        schemeForecastDto.setBusinessFormatCode(activityPlanDto.getBusinessFormatCode());
        schemeForecastDto.setBusinessUnitCode(activityPlanDto.getBusinessUnitCode());
        schemeForecastDto.setSchemeCode(activityPlanDto.getPlanCode());
        schemeForecastDto.setSchemeItemCode(item.getPlanItemCode());
        schemeForecastDto.setSchemeName(activityPlanDto.getPlanName());
        schemeForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        schemeForecastDto.setActivityTypeName(item.getActivityTypeName());
        schemeForecastDto.setActivityFormCode(item.getActivityFormCode());
        schemeForecastDto.setActivityFormName(item.getActivityFormName());
        schemeForecastDto.setSystemCode(item.getSupplierCode());
        schemeForecastDto.setSystemName(item.getSupplierName());
        schemeForecastDto.setAuditFormulaCode(item.getAuditConditionCode());
        schemeForecastDto.setAuditType(item.getAuditType());
        schemeForecastDto.setProductCode(item.getProductCode());
        schemeForecastDto.setProductName(item.getProductName());
        schemeForecastDto.setProductBrandCode(item.getProductBrandCode());
        schemeForecastDto.setProductBrandName(item.getProductBrandName());
        schemeForecastDto.setProductCategoryCode(item.getProductCategoryCode());
        schemeForecastDto.setProductCategoryName(item.getProductCategoryName());
        schemeForecastDto.setProductItemCode(item.getProductItemCode());
        schemeForecastDto.setProductItemName(item.getProductItemName());
        schemeForecastDto.setTerminalCode(item.getTerminalCode());
        schemeForecastDto.setTerminalName(item.getTerminalName());
        schemeForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        schemeForecastDto.setActivityTypeName(item.getActivityTypeName());
        schemeForecastDto.setActivityFormCode(item.getActivityFormCode());
        schemeForecastDto.setActivityFormName(item.getActivityFormName());
        schemeForecastDto.setFirstChannelCode(item.getFirstChannelCode());
        schemeForecastDto.setFirstChannelName(item.getFirstChannelName());
        schemeForecastDto.setSecondChannelCode(item.getSecondChannelCode());
        schemeForecastDto.setSecondChannelName(item.getSecondChannelName());
        schemeForecastDto.setSchemeCode(activityPlanDto.getPlanCode());
        schemeForecastDto.setRelatePlanCode(item.getRelatePlanCode());
        schemeForecastDto.setRelatePlanItemCode(item.getRelatePlanItemCode());
        schemeForecastDto.setSchemeItemCode(item.getPlanItemCode());
        schemeForecastDto.setApplyAmount(item.getFeeAmount());
        schemeForecastDto.setDepartmentFeeAmount(item.getDepartmentFeeAmount());
        schemeForecastDto.setHeadFeeAmount(item.getHeadFeeAmount());

        schemeForecastDto.setYearMonthStr(DateFormatUtils.format(item.getFeeYearMonth(), "yyyy-MM"));
        schemeForecastDto.setYearMonthLy(DateUtil.parse(schemeForecastDto.getYearMonthStr() + "-01 " + DateUtil.DAY_EARLIEST_TIME, DateUtil.DEFAULT_DATE_ALL_PATTERN));
        schemeForecastDto.setActivityStartTime(item.getActivityBeginDate());
        schemeForecastDto.setActivityEndTime(item.getActivityEndDate());
        schemeForecastDto.setActivityDelayEndTime(item.getActivityEndDate());

        //客户
        schemeForecastDto.setCustomerName(item.getCustomerName());
        schemeForecastDto.setCustomerCode(item.getCustomerCode());
        if (Objects.nonNull(customerVo)) {
            schemeForecastDto.setCustomerErpCode(customerVo.getErpCode());
            schemeForecastDto.setChannelCode(customerVo.getCustomerChannelCode());
            schemeForecastDto.setChannelName(customerVo.getCustomerChannelName());
        }
        //销售组织
        schemeForecastDto.setSalesOrgCode(item.getActivityOrgCode());
        schemeForecastDto.setSalesOrgName(item.getActivityOrgName());
        if (Objects.nonNull(salesOrgAllParentVo)) {
            schemeForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getCurrSalesOrgVo().getErpCode());
            schemeForecastDto.setSalesInstitutionCode(salesOrgAllParentVo.getSalesInstitutionCode());
            schemeForecastDto.setSalesInstitutionErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
            schemeForecastDto.setSalesInstitutionName(salesOrgAllParentVo.getSalesInstitutionName());
            schemeForecastDto.setSalesRegionCode(salesOrgAllParentVo.getSalesDepartCode());
            schemeForecastDto.setSalesRegionErpCode(salesOrgAllParentVo.getSalesDepartErpCode());
            schemeForecastDto.setSalesRegionName(salesOrgAllParentVo.getSalesDepartName());
            schemeForecastDto.setSalesOrgCode(salesOrgAllParentVo.getSalesGroupCode());
            schemeForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getSalesGroupErpCode());
            schemeForecastDto.setSalesOrgName(salesOrgAllParentVo.getSalesGroupName());
        }

        //区域
        schemeForecastDto.setRegion(item.getRegion());
        schemeForecastDto.setPlanOrgCode(item.getRegion());
        if (StringUtils.isNotEmpty(item.getRegion())) {
            schemeForecastDto.setRegionName(regionMap.get(item.getRegion()));
            schemeForecastDto.setPlanOrgName(regionMap.get(item.getRegion()));
        }

        //预算和费用归口
        List<ActivityPlanBudgetDto> budgetShares = item.getBudgetShares();
        if (!CollectionUtils.isEmpty(budgetShares)){
            Set<String> monthBudgetCodeSet = Sets.newHashSet();
            Set<String> feeBelongCodeSet = Sets.newHashSet();
            for (ActivityPlanBudgetDto budgetShare : budgetShares) {
                monthBudgetCodeSet.add(budgetShare.getMonthBudgetCode());
                feeBelongCodeSet.add(budgetShare.getFeeBelongCode());
            }
            schemeForecastDto.setMonthBudgetCode(String.join(",",monthBudgetCodeSet));
            schemeForecastDto.setFeeBelongCode(String.join(",",feeBelongCodeSet));
        }
        schemeForecastDto.setIsClose(item.getIsClose());
        return schemeForecastDto;
    }
}
