package com.biz.crm.tpm.business.scheme.forecast.local.util;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.month.budget.sdk.dto.OperateMonthBudgetDto;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.BudgetOperationTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetLockService;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmHeadSchemeForecastWorkflowEntity;
import com.biz.crm.tpm.business.scheme.forecast.local.entity.TpmVerticalSchemeForecastBudgetCashEntity;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmHeadSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.constants.TpmVerticalSchemeForecastConstants;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmHeadSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashConfirmDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastBudgetCashDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeWorkflowTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashConfirmVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-09
 */
@Slf4j
@Component
public class TpmHeadSchemeForecastUtil {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private MonthBudgetLockService monthBudgetLockService;

    @Autowired(required = false)
    private MonthBudgetService monthBudgetService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    public List<String> operateLock(List<String> idList) {
        List<String> lockKeys = new ArrayList<>();
        for (String id : idList) {
            String lockKey = TpmHeadSchemeForecastConstants.data_operate_lock + id;
            boolean lock = redisLockService.tryLock(lockKey, TimeUnit.SECONDS, 60 * 60, 5);
            if (!lock) {
                break;
            }
            lockKeys.add(lockKey);
        }
        return lockKeys;
    }

    /**
     * 构建流程日志信息
     *
     * @param forecastEntity
     * @param workflowTypeEnum
     * @return
     */
    public TpmHeadSchemeForecastWorkflowEntity buildWorkflowEntity(TpmHeadSchemeForecastEntity forecastEntity, TpmHeadSchemeWorkflowTypeEnum workflowTypeEnum) {
        TpmHeadSchemeForecastWorkflowEntity workflowEntity = new TpmHeadSchemeForecastWorkflowEntity();
        workflowEntity.setId(UUID.randomUUID().toString().replace("-", ""));
        workflowEntity.setSchemeForecastId(forecastEntity.getId());
        workflowEntity.setSchemeForecastCode(forecastEntity.getSchemeForecastCode());
        workflowEntity.setSchemeCode(forecastEntity.getSchemeCode());
        workflowEntity.setSchemeItemCode(forecastEntity.getSchemeItemCode());
        workflowEntity.setYearMonthLy(forecastEntity.getYearMonthLy());
        workflowEntity.setYearMonthStr(forecastEntity.getYearMonthStr());
        workflowEntity.setTenantCode(TenantUtils.getTenantCode());
        workflowEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        workflowEntity.setWorkflowType(workflowTypeEnum.getCode());
        workflowEntity.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        return workflowEntity;
    }

    /**
     * 拆分创建dto
     *
     * @param activityPlanDto
     * @param item
     * @param regionMap
     * @param allReginMap
     * @param customerVo
     * @param salesOrgVoMap
     * @return
     */
    public List<TpmHeadSchemeForecastDto> buildDtoList(ActivityPlanDto activityPlanDto,
                                                       ActivityPlanItemDto item,
                                                       Map<String, String> regionMap,
                                                       Map<String, Set<String>> allReginMap,
                                                       CustomerVo customerVo,
                                                       Map<String, SalesOrgAllParentVo> salesOrgVoMap) {
        if (StringUtils.isEmpty(item.getActivityOrgCode())) {
            return Lists.newArrayList();
        }
        List<String> activityOrgCodeList = new ArrayList<>();
        if (StringUtils.equals(TpmHeadSchemeForecastConstants.all_region_code, item.getActivityOrgCode())) {
            if (!allReginMap.containsKey(item.getActivityOrgCode())) {
                return Lists.newArrayList();
            }
            activityOrgCodeList.addAll(allReginMap.get(item.getActivityOrgCode()));
        } else {
            activityOrgCodeList.add(item.getActivityOrgCode());
        }

        List<TpmHeadSchemeForecastDto> dtoList = new ArrayList<>();
        for (String activityOrgCode : activityOrgCodeList) {
            TpmHeadSchemeForecastDto forecastDto = TpmHeadSchemeForecastBuilder.buildDto(activityPlanDto, item, regionMap, customerVo, salesOrgVoMap.get(activityOrgCode));
            dtoList.add(forecastDto);
        }
        return dtoList;
    }
}
