package com.biz.crm.tpm.business.scheme.forecast.local.util;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgAllParentVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.constant.DetailedPredictionTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.TpmVerticalSchemeForecastDto;
import com.google.common.collect.Maps;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * <p>
 * 活动方案推垂直大区方案兑付
 * </p>
 *
 * @author chenshuang
 * @since 2023-04-18
 */
public class TpmVerticalSchemeForecastBuilder {

    /**
     * 拆分创建dto
     *
     * @param activityPlanDto
     * @param item
     * @param regionMap
     * @param customerVo
     * @param salesOrgAllParentVo
     * @return
     */
    public static List<TpmVerticalSchemeForecastDto> buildDtoList(ActivityPlanDto activityPlanDto,
                                                                  ActivityPlanItemDto item,
                                                                  Map<String, String> regionMap,
                                                                  CustomerVo customerVo,
                                                                  SalesOrgAllParentVo salesOrgAllParentVo) {
        Date activityBeginDate = item.getActivityBeginDate();
        Date activityEndDate = item.getActivityEndDate();
        List<String> yearMonths = DateUtil.getBetweenYearMonths(activityBeginDate, activityEndDate, DateUtil.DEFAULT_YEAR_MONTH);

        List<String> regionList = new ArrayList<>();
        if (StringUtils.isNotEmpty(item.getRegion())) {
            regionList = Arrays.asList(item.getRegion().split(","));
        }
        Map<String, String> systemMap = new HashMap<>();
        if (StringUtils.isNotEmpty(item.getSystemCode())) {
            List<String> systemCodeList = Arrays.asList(item.getSystemCode().split(","));
            List<String> systemNameList = Arrays.asList(item.getSystemName().split(","));
            int i = 0;
            for (String systemCode : systemCodeList) {
                systemMap.put(systemCode, "");
                if (i < systemNameList.size()) {
                    systemMap.put(systemCode, systemNameList.get(i));
                }
                i++;
            }
        }

        List<TpmVerticalSchemeForecastDto> dtoList = new ArrayList<>();
        //四种情况 两大逻辑
        //1。systemMap不为空、regionList不为空
        //2。systemMap为空、regionList不为空
        //3。systemMap不为空、regionList为空
        //4。systemMap为空、regionList为空
        //1,3一种逻辑 2,4一种逻辑
        if(CollectionUtils.isEmpty(regionList)){
            regionList.addAll(regionMap.keySet().stream().filter(e -> !"9999".equals(e) && !"9998".equals(e)).collect(Collectors.toList()));
        }
        for (String yearMonth : yearMonths) {
            if (!MapUtils.isEmpty(systemMap)) {
                for (String region : regionList) {
                    systemMap.forEach((k, v) -> {
                        dtoList.add(buildDto(activityPlanDto, item, regionMap, customerVo, salesOrgAllParentVo, yearMonth, region, k, v));
                    });
                }
            } else {
                for (String region : regionList) {
                    dtoList.add(buildDto(activityPlanDto, item, regionMap, customerVo, salesOrgAllParentVo, yearMonth, region, null, null));
                }
                /*systemMap.forEach((k, v) -> {
                    dtoList.add(buildDto(activityPlanDto, item, regionMap, customerVo, salesOrgAllParentVo, yearMonth, null, k, v));
                });*/
            }
        }
        return dtoList;
    }

    /**
     * @param activityPlanDto
     * @param item
     * @param regionMap
     * @param customerVo
     * @param salesOrgAllParentVo
     * @return
     */
    public static TpmVerticalSchemeForecastDto buildDto(ActivityPlanDto activityPlanDto,
                                                        ActivityPlanItemDto item,
                                                        Map<String, String> regionMap,
                                                        CustomerVo customerVo,
                                                        SalesOrgAllParentVo salesOrgAllParentVo,
                                                        String yearMonthStr,
                                                        String region,
                                                        String systemCode,
                                                        String systemName) {
        TpmVerticalSchemeForecastDto schemeForecastDto = new TpmVerticalSchemeForecastDto();
        schemeForecastDto.setBusinessFormatCode(activityPlanDto.getBusinessFormatCode());
        schemeForecastDto.setBusinessUnitCode(activityPlanDto.getBusinessUnitCode());
        schemeForecastDto.setSchemeCode(activityPlanDto.getPlanCode());
        schemeForecastDto.setSchemeItemCode(item.getPlanItemCode());
        schemeForecastDto.setSchemeName(activityPlanDto.getPlanName());
        schemeForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        schemeForecastDto.setActivityTypeName(item.getActivityTypeName());
        schemeForecastDto.setActivityFormCode(item.getActivityFormCode());
        schemeForecastDto.setActivityFormName(item.getActivityFormName());
        schemeForecastDto.setSystemCode(systemCode);
        schemeForecastDto.setSystemName(systemName);
        schemeForecastDto.setAuditFormulaCode(item.getAuditConditionCode());
        schemeForecastDto.setAuditType(item.getAuditType());
        schemeForecastDto.setProductCode(item.getProductCode());
        schemeForecastDto.setProductName(item.getProductName());
        schemeForecastDto.setProductBrandCode(item.getProductBrandCode());
        schemeForecastDto.setProductBrandName(item.getProductBrandName());
        schemeForecastDto.setProductCategoryCode(item.getProductCategoryCode());
        schemeForecastDto.setProductCategoryName(item.getProductCategoryName());
        schemeForecastDto.setProductItemCode(item.getProductItemCode());
        schemeForecastDto.setProductItemName(item.getProductItemName());
        schemeForecastDto.setTerminalCode(item.getTerminalCode());
        schemeForecastDto.setTerminalName(item.getTerminalName());
        schemeForecastDto.setActivityTypeCode(item.getActivityTypeCode());
        schemeForecastDto.setActivityTypeName(item.getActivityTypeName());
        schemeForecastDto.setActivityFormCode(item.getActivityFormCode());
        schemeForecastDto.setActivityFormName(item.getActivityFormName());
        schemeForecastDto.setFirstChannelCode(item.getFirstChannelCode());
        schemeForecastDto.setFirstChannelName(item.getFirstChannelName());
        schemeForecastDto.setSecondChannelCode(item.getSecondChannelCode());
        schemeForecastDto.setSecondChannelName(item.getSecondChannelName());
        schemeForecastDto.setSchemeCode(activityPlanDto.getPlanCode());
        schemeForecastDto.setSchemeItemCode(item.getPlanItemCode());
        schemeForecastDto.setApplyAmount(item.getFeeAmount());
        schemeForecastDto.setDepartmentFeeAmount(item.getDepartmentFeeAmount());
        schemeForecastDto.setHeadFeeAmount(item.getHeadFeeAmount());

        schemeForecastDto.setYearMonthStr(yearMonthStr);
        schemeForecastDto.setYearMonthLy(DateUtil.parse(yearMonthStr + "-01 " + DateUtil.DAY_EARLIEST_TIME, DateUtil.DEFAULT_DATE_ALL_PATTERN));
        String firstDayOfMonth = DateUtil.getFirstDayOfMonth(yearMonthStr);
        String finalDayOfMonth = DateUtil.getFinalDayOfMonth(yearMonthStr);
        schemeForecastDto.setActivityStartTime(DateUtil.parse(firstDayOfMonth + " " + DateUtil.DAY_EARLIEST_TIME, DateUtil.DEFAULT_DATE_ALL_PATTERN));
        schemeForecastDto.setActivityEndTime(DateUtil.parse(finalDayOfMonth + " " + DateUtil.DAY_LATEST_TIME, DateUtil.DEFAULT_DATE_ALL_PATTERN));


        //客户
        schemeForecastDto.setCustomerName(item.getCustomerName());
        schemeForecastDto.setCustomerCode(item.getCustomerCode());
        if (Objects.nonNull(customerVo)) {
            schemeForecastDto.setCustomerErpCode(customerVo.getErpCode());
            schemeForecastDto.setChannelCode(customerVo.getCustomerChannelCode());
            schemeForecastDto.setChannelName(customerVo.getCustomerChannelName());
        }
        //销售组织
        schemeForecastDto.setSalesOrgCode(item.getActivityOrgCode());
        schemeForecastDto.setSalesOrgName(item.getActivityOrgName());
        if (Objects.nonNull(salesOrgAllParentVo)) {
            schemeForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getCurrSalesOrgVo().getErpCode());
            schemeForecastDto.setSalesInstitutionCode(salesOrgAllParentVo.getSalesInstitutionCode());
            schemeForecastDto.setSalesInstitutionErpCode(salesOrgAllParentVo.getSalesInstitutionErpCode());
            schemeForecastDto.setSalesInstitutionName(salesOrgAllParentVo.getSalesInstitutionName());
            schemeForecastDto.setSalesRegionCode(salesOrgAllParentVo.getSalesDepartCode());
            schemeForecastDto.setSalesRegionErpCode(salesOrgAllParentVo.getSalesDepartErpCode());
            schemeForecastDto.setSalesRegionName(salesOrgAllParentVo.getSalesDepartName());
            schemeForecastDto.setSalesOrgCode(salesOrgAllParentVo.getSalesGroupCode());
            schemeForecastDto.setSalesOrgErpCode(salesOrgAllParentVo.getSalesGroupErpCode());
            schemeForecastDto.setSalesOrgName(salesOrgAllParentVo.getSalesGroupName());
        }

        //区域
        schemeForecastDto.setRegion(region);
        schemeForecastDto.setPlanOrgCode(region);
        if (StringUtils.isNotEmpty(region)) {
            schemeForecastDto.setRegionName(regionMap.get(region));
            schemeForecastDto.setPlanOrgName(regionMap.get(region));
        }
        return schemeForecastDto;
    }
}
