package com.biz.crm.tpm.business.scheme.forecast.sdk.dto;


import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author youjun
 * @date 2022年11月10日 15:00
 */
@Data
@ApiModel(value = "方案预测dto")
public class SchemeForecastDto extends TenantFlagOpDto {
    /**
     * 状态
     */
    @ApiModelProperty(name = "detailedPredictionType", notes = "状态")
    private String detailedPredictionType;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;
    /**
     * 方案编码
     */
    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    private String schemeCode;

    /**
     * 方案明细编码
     */
    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    private String schemeItemCode;
    /**
     * 方案名称
     */
    @ApiModelProperty(name = "schemeName", notes = "方案名称")
    private String schemeName;

    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    /**
     * 活动开始时间
     */
    @ApiModelProperty(name = "activityStartTime", notes = "活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityStartTime;

    /**
     * 活动结束时间
     */
    @ApiModelProperty(name = "activityEndTime", notes = "活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date activityEndTime;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty(name = "primaryManagementChannel", notes = "一级管理渠道")
    private String primaryManagementChannel;

    /**
     * 方案范围编码
     */
    @ApiModelProperty("方案范围编码")
    private String planOrgCode;
    /**
     * 方案范围名称
     */
    @ApiModelProperty("方案范围名称")
    private String planOrgName;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(name = "feeBelongCode", notes = "费用归口编码")
    private String feeBelongCode;

    @ApiModelProperty(name = "feeBelongName", notes = "费用归口名称")
    private String feeBelongName;

    /**
     * 客户
     */
    @ApiModelProperty(name = "customer", notes = "客户")
    private String customer;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode", notes = "客户编码")
    private String customerCode;

    /**
     * 客户erpCode
     */
    @ApiModelProperty(name = "customerErpCode", notes = "客户erpCode")
    private String customerErpCode;

    /**
     * 客户rtm模式
     */
    @ApiModelProperty(name = "rtmMode", notes = "客户rtm模式")
    private String rtmMode;

    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    private String auditType;

    /**
     * 核销公式编码
     */
    @ApiModelProperty(name = "auditFormulaCode", notes = "核销公式编码")
    private String auditFormulaCode;

    /**
     * 核销条件
     */
    @ApiModelProperty(name = "writeOffConditions", notes = "核销条件")
    private String writeOffConditions;

    /**
     * 核销公式
     */
    @ApiModelProperty(name = "writeOffFormula", notes = "核销公式")
    private String writeOffFormula;

    /**
     * 核销条件取值
     */
    @ApiModelProperty(name = "writeOffConditionValue", notes = "核销条件取值")
    private String writeOffConditionValue;

    /**
     * 核销公式取值
     */
    @ApiModelProperty(name = "writeOffFormulaValue", notes = "核销公式取值")
    private String writeOffFormulaValue;

    /**
     * 预估核销金额
     */
    @ApiModelProperty(name = "estimatedWriteOffAmount", notes = "预估核销金额")
    private BigDecimal estimatedWriteOffAmount;

    /**
     * 实际核销金额
     */
    @ApiModelProperty(name = "actualWriteOffAmount",notes = "实际核销金额")
    private BigDecimal actualWriteOffAmount;

    /**
     * 任务量缺口
     */
    @ApiModelProperty(name = "taskVolumeGap", notes = "任务量缺口")
    private BigDecimal taskVolumeGap;

    /**
     * 可核销前提
     */
    @ApiModelProperty(name = "writeOffPremise", notes = "可核销前提")
    private String writeOffPremise;

    /**
     * 是否推送结案核销
     */
    @ApiModelProperty(name = "isPushAudit",notes = "是否推送结案核销")
    private String isPushAudit;

    /**
     * 预算编码
     */
    @ApiModelProperty("预算编码")
    private String budgetCode;

    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    private String productName;

    /**
     * 销售组织编码
     */
    @ApiModelProperty("销售组织编码")
    private String saleOrgCode;

    /**
     * 销售组织ERP编码
     */
    @ApiModelProperty("销售组织ERP编码")
    private String saleOrgErpCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty("销售组织名称")
    private String saleOrgName;

    /**
     * 所属销售机构ERP编码
     */
    @ApiModelProperty("所属销售机构ERP编码")
    private String salesInstitutionErpCode;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    /**
     * 销售机构名称
     */
    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区ERP编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区名称")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty(value = "公式计算参数")
    private String calParam;

    @ApiModelProperty(value = "公式计算异常")
    private String calEx;

    @ApiModelProperty(value = "年月")
    private String yearMonthStr;

    @ApiModelProperty(value = "门店编码")
    private String terminalCode;

    @ApiModelProperty(value = "门店名称")
    private String terminalName;

    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    private String productBrandName;

    @ApiModelProperty("品类编码")
    private String productCategoryCode;

    @ApiModelProperty("品类名称")
    private String productCategoryName;

    @ApiModelProperty("品项编码")
    private String productItemCode;

    @ApiModelProperty("品项名称")
    private String productItemName;

    @ApiModelProperty("上级方案明细编码")
    private String relatePlanItemCode;

    @ApiModelProperty("区域")
    private String region;

    @ApiModelProperty("区域")
    private String regionName;

    @ApiModelProperty("零售商编码")
    private String systemCode;

    @ApiModelProperty("零售商名称")
    private String systemName;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty(name = "人员编码", notes = "人员编码")
    private String personCode;

    @ApiModelProperty(name = "人员身份证号码", notes = "人员身份证号码")
    private String identityCard;

    @ApiModelProperty("二级渠道编码")
    private String secondChannelCode;

    @ApiModelProperty("二级渠道名称")
    private String secondChannelName;

    @ApiModelProperty("总部预算项目编码")
    private String headBudgetItemCode;

    @ApiModelProperty("预算编码/大区预算编码")
    private String monthBudgetCode;

    @ApiModelProperty("形式说明")
    private String formDescription;

    @ApiModelProperty("是否临时活动")
    private String isTemporary;

    @ApiModelProperty("一级渠道编码")
    private String firstChannelCode;

    @ApiModelProperty("一级渠道名称")
    private String firstChannelName;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "cusCreateTime", notes = "经销商创建时间")
    private Date cusCreateTime;

    @ApiModelProperty(name = "applyAmount",notes = "申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty("预估超额扣减预算失败时，记录上一次预估核销金额")
    private BigDecimal overBudgetFailAmount;

    @ApiModelProperty("预估超额扣减预算成功标志(Y/N)")
    private String overBudgetSuccess;

    @ApiModelProperty("陈列批次")
    private String displayNumber;

    @ApiModelProperty("是否客户上账")
    private String customerAccount;

    @ApiModelProperty("分销渠道")
    private String distributionChannelName;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;

    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;

    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;

    @ApiModelProperty("超额补占预算备注")
    private String overBudgetRemark;

}
