package com.biz.crm.tpm.business.scheme.forecast.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-09
 */
@Data
@ApiModel(value = "方案预测预算兑付dto")
public class TpmVerticalSchemeForecastBudgetCashDto extends TenantFlagOpDto {

    @ApiModelProperty(name = "schemeForecastId", notes = "方案预测id")
    private String schemeForecastId;

    @ApiModelProperty(name = "schemeForecastCode", notes = "方案预测编码")
    private String schemeForecastCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    private String schemeCode;

    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    private String schemeItemCode;

    @ApiModelProperty(name = "detailCode", notes = "明细编码")
    private String detailCode;

    private List<String> detailCodeList;

    @ApiModelProperty("预算项目")
    private String budgetItemCode;

    @ApiModelProperty("预算项目")
    private String budgetItemName;

    @ApiModelProperty("预算编码")
    private String budgetCode;

    @ApiModelProperty(name = "confirmAmount",notes = "确认金额")
    private BigDecimal confirmAmount;

    @ApiModelProperty(name = "usedAmount",notes = "已使用金额")
    private BigDecimal usedAmount;

    @ApiModelProperty(name = "balanceAmount",notes = "剩余可使用金额")
    private BigDecimal balanceAmount;

    @ApiModelProperty(name = "actFrozenAmount",notes = "申请时冻结金额")
    private BigDecimal actFrozenAmount;

    @ApiModelProperty(name = "overFrozenAmount",notes = "补冻结金额")
    private BigDecimal overFrozenAmount;
}
