package com.biz.crm.tpm.business.scheme.forecast.sdk.enums;

/**
 * <p>
 * 数据字典：scheme_prediction_type
 * </p>
 *
 * @author chenshuang
 * @since 2023-02-22
 */
public enum SchemePredictionTypeEnum {

    NORMAL("10", "10", "未关闭"),
    CONFIRMED("20", "20", "已确定"),
    CLOSED("30", "30", "关闭"),
    ;

    private String dictCode;
    private String value;
    private String name;

    SchemePredictionTypeEnum(String dictCode, String value, String name){
        this.dictCode = dictCode;
        this.value = value;
        this.name = name;
    }

    public String getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public String getDictCode() {
        return dictCode;
    }

    public static SchemePredictionTypeEnum codeToEnum(String code) {
        SchemePredictionTypeEnum stateEnum = null;
        SchemePredictionTypeEnum[] stateList = values();

        for (SchemePredictionTypeEnum categoryEnum : stateList) {
            if (categoryEnum.dictCode.equals(code)) {
                stateEnum = categoryEnum;
            }
        }
        return stateEnum;
    }

}
