package com.biz.crm.tpm.business.scheme.forecast.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastAutoCreateDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastAutoRefreshDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.SchemePushSchemeForecastDto;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.SchemeForecastVo;
import org.springframework.data.domain.Pageable;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 细案预测表(DetailedForecastEntity)表服务接口
 *
 * @author youjun
 * @date 2022年11月09日 11:08
 */
public interface SchemeForecastService {

    /**
     * 分页查询数据
     *
     * @param pageable          分页对象
     * @param schemeForecastDto 实体对象
     * @return
     */
    Page<SchemeForecastVo> findByForecasts(Pageable pageable, SchemeForecastDto schemeForecastDto);

    /**
     * 新增数据
     *
     * @param schemeForecastDto 实体对象
     * @return 新增结果
     */
    void create(SchemeForecastDto schemeForecastDto);

    /**
     * 修改新据
     *
     * @param schemeForecastDto 实体对象
     * @return 修改结果
     */
    void update(SchemeForecastDto schemeForecastDto);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    SchemeForecastVo findById(String id);


    /**
     * 通过id批量查询
     *
     * @param idList
     * @return
     */
    List<SchemeForecastVo> findByIds(List<String> idList);

    /**
     * 更新数据
     *
     * @param schemeForecastDto 实体对象
     * @return 更新结果
     */
    void updateDetailedForecast(SchemeForecastDto schemeForecastDto);

    /**
     * 批量导入新增
     *
     * @param importList
     * @author youjun
     * @date 2022/11/10 10:03
     **/
    void importSave(List<SchemeForecastDto> importList);

    /**
     * 批量更新(重新计算预估可核销金额)
     *
     * @param idList 主键列表
     */
    void updateAuditAmount(List<String> idList);

    /**
     * 确认方案预测
     *
     * @param idList
     */
    void confirm(List<String> idList);

    /**
     * 导入更新保存
     *
     * @param dtoList
     */
    void importUpdate(List<SchemeForecastDto> dtoList);

    /**
     * 根据方案编码查询
     *
     * @param codes
     * @return
     */
    Collection<SchemeForecastVo> findByCodes(Set<String> codes);

    /**
     * 方案手动重推预测-主体、垂直
     *
     * @param page
     * @param dto
     * @return
     */
    Page<String> findHeadVerticalCodeList(Page<String> page, SchemePushSchemeForecastDto dto);

    /**
     * 自动更新数量
     *
     * @param dto
     * @return
     */
    Long findAutoRefreshCount(SchemeForecastAutoRefreshDto dto);

    /**
     * 自动更新数据id
     *
     * @param pageable
     * @param dto
     * @return
     */
    List<String> findAutoRefreshDataList(Pageable pageable, SchemeForecastAutoRefreshDto dto);

    List<String> findAutoCreateDataList(SchemeForecastAutoCreateDto dto);

    Long autoUpdateShowFLag(SchemeForecastAutoCreateDto dto);

    /**
     * 根据方案明细码查询方案预测表
     * @param planItemCodes
     */
    List<SchemeForecastVo> findByPlanItemCodes(Set<String> planItemCodes);
}
