package com.biz.crm.tpm.business.scheme.forecast.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmHeadSchemeWorkflowTypeEnum;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastActivityDetailPlanVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastUploadFileVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-09
 */
public interface TpmHeadSchemeForecastService {

    /**
     * 编辑
     * @param dto
     * @return
     */
    void edit(TpmHeadSchemeForecastDto dto);

    /**
     * 编辑扣减预算编码
     *
     * @param dto
     */
    void editMonthBudgetCodeDeduction(TpmHeadSchemeForecastDto dto);

    /**
     * 上传资料
     *
     * @param dto
     * @return
     */
    String uploadFile(TpmHeadSchemeForecastUploadFileDto dto);

    /**
     * 提交流程
     *
     * @param dto
     * @param workflowTypeEnum
     * @return
     */
    String submit(TpmHeadSchemeForecastSubmitDto dto, TpmHeadSchemeWorkflowTypeEnum workflowTypeEnum);

    /**
     * 批量更新(重新计算预估可核销金额)
     *
     * @param idList 主键列表
     */
    void updateAuditAmount(List<String> idList);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 确认
     *
     * @param idList
     */
    void confirm(List<String> idList);

    /**
     * 流程回调更新
     *
     * @param processNo
     * @param processStatus
     */
    void completeCallback(String processNo, String processStatus);

    /**
     * 补创建
     *
     * @param dto
     * @return
     */
    List<String> findAutoCreateDataList(TpmHeadSchemeForecastAutoCreateDto dto);

    /**
     * 定时任务更新总数量
     *
     * @param dto
     * @return
     */
    Long findAutoRefreshCount(TpmHeadSchemeForecastAutoRefreshDto dto);

    /**
     * 定时任务更新查询待更新数据id
     *
     * @param pageable
     * @param dto
     * @return
     */
    List<String> findAutoRefreshDataList(Pageable pageable, TpmHeadSchemeForecastAutoRefreshDto dto);

    /**
     * 列表查询-流程可用
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<TpmHeadSchemeForecastVo> findByForecasts(Pageable pageable, TpmHeadSchemeForecastDto dto);

    /**
     * 详情
     * @param id
     * @return
     */
    TpmHeadSchemeForecastVo findById(String id);

    /**
     * 资料详情
     *
     * @param id
     * @return
     */
    TpmHeadSchemeForecastUploadFileVo findFileById(String id);

    /**
     * 关联细案详情
     *
     * @param id
     * @return
     */
    List<TpmHeadSchemeForecastActivityDetailPlanVo> findActivityDetailPlanById(String id);

    List<TpmHeadSchemeForecastVo> findByPlanItemCodes(List<String> planItemCodes);

    /**
     * 更新核销扣减预算金额
     * @param detailPlanItemCodeList 细案明细编码
     */
    void updateAuditReduceAmount(List<String> detailPlanItemCodeList);

}
