package com.biz.crm.tpm.business.scheme.forecast.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.scheme.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashConfirmVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmVerticalSchemeForecastBudgetCashVo;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-09
 */
public interface TpmVerticalSchemeForecastService {

    /**
     * 批量更新(重新计算预估可核销金额)
     *
     * @param idList 主键列表
     */
    void updateAuditAmount(List<String> idList);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * 确认
     *
     * @param dto
     */
    void confirm(TpmVerticalSchemeForecastBudgetCashConfirmDto dto);

    void confirmBatch(TpmVerticalSchemeForecastBudgetCashConfirmDto dto);

    /**
     * 流程回调更新
     *
     * @param businessNo
     * @param processStatus
     */
    void completeCallback(String businessNo, String processStatus);

    void completeCallbackBatch(List<String> businessNoList, String processStatus);

    /**
     * 查询兑付详情
     *
     * @param id
     * @param code
     */
    TpmVerticalSchemeForecastBudgetCashConfirmVo findConfirmDetail(String id, String code);

    /**
     * 补创建
     *
     * @param dto
     * @return
     */
    List<String> findAutoCreateDataList(TpmVerticalSchemeForecastAutoCreateDto dto);

    /**
     * 定时任务更新总数量
     *
     * @param dto
     * @return
     */
    Long findAutoRefreshCount(TpmVerticalSchemeForecastAutoRefreshDto dto);

    /**
     * 定时任务更新查询待更新数据id
     *
     * @param pageable
     * @param dto
     * @return
     */
    List<String> findAutoRefreshDataList(Pageable pageable, TpmVerticalSchemeForecastAutoRefreshDto dto);

    /**
     * 根据区域+零售商查兑付明细
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<TpmVerticalSchemeForecastBudgetCashVo> findCashPage(Pageable pageable, TpmVerticalSchemeForecastBudgetCashQueryDto dto);

    /**
     * 加锁
     *
     * @param keys
     * @param timeUnit
     * @param lockTime
     * @param waitedTime
     * @return
     */
    List<String> lock(List<String> keys, TimeUnit timeUnit, int lockTime, int waitedTime);

    /**
     * 操作兑付明细
     *
     * @param dtoList
     * @param doSave 是否执行保存操作
     */
    void operate(List<TpmVerticalSchemeForecastBudgetCashOperateDto> dtoList, boolean doSave);

    /**
     * 解锁
     *
     * @param lockedKeys
     */
    void unLock(List<String> lockedKeys);

    /**
     * 查询垂直方案兑付明细
     */
    List<TpmVerticalSchemeForecastBudgetCashVo> findDetailListByConditions(TpmVerticalSchemeForecastBudgetCashDto cashDto);

}
