package com.biz.crm.tpm.business.scheme.forecast.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-06-08
 */
@Data
@ApiModel(value = "主体方案预测vo")
public class TpmHeadSchemeForecastVo extends TenantFlagOpDto {

    @ApiModelProperty(name = "onlyKey", notes = "唯一key")
    private String onlyKey;

    /**
     * 状态[数据字典:tpm_head_scheme_status]
     */
    @ApiModelProperty(name = "status", notes = "状态")
    private String status;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "businessFormatCode", notes = "业态")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "schemeForecastCode", notes = "方案预测编码")
    private String schemeForecastCode;

    @ApiModelProperty(name = "schemeCode", notes = "方案编码")
    private String schemeCode;

    @ApiModelProperty(name = "schemeItemCode", notes = "方案明细编码")
    private String schemeItemCode;

    @ApiModelProperty(name = "schemeName", notes = "方案名称")
    private String schemeName;

    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "activityStartTime", notes = "活动开始时间")
    private Date activityStartTime;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "activityEndTime", notes = "活动结束时间")
    private Date activityEndTime;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "activityDelayEndTime", notes = "活动延期结束时间")
    private Date activityDelayEndTime;

    @ApiModelProperty("方案范围编码")
    private String planOrgCode;

    @ApiModelProperty("方案范围名称")
    private String planOrgName;

    @ApiModelProperty(name = "customerCode", notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "customerErpCode", notes = "客户erpCode")
    private String customerErpCode;

    @ApiModelProperty(name = "customerName", notes = "客户")
    private String customerName;

    @ApiModelProperty(name = "rtmMode", notes = "客户rtm模式")
    private String rtmMode;

    @ApiModelProperty(name = "auditType", notes = "核销类型")
    private String auditType;

    @ApiModelProperty(name = "auditFormulaCode", notes = "核销公式编码")
    private String auditFormulaCode;

    @ApiModelProperty("核销方式")
    private String writeOffMethod;

    @ApiModelProperty("所属销售机构ERP编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区ERP编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区名称")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)ERP编码")
    private String salesGroupErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesGroupCode;

    @ApiModelProperty("所属销售组织(组)名称")
    private String salesGroupName;

    @ApiModelProperty("所属销售组织ERP编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织名称")
    private String salesOrgName;

    @ApiModelProperty("区域编码")
    private String region;

    @ApiModelProperty("区域名称")
    private String regionName;

    @ApiModelProperty("零售商编码")
    private String systemCode;

    @ApiModelProperty("零售商名称")
    private String systemName;

    @ApiModelProperty("渠道编码")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    private String channelName;

    @ApiModelProperty("年月")
    private String yearMonthStr;

    @ApiModelProperty("年月（datetime）")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearMonthLy;

    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    private String productBrandName;

    @ApiModelProperty("品类编码")
    private String productCategoryCode;

    @ApiModelProperty("品类名称")
    private String productCategoryName;

    @ApiModelProperty("品项编码")
    private String productItemCode;

    @ApiModelProperty("品项名称")
    private String productItemName;

    @ApiModelProperty("上级方案明细编码")
    private String relatePlanItemCode;

    @ApiModelProperty("一级管理渠道编码")
    private String firstChannelCode;

    @ApiModelProperty("一级管理渠道名称")
    private String firstChannelName;

    @ApiModelProperty(name = "二级渠道编码", notes = "二级渠道编码")
    private String secondChannelCode;

    @ApiModelProperty(name = "二级渠道名称", notes = "二级渠道名称")
    private String secondChannelName;

    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(name = "cusCreateTime", notes = "经销商创建时间")
    private Date cusCreateTime;

    @ApiModelProperty("总部预算项目编码")
    private String headBudgetItemCode;

    @ApiModelProperty("预算编码/大区预算编码")
    private String monthBudgetCode;

    @ApiModelProperty("费用归口")
    private String feeBelongCode;

    @ApiModelProperty("扣减大区预算编码")
    private String monthBudgetCodeDeduction;

    @ApiModelProperty("扣减大区预算金额")
    private BigDecimal deductionAmount;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道")
    private String distributionChannelName;

    @ApiModelProperty("是否展示")
    private String showFlag;

    @ApiModelProperty(name = "applyAmount",notes = "申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty(name = "estimatedWriteOffAmount",notes = "预估核销金额")
    private BigDecimal estimatedWriteOffAmount;

    @ApiModelProperty("大区承担金额")
    private BigDecimal departmentFeeAmount;

    @ApiModelProperty("总部承担金额")
    private BigDecimal headFeeAmount;


    @ApiModelProperty("总部方案对应大区承担金额")
    private BigDecimal relatePlanDepartmentFeeAmount;

    @ApiModelProperty("总部方案对应总部承担金额")
    private BigDecimal relatePlanHeadFeeAmount;
    @ApiModelProperty("实际核销金额")
    private BigDecimal actualAuditAmount;

    @ApiModelProperty(name = "审批编码（总部）", notes = "")
    private String headProcessNo;

    @ApiModelProperty("审批状态（总部）")
    private String headProcessStatus;

    @ApiModelProperty(name = "审批编码（大区）", notes = "")
    private String regionProcessNo;

    @ApiModelProperty("审批状态（大区）")
    private String regionProcessStatus;

    /**********扩展表公式表字段，当前表不存值**************/

    @ApiModelProperty(name = "writeOffConditions", notes = "核销条件")
    private String writeOffConditions;

    @ApiModelProperty(name = "writeOffFormula", notes = "核销公式")
    private String writeOffFormula;

    @ApiModelProperty(name = "writeOffConditionValue", notes = "核销条件取值")
    private String writeOffConditionValue;

    @ApiModelProperty(name = "writeOffFormulaValue", notes = "核销公式取值")
    private String writeOffFormulaValue;

    @ApiModelProperty(name = "calParam", notes = "公式计算参数")
    private String calParam;

    @ApiModelProperty(name = "calEx", notes = "公式计算异常")
    private String calEx;

    /**********扩展表产品表字段，当前表不存值**************/

    @ApiModelProperty("产品编码")
    private String productCode;

    @ApiModelProperty("产品名称")
    private String productName;

    /**********扩展表门店表字段，当前表不存值**************/

    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", columnDefinition = "VARCHAR(64) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", columnDefinition = "VARCHAR(255) COMMENT '门店名称'")
    private String terminalName;
}
