/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.settlement.manage.local.service.imports;

import com.aliyun.openservices.shade.com.google.common.collect.Sets;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.platform.expense.form.sdk.dto.PlatformExpenseFormDto;
import com.biz.crm.tpm.business.platform.expense.form.sdk.service.PlatformExpenseFormService;
import com.biz.crm.tpm.business.platform.product.relation.sdk.dto.PlatformProductRelationDto;
import com.biz.crm.tpm.business.platform.product.relation.sdk.service.PlatformProductRelationService;
import com.biz.crm.tpm.business.platform.product.relation.sdk.vo.PlatformProductRelationVo;
import com.biz.crm.tpm.business.settlement.manage.local.entity.TpmSettlementManage;
import com.biz.crm.tpm.business.settlement.manage.local.repository.TpmSettlementManageRepository;
import com.biz.crm.tpm.business.settlement.manage.sdk.enums.TpmSettlementSourceEnum;
import com.biz.crm.tpm.business.settlement.manage.sdk.vo.imports.JDflagshipSettlementImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JDflagshipSettlementImportsProcess
implements ImportProcess<JDflagshipSettlementImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(JDflagshipSettlementImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private PlatformExpenseFormService platformExpenseFormService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    PlatformProductRelationService platformProductRelationService;
    @Autowired(required=false)
    private TpmSettlementManageRepository tpmSettlementManageRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    public Integer getBatchCount() {
        return 10000;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, JDflagshipSettlementImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Validate.notEmpty(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        try {
            this.baseValidate(data);
            this.validateRepeatAndSave(data);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw e;
        }
        return null;
    }

    private void baseValidate(LinkedHashMap<Integer, JDflagshipSettlementImportsVo> data) {
        List expenseFormDtoList;
        List customerVos;
        JDflagshipSettlementImportsVo importsVo;
        int i;
        Map mdmBusinessFormatMap = new HashMap();
        Map<Object, Object> customerVoMap = new HashMap();
        Map<Object, Object> platformProductRelationVoMap = new HashMap();
        Map<Object, Object> expenseFormDtoMap = new HashMap();
        mdmBusinessFormatMap = this.dictToolkitService.findConvertMapByDictTypeCode("mdm_business_format");
        HashSet customerCodeSet = Sets.newHashSet();
        HashSet expenseItemSet = Sets.newHashSet();
        HashSet productCodeSet = Sets.newHashSet();
        for (i = 0; i < data.size(); ++i) {
            importsVo = data.get(i);
            Validate.notBlank((CharSequence)importsVo.getCode(), (String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getOrderType(), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)importsVo.getPlatformProductCode(), (String)"\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            productCodeSet.add(importsVo.getPlatformProductCode());
            Validate.notBlank((CharSequence)importsVo.getExpenseItem(), (String)"\u8d39\u7528\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            expenseItemSet.add(importsVo.getExpenseItem());
            Validate.notBlank((CharSequence)importsVo.getAmountStr(), (String)"\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String customerCode = "";
            String mdgCode = importsVo.getMdgCode();
            Validate.notBlank((CharSequence)mdgCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            customerCode = customerCode + mdgCode;
            String salesOrgCode = importsVo.getSalesOrgCode();
            Validate.notBlank((CharSequence)salesOrgCode, (String)"\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            customerCode = customerCode + salesOrgCode;
            String channelCode = importsVo.getChannelCode();
            Validate.notBlank((CharSequence)channelCode, (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            customerCode = customerCode + channelCode;
            String businessFormatCode = importsVo.getBusinessFormatCode();
            Validate.notBlank((CharSequence)businessFormatCode, (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (!StringUtils.isEmpty((CharSequence)businessFormatCode)) {
                if (!mdmBusinessFormatMap.containsKey(businessFormatCode)) {
                    throw new RuntimeException("\u4e1a\u6001" + businessFormatCode + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
                importsVo.setBusinessFormatCode((String)mdmBusinessFormatMap.get(businessFormatCode));
            }
            customerCode = customerCode + importsVo.getBusinessFormatCode();
            customerCodeSet.add(customerCode);
            importsVo.setCustomerCode(customerCode);
            try {
                importsVo.setAmount(new BigDecimal(importsVo.getAmountStr()));
            }
            catch (Exception e3) {
                log.error("\u5bfc\u5165\u62a5\u9519:{}", (Object)e3.getMessage());
                throw new IllegalArgumentException("\u542b\u7a0e\u91d1\u989d\u4e3a\u7a7a\u6216\u683c\u5f0f\u9519\u8bef");
            }
            try {
                DateStringDealUtil.validateDateStrAndSet((String)importsVo.getBusinessTimeStr(), (String)"\u4e1a\u52a1\u53d1\u751f\u65f6\u95f4", (boolean)true, (String)"yyyy-MM-dd HH:mm:ss", arg_0 -> ((JDflagshipSettlementImportsVo)importsVo).setBusinessTime(arg_0));
            }
            catch (Exception e4) {
                throw new IllegalArgumentException(e4.getMessage());
            }
            importsVo.setYearMonthStr(DateUtil.dateToStr((SimpleDateFormat)DateUtil.date_yyyy_MM, (Date)importsVo.getBusinessTime()));
        }
        if (!CollectionUtils.isEmpty((Collection)customerCodeSet) && !CollectionUtils.isEmpty((Collection)(customerVos = this.customerVoService.findByCustomerCodes(new ArrayList(customerCodeSet))))) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        if (!CollectionUtils.isEmpty((Collection)productCodeSet) && !CollectionUtils.isEmpty((Collection)customerCodeSet)) {
            PlatformProductRelationDto platformProductRelationDto = new PlatformProductRelationDto();
            platformProductRelationDto.setPlatformProductCodeSet((Set)productCodeSet);
            platformProductRelationDto.setCustomerCodeSet((Set)customerCodeSet);
            List platformVoList = this.platformProductRelationService.findListByConditions(platformProductRelationDto);
            if (!CollectionUtils.isEmpty((Collection)platformVoList)) {
                platformProductRelationVoMap = platformVoList.stream().collect(Collectors.toMap(e -> e.getCustomerCode() + e.getPlatformProductCode(), Function.identity(), (e1, e2) -> e1));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)productCodeSet) && !CollectionUtils.isEmpty((Collection)(expenseFormDtoList = this.platformExpenseFormService.findListByExpenseNameSet((Set)expenseItemSet)))) {
            expenseFormDtoMap = expenseFormDtoList.stream().collect(Collectors.toMap(PlatformExpenseFormDto::getExpensesName, Function.identity(), (e1, e2) -> e1));
        }
        for (i = 0; i < data.size(); ++i) {
            importsVo = data.get(i);
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(importsVo.getCustomerCode());
            PlatformProductRelationVo productVo = (PlatformProductRelationVo)platformProductRelationVoMap.get(importsVo.getCustomerCode() + importsVo.getPlatformProductCode());
            PlatformExpenseFormDto platformExpenseFormDto = (PlatformExpenseFormDto)expenseFormDtoMap.get(importsVo.getExpenseItem());
            Validate.notNull((Object)customerVo, (String)"\u6839\u636eMDG\u5ba2\u6237\u7f16\u7801+\u9500\u552e\u673a\u6784\u7f16\u7801+\u6e20\u9053\u7f16\u7801+\u4e1a\u6001\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u5ba2\u6237\uff01", (Object[])new Object[0]);
            importsVo.setCustomerName(customerVo.getCustomerName());
            importsVo.setSalesOrgCode(customerVo.getSalesInstitutionErpCode());
            importsVo.setSalesOrgName(customerVo.getSalesInstitutionName());
            importsVo.setChannelCode(customerVo.getCustomerChannelCode());
            importsVo.setChannelName(customerVo.getCustomerChannelName());
            Validate.notNull((Object)productVo, (String)"\u6839\u636e\u540e\u7aef\u5546\u54c1\u7f16\u7801\u672a\u627e\u5230\u5bf9\u5e94\u4ea7\u54c1\uff01", (Object[])new Object[0]);
            importsVo.setProductName(productVo.getProductName());
            importsVo.setProductCode(productVo.getProductCode());
            importsVo.setPlatformProductCode(productVo.getPlatformProductCode());
            importsVo.setPlatformProductName(productVo.getPlatformProductName());
            Validate.notNull((Object)platformExpenseFormDto, (String)"\u6839\u636e\u8d39\u7528\u9879\u672a\u627e\u5230\u5bf9\u5e94\u6d3b\u52a8\u5f62\u5f0f\uff01", (Object[])new Object[0]);
            importsVo.setActivityFormCode(platformExpenseFormDto.getActivityFormCode());
            importsVo.setActivityFormName(platformExpenseFormDto.getActivityFormName());
            importsVo.setSourceCode(TpmSettlementSourceEnum.JD_FLAGSHIP.getCode());
        }
    }

    private void validateRepeatAndSave(LinkedHashMap<Integer, JDflagshipSettlementImportsVo> data) {
        HashMap repeatKeyToIndexMap = Maps.newHashMap();
        data.forEach((index, importsVo) -> {
            String key = TpmSettlementSourceEnum.JD_FLAGSHIP.getCode() + importsVo.getCode() + importsVo.getCustomerCode() + importsVo.getPlatformProductCode() + importsVo.getExpenseItem();
            if (repeatKeyToIndexMap.containsKey(key)) {
                Integer lastIndex = (Integer)repeatKeyToIndexMap.get(key);
                throw new IllegalArgumentException("\u8be5\u884c\u5355\u636e\u7f16\u53f7+\u5ba2\u6237\u7f16\u7801+\u5546\u54c1\u7f16\u53f7+\u8d39\u7528\u9879\u4e0e\u7b2c\u3010" + lastIndex + "\u3011\u884c\u91cd\u590d");
            }
            repeatKeyToIndexMap.put(key, index);
        });
        List importList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(data.values(), JDflagshipSettlementImportsVo.class, TpmSettlementManage.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList<String> repeatKeyList = new ArrayList<String>(repeatKeyToIndexMap.keySet());
        boolean isLock = this.redisLockService.batchLock("tpm:settlement_manage:edit:", repeatKeyList, TimeUnit.MINUTES, 20);
        Validate.isTrue((boolean)isLock, (String)"\u52a0\u9501\u5931\u8d25", (Object[])new Object[0]);
        Set<String> repeatSet = this.tpmSettlementManageRepository.repeatValidateBatch(repeatKeyList);
        if (CollectionUtils.isNotEmpty(repeatSet)) {
            data.forEach((index, importsVo) -> {
                if (repeatSet.contains(importsVo.getVerifyId())) {
                    throw new IllegalArgumentException("\u5355\u636e\u7f16\u53f7+\u5ba2\u6237\u7f16\u7801+\u5546\u54c1\u7f16\u53f7+\u8d39\u7528\u9879\u5df2\u6709\u73b0\u5b58\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                }
            });
        }
        this.tpmSettlementManageRepository.bulkPreservation(importList);
        try {
            this.redisLockService.batchUnLock("tpm:settlement_manage:edit:", repeatKeyList);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Class<JDflagshipSettlementImportsVo> findCrmExcelVoClass() {
        return JDflagshipSettlementImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SETTLEMENT_JD_FLAGSHIP_IMPORT";
    }

    public String getTemplateName() {
        return "TPM\u7ed3\u7b97\u5355\u7ba1\u7406-\u4eac\u4e1c\u65d7\u8230\u5e97\u5bfc\u5165";
    }
}

