package com.biz.crm.tpm.business.son.company.report.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.son.company.report.sdk.dto.FixDisbursementMonitorDto;
import com.biz.crm.tpm.business.son.company.report.sdk.dto.PromotionExecuteMonitoringDto;
import com.biz.crm.tpm.business.son.company.report.sdk.dto.SaleAndFeeMonitoringDto;
import com.biz.crm.tpm.business.son.company.report.sdk.dto.SalesVolumeMonitoringDto;
import com.biz.crm.tpm.business.son.company.report.sdk.service.SubComReportService;
import com.biz.crm.tpm.business.son.company.report.sdk.vo.FixDisbursementMonitorVo;
import com.biz.crm.tpm.business.son.company.report.sdk.vo.PromotionExecuteMonitoringVo;
import com.biz.crm.tpm.business.son.company.report.sdk.vo.SaleAndFeeMonitoringVo;
import com.biz.crm.tpm.business.son.company.report.sdk.vo.SalesVolumeMonitoringVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author : dengwei
 * @Date :2023/7/4  9:55
 * @Description: 分子公司报表
 */
@RestController
@RequestMapping("/v1/sonCompanyReport")
@Slf4j
@Api(tags = "TPM-分子公司报表")
public class SonCompanyReportController {


    @Autowired(required = false)
    private SubComReportService subComReportService;

    @ApiOperation("固定支出监控表")
    @GetMapping("fixDisbursementMonitorByConditions")
    public Result<Page<FixDisbursementMonitorVo>> fixDisbursementMonitorByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable, FixDisbursementMonitorDto dto) {
        try {
            Page<FixDisbursementMonitorVo> page = this.subComReportService.fixDisbursementMonitorByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("销量监控（品项）")
    @GetMapping("salesVolumeMonitoring")
    public Result<Page<SalesVolumeMonitoringVo>> salesVolumeMonitoringByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable, SalesVolumeMonitoringDto dto){

        try {
            Page<SalesVolumeMonitoringVo> page = this.subComReportService.salesVolumeMonitoringByConditions(pageable, dto);
            return Result.ok(page);
        }catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("手动执行经营例会单品费用")
    @GetMapping("manualManageOneProductFeeReport")
    public Result<?> manualManageOneProductFeeReport(@RequestParam("year")Integer year, @RequestParam("companyCode") String companyCode, @RequestParam("productCode") String productCode){
        try {
            subComReportService.manageOneProductFee(year,companyCode,productCode);
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("手动执行分子预算预警")
    @GetMapping("manualSonCompanyBudgetWarn")
    public Result<?> manualSonCompanyBudgetWarn(@RequestParam(value = "yearMonthly",required = false) String yearMonthly,@RequestParam(value = "orgCode",required = false) String orgCode,@RequestParam(value = "saleCompanyCode",required = false) String saleCompanyCode,@RequestParam(value = "channelCode",required = false) String channelCode,@RequestParam(value = "saleGroupCode",required = false) String saleGroupCode,@RequestParam(value = "customerCode",required = false) String customerCode,@RequestParam(value = "budgetItemCode",required = false) String budgetItemCode){
        try {
            subComReportService.sonCompanyBudgetWarn(yearMonthly, orgCode, saleCompanyCode, channelCode, saleGroupCode, customerCode, budgetItemCode);
            return Result.ok();
        } catch (Exception e){
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
