package com.biz.crm.tpm.business.son.company.report.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Author : dengwei
 * @Date :2023/11/22  15:26
 * @Description: 经营例会单品费用表
 */
@ApiModel(value = "ManageOneProductFeeEntity", description = "经营例会单品费用表")
@TableName("tpm_manage_one_product_fee")
@Getter
@Setter
@Entity(name = "tpm_manage_one_product_fee")
@org.hibernate.annotations.Table(appliesTo = "tpm_manage_one_product_fee", comment = "经营例会单品费用表")
@Table(name = "tpm_manage_one_product_fee")
public class ManageOneProductFeeEntity extends TenantFlagOpEntity {

    @ApiModelProperty("维度(组织编码+产品编码+年度)")
    @Column(name = "dimensionality", length = 255, columnDefinition = "varchar(255) COMMENT '维度'")
    private String dimensionality;

    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "varchar(32) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty("年")
    @Column(name = "yearly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年'")
    private String yearly;

    @ApiModelProperty("月")
    @Column(name = "monthly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '月'")
    private String monthly;

    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;

    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", columnDefinition = "VARCHAR(255) COMMENT '品类名称 '")
    private String productCategoryName;

    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;

    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称", notes = "产品编码")
    @Column(name = "product_name", columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("费用合计1月")
    @Column(name = "total_cost01", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计1月'")
    private BigDecimal totalCost01;

    @ApiModelProperty("费用合计2月")
    @Column(name = "total_cost02", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计2月'")
    private BigDecimal totalCost02;

    @ApiModelProperty("费用合计3月")
    @Column(name = "total_cost03", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计3月'")
    private BigDecimal totalCost03;

    @ApiModelProperty("费用合计4月")
    @Column(name = "total_cost04", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计4月'")
    private BigDecimal totalCost04;

    @ApiModelProperty("费用合计5月")
    @Column(name = "total_cost05", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计5月'")
    private BigDecimal totalCost05;

    @ApiModelProperty("费用合计6月")
    @Column(name = "total_cost06", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计6月'")
    private BigDecimal totalCost06;

    @ApiModelProperty("费用合计7月")
    @Column(name = "total_cost07", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计7月'")
    private BigDecimal totalCost07;

    @ApiModelProperty("费用合计8月")
    @Column(name = "total_cost08", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计8月'")
    private BigDecimal totalCost08;

    @ApiModelProperty("费用合计9月")
    @Column(name = "total_cost09", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计9月'")
    private BigDecimal totalCost09;

    @ApiModelProperty("费用合计10月")
    @Column(name = "total_cost10", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计10月'")
    private BigDecimal totalCost10;

    @ApiModelProperty("费用合计11月")
    @Column(name = "total_cost11", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计11月'")
    private BigDecimal totalCost11;

    @ApiModelProperty("费用合计12月")
    @Column(name = "total_cost12", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '费用合计12月'")
    private BigDecimal totalCost12;

    @ApiModelProperty("本次结案金额1月")
    @Column(name = "this_audit_amount01", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额1月'")
    private BigDecimal thisAuditAmount01;

    @ApiModelProperty("本次结案金额2月")
    @Column(name = "this_audit_amount02", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额2月'")
    private BigDecimal thisAuditAmount02;

    @ApiModelProperty("本次结案金额3月")
    @Column(name = "this_audit_amount03", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额3月'")
    private BigDecimal thisAuditAmount03;

    @ApiModelProperty("本次结案金额4月")
    @Column(name = "this_audit_amount04", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额4月'")
    private BigDecimal thisAuditAmount04;

    @ApiModelProperty("本次结案金额5月")
    @Column(name = "this_audit_amount05", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额5月'")
    private BigDecimal thisAuditAmount05;

    @ApiModelProperty("本次结案金额6月")
    @Column(name = "this_audit_amount06", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额6月'")
    private BigDecimal thisAuditAmount06;

    @ApiModelProperty("本次结案金额7月")
    @Column(name = "this_audit_amount07", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额7月'")
    private BigDecimal thisAuditAmount07;

    @ApiModelProperty("本次结案金额8月")
    @Column(name = "this_audit_amount08", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额8月'")
    private BigDecimal thisAuditAmount08;

    @ApiModelProperty("本次结案金额9月")
    @Column(name = "this_audit_amount09", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额9月'")
    private BigDecimal thisAuditAmount09;

    @ApiModelProperty("本次结案金额10月")
    @Column(name = "this_audit_amount10", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额10月'")
    private BigDecimal thisAuditAmount10;

    @ApiModelProperty("本次结案金额11月")
    @Column(name = "this_audit_amount11", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额11月'")
    private BigDecimal thisAuditAmount11;

    @ApiModelProperty("本次结案金额12月")
    @Column(name = "this_audit_amount12", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额12月'")
    private BigDecimal thisAuditAmount12;

    @ApiModelProperty("本次结案金额1月")
    @Column(name = "this_audit_amount01_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额1月'")
    private BigDecimal thisAuditAmount01Pre;

    @ApiModelProperty("本次结案金额2月")
    @Column(name = "this_audit_amount02_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额2月'")
    private BigDecimal thisAuditAmount02Pre;

    @ApiModelProperty("本次结案金额3月")
    @Column(name = "this_audit_amount03_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额3月'")
    private BigDecimal thisAuditAmount03Pre;

    @ApiModelProperty("本次结案金额4月")
    @Column(name = "this_audit_amount04_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额4月'")
    private BigDecimal thisAuditAmount04Pre;

    @ApiModelProperty("本次结案金额5月")
    @Column(name = "this_audit_amount05_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额5月'")
    private BigDecimal thisAuditAmount05Pre;

    @ApiModelProperty("本次结案金额6月")
    @Column(name = "this_audit_amount06_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额6月'")
    private BigDecimal thisAuditAmount06Pre;

    @ApiModelProperty("本次结案金额7月")
    @Column(name = "this_audit_amount07_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额7月'")
    private BigDecimal thisAuditAmount07Pre;

    @ApiModelProperty("本次结案金额8月")
    @Column(name = "this_audit_amount08_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额8月'")
    private BigDecimal thisAuditAmount08Pre;

    @ApiModelProperty("本次结案金额9月")
    @Column(name = "this_audit_amount09_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额9月'")
    private BigDecimal thisAuditAmount09Pre;

    @ApiModelProperty("本次结案金额10月")
    @Column(name = "this_audit_amount10_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额10月'")
    private BigDecimal thisAuditAmount10Pre;

    @ApiModelProperty("本次结案金额11月")
    @Column(name = "this_audit_amount11_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额11月'")
    private BigDecimal thisAuditAmount11Pre;

    @ApiModelProperty("本次结案金额12月")
    @Column(name = "this_audit_amount12_pre", precision = 24, scale = 2, columnDefinition = "DECIMAL(24,2) COMMENT '本次结案金额12月'")
    private BigDecimal thisAuditAmount12Pre;
}
