package com.biz.crm.tpm.business.son.company.report.local.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value = "PromotionProgressIntensityMonitor", description = "促销进度力度监控表")
@TableName("tpm_promotion_progress_intensity_monitor")
@Getter
@Setter
@Entity(name = "tpm_promotion_progress_intensity_monitor")
@org.hibernate.annotations.Table(appliesTo = "tpm_promotion_progress_intensity_monitor", comment = "促销进度力度监控表")
@Table(name = "tpm_promotion_progress_intensity_monitor")
public class PromotionProgressIntensityMonitor extends TenantFlagOpEntity {

    @ApiModelProperty(value = "业务单元", notes = "")
    @Column(name = "business_unit_code",  length = 20, columnDefinition = "VARCHAR(20) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(value = "业态", notes = "")
    @Column(name = "business_format_code",  length = 20, columnDefinition = "VARCHAR(20) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "orgCode", value = "组织编码", notes = "组织编码")
    @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty(name = "orgName", value = "组织名称", notes = "组织名称")
    @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "datetime COMMENT '费用所属年月 '")
    private Date feeYearMonth;

    @ApiModelProperty(name = "分子公司活动细案", notes = "分子公司活动细案")
    @Column(name = "constituent_detail_plan_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '分子公司活动细案编码'")
    private String constituentDetailPlanCode;

    @ApiModelProperty(name = "分子公司活动细案名称", notes = "分子公司活动细案名称")
    @Column(name = "constituent_detail_plan_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '分子公司活动细案名称'")
    private String constituentDetailPlanName;

    @ApiModelProperty(name = "分子公司活动细案明细编码", notes = "分子公司活动细案明细编码")
    @Column(name = "constituent_detail_plan_item_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '分子公司活动细案编码'")
    private String constituentDetailPlanItemCode;

    @ApiModelProperty("活动类型")
    @Column(name = "activity_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型编码'")
    private String activityType;

    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动类型'")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty("活动形式说明")
    @Column(name = "activity_form_desc", columnDefinition = "text COMMENT '活动形式说明'")
    private String activityFormDesc;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("部门编码")
    @Column(name = "department_code",  length = 255, columnDefinition = "varchar(255) COMMENT '部门编码'")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    @Column(name = "department_name",  length = 255, columnDefinition = "varchar(1024) COMMENT '方案结束时间'")
    private String departmentName;

    @ApiModelProperty(name = "salesGroupName", value = "销售组(省区)", notes = "销售组(省区)")
    @Column(name = "sales_group_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组(省区) '")
    private String salesGroupName;

    @ApiModelProperty(name = "salesGroupCode", value = "销售组编码", notes = "销售组编码")
    @Column(name = "sales_group_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码 '")
    private String salesGroupCode;

    @ApiModelProperty("渠道编码")
    @TableField(value = "channel_code")
    @Column(name = "channel_code", length = 64, columnDefinition = "varchar(64) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty("渠道名称")
    @TableField(value = "channel_name")
    @Column(name = "channel_name", columnDefinition = "varchar(255) COMMENT '渠道名称'")
    private String channelName;

    @ApiModelProperty("客户编码")
    @TableField(value = "customer_code")
    @Column(name = "customer_code", length = 255, columnDefinition = "varchar(255) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @TableField(value = "customer_name")
    @Column(name = "customer_name", length = 64, columnDefinition = "varchar(64) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 64, columnDefinition = "varchar(64) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty("品牌名称")
    @TableField(value = "product_brand_name")
    @Column(name = "product_brand_name", length = 64, columnDefinition = "varchar(64) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty("品牌编码")
    @TableField(value = "product_brand_code")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code",  length = 64, columnDefinition = "varchar(64) COMMENT '品项编码'")
    private String productItemCode;

    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name",  length = 64, columnDefinition = "varchar(64) COMMENT '品项名称'")
    private String productItemName;

    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code",  length = 64, columnDefinition = "varchar(64) COMMENT '品类编码'")
    private String productCategoryCode;

    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name",  length = 64, columnDefinition = "varchar(64) COMMENT '品类名称'")
    private String productCategoryName;

    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品编码")
    @Column(name = "product_name", columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty("核销方式")
    @Column(name = "audit_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销方式'")
    private String auditType;

    @ApiModelProperty("活动创建人")
    @Column(name = "activity_create", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动创建人'")
    private String activityCreate;

    @ApiModelProperty("是否价格相关")
    @Column(name = "is_price_relation", length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否价格相关'")
    private String isPriceRelation;

    @ApiModelProperty("销售申请量")
    @Column(name = "promote_sales", length = 4, columnDefinition = "decimal(24,6) COMMENT '销售申请量'")
    private BigDecimal promoteSales;

    @ApiModelProperty("活动申请金额")
    @Column(name = "total_cost", columnDefinition = "decimal(20,6) COMMENT '活动申请金额'")
    private BigDecimal totalCost;

    @ApiModelProperty("活动执行量")
    @Column(name = "execute_sales", length = 4, columnDefinition = "decimal(24,6) COMMENT '活动执行量'")
    private BigDecimal executeSales;

    @ApiModelProperty("活动剩余量")
    @Column(name = "residue_sales", length = 4, columnDefinition = "decimal(24,6) COMMENT '活动剩余量'")
    private BigDecimal residueSales;

    @ApiModelProperty("活动执行进度")
    @Column(name = "execute_progress", length = 4, columnDefinition = "decimal(24,6) COMMENT '活动执行进度'")
    private BigDecimal executeProgress;

    @ApiModelProperty("预计费用金额")
    @Column(name = "expected_amount", length = 4, columnDefinition = "decimal(24,6) COMMENT '预计费用金额'")
    private BigDecimal expectedAmount;

    @ApiModelProperty("标准供货价")
    @Column(name = "standard_price", length = 4, columnDefinition = "decimal(24,6) COMMENT '标准供货价'")
    private BigDecimal standardPrice;

    @ApiModelProperty("促销零售价")
    @Column(name = "promotion_retail_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销零售价'")
    private BigDecimal promotionRetailPrice;

    @ApiModelProperty(name = "redLinePrice", value = "红线价", notes = "红线价")
    @Column(name = "red_line_price", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '红线价'")
    private BigDecimal redLinePrice;

    @ApiModelProperty("供货红线价")
    @Column(name = "supply_red_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '供货红线价'")
    private BigDecimal supplyRedPrice;

    @ApiModelProperty("开单价")
    @Column(name = "order_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '开单价'")
    private BigDecimal orderPrice;

    @ApiModelProperty("POS价格")
    @Column(name = "pos_price", length = 24, columnDefinition = "decimal(24,6) COMMENT 'POS价格'")
    private BigDecimal posPrice;

    @ApiModelProperty("是否超供货红线价")
    @Column(name = "exceed_supply_red_price", length = 64, columnDefinition = "varchar(64) COMMENT '是否超供货红线价'")
    private String exceedSupplyRedPrice;

    @ApiModelProperty("是否超零售红线价")
    @Column(name = "exceed_retail_red_price", length = 64, columnDefinition = "varchar(64) COMMENT '是否超零售红线价'")
    private String exceedRetailRedPrice;

    @ApiModelProperty("分销渠道")
    @Column(name = "distribution_channel_name", length = 64, columnDefinition = "varchar(64) COMMENT '分销渠道'")
    private String distributionChannelName;

    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", length = 64, columnDefinition = "varchar(64) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty(name = "unitCode", value = "单位编码", notes = "单位编码")
    @Column(name = "unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位编码'")
    private String unitCode;

    @ApiModelProperty(name = "unit", value = "单位", notes = "单位")
    @Column(name = "unit", length = 255, columnDefinition = "VARCHAR(255) COMMENT '单位'")
    private String unit;
}
