package com.biz.crm.tpm.business.son.company.report.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @CLASS_DESCRIBE: 销量与费用监控表
 * @AUTHOR: create by zkey on 2023-10-21
 */
@ApiModel(value = "SalesVolumeMonitor", description = "销量与费用监控表")
@TableName("tpm_sales_and_fee_monitor")
@Getter
@Setter
@Entity(name = "tpm_sales_and_fee_monitor")
@org.hibernate.annotations.Table(appliesTo = "tpm_sales_and_fee_monitor", comment = "销量与费用监控表")
@Table(name = "tpm_sales_and_fee_monitor", indexes = {
        @Index(name = "tpm_sales_and_fee_monitor_idx1", columnList = "fee_year_month_str", unique = false),
})
public class SalesAndFeeMonitor extends TenantFlagOpEntity {
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", length = 20, columnDefinition = "datetime COMMENT '费用所属年月'")
    private Date feeYearMonth;

    @Column(name = "fee_year_month_str", length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用所属年月'")
    private String feeYearMonthStr;

    @ApiModelProperty("组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码'")
    private String orgCode;

    @ApiModelProperty("组织名称")
    @Column(name = "org_name", columnDefinition = "VARCHAR(255) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty("业态")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("销售公司代码")
    @Column(name = "sales_company_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售公司代码 '")
    private String salesCompanyCode;

    @ApiModelProperty(name = "salesInstitutionName", value = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name", columnDefinition = "VARCHAR(255) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    @ApiModelProperty(name = "salesInstitutionCode", value = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesOrgCode", value = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "supplierName", value = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", length = 200, columnDefinition = "VARCHAR(200) COMMENT '销售组织名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "salesGroupCode", value = "销售组编码", notes = "销售组编码")
    @Column(name = "sales_group_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码 '")
    private String salesGroupCode;

    @ApiModelProperty(name = "salesGroupName", value = "销售组", notes = "销售组")
    @Column(name = "sales_group_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组 '")
    private String salesGroupName;
    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @Column(name = "activity_form_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动形式编码'")
    private String activityFormCode;

    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type", columnDefinition = "VARCHAR(255) COMMENT '活动类型编码'")
    private String activityType;

    @ApiModelProperty("部门当前销售额")
    @Column(name = "depart_current_sale_amount", columnDefinition = "decimal(20,4) COMMENT '部门当前销售额'")
    private BigDecimal departCurrentSaleAmount;

    @ApiModelProperty("部门计划销售额")
    @Column(name = "depart_plan_sale_amount", columnDefinition = "decimal(20,4) COMMENT '部门计划销售额'")
    private BigDecimal departPlanSaleAmount;

    @ApiModelProperty("销售计划达成进度")
    @Column(name = "sale_plan_reach", columnDefinition = "decimal(20,4) COMMENT '销售计划达成进度'")
    private BigDecimal salePlanReach;

    @ApiModelProperty("部门预算总金额")
    @Column(name = "depart_budget_total_amount", columnDefinition = "decimal(20,4) COMMENT '部门预算总金额'")
    private BigDecimal departBudgetTotalAmount;

    @ApiModelProperty("部门申请费用")
    @Column(name = "depart_apply_fee", columnDefinition = "decimal(20,4) COMMENT '部门申请费用'")
    private BigDecimal departApplyFee;

    @ApiModelProperty("部门预结案金额")
    @Column(name = "depart_audit_amount", columnDefinition = "decimal(20,4) COMMENT '部门预结案金额'")
    private BigDecimal departAuditAmount;

    @ApiModelProperty("部门费用使用进度")
    @Column(name = "depart_fee_use_schedule", columnDefinition = "decimal(20,4) COMMENT '部门费用使用进度'")
    private BigDecimal departFeeUseSchedule;

    @ApiModelProperty("部门实际投产比")
    @Column(name = "depart_actual_put_product_ratio", columnDefinition = "decimal(20,4) COMMENT '部门实际投产比'")
    private BigDecimal departActualPutProductRatio;

    @ApiModelProperty("部门预计投入产出比")
    @Column(name = "depart_predict_put_product_ratio", columnDefinition = "decimal(20,4) COMMENT '部门预计投入产出比'")
    private BigDecimal departPredictPutProductRatio;

    @ApiModelProperty("销售投产比差")
    @Column(name = "sale_put_product_ratio_diff", columnDefinition = "decimal(20,4) COMMENT '销售投产比差'")
    private BigDecimal salePutProductRatioDiff;

    @ApiModelProperty("陈列预算金额")
    @Column(name = "display_budget_amount", columnDefinition = "decimal(20,4) COMMENT '陈列预算金额'")
    private BigDecimal displayBudgetAmount;

    @ApiModelProperty("陈列申请费用")
    @Column(name = "display_apply_fee", columnDefinition = "decimal(20,4) COMMENT '陈列申请费用'")
    private BigDecimal displayApplyFee;

    @ApiModelProperty("陈列预估核销金额")
    @Column(name = "display_forecast_audit_amount", columnDefinition = "decimal(20,4) COMMENT '陈列预估核销金额'")
    private BigDecimal displayForecastAuditAmount;

    @ApiModelProperty("陈列费用使用进度")
    @Column(name = "display_fee_use_schedule", columnDefinition = "decimal(20,4) COMMENT '陈列费用使用进度'")
    private BigDecimal displayFeeUseSchedule;

    @ApiModelProperty("人员预算金额")
    @Column(name = "people_budget_amount", columnDefinition = "decimal(20,4) COMMENT '人员预算金额'")
    private BigDecimal peopleBudgetAmount;

    @ApiModelProperty("人员申请费用")
    @Column(name = "people_apply_fee", columnDefinition = "decimal(20,4) COMMENT '人员申请费用'")
    private BigDecimal peopleApplyFee;

    @ApiModelProperty("人员预估核销金额")
    @Column(name = "people_forecast_audit_amount", columnDefinition = "decimal(20,4) COMMENT '人员预估核销金额'")
    private BigDecimal peopleForecastAuditAmount;

    @ApiModelProperty("人员费用使用进度")
    @Column(name = "people_fee_use_schedule", columnDefinition = "decimal(20,4) COMMENT '人员费用使用进度'")
    private BigDecimal peopleFeeUseSchedule;

    @ApiModelProperty("促销活动预算金额")
    @Column(name = "promotion_budget_amount", columnDefinition = "decimal(20,4) COMMENT '促销活动预算金额'")
    private BigDecimal promotionBudgetAmount;

    @ApiModelProperty("促销活动申请费用")
    @Column(name = "promotion_apply_fee", columnDefinition = "decimal(20,4) COMMENT '促销活动申请费用'")
    private BigDecimal promotionApplyFee;

    @ApiModelProperty("促销活动预估核销金额")
    @Column(name = "promotion_forecast_audit_amount", columnDefinition = "decimal(20,4) COMMENT '促销活动预估核销金额'")
    private BigDecimal promotionForecastAuditAmount;

    @ApiModelProperty("促销活动费用使用进度")
    @Column(name = "promotion_fee_use_schedule", columnDefinition = "decimal(20,4) COMMENT '促销活动费用使用进度'")
    private BigDecimal promotionFeeUseSchedule;

    @ApiModelProperty("大日期预算金额")
    @Column(name = "big_date_budget_amount", columnDefinition = "decimal(20,4) COMMENT '大日期预算金额'")
    private BigDecimal bigDateBudgetAmount;

    @ApiModelProperty("大日期申请费用")
    @Column(name = "big_date_apply_fee", columnDefinition = "decimal(20,4) COMMENT '大日期申请费用'")
    private BigDecimal bigDateApplyFee;

    @ApiModelProperty("大日期预估核销金额")
    @Column(name = "big_date_forecast_audit_amount", columnDefinition = "decimal(20,4) COMMENT '大日期预估核销金额'")
    private BigDecimal bigDateForecastAuditAmount;

    @ApiModelProperty("大日期费用使用进度")
    @Column(name = "big_date_fee_use_schedule", columnDefinition = "decimal(20,4) COMMENT '大日期费用使用进度'")
    private BigDecimal bigDateFeeUseSchedule;
}
