package com.biz.crm.tpm.business.son.company.report.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @CLASS_DESCRIBE: 销量监控(品项)
 * @AUTHOR: create by zkey on 2023-10-20
 */
@ApiModel(value = "SalesVolumeMonitor", description = "销量监控(品项)表")
@TableName("tpm_sales_volume_monitor")
@Getter
@Setter
@Entity(name = "tpm_sales_volume_monitor")
@org.hibernate.annotations.Table(appliesTo = "tpm_sales_volume_monitor", comment = "销量监控(品项)表")
@Table(name = "tpm_sales_volume_monitor")
public class SalesVolumeMonitor extends TenantFlagOpEntity {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]")
    @Column(name = "business_unit_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(name = "年月")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码")
    @Column(name = "org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    @ApiModelProperty(name = "salesCompanyCode", value = "销售公司代码", notes = "销售公司代码")
    @Column(name = "sales_company_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售公司代码'")
    private String salesCompanyCode;

    @ApiModelProperty(name = "salesOrgName",value = "销售部门名称",notes = "销售部门名称")
    @Column(name = "sales_org_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '销售部门名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码",notes = "销售部门编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码'")
    private String salesOrgCode;

    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    @Column(name = "sales_group_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码'")
    private String salesGroupCode;

    @ApiModelProperty(name = "salesGroupName",value = "销售组",notes = "销售组")
    @Column(name = "sales_group_name",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组'")
    private String salesGroupName;

    @ApiModelProperty(name = "customerCode", notes = "客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码 '")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "productBrandCode", notes = "品牌编码")
    @Column(name = "product_brand_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码'")
    private String productBrandCode;

    @ApiModelProperty(name = "productBrandName", notes = "品牌名称")
    @Column(name = "product_brand_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称'")
    private String productBrandName;

    @ApiModelProperty(name = "productCategoryCode",value = "产品品类编码",notes = "产品品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品品类编码'")
    private String productCategoryCode;

    @ApiModelProperty(name = "productCategoryName",value = "产品品类名称",notes = "产品品类名称")
    @Column(name = "product_category_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '产品品类名称'")
    private String productCategoryName;

    @ApiModelProperty(name = "productItemCode",value = "产品品项编码",notes = "产品品项编码")
    @Column(name = "product_item_code", columnDefinition = "VARCHAR(255) COMMENT '产品品项编码'")
    private String productItemCode;

    @ApiModelProperty(name = "productItemName",value = "产品品项名称",notes = "产品品项名称")
    @Column(name = "product_item_name", columnDefinition = "VARCHAR(255) COMMENT '产品品项名称'")
    private String productItemName;

    @ApiModelProperty("品项计划销量")
    @Column(name = "product_item_plan_sale_amount", columnDefinition = "decimal(20,4) COMMENT '品项计划销量'")
    private BigDecimal productItemPlanSaleAmount;

    @ApiModelProperty("品项预算折前销售额")
    @Column(name = "product_item_plan_sale_quantity", columnDefinition = "decimal(20,4) COMMENT '品项预算折前销售额'")
    private BigDecimal productItemPlanSaleQuantity;

    @ApiModelProperty("品项预算折后销售额")
    @Column(name = "product_item_budget_discount_before_sale_amount", columnDefinition = "decimal(20,4) COMMENT '品项预算折后销售额'")
    private BigDecimal productItemBudgetDiscountBeforeSaleAmount;

    @ApiModelProperty("品项预算理论成本")
    @Column(name = "product_item_budget_theory_cost", columnDefinition = "decimal(20,4) COMMENT '品项预算理论成本'")
    private BigDecimal productItemBudgetTheoryCost;

    @ApiModelProperty("品项预算理论毛利")
    @Column(name = "product_item_budget_theory_gross_margin", columnDefinition = "decimal(20,4) COMMENT '品项预算理论毛利'")
    private BigDecimal productItemBudgetTheoryGrossMargin;

    @ApiModelProperty("品项实际销售量")
    @Column(name = "product_item_actual_sale_quantity", columnDefinition = "decimal(20,4) COMMENT '品项实际销售量'")
    private BigDecimal productItemActualSaleQuantity;

    @ApiModelProperty("品项实际折前销售额")
    @Column(name = "product_item_actual_discount_before_sale_amount", columnDefinition = "decimal(20,4) COMMENT '品项实际折前销售额'")
    private BigDecimal productItemActualDiscountBeforeSaleAmount;

    @ApiModelProperty("品项实际折后销售额")
    @Column(name = "product_item_actual_discount_after_sale_amount", columnDefinition = "decimal(20,4) COMMENT '品项实际折后销售额'")
    private BigDecimal productItemActualDiscountAfterSaleAmount;

    @ApiModelProperty("品项实际理论成本")
    @Column(name = "product_item_actual_theory_cost", columnDefinition = "decimal(20,4) COMMENT '品项实际理论成本'")
    private BigDecimal productItemActualTheoryCost;

    @ApiModelProperty("品项实际理论毛利")
    @Column(name = "product_item_actual_theory_gross_margin", columnDefinition = "decimal(20,4) COMMENT '品项实际理论毛利'")
    private BigDecimal productItemActualTheoryGrossMargin;

    @ApiModelProperty("品项销量达成率")
    @Column(name = "product_item_sale_reach_rate", columnDefinition = "decimal(20,4) COMMENT '品项销量达成率'")
    private BigDecimal productItemSaleReachRate;

    @ApiModelProperty("品项销量偏差")
    @Column(name = "product_item_sale_diff", columnDefinition = "decimal(20,4) COMMENT '品项销量偏差'")
    private BigDecimal productItemSaleDiff;

    @ApiModelProperty("品项折前销售偏差")
    @Column(name = "product_item_discount_before_sale_diff", columnDefinition = "decimal(20,4) COMMENT '品项折前销售偏差'")
    private BigDecimal productItemDiscountBeforeSaleDiff;

    @ApiModelProperty("品项折后销售偏差")
    @Column(name = "product_item_discount_after_sale_diff", columnDefinition = "decimal(20,4) COMMENT '品项折后销售偏差'")
    private BigDecimal productItemDiscountAfterSaleDiff;

    @ApiModelProperty("品项理论成本偏差")
    @Column(name = "product_item_theory_cost_diff", columnDefinition = "decimal(20,4) COMMENT '品项理论成本偏差'")
    private BigDecimal productItemTheoryCostDiff;

    @ApiModelProperty("品项理论毛利偏差")
    @Column(name = "product_item_theory_gross_margin_diff", columnDefinition = "decimal(20,4) COMMENT '品项理论毛利偏差'")
    private BigDecimal productItemTheoryGrossMarginDiff;
}
