package com.biz.crm.tpm.business.son.company.report.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Author : dengwei
 * @Date :2023/11/24  17:36
 * @Description: 分子预算预警
 */
@ApiModel(value = "SonCompanyBudgetWarnEntity", description = "分子预算预警")
@TableName("tpm_son_company_budget_warn")
@Getter
@Setter
@Entity(name = "tpm_son_company_budget_warn")
@org.hibernate.annotations.Table(appliesTo = "tpm_son_company_budget_warn", comment = "分子预算预警")
@Table(name = "tpm_son_company_budget_warn")
public class SonCompanyBudgetWarnEntity extends TenantFlagOpEntity {

    /**
     * 业态
     */
    @ApiModelProperty(value = "业态",notes = "")
    @Column(name = "business_format_code", nullable = true, length = 64, columnDefinition = " varchar(64) COMMENT '业态'")
    private String businessFormatCode;
    /**
     * 业务单元
     */
    @ApiModelProperty(value = "业务单元",notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 64, columnDefinition = " varchar(64) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty("年月")
    @Column(name = "year_monthly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearMonthly;

    @ApiModelProperty(name = "orgCode",value = "组织编码",notes = "组织编码")
    @Column(name = "org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织编码'")
    private String orgCode;


    @ApiModelProperty(name = "orgName",value = "组织名称",notes = "组织名称")
    @Column(name = "org_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '组织名称'")
    private String orgName;

    @ApiModelProperty(name = "salesCompanyCode", value = "销售公司代码", notes = "销售公司代码")
    @Column(name = "sales_company_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售公司代码 '")
    private String salesCompanyCode;

    @ApiModelProperty("渠道编码")
    @Column(name = "channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    @Column(name = "sales_group_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组编码'")
    private String salesGroupCode;

    @ApiModelProperty(value = "客户编码", notes = "")
    @Column(name = "customer_code", nullable = true, length = 64, columnDefinition = "varchar(20) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty(value = "客户名称", notes = "")
    @Column(name = "customer_name", nullable = true, length = 200, columnDefinition = "varchar(20) COMMENT '客户名称'")
    private String customerName;

    @ApiModelProperty(name = "budgetItemCode", value = "预算项目编码")
    @Column(name = "budget_item_code",  length = 64, columnDefinition = "varchar(64) COMMENT '预算项目编码'")
    private String budgetItemCode;

    @ApiModelProperty("公司月度预算申请点内")
    @Column(name = "month_budget_apply_point_in", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '公司月度预算申请点内'")
    private BigDecimal monthBudgetApplyPointIn;

    @ApiModelProperty("公司月度预算申请自投")
    @Column(name = "month_budget_apply_point_put_self", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '公司月度预算申请自投'")
    private BigDecimal monthBudgetApplyPointPutSelf;

    @ApiModelProperty("公司月度预算申请点外")
    @Column(name = "month_budget_apply_point_out", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '公司月度预算申请点外'")
    private BigDecimal monthBudgetApplyPointOut;

    @ApiModelProperty("客户年月预算点内额度")
    @Column(name = "customer_month_budget_apply_point_in", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '客户年月预算点内额度'")
    private BigDecimal customerMonthBudgetApplyPointIn;

    @ApiModelProperty("客户年月预算自投额度")
    @Column(name = "customer_month_budget_apply_point_put_self", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '客户年月预算自投额度'")
    private BigDecimal customerMonthBudgetApplyPointPutSelf;

    @ApiModelProperty("客户年月预算点外额度")
    @Column(name = "customer_month_budget_apply_point_out", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '客户年月预算点外额度'")
    private BigDecimal customerMonthBudgetApplyPointOut;

    @ApiModelProperty("销售组年月折后销售额")
    @Column(name = "sale_group_after_sale_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '销售组年月折后销售额'")
    private BigDecimal saleGroupAfterSaleAmount;

    @ApiModelProperty("销售组年月点外总额度")
    @Column(name = "sale_group_month_budget_apply_point_out", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '销售组年月点外总额度'")
    private BigDecimal saleGroupMonthBudgetApplyPointOut;

    @ApiModelProperty("销售组年月点内总额度")
    @Column(name = "sale_group_month_budget_apply_point_in", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '销售组年月点内总额度'")
    private BigDecimal saleGroupMonthBudgetApplyPointIn;

    @ApiModelProperty("销售组年月自投总额度")
    @Column(name = "sale_group_month_budget_apply_point_put_self", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '销售组年月自投总额度'")
    private BigDecimal saleGroupMonthBudgetApplyPointPutSelf;

    @ApiModelProperty("销售组实际折后收入")
    @Column(name = "sale_group_real_after_income", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '销售组实际折后收入'")
    private BigDecimal saleGroupRealAfterIncome;
}
