package com.biz.crm.tpm.business.son.company.report.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @CLASS_DESCRIBE: 分子公司利润监控表
 * @AUTHOR: create by zkey on 2023-09-25
 */
@ApiModel(value = "SubComProfitMonitor", description = "分子公司利润监控表")
@TableName("tpm_sub_com_profit_monitor")
@Getter
@Setter
@Entity(name = "tpm_sub_com_profit_monitor")
@org.hibernate.annotations.Table(appliesTo = "tpm_sub_com_profit_monitor", comment = "分子公司利润监控表")
@Table(name = "tpm_sub_com_profit_monitor")
public class SubComProfitMonitor extends TenantOpEntity {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(name = "年月", notes = "")
    @Column(name = "year_month_ly", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月 '")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '组织编码 '")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '组织名称 '")
    private String orgName;

    /**
     * 销售公司代码
     */
    @ApiModelProperty(name = "salesCompanyCode", value = "销售公司代码", notes = "销售公司代码")
    @Column(name = "sales_company_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售公司代码 '")
    private String salesCompanyCode;

    /**
     * 销售公司代码
     */
    @ApiModelProperty(name = "salesCompanyName", value = "销售公司名称", notes = "销售公司名称")
    @Column(name = "sales_company_name", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售公司名称 '")
    private String salesCompanyName;


    /**
     * 预算理论收入
     */
    @ApiModelProperty(name = "budgetTheoryIncome", value = "预算理论收入", notes = "预算理论收入")
    @Column(name = "budget_theory_income", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算理论收入'")
    private BigDecimal budgetTheoryIncome;

    /**
     * 预算理论毛利
     */
    @ApiModelProperty(name = "budgetTheoryGross", value = "预算理论毛利", notes = "预算理论毛利")
    @Column(name = "budget_theory_Gross", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算理论毛利'")
    private BigDecimal budgetTheoryGross;

    /**
     * 预算税金及附加
     */
    @ApiModelProperty(name = "budgetTaxSurcharges", value = "预算税金及附加", notes = "预算税金及附加")
    @Column(name = "budget_tax_surcharges", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算税金及附加'")
    private BigDecimal budgetTaxSurcharges;

    /**
     * 期初利润目标
     */
    @ApiModelProperty(name = "openingProfitTarget", value = "期初利润目标", notes = "期初利润目标")
    @Column(name = "opening_profit_target", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '期初利润目标'")
    private BigDecimal openingProfitTarget;

    /**
     * 预算固定支出
     */
    @ApiModelProperty(name = "budgetFixedExpend", value = "预算固定支出", notes = "预算固定支出")
    @Column(name = "budget_fixed_expend", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算固定支出'")
    private BigDecimal budgetFixedExpend;

    /**
     * 预算考核扣款
     */
    @ApiModelProperty(name = "budgetExamineDeduction", value = "预算考核扣款", notes = "预算考核扣款")
    @Column(name = "budget_examine_deduction", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算考核扣款'")
    private BigDecimal budgetExamineDeduction;

    /**
     * 预算专项费用投入
     */
    @ApiModelProperty(name = "budgetSpecialInput", value = "预算专项费用投入", notes = "预算专项费用投入")
    @Column(name = "budget_special_input", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算专项费用投入'")
    private BigDecimal budgetSpecialInput;

    /**
     * 预算公投费用
     */
    @ApiModelProperty(name = "budgetReferendumCost", value = "预算公投费用", notes = "预算公投费用")
    @Column(name = "budget_referendum_cost", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算公投费用'")
    private BigDecimal budgetReferendumCost;

    /**
     * 预算利润
     */
    @ApiModelProperty(name = "budgetProfit", value = "预算利润", notes = "预算利润")
    @Column(name = "budget_profit", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算利润'")
    private BigDecimal budgetProfit;

    /**
     * 预算利润率
     */
    @ApiModelProperty(name = "budgetProfitMargin", value = "预算利润率", notes = "预算利润率")
    @Column(name = "budget_profit_margin", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '预算利润率'")
    private BigDecimal budgetProfitMargin;

    /**
     * 实际理论毛利
     */
    @ApiModelProperty(name = "actualTheoryGross", value = "实际理论毛利", notes = "实际理论毛利")
    @Column(name = "actual_theory_gross", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际理论毛利'")
    private BigDecimal actualTheoryGross;

    /**
     * 实际收入
     */
    @ApiModelProperty(name = "realIncome", value = "实际收入", notes = "实际收入")
    @Column(name = "real_income", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际收入'")
    private BigDecimal realIncome;

    /**
     * 实际税金及附加
     */
    @ApiModelProperty(name = "actualTaxSurcharges", value = "实际税金及附加", notes = "实际税金及附加")
    @Column(name = "actual_tax_surcharges", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际税金及附加'")
    private BigDecimal actualTaxSurcharges;

    /**
     * 实际专项费用投入
     */
    @ApiModelProperty(name = "actualSpecialInput", value = "实际专项费用投入", notes = "实际专项费用投入")
    @Column(name = "actual_special_input", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际专项费用投入'")
    private BigDecimal actualSpecialInput;

    /**
     * 实际固定支出
     */
    @ApiModelProperty(name = "actualFixedExpend", value = "实际固定支出", notes = "实际固定支出")
    @Column(name = "actual_fixed_expend", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际固定支出'")
    private BigDecimal actualFixedExpend;

    /**
     * 实际考核扣款
     */
    @ApiModelProperty(name = "actualExamineDeduction", value = "实际考核扣款", notes = "实际考核扣款")
    @Column(name = "actual_examine_deduction", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际考核扣款'")
    private BigDecimal actualExamineDeduction;

    /**
     * 实际公投费用
     */
    @ApiModelProperty(name = "actualReferendumCost", value = "实际公投费用", notes = "实际公投费用")
    @Column(name = "actual_referendum_cost", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际公投费用'")
    private BigDecimal actualReferendumCost;

    /**
     * 实际核销公投费用
     */
    @ApiModelProperty(name = "actualAuditReferendumCost", value = "实际核销公投费用", notes = "实际核销公投费用")
    @Column(name = "actual_audit_referendum_cost", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际核销公投费用'")
    private BigDecimal actualAuditReferendumCost;

    /**
     * 实际利润
     */
    @ApiModelProperty(name = "actualProfit", value = "实际利润", notes = "实际利润")
    @Column(name = "actual_profit", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际利润'")
    private BigDecimal actualProfit;

    /**
     * 实际利润率
     */
    @ApiModelProperty(name = "actualProfitMargin", value = "实际利润率", notes = "实际利润率")
    @Column(name = "actual_profit_margin", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '实际利润率'")
    private BigDecimal actualProfitMargin;

    /**
     * 毛利额偏差
     */
    @ApiModelProperty(name = "actualProfitMargin", value = "毛利额偏差", notes = "毛利额偏差")
    @Column(name = "gross_profit_deviation", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '毛利额偏差'")
    private BigDecimal grossProfitDeviation;

    /**
     * 税金及附加偏差
     */
    @ApiModelProperty(name = "taxSurchargesDeviation", value = "税金及附加偏差", notes = "税金及附加偏差")
    @Column(name = "tax_surcharges_deviation", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '税金及附加偏差'")
    private BigDecimal taxSurchargesDeviation;

    /**
     * 专项费用投入偏差
     */
    @ApiModelProperty(name = "specialInputDeviation", value = "专项费用投入偏差", notes = "专项费用投入偏差")
    @Column(name = "special_input_deviation", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '专项费用投入偏差'")
    private BigDecimal specialInputDeviation;

    /**
     * 固定支出偏差
     */
    @ApiModelProperty(name = "fixedExpendDeviation", value = "固定支出偏差", notes = "固定支出偏差")
    @Column(name = "fixed_expend_deviation", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '固定支出偏差'")
    private BigDecimal fixedExpendDeviation;

    /**
     * 公投费用偏差
     */
    @ApiModelProperty(name = "referendumCostDeviation", value = "公投费用偏差", notes = "公投费用偏差")
    @Column(name = "referendum_cost_deviation", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '公投费用偏差'")
    private BigDecimal referendumCostDeviation;

    /**
     * 考核扣款偏差
     */
    @ApiModelProperty(name = "examineDeductionDeviation", value = "考核扣款偏差", notes = "考核扣款偏差")
    @Column(name = "examine_deduction_deviation", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '考核扣款偏差'")
    private BigDecimal examineDeductionDeviation;

    /**
     * 利润偏差
     */
    @ApiModelProperty(name = "examineDeductionDeviation", value = "利润偏差", notes = "利润偏差")
    @Column(name = "profit_deviation", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '利润偏差'")
    private BigDecimal profitDeviation;

    /**
     * 利润率偏差
     */
    @ApiModelProperty(name = "profitMarginDeviation", value = "利润率偏差", notes = "利润率偏差")
    @Column(name = "profit_margin_deviation", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '利润率偏差'")
    private BigDecimal profitMarginDeviation;
}
