package com.biz.crm.tpm.business.son.company.report.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.son.company.report.sdk.service.SubComReportService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @Author : dengwei
 * @Date :2023/7/4  10:11
 * @Description: 分子公司报表
 */
@Slf4j
@Service
public class SubComReportXxlJob {


    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private SubComReportService subComReportService;


    @DynamicTaskService(cornExpression = "0 30 0 * * ? ", taskDesc = "促销进度力度执行监控报表定时任务")
    public void promotionProgressIntensityMonitorJob() {
        this.loginUserService.refreshAuthentication(null);
        subComReportService.promotionProgressIntensityMonitor();

    }

    @DynamicTaskService(cornExpression = "0 30 0 * * ? ", taskDesc = "分子公司利润监控报表定时任务")
    public void profitMonitorJob() {
        this.loginUserService.refreshAuthentication(null);
        subComReportService.profitMonitor();

    }

    @DynamicTaskService(cornExpression = "0 1 0 * * ? ", taskDesc = "销量监控(品项)报表定时任务")
    public void salesVolumeMonitorJob() {
        this.loginUserService.refreshAuthentication(null);
        subComReportService.salesVolumeMonitor();

    }

    @DynamicTaskService(cornExpression = "0 3 0 * * ? ", taskDesc = "销量与费用进度监控报表定时任务")
    public void salesAndFeeMonitorJob() {
        this.loginUserService.refreshAuthentication(null);
        subComReportService.salesAndFeeMonitor();

    }

}
