package com.biz.crm.tpm.business.son.company.report.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class PromotionProgressIntensityDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_promotion_progress_intensity_data_view";
    }

    @Override
    public String desc() {
        return "TPM-促销进度力度执行监控报表";
    }

    @Override
    public String buildSql() {
        return "select t.* from tpm_promotion_progress_intensity_monitor t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

}
