package com.biz.crm.tpm.business.son.company.report.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@Slf4j
public class SalesAndFeeMonitorDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_sales_and_fee_monitor_data_view";
    }

    @Override
    public String desc() {
        return "TPM-销量与费用进度监控报表";
    }

    @Override
    public String buildSql() {
        return "select t.*,\n" +
                "concat(round(t.sale_plan_reach * 100,2),'%') as sale_plan_reach_progress\n" +
                "from tpm_sales_and_fee_monitor t\n" +
                "where t.tenant_code = :tenantCode\n" +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }

}
