package com.biz.crm.tpm.business.son.company.report.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.son.company.report.local.entity.ManageActivityTypeFeeEntity;
import com.biz.crm.tpm.business.son.company.report.local.mapper.ManageActivityTypeFeeMapper;
import com.biz.crm.tpm.business.son.company.report.sdk.vo.ManageActivityTypeFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Author : dengwei
 * @Date :2023/11/23  9:58
 * @Description: TODO
 */
@Component
public class ManageActivityTypeFeeRepository extends ServiceImpl<ManageActivityTypeFeeMapper, ManageActivityTypeFeeEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteYearsData(int year) {
        this.remove(Wrappers.lambdaUpdate(ManageActivityTypeFeeEntity.class).eq(ManageActivityTypeFeeEntity::getYearly,year));
    }

    public List<ManageActivityTypeFeeVo> findListByDimensionalitys(Set<String> dimensionalitys) {
        if(!CollectionUtils.isEmpty(dimensionalitys)){
            List<ManageActivityTypeFeeEntity> list = this.lambdaQuery()
                    .in(ManageActivityTypeFeeEntity::getDimensionality, dimensionalitys)
                    .list();
            if(CollectionUtils.isEmpty(list)){
                return Lists.newArrayList();
            }
            Collection<ManageActivityTypeFeeVo> manageOneProductFeeVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, ManageActivityTypeFeeEntity.class, ManageActivityTypeFeeVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<ManageActivityTypeFeeVo>) manageOneProductFeeVos;
        }
        return Lists.newArrayList();
    }
}
