package com.biz.crm.tpm.business.son.company.report.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.son.company.report.local.entity.ManageChannelFeeEntity;
import com.biz.crm.tpm.business.son.company.report.local.mapper.ManageChannelFeeMapper;
import com.biz.crm.tpm.business.son.company.report.sdk.vo.ManageChannelFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Author : dengwei
 * @Date :2023/11/24  15:05
 * @Description: TODO
 */
@Component
public class ManageChannelFeeRepository extends ServiceImpl<ManageChannelFeeMapper, ManageChannelFeeEntity> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteYearsData(int year) {
        this.remove(Wrappers.lambdaUpdate(ManageChannelFeeEntity.class).eq(ManageChannelFeeEntity::getYearly,year));
    }

    public List<ManageChannelFeeVo> findListByDimensionalitys(Set<String> dimensionalitys) {
        if(!CollectionUtils.isEmpty(dimensionalitys)){
            List<ManageChannelFeeEntity> list = this.lambdaQuery()
                    .in(ManageChannelFeeEntity::getDimensionality, dimensionalitys)
                    .list();
            if(CollectionUtils.isEmpty(list)){
                return Lists.newArrayList();
            }
            Collection<ManageChannelFeeVo> manageChannelFeeVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, ManageChannelFeeEntity.class, ManageChannelFeeVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<ManageChannelFeeVo>) manageChannelFeeVos;
        }
        return Lists.newArrayList();
    }
}
