package com.biz.crm.tpm.business.son.company.report.local.repository;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.son.company.report.local.entity.ManageOneProductFeeEntity;
import com.biz.crm.tpm.business.son.company.report.local.mapper.ManageOneProductFeeMapper;
import com.biz.crm.tpm.business.son.company.report.sdk.vo.ManageOneProductFeeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * @Author : dengwei
 * @Date :2023/11/22  19:47
 * @Description: TODO
 */
@Component
public class ManageOneProductFeeRepository extends ServiceImpl<ManageOneProductFeeMapper, ManageOneProductFeeEntity> {


    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    public void deleteYearsData(int year, String companyCode, String productCode) {

        this.remove(Wrappers.lambdaUpdate(ManageOneProductFeeEntity.class).eq(ManageOneProductFeeEntity::getYearly,year)
                .eq(StringUtils.isNotEmpty(companyCode),ManageOneProductFeeEntity::getSalesInstitutionCode,companyCode)
                .eq(StringUtils.isNotEmpty(productCode),ManageOneProductFeeEntity::getProductCode,productCode)
        );
    }

    public List<ManageOneProductFeeVo> findListByDimensionalitys(Set<String> dimensionalitys) {
        if(!CollectionUtils.isEmpty(dimensionalitys)){
            List<ManageOneProductFeeEntity> list = this.lambdaQuery()
                    .in(ManageOneProductFeeEntity::getDimensionality, dimensionalitys)
                    .list();
            if(CollectionUtils.isEmpty(list)){
                return Lists.newArrayList();
            }
            Collection<ManageOneProductFeeVo> manageOneProductFeeVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, ManageOneProductFeeEntity.class, ManageOneProductFeeVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<ManageOneProductFeeVo>) manageOneProductFeeVos;
        }
        return Lists.newArrayList();
    }
}
