package com.biz.crm.tpm.business.son.company.report.local.repository;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.son.company.report.local.entity.SonCompanyBudgetWarnEntity;
import com.biz.crm.tpm.business.son.company.report.local.mapper.SonCompanyBudgetWarnMapper;
import com.biz.crm.tpm.business.son.company.report.sdk.dto.SonCompanyBudgetWarnDto;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Author : dengwei
 * @Date :2023/11/24  17:32
 * @Description: TODO
 */
@Component
public class SonCompanyBudgetWarnRepository extends ServiceImpl<SonCompanyBudgetWarnMapper, SonCompanyBudgetWarnEntity> {

    public void deleteYearMonthData(List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode) {

        if(CollectionUtils.isEmpty(yearMonthList)){
            return;
        }
        this.remove(Wrappers.lambdaUpdate(SonCompanyBudgetWarnEntity.class)
                .in(SonCompanyBudgetWarnEntity::getYearMonthly,yearMonthList)
                .eq(StringUtils.isNotEmpty(orgCode),SonCompanyBudgetWarnEntity::getOrgCode,orgCode)
                .eq(StringUtils.isNotEmpty(saleCompanyCode),SonCompanyBudgetWarnEntity::getSalesCompanyCode,saleCompanyCode)
                .eq(StringUtils.isNotEmpty(channelCode),SonCompanyBudgetWarnEntity::getChannelCode,channelCode)
                .eq(StringUtils.isNotEmpty(saleGroupCode),SonCompanyBudgetWarnEntity::getSalesGroupCode,saleGroupCode)
                .eq(StringUtils.isNotEmpty(customerCode),SonCompanyBudgetWarnEntity::getCustomerCode,customerCode)
                .eq(StringUtils.isNotEmpty(budgetItemCode),SonCompanyBudgetWarnEntity::getBudgetItemCode,budgetItemCode)
        );
    }

    public List<SonCompanyBudgetWarnEntity> findByDimensionalitys(List<SonCompanyBudgetWarnDto> sonCompanyBudgetWarnDtos) {
        if(CollectionUtils.isEmpty(sonCompanyBudgetWarnDtos)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByDimensionalitys(sonCompanyBudgetWarnDtos);
    }

    public List<SonCompanyBudgetWarnEntity> findByDimensionalitys2(List<SonCompanyBudgetWarnDto> sonCompanyBudgetWarnDtos) {
        if(CollectionUtils.isEmpty(sonCompanyBudgetWarnDtos)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByDimensionalitys2(sonCompanyBudgetWarnDtos);
    }

    public List<SonCompanyBudgetWarnEntity> findByDimensionalitys3_1(List<SonCompanyBudgetWarnDto> sonCompanyBudgetWarnDtos) {
        if(CollectionUtils.isEmpty(sonCompanyBudgetWarnDtos)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByDimensionalitys3_1(sonCompanyBudgetWarnDtos);
    }

    public List<SonCompanyBudgetWarnEntity> findByDimensionalitys3_2(List<SonCompanyBudgetWarnDto> sonCompanyBudgetWarnDtos) {
        if(CollectionUtils.isEmpty(sonCompanyBudgetWarnDtos)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByDimensionalitys3_2(sonCompanyBudgetWarnDtos);
    }

    public List<SonCompanyBudgetWarnEntity> findByDimensionalitys4(List<SonCompanyBudgetWarnDto> sonCompanyBudgetWarnDtos) {
        if(CollectionUtils.isEmpty(sonCompanyBudgetWarnDtos)){
            return Lists.newArrayList();
        }
        return this.getBaseMapper().findByDimensionalitys4(sonCompanyBudgetWarnDtos);
    }
}
