package com.biz.crm.tpm.business.son.company.report.local.task.impl;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.son.company.report.sdk.constant.SonCompanyConstant;
import com.biz.crm.tpm.business.son.company.report.sdk.service.SubComReportService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * @Author : dengwei
 * @Date :2023/11/22  10:54
 * @Description: 分子公司报表定时任务
 */
@Component
@Slf4j
public class SubComSchedulingImpl {

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;

    @Autowired(required = false)
    private SubComReportService subComReportService;
    /**
     * 经营例会单品费用
     */
    @DynamicTaskService(cornExpression = "0 30 0 * * ?", taskDesc = "经营例会单品费用(每天凌晨00:30)")
    public void manageOneProductFee(){
        loginUserService.refreshAuthentication(null);
        String lockKey = SonCompanyConstant.MANAGE_ONE_PRODUCT_FEE_LOCK;
        boolean lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 5);
        Validate.isTrue(lock,"正在跑定时任务经营例会单品费用");
        try {

            log.info("定时任务经营例会单品费用开始...");

            subComReportService.manageOneProductFee(null,null,null);

            log.info("定时任务经营例会单品费用结束...");
        }catch (Exception e){
            log.error("定时任务经营例会单品费用失败",e);
            throw e;
        }finally {
            if(lock){
                this.redisLockService.unlock(lockKey);
            }
        }

    }

    /**
     * 经营例会活动类型费用
     */
    @DynamicTaskService(cornExpression = "0 30 0 * * ?", taskDesc = "经营例会活动类型费用(每天凌晨00:30)")
    public void manageActivityTypeFee(){
        loginUserService.refreshAuthentication(null);
        String lockKey = SonCompanyConstant.MANAGE_ACTIVITY_TYPE_FEE_LOCK;
        boolean lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 5);
        Validate.isTrue(lock,"正在跑定时任务经营例会活动类型费用");
        try {
            log.info("定时任务经营例会活动类型费用开始...");
            subComReportService.manageActivityTypeFee();
            log.info("定时任务经营例会活动类型费用结束...");
        }catch (Exception e){
            log.error("定时任务经营例会活动类型费用失败",e);
            throw e;
        }finally {
            if(lock){
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    /**
     * 经营例会渠道费用
     */
    @DynamicTaskService(cornExpression = "0 30 0 * * ?", taskDesc = "经营例会渠道费用(每天凌晨00:30)")
    public void manageChannelFee(){
        loginUserService.refreshAuthentication(null);
        String lockKey = SonCompanyConstant.MANAGE_CHANNEL_FEE_LOCK;
        boolean lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 5);
        Validate.isTrue(lock,"正在跑定时任务经营例会渠道费用");
        try {
            log.info("定时任务经营例会渠道费用开始...");
            subComReportService.manageChannelFee();
            log.info("定时任务经营例会渠道费用结束...");
        }catch (Exception e){
            log.error("定时任务经营例会渠道费用失败",e);
            throw e;
        }finally {
            if(lock){
                this.redisLockService.unlock(lockKey);
            }
        }
    }

    /**
     * 分子预算预警
     */
    @DynamicTaskService(cornExpression = "0 30 0 * * ?", taskDesc = "分子预算预警(每天凌晨00:30)")
    public void sonCompanyBudgetWarn(){
        loginUserService.refreshAuthentication(null);
        String lockKey = SonCompanyConstant.SON_COMPANY_BUDGET_WARN_LOCK;
        boolean lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 5);
        Validate.isTrue(lock,"正在跑定时任务分子预算预警");
        try {
            log.info("定时任务分子预算预警开始...");
            subComReportService.sonCompanyBudgetWarn(null,null,null,null,null,null,null);
            log.info("定时任务分子预算预警结束...");
        }catch (Exception e){
            log.error("定时任务分子预算预警失败",e);
            throw e;
        }finally {
            if(lock){
                this.redisLockService.unlock(lockKey);
            }
        }
    }
}
