/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.service.config.GenerateDataAsync;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SummationAmountForSubmitApprovalDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.cps.CpsFeeDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SummationAmountForSubmitApprovaVo;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/subsidiary/activity/design"})
@Api(tags={"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212"})
public class SubComActivityDesignController {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignController.class);
    @Resource
    private SubComActivityDesignService subComActivityDesignService;
    @Autowired(required=false)
    private GenerateDataAsync generateDataAsync;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u65b0\u589e\u7f16\u8f91")
    @PostMapping(value={"saveSubComActivityDesign"})
    public Result saveSubComActivityDesign(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="SubComActivityDesignDto", value="\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u8868\u5934") @RequestBody SubComActivityDesignDto dto) {
        try {
            this.subComActivityDesignService.saveSubComActivityDesign(dto, cacheKey);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/findDetailById"})
    public Result<SubComActivityDesignVo> findDetailById(@RequestParam(value="id") String id) {
        try {
            SubComActivityDesignVo subComActivityDesignVo = this.subComActivityDesignService.findById(id);
            return Result.ok((Object)subComActivityDesignVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u53ef\u4ee5\u5173\u8054\u7684\u65b9\u6848\u3001\u7ec6\u6848")
    @GetMapping(value={"findCanRelationPlanListPage"})
    public Result<Page<SubComActivityDesignPlanVo>> findCanRelationPlanListPage(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u67e5\u8be2\u53c2\u6570") SubComActivityDesignPlanDto dto) {
        try {
            Validate.notBlank((CharSequence)dto.getAssociationType(), (String)"\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Page page = this.subComActivityDesignService.findCanRelationPlanListPage(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d41\u7a0b\u5ba1\u6279\u901a\u8fc7")
    @GetMapping(value={"/passBatch"})
    public Result passBatch(@RequestParam(value="processNo") String processNo) {
        try {
            this.subComActivityDesignService.passBatch(processNo, null);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"submitApproval"})
    public Result submitApproval(@ApiParam(value="\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4") @RequestBody SubComActivityDesignApproveSubmitDto dto) {
        List ids = dto.getIds();
        boolean lockSuccess = false;
        try {
            if (CollectionUtils.isEmpty((Collection)ids)) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            }
            lockSuccess = this.redisLockService.batchLock("sub_com_activity_design:lock:approve:", ids, TimeUnit.HOURS, 1);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e");
            }
            this.subComActivityDesignService.submitApproval(dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("sub_com_activity_design:lock:approve:", ids);
            }
        }
    }

    @PostMapping(value={"activityDesignPassBatch"})
    @ApiOperation(value="\u5ba1\u6279\u901a\u8fc7\u56de\u8c03")
    public Result activityDesignPassBatch(String processNo) {
        try {
            this.subComActivityDesignService.activityDesignPassBatch(processNo);
            return Result.ok((String)"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u5ba1\u6279\u901a\u8fc7\u56de\u8c03\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.subComActivityDesignService.deleteBatch(ids);
            return Result.ok((String)"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="cps\u6e20\u9053\u63a8\u9001\u5206\u5b50\u516c\u53f8\u8d39\u7528\u660e\u7ec6")
    @PostMapping(value={"/pushFeeDetail"})
    public Result pushFeeDetail(@RequestBody List<CpsFeeDetailDto> dtoList) {
        try {
            log.info(JSONObject.toJSONString(dtoList));
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u751f\u6210\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u548c\u9884\u7b97")
    @PostMapping(value={"/generateDetailAndBudget"})
    public Result generateDetailAndBudget(String processNo, String tableId) {
        try {
            this.generateDataAsync.generateData(processNo, (UserIdentity)this.loginUserService.getAbstractLoginUser(), tableId);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u751f\u6210\u5206\u5b50\u6d3b\u52a8\u7ec6\u6848\u548c\u9884\u7b97")
    @PostMapping(value={"/generateDetailAndBudgetByDesignCode"})
    public Result generateDetailAndBudget(String activityDesignCode) {
        try {
            this.generateDataAsync.generateDetailAndBudgetByDesignCode(activityDesignCode);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5408\u8ba1")
    @GetMapping(value={"summationAmount"})
    public Result<SubComActivityDesignVo> summationAmount(@ApiParam(name="subComActivityDesignDto", value="\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212dto") SubComActivityDesignDto dto) {
        try {
            SubComActivityDesignVo summation = this.subComActivityDesignService.summationAmount(dto);
            return Result.ok((Object)summation);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u89c4\u5212\u4f7f\u7528\u9884\u7b97\u8be6\u60c5")
    @GetMapping(value={"findUseBudgetDetailByDesignCode"})
    public Result<Page<SubComActivityDesignBudgetVo>> findUseBudgetDetailByDesignCode(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityDesignCode", value="\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u7f16\u7801") String activityDesignCode) {
        try {
            Page page = this.subComActivityDesignService.findUseBudgetDetailByDesignCode(pageable, activityDesignCode);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa\u5ba1\u6279-\u5206\u9875-\u66f4\u636e\u6d41\u7a0b\u7f16\u7801\u67e5\u9884\u7b97\u8be6\u60c5")
    @GetMapping(value={"/findBudgetByProcessNoConditions/create"})
    public Result<Page<SubComActivityDesignBudgetVo>> findBudgetByProcessNoConditionsCreate(@PageableDefault(value=50) Pageable pageable, SubComActivityDesignBudgetDto dto) {
        try {
            Page result = this.subComActivityDesignService.findBudgetByProcessNoConditionsCreate(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u89c4\u5212\u5ba1\u6279\uff0c\u6839\u636eid\u6216\u6d41\u7a0b\u7f16\u7801\u67e5\u8be2\u5408\u8ba1")
    @PostMapping(value={"/summationAmountForSubmitApproval"})
    public Result<SummationAmountForSubmitApprovaVo> summationAmountForSubmitApproval(@RequestBody SummationAmountForSubmitApprovalDto dto) {
        try {
            SummationAmountForSubmitApprovaVo result = this.subComActivityDesignService.summationAmountForSubmitApproval(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

