/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignCloseApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignProductService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignProductVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/subsidiary/activity/design/detail"})
@Api(tags={"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212"})
public class SubComActivityDesignDetailController
extends MnPageCacheController<SubComActivityDesignDetailVo, SubComActivityDesignDetailDto> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignDetailController.class);
    @Resource
    private SubComActivityDesignDetailService subComActivityDesignDetailService;
    @Resource
    private SubComActivityDesignProductService subComActivityDesignProductService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @ApiOperation(value="\u6839\u636e\u7f13\u5b58\u660e\u7ec6\u83b7\u53d6\u4ea7\u54c1\u5206\u644a\u8be6\u60c5")
    @GetMapping(value={"/findProductShareList"})
    public Result<Page<SubComActivityDesignProductVo>> findProductShareList(@PageableDefault(value=50) Pageable pageable, SubComActivityDesignDetailDto dto) {
        try {
            return Result.ok((Object)this.subComActivityDesignProductService.findProductShareList(pageable, dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f13\u5b58\u83b7\u53d6\u603b\u8d39\u7528")
    @GetMapping(value={"/getApplyAmount"})
    public Result<BigDecimal> getApplyAmount(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") String cacheKey, @ApiParam(name="activityDesignCode", value="\u6d3b\u52a8\u89c4\u5212\u7f16\u7801") String activityDesignCode) {
        try {
            return Result.ok((Object)this.subComActivityDesignDetailService.getApplyAmount(cacheKey, activityDesignCode));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5173\u95ed\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u67e5\u8be2\u660e\u7ec6")
    @GetMapping(value={"/closeFindDetail"})
    public Result<Page<SubComActivityDesignDetailVo>> closeFindDetail(@PageableDefault(value=50) Pageable pageable, SubComActivityDesignDetailDto dto) {
        try {
            Page detailVoPage = this.subComActivityDesignDetailService.closeFindDetail(pageable, dto);
            return Result.ok((Object)detailVoPage);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5173\u95ed\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212")
    @PostMapping(value={"/close"})
    public Result<?> close(@RequestBody List<SubComActivityDesignDetailDto> detailDtos) {
        try {
            this.subComActivityDesignDetailService.close(detailDtos);
            return Result.ok((String)"\u64cd\u4f5c\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u6d3b\u52a8\u5173\u95ed\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4")
    @PostMapping(value={"closeActivitySubmitApproval"})
    public Result closeActivitySubmitApproval(@ApiParam(value="\u6d3b\u52a8\u5173\u95ed\u63d0\u4ea4\u6d41\u7a0b,\u591a\u9009\u6279\u91cf\u63d0\u4ea4") @RequestBody SubComActivityDesignCloseApproveSubmitDto dto) {
        List ids = null;
        boolean lockSuccess = false;
        try {
            if (CollectionUtils.isEmpty((Collection)dto.getDetailDtos())) {
                throw new RuntimeException("\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            }
            ids = dto.getDetailDtos().stream().map(UuidDto::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ids)) {
                throw new RuntimeException("\u52a0\u9501\u5931\u8d25,\u6570\u636eid\u4e3a\u7a7a!");
            }
            lockSuccess = this.redisLockService.batchLock("sub_com_activity_design_close:lock:approve:", ids, TimeUnit.HOURS, 1);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e");
            }
            this.subComActivityDesignDetailService.closeSubmitApproval(ids, dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.batchUnLock("sub_com_activity_design_close:lock:approve:", ids);
            }
        }
    }

    @ApiOperation(value="\u66f4\u636e\u5173\u95ed\u6d41\u7a0b\u7f16\u7801\u67e5\u8be2\u660e\u7ec6")
    @GetMapping(value={"/findDetailByCloseProcessNo"})
    public Result<Page<SubComActivityDesignDetailVo>> findDetailByCloseProcessNo(@PageableDefault(value=50) Pageable pageable, String detailProcessNo) {
        try {
            Page detailVoPage = this.subComActivityDesignDetailService.findByConditionsWithDetailProcessNo(pageable, detailProcessNo);
            return Result.ok((Object)detailVoPage);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa\u5ba1\u6279-\u5206\u9875-\u66f4\u636e\u6d41\u7a0b\u7f16\u7801\u67e5\u660e\u7ec6\u8be6\u60c5")
    @GetMapping(value={"/findByProcessNoConditions/create"})
    public Result<Page<SubComActivityDesignDetailVo>> findByProcessNoConditionsCreate(@PageableDefault(value=50) Pageable pageable, SubComActivityDesignDetailDto dto) {
        try {
            Page result = this.subComActivityDesignDetailService.findByProcessNoConditionsCreate(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5f85\u8c03\u6574\u7684\u5206\u5b50\u516c\u53f8\u89c4\u5212\u660e\u7ec6\u6570\u636e")
    @GetMapping(value={"findToModifyList"})
    public Result<Page<SubComActivityDesignDetailVo>> findToModifyList(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SubComActivityDesignDetailDto dto) {
        try {
            Page page = this.subComActivityDesignDetailService.findToModifyList(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

