/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.dto.SubComActivityDesignDetailExportDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.mapper.SubComActivityDesignDetailExportMapper;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.vo.SubComActivityDesignDetailCloseExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.vo.SubDetailExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignSapEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SubComActivityDesignSapEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignSapEventResponse;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignDetailCloseExportProcess
implements ExportProcess<SubComActivityDesignDetailCloseExportVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignDetailCloseExportProcess.class);
    @Autowired(required=false)
    private SubComActivityDesignDetailExportMapper detailService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    private static final String AUDIT_TYPE = "audit_type";
    private static final String TPM_AUDIT_TYPE = "tpm_audit_type";
    private static final String ACT_DETAIL_STATE = "tpm_activity_design_detail_status";

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        SubComActivityDesignDetailExportDto dto = this.convertParams(params);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Integer total = this.detailService.getExportTotal(dto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        SubComActivityDesignDetailExportDto dto = this.convertParams(params);
        dto.setOffset(this.getPageSize() * vo.getPageNo());
        dto.setLimit(vo.getPageSize());
        List<SubDetailExportVo> data = this.detailService.findData(dto);
        if (CollectionUtils.isEmpty(data)) {
            return new JSONArray();
        }
        List<SubComActivityDesignDetailCloseExportVo> dataList = this.adjustData(data);
        if (CollectionUtils.isEmpty(dataList)) {
            return new JSONArray();
        }
        List itemCodes = dataList.stream().map(SubComActivityDesignDetailCloseExportVo::getActivityDesignDetailCode).collect(Collectors.toList());
        SubComActivityDesignSapEventDto sapDto = new SubComActivityDesignSapEventDto();
        sapDto.setActivityNos(itemCodes);
        SerializableBiConsumer & Serializable getSapAmountAndQuantity = SubComActivityDesignSapEventListener::getSapAmountAndQuantity;
        SubComActivityDesignSapEventResponse eventResponse = (SubComActivityDesignSapEventResponse)this.nebulaNetEventClient.directPublish((NebulaEventDto)sapDto, SubComActivityDesignSapEventListener.class, (SerializableBiConsumer)getSapAmountAndQuantity);
        Validate.notNull((Object)eventResponse, (String)"\u83b7\u53d6sap\u6267\u884c\u6570\u636e\u65f6\uff0c\u4e8b\u4ef6\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
        Map sapAmountMap = new HashMap();
        if (null != eventResponse.getSapAmountMap() && !eventResponse.getSapAmountMap().isEmpty()) {
            sapAmountMap = eventResponse.getSapAmountMap();
        }
        Map sapQuantityMap = new HashMap();
        if (null != eventResponse.getSapQuantityMap() && !eventResponse.getSapQuantityMap().isEmpty()) {
            sapQuantityMap = eventResponse.getSapQuantityMap();
        }
        for (SubComActivityDesignDetailCloseExportVo record : dataList) {
            record.setExecutedAmount(sapAmountMap.getOrDefault(record.getActivityDesignDetailCode(), BigDecimal.ZERO));
            record.setExecutedQuantity(sapQuantityMap.getOrDefault(record.getActivityDesignDetailCode(), BigDecimal.ZERO));
        }
        return JSONArray.parseArray((String)JSON.toJSONString(dataList));
    }

    public String getBusinessCode() {
        return "TPM_SUB_COM_ACTIVITY_DESIGN_DETAIL_CLOSE_EXPORT";
    }

    public String getBusinessName() {
        return "\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u5173\u95ed\u6d41\u7a0b\u4e1a\u52a1\u8868\u5355\u9875\u9762\u5bfc\u51fa";
    }

    public Class<SubComActivityDesignDetailCloseExportVo> findCrmExcelVoClass() {
        return SubComActivityDesignDetailCloseExportVo.class;
    }

    private SubComActivityDesignDetailExportDto convertParams(Map<String, Object> params) {
        params.remove("sort");
        params.remove("europaInfoCode");
        Set<String> keySet = params.keySet();
        Date feeYearMonth = null;
        if (params.containsKey("feeYearMonth")) {
            SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
            String date = (String)params.get("feeYearMonth");
            try {
                feeYearMonth = sif.parse(date);
            }
            catch (ParseException e2) {
                throw new RuntimeException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\uff01");
            }
            params.remove("feeYearMonth");
        }
        log.info("\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u5173\u95ed\u6d41\u7a0b\u4e1a\u52a1\u8868\u5355\u9875\u9762\u5bfc\u51fa,params:{}", (Object)JSONObject.toJSONString(params));
        Map<String, Object> map = params.entrySet().stream().filter(f -> StringUtils.isNotBlank((CharSequence)((CharSequence)f.getKey())) && !Objects.isNull(f.getValue())).collect(Collectors.toMap(e -> (String)e.getKey(), Map.Entry::getValue));
        SubComActivityDesignDetailExportDto dto = (SubComActivityDesignDetailExportDto)((Object)JSON.parseObject((String)JSON.toJSONString(map), SubComActivityDesignDetailExportDto.class));
        dto.setFeeYearMonth(feeYearMonth);
        return dto;
    }

    private List<SubComActivityDesignDetailCloseExportVo> adjustData(List<SubDetailExportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        SimpleDateFormat bartDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        ArrayList<SubComActivityDesignDetailCloseExportVo> arrayList = new ArrayList<SubComActivityDesignDetailCloseExportVo>();
        for (SubDetailExportVo datum : data) {
            SubComActivityDesignDetailCloseExportVo exportVo = (SubComActivityDesignDetailCloseExportVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)datum, SubComActivityDesignDetailCloseExportVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            if (!Objects.isNull(datum.getActivityBeginTime())) {
                exportVo.setActivityBeginTimeStr(bartDateFormat.format(datum.getActivityBeginTime()));
            }
            if (!Objects.isNull(datum.getActivityEndTime())) {
                exportVo.setActivityEndTimeStr(bartDateFormat.format(datum.getActivityEndTime()));
            }
            if (!Objects.isNull(datum.getProductDate())) {
                exportVo.setProductDateStr(dateFormat.format(datum.getProductDate()));
            }
            arrayList.add(exportVo);
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{AUDIT_TYPE, ACT_DETAIL_STATE, TPM_AUDIT_TYPE}));
        for (SubComActivityDesignDetailCloseExportVo vo : arrayList) {
            vo.setAuditType(this.findDictValue(mapDict, AUDIT_TYPE, vo.getAuditType()));
            vo.setActivityDetailStatus(this.findDictValue(mapDict, ACT_DETAIL_STATE, vo.getActivityDetailStatus()));
            vo.setAuditCondition(this.findDictValue(mapDict, TPM_AUDIT_TYPE, vo.getAuditCondition()));
        }
        return arrayList;
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }
}

