/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemMainItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.dto.SubComActivityDesignDetailExportDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.mapper.SubComActivityDesignDetailExportMapper;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.vo.SubComActivityDesignDetailExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.exports.vo.SubDetailExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignDetailExportProcess
implements ExportProcess<SubComActivityDesignDetailExportVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignDetailExportProcess.class);
    @Autowired(required=false)
    private SubComActivityDesignDetailExportMapper detailService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignBudgetService subComActivityDesignBudgetService;
    @Autowired(required=false)
    private BudgetItemMainItemService budgetItemMainItemService;
    private static final String AUDIT_TYPE = "audit_type";
    private static final String TPM_AUDIT_TYPE = "tpm_audit_type";
    private static final String isBigDateOrNo = "isBigDateOrNo";
    private static final String whetherScheduleTimeNo = "whetherScheduleTimeNo";
    private static final String ACCEPT_TYPE = "accept_type";
    private static final String IS_PRICE_RELATED_NO = "isPriceRelatedNo";
    private static final String IS_PATROL_OPERATIONS_NO = "isPatrolOperationsNo";
    private static final String DISPLAY_TYPE = "dis_Type";
    private static final String ACT_DETAIL_STATE = "tpm_activity_design_detail_status";

    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Integer getTotal(Map<String, Object> params) {
        SubComActivityDesignDetailExportDto dto = this.convertParams(params);
        dto.setTenantCode(TenantUtils.getTenantCode());
        Integer total = this.detailService.getExportTotal(dto);
        Validate.isTrue((total < CommonConstant.IE_EXPORT_MAX_TOTAL ? 1 : 0) != 0, (String)("\u5bfc\u51fa\u65f6\uff0c\u5355\u6b21\u6700\u5927\u5bfc\u51fa[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]\u6761,\u8bf7\u8f93\u5165\u66f4\u591a\u67e5\u8be2\u6761\u4ef6!!"), (Object[])new Object[0]);
        return total;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        SubComActivityDesignDetailExportDto dto = this.convertParams(params);
        dto.setOffset(this.getPageSize() * vo.getPageNo());
        dto.setLimit(vo.getPageSize());
        List<SubDetailExportVo> data = this.detailService.findData(dto);
        if (CollectionUtils.isEmpty(data)) {
            return new JSONArray();
        }
        List<SubComActivityDesignDetailExportVo> exportVos = this.adjustData(data);
        if (CollectionUtils.isEmpty(exportVos)) {
            return new JSONArray();
        }
        return JSONArray.parseArray((String)JSON.toJSONString(exportVos));
    }

    public String getBusinessCode() {
        return "TPM_SUB_COM_ACTIVITY_DESIGN_DETAIL_EXPORT";
    }

    public String getBusinessName() {
        return "\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u5bfc\u51fa";
    }

    public Class<SubComActivityDesignDetailExportVo> findCrmExcelVoClass() {
        return SubComActivityDesignDetailExportVo.class;
    }

    private SubComActivityDesignDetailExportDto convertParams(Map<String, Object> params) {
        params.remove("sort");
        params.remove("europaInfoCode");
        Set<String> keySet = params.keySet();
        Date feeYearMonth = null;
        if (params.containsKey("feeYearMonth")) {
            SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
            String date = (String)params.get("feeYearMonth");
            try {
                feeYearMonth = sif.parse(date);
            }
            catch (ParseException e2) {
                throw new RuntimeException("\u5e74\u6708\u683c\u5f0f\u9519\u8bef\uff01");
            }
            params.remove("feeYearMonth");
        }
        Map<String, Object> map = params.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), Map.Entry::getValue));
        SubComActivityDesignDetailExportDto dto = (SubComActivityDesignDetailExportDto)((Object)JSON.parseObject((String)JSON.toJSONString(map), SubComActivityDesignDetailExportDto.class));
        dto.setFeeYearMonth(feeYearMonth);
        return dto;
    }

    private List<SubComActivityDesignDetailExportVo> adjustData(List<SubDetailExportVo> data) {
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        SimpleDateFormat bartDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        ArrayList<SubComActivityDesignDetailExportVo> arrayList = new ArrayList<SubComActivityDesignDetailExportVo>();
        List detailCodes = data.stream().map(SubDetailExportVo::getActivityDesignDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List budgetVoList = this.subComActivityDesignBudgetService.listByActivityDetailCodes(detailCodes);
        Map<String, List<SubComActivityDesignBudgetVo>> budgetVoMap = null;
        if (!CollectionUtils.isEmpty((Collection)budgetVoList)) {
            budgetVoMap = budgetVoList.stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetVo::getActivityDesignDetailCode));
        }
        Map budgetItemMainItemMap = null;
        HashSet mainBudgetItemCodeSet = new HashSet();
        List upDetailCodes = data.stream().filter(d -> RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(d.getAssociationType())).map(SubDetailExportVo::getActivityDesignDetailCode).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(upDetailCodes) && !CollectionUtils.isEmpty(budgetVoMap)) {
            for (String key : budgetVoMap.keySet()) {
                List<SubComActivityDesignBudgetVo> subComActivityDesignBudgetVos = budgetVoMap.get(key);
                if (CollectionUtils.isEmpty(subComActivityDesignBudgetVos)) continue;
                List mainBudgetItemCodes = subComActivityDesignBudgetVos.stream().filter(s -> !FeeSourceEnum.AUTO_FEE.getCode().equals(s.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetItemCode).distinct().collect(Collectors.toList());
                mainBudgetItemCodeSet.addAll(mainBudgetItemCodes);
            }
            List budgetItemMainItemVos = this.budgetItemMainItemService.listByMainBudgetItemCodeList((List)Lists.newArrayList(mainBudgetItemCodeSet));
            if (!CollectionUtils.isEmpty((Collection)budgetItemMainItemVos)) {
                budgetItemMainItemMap = budgetItemMainItemVos.stream().collect(Collectors.toMap(BudgetItemMainItemVo::getMainBudgetItemCode, Function.identity(), (v1, v2) -> v2));
            }
        }
        for (SubDetailExportVo datum : data) {
            List<SubComActivityDesignBudgetVo> budgetVos;
            SubComActivityDesignDetailExportVo exportVo = (SubComActivityDesignDetailExportVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)datum, SubComActivityDesignDetailExportVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            if (!Objects.isNull(datum.getActivityBeginTime())) {
                exportVo.setActivityBeginTimeStr(bartDateFormat.format(datum.getActivityBeginTime()));
            }
            if (!Objects.isNull(datum.getActivityEndTime())) {
                exportVo.setActivityEndTimeStr(bartDateFormat.format(datum.getActivityEndTime()));
            }
            if (!Objects.isNull(datum.getOrderEndDate())) {
                exportVo.setOrderEndDateStr(bartDateFormat.format(datum.getOrderEndDate()));
            }
            if (!Objects.isNull(datum.getOrderStartDate())) {
                exportVo.setOrderStartDateStr(bartDateFormat.format(datum.getOrderStartDate()));
            }
            if (!Objects.isNull(datum.getFeeYearMonth())) {
                exportVo.setFeeYearMonthStr(dateFormat.format(datum.getFeeYearMonth()));
            }
            if (!Objects.isNull(datum.getProductDate())) {
                exportVo.setProductDateStr(dateFormat.format(datum.getProductDate()));
            }
            if (!CollectionUtils.isEmpty(budgetVoMap) && !CollectionUtils.isEmpty(budgetVos = budgetVoMap.get(datum.getActivityDesignDetailCode()))) {
                for (SubComActivityDesignBudgetVo budget : budgetVos) {
                    if (RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(datum.getAssociationType()) && !CollectionUtils.isEmpty(budgetItemMainItemMap)) {
                        BudgetItemMainItemVo budgetItemMainItemVo;
                        if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budget.getFeeSourceCode()) && !Objects.isNull(budgetItemMainItemVo = (BudgetItemMainItemVo)budgetItemMainItemMap.get(budget.getBudgetItemCode()))) {
                            exportVo.setInPointBudgetItem(budget.getBudgetItemName());
                            exportVo.setInternalPointFee(budget.getBudgetAmount());
                        }
                        if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budget.getFeeSourceCode()) && !Objects.isNull(budgetItemMainItemVo = (BudgetItemMainItemVo)budgetItemMainItemMap.get(budget.getBudgetItemCode()))) {
                            exportVo.setOffPointBudgetItem(budget.getBudgetItemName());
                            exportVo.setOffPointFee(budget.getBudgetAmount());
                        }
                    } else {
                        if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budget.getFeeSourceCode())) {
                            exportVo.setInPointBudgetItem(budget.getBudgetItemName());
                            exportVo.setInternalPointFee(budget.getBudgetAmount());
                        }
                        if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budget.getFeeSourceCode())) {
                            exportVo.setOffPointBudgetItem(budget.getBudgetItemName());
                            exportVo.setOffPointFee(budget.getBudgetAmount());
                        }
                    }
                    if (!FeeSourceEnum.AUTO_FEE.getCode().equals(budget.getFeeSourceCode())) continue;
                    exportVo.setAutoBudgetItem(budget.getBudgetItemName());
                    exportVo.setAutoFee(budget.getBudgetAmount());
                }
            }
            arrayList.add(exportVo);
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{DISPLAY_TYPE, AUDIT_TYPE, ACCEPT_TYPE, IS_PRICE_RELATED_NO, IS_PATROL_OPERATIONS_NO, ACT_DETAIL_STATE, TPM_AUDIT_TYPE, isBigDateOrNo, whetherScheduleTimeNo}));
        for (SubComActivityDesignDetailExportVo vo : arrayList) {
            vo.setAuditType(this.findDictValue(mapDict, AUDIT_TYPE, vo.getAuditType()));
            vo.setUndertakingMode(this.findDictValue(mapDict, ACCEPT_TYPE, vo.getUndertakingMode()));
            vo.setIsPriceRelation(this.findDictValue(mapDict, IS_PRICE_RELATED_NO, vo.getIsPriceRelation()));
            vo.setIsPatrolOperations(this.findDictValue(mapDict, IS_PATROL_OPERATIONS_NO, vo.getIsPatrolOperations()));
            vo.setDisplayType(this.findDictValue(mapDict, DISPLAY_TYPE, vo.getDisplayType()));
            vo.setAssociationType(RelationTypeEnum.getDesc((String)vo.getAssociationType()));
            vo.setActivityDetailStatus(this.findDictValue(mapDict, ACT_DETAIL_STATE, vo.getActivityDetailStatus()));
            vo.setAuditCondition(this.findDictValue(mapDict, TPM_AUDIT_TYPE, vo.getAuditCondition()));
            vo.setWhetherScheduleTime(this.findDictValue(mapDict, whetherScheduleTimeNo, vo.getWhetherScheduleTime()));
            vo.setIsBigDate(this.findDictValue(mapDict, isBigDateOrNo, vo.getIsBigDate()));
        }
        return arrayList;
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictCode().equals(code)).map(DictDataVo::getDictValue).findFirst();
        return first.orElse("");
    }
}

