/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.helper;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanBudgetDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanRollbackBudgetEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanStatusEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignFeeDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.ActivityStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.SubComActivityDesignDetailAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SubComActivityDesignHelper {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignHelper.class);
    @Autowired(required=false)
    private SubComActivityDesignRepository subComActivityDesignRepository;
    @Autowired(required=false)
    private SubComActivityDesignDetailRepository subComActivityDesignDetailRepository;
    @Autowired(required=false)
    private SubComActivityDesignBudgetRepository subComActivityDesignBudgetRepository;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    public void buildByActivityNumberDetail(List<SubComActivityDesignDetailDto> detailDtos) {
        List<String> selectIds = detailDtos.stream().map(UuidDto::getId).collect(Collectors.toList());
        AtomicReference<String> activityNumber = new AtomicReference<String>("");
        selectIds.forEach(id -> {
            Assert.hasText((String)id, (String)"\u9009\u62e9\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
            SubComActivityDesignDetailVo designDetailVo = this.subComActivityDesignDetailRepository.findById((String)id);
            Assert.notNull((Object)designDetailVo, (String)"\u4e3a\u67e5\u8be2\u89c4\u5212\u660e\u7ec6\u6570\u636e\u4fe1\u606f");
            Assert.hasText((String)designDetailVo.getActivityNumber(), (String)"\u4fc3\u9500\u6d3b\u52a8\u53f7\u4e3a\u7a7a");
            if (((String)activityNumber.get()).equals(designDetailVo.getActivityNumber())) {
                return;
            }
            activityNumber.set(designDetailVo.getActivityNumber());
            Date now = DateUtil.getDate((SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd"));
            int startCompare = now.compareTo(designDetailVo.getActivityBeginTime());
            int endCompare = now.compareTo(designDetailVo.getActivityEndTime());
            if (startCompare < 0 && Objects.equals(designDetailVo.getAuditType(), SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode()) && TotalQuantityOrNotEnum.N.getCode().equals(designDetailVo.getIsSupplyAmount())) {
                List<SubComActivityDesignDetailVo> detailVos = this.subComActivityDesignDetailRepository.findByActivityNumber((String)activityNumber.get());
                detailVos.forEach(detailVo -> {
                    if (!selectIds.contains(detailVo.getId())) {
                        SubComActivityDesignDetailDto detailDto = new SubComActivityDesignDetailDto();
                        detailDto.setId(detailVo.getId());
                        detailDtos.add(detailDto);
                    }
                });
            }
        });
    }

    public void releaseAmount(SubComActivityDesignDetailVo designDetailVo, SubComActivityDesignFeeDetailEntity fee, boolean dealThings) {
        String activityDesignCode = designDetailVo.getActivityDesignCode();
        SubComActivityDesignVo designVo = this.subComActivityDesignRepository.findByActivityDesignCode(activityDesignCode);
        Assert.isTrue((boolean)ProcessStatusEnum.PASS.getDictCode().equals(designVo.getProcessStatus()), (String)"\u53ea\u80fd\u5173\u95ed\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e");
        String activityDesignDetailCode = designDetailVo.getActivityDesignDetailCode();
        List<SubComActivityDesignBudgetVo> designBudgetVos = this.subComActivityDesignBudgetRepository.findByActivityDesignDetailCode(activityDesignDetailCode);
        Assert.notEmpty(designBudgetVos, (String)("\u672a\u627e\u7684\u660e\u7ec6[" + activityDesignDetailCode + "]\u9884\u7b97\u9884\u6d4b\u6263\u51cf\u4fe1\u606f"));
        Date now = DateUtil.getDate((SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd"));
        int startCompare = now.compareTo(designDetailVo.getActivityBeginTime());
        int endCompare = now.compareTo(designDetailVo.getActivityEndTime());
        BigDecimal returnInternalAmount = designBudgetVos.stream().filter(item -> com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(item.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal returnOffAmount = designBudgetVos.stream().filter(item -> com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.OFF_POINT_FEE.getCode().equals(item.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal returnAutoAmount = designBudgetVos.stream().filter(item -> com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.AUTO_FEE.getCode().equals(item.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        AtomicReference<BigDecimal> returnOffAmountObj = new AtomicReference<BigDecimal>(returnOffAmount);
        AtomicReference<BigDecimal> returnInternalAmountObj = new AtomicReference<BigDecimal>(returnInternalAmount);
        AtomicReference<BigDecimal> returnAutoAmountObj = new AtomicReference<BigDecimal>(returnAutoAmount);
        AtomicReference<BigDecimal> returnAmountObj = new AtomicReference<BigDecimal>(designDetailVo.getReturnAmount());
        if (startCompare >= 0) {
            Validate.notNull((Object)designDetailVo.getReturnAmount(), (String)"\u91ca\u653e\u91d1\u989d\u5fc5\u586b\uff01", (Object[])new Object[0]);
            this.compareAmount(returnAutoAmountObj, returnAmountObj);
            this.compareAmount(returnInternalAmountObj, returnAmountObj);
            this.compareAmount(returnOffAmountObj, returnAmountObj);
        }
        returnOffAmount = returnOffAmountObj.get();
        returnInternalAmount = returnInternalAmountObj.get();
        returnAutoAmount = returnAutoAmountObj.get();
        BigDecimal refundAmount = returnAutoAmount.add(returnInternalAmount).add(returnOffAmount);
        ArrayList operationBudgetForecastList = Lists.newArrayList();
        ArrayList operatePlanBudgetList = Lists.newArrayList();
        ArrayList operateDetailPlanBudgetList = Lists.newArrayList();
        for (SubComActivityDesignBudgetVo designBudgetVo : designBudgetVos) {
            if (designBudgetVo.getBudgetAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal curOperationAmount = BigDecimal.ZERO;
            if (returnInternalAmount.compareTo(BigDecimal.ZERO) > 0 && com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(designBudgetVo.getFeeSourceCode())) {
                curOperationAmount = returnInternalAmount;
                if (curOperationAmount.compareTo(designBudgetVo.getBudgetAmount()) > 0) {
                    curOperationAmount = designBudgetVo.getBudgetAmount();
                }
                returnInternalAmount = returnInternalAmount.subtract(curOperationAmount);
            } else if (returnOffAmount.compareTo(BigDecimal.ZERO) > 0 && com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.OFF_POINT_FEE.getCode().equals(designBudgetVo.getFeeSourceCode())) {
                curOperationAmount = returnOffAmount;
                if (curOperationAmount.compareTo(designBudgetVo.getBudgetAmount()) > 0) {
                    curOperationAmount = designBudgetVo.getBudgetAmount();
                }
                returnOffAmount = returnOffAmount.subtract(curOperationAmount);
            } else if (returnAutoAmount.compareTo(BigDecimal.ZERO) > 0 && com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.AUTO_FEE.getCode().equals(designBudgetVo.getFeeSourceCode())) {
                curOperationAmount = returnAutoAmount;
                if (curOperationAmount.compareTo(designBudgetVo.getBudgetAmount()) > 0) {
                    curOperationAmount = designBudgetVo.getBudgetAmount();
                }
                returnAutoAmount = returnAutoAmount.subtract(curOperationAmount);
            }
            if (curOperationAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (null != fee) {
                fee.setReturnOffAmount(returnOffAmount);
                fee.setReturnInternalAmount(returnInternalAmount);
                fee.setReturnAutoAmount(returnAutoAmount);
            }
            SubComBudgetForecastDetailDto subComBudgetForecastDto = new SubComBudgetForecastDetailDto();
            subComBudgetForecastDto.setBudgetForecastCode(designBudgetVo.getBudgetForecastCode());
            subComBudgetForecastDto.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
            subComBudgetForecastDto.setUndertakingMode(designBudgetVo.getUndertakingMode());
            subComBudgetForecastDto.setBusinessCode(designBudgetVo.getActivityDesignDetailCode());
            subComBudgetForecastDto.setCurOperationAmount(curOperationAmount);
            operationBudgetForecastList.add(subComBudgetForecastDto);
            if (RelationTypeEnum.UP_RELATION_PLAN.getCode().equals(designBudgetVo.getAssociationType()) && !FeeSourceEnum.AUTO_FEE.getCode().equals(designBudgetVo.getFeeSourceCode())) {
                ActivityPlanBudgetDto activityPlanBudgetDto = new ActivityPlanBudgetDto();
                activityPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).subtract(curOperationAmount));
                activityPlanBudgetDto.setPlanItemCode(designBudgetVo.getPlanDetailCode());
                operatePlanBudgetList.add(activityPlanBudgetDto);
            }
            if (!RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(designBudgetVo.getAssociationType()) || FeeSourceEnum.AUTO_FEE.getCode().equals(designBudgetVo.getFeeSourceCode())) continue;
            ActivityDetailPlanBudgetDto activityDetailPlanBudgetDto = new ActivityDetailPlanBudgetDto();
            activityDetailPlanBudgetDto.setThisDownAmount(Optional.ofNullable(activityDetailPlanBudgetDto.getThisDownAmount()).orElse(BigDecimal.ZERO).subtract(curOperationAmount));
            activityDetailPlanBudgetDto.setDetailPlanItemCode(designBudgetVo.getPlanDetailCode());
            operateDetailPlanBudgetList.add(activityDetailPlanBudgetDto);
        }
        if (CollectionUtil.isNotEmpty((Collection)operationBudgetForecastList)) {
            this.subComBudgetForecastService.operationBudgetForecast((List)operationBudgetForecastList);
        }
        if (CollectionUtil.isNotEmpty((Collection)operatePlanBudgetList)) {
            operatePlanBudgetList.forEach(item -> item.setThisDownAmount(item.getThisDownAmount().negate()));
            this.activityPlanItemSdkService.operationBudget((List)operatePlanBudgetList);
        }
        if (CollectionUtil.isNotEmpty((Collection)operateDetailPlanBudgetList)) {
            operateDetailPlanBudgetList.forEach(item -> item.setThisDownAmount(item.getThisDownAmount().negate()));
            this.activityDetailPlanItemSdkService.operationBudget((List)operateDetailPlanBudgetList);
        }
        designDetailVo.setRefundAmount(refundAmount);
        designDetailVo.setReturnAmount(refundAmount);
        this.updateCloseStatus(designDetailVo, ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
    }

    public void updateCloseStatus(SubComActivityDesignDetailVo designDetailVo, String rollbackBudgetTag) {
        String activityStatus = ActivityPlanStatusEnum.closed.getCode();
        String activityItemStatus = "";
        BigDecimal refundAmount = designDetailVo.getRefundAmount();
        if (ActivityDetailPlanRollbackBudgetEnum.NO_ROLLBACK.getCode().equals(rollbackBudgetTag)) {
            refundAmount = designDetailVo.getWillRefundAmount();
        }
        activityItemStatus = refundAmount.compareTo(designDetailVo.getTotalCost()) < 0 ? ActivityStatusEnum.CLOSE_SOME_REBUDGET.getCode() : ActivityStatusEnum.CLOSE_FULL_REBUDGET.getCode();
        this.subComActivityDesignDetailRepository.close(designDetailVo.getActivityDesignDetailCode(), activityStatus, activityItemStatus, rollbackBudgetTag, designDetailVo.getRefundAmount());
    }

    private void compareAmount(AtomicReference<BigDecimal> amountObj, AtomicReference<BigDecimal> returnAmountObj) {
        BigDecimal returnAmount = returnAmountObj.get();
        BigDecimal amount = amountObj.get();
        if (returnAmount.compareTo(BigDecimal.ZERO) == 1) {
            if (amount.compareTo(returnAmount) == 1) {
                amount = returnAmount;
                returnAmount = BigDecimal.ZERO;
            } else {
                returnAmount = amount.compareTo(returnAmount) == -1 ? returnAmount.subtract(amount) : BigDecimal.ZERO;
            }
        } else {
            amount = BigDecimal.ZERO;
        }
        amountObj.set(amount);
        returnAmountObj.set(returnAmount);
    }
}

