/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.imports.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityPlanRelationTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.enums.SubComActivityValidationFormCodeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.SubRelatedMainActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.promotion.policy.sdk.service.PromotionPolicyService;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.imports.model.SubComActivityDesignDetailDisplayImportsVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal.SubComActivityDesignDetailPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.AcceptTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.AuditConditionEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsBigDateOrNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsInspectionEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsPriceRelatedNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.SubComActivityDesignDetailAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.UndertakingModeTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignPlanVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class SubComActivityDesignDetailDisplayImportsProcess
implements ImportProcess<SubComActivityDesignDetailDisplayImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignDetailDisplayImportsProcess.class);
    @Autowired(required=false)
    private SubComActivityDesignDetailPageCacheHelper subComActivityDesignDetailPageCacheHelper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignService comActivityDesignService;
    @Autowired(required=false)
    private ActivityTypeService activityTypeService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private PromotionPolicyService promotionPolicyService;
    private static final String ACCEPT_TYPE = "accept_type";
    private static final String TOTAL_QUANTITY_OR_NOT = "Total_quantity_or_not";
    private static final String YESORNO = "yesOrNo";
    private static final String ISTWENTYSTORE = "istwentystore";
    private static final String WRITE_OFF_CONDITION_XA = "write_off_condition_xa";
    private static final String ISBIGDATEORNO = "isBigDateOrNo";
    private static final String WHETHERSCHEDULETIMENO = "whetherScheduleTimeNo";
    private static final String ISPRICERELATEDNO = "isPriceRelatedNo";
    private static final String ISPATROLOPERATIONSNO = "isPatrolOperationsNo";
    private static final String AUDIT_TYPE = "audit_type";
    private static final String WHETHERFEEPOOLDEDUCTION = "whetherfeepooldeduction";
    private static final String TPM_CONTRACT_STORE_TYPE = "tpm_contract_store_type";
    private static final String DIS_TYPE = "dis_Type";
    private static final String SALES_PROMOTER_TYPE = "sales_promoter_type";
    private static final String IS_TYPE_OF_PURCHASE_NO = "isTypeOfPurchaseNo";
    private static final String MATERIAL_BASE_UNIT = "material_base_unit";
    private static final String CUSTOMER_SOURCE = "customer_source";
    private static final String tpm_pay_type = "tpm_pay_type";
    private static final String tpm_audit_form = "tpm_audit_form";

    public Integer getBatchCount() {
        return 2000;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, SubComActivityDesignDetailDisplayImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, SubComActivityDesignDetailDisplayImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            SubComActivityDesignDetailDisplayImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getDistributionChannelCode()), "\u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesInstitutionCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityFormCode()), "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComActivityDesignDetailDisplayImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            log.info("TPM-\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u5bfc\u5165-\u9648\u5217\u7c7b\u6d3b\u52a8\uff0c\u6267\u884c");
            Object cacheKey = params.get("cacheKey");
            Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3anull", (Object[])new Object[0]);
            if (CollectionUtil.isNotEmpty(data.values())) {
                Set yearMonthLySet = data.values().stream().map(SubComActivityDesignDetailDisplayImportsVo::getYearMonthLyStr).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(yearMonthLySet)) {
                    Validate.isTrue((yearMonthLySet.size() == 1 ? 1 : 0) != 0, (String)"\u540c\u4e00\u89c4\u5212\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u9700\u76f8\u540c", (Object[])new Object[0]);
                }
                ArrayList<Object> salesInstitutionCodes = new ArrayList<Object>();
                ArrayList<String> associatedDateCodes = new ArrayList<String>();
                HashSet<String> channelCodes = new HashSet<String>();
                HashSet<String> promotionCodes = new HashSet<String>();
                String businessFormatCode = BusinessFormatEnum.NORMAL.getCode();
                if (CollectionUtil.isNotEmpty(data.values())) {
                    data.forEach((k, v) -> v.setIndex((Integer)k));
                    for (SubComActivityDesignDetailDisplayImportsVo value : data.values()) {
                        String errInfo;
                        this.validateIsTrue(value.getSalesInstitutionCode().length() <= 4, "\u8bf7\u586b\u5199\u672a\u62fc\u63a5\u540e\u9500\u552e\u673a\u6784\u7f16\u7801\uff01");
                        channelCodes.add(value.getDistributionChannelCode());
                        String insCode = value.getDistributionChannelCode() + businessFormatCode + value.getSalesInstitutionCode();
                        salesInstitutionCodes.add(insCode);
                        if (StringUtils.isNotBlank((CharSequence)value.getSalesOrgCode())) {
                            String regionCode = (String)insCode + value.getSalesOrgCode();
                            salesInstitutionCodes.add(regionCode);
                            if (StringUtils.isNotBlank((CharSequence)value.getSalesGroupCode())) {
                                String salesOrgCode = regionCode + value.getSalesGroupCode();
                                salesInstitutionCodes.add(salesOrgCode);
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)value.getAssociatedDateCode())) {
                            associatedDateCodes.add(value.getAssociatedDateCode());
                        }
                        if (StringUtils.isNotBlank((CharSequence)value.getPromotionCode()) && BooleanEnum.TRUE.getSure().equals(value.getIsAssPromotion())) {
                            promotionCodes.add(value.getPromotionCode());
                        }
                        if ((errInfo = this.validateGetErrorInfo()) == null) continue;
                        errMap.put(value.getIndex(), errInfo);
                    }
                }
                if (CollectionUtil.isNotEmpty(promotionCodes)) {
                    List policyVoList = this.promotionPolicyService.findPolicyByPromotionCodes((List)Lists.newArrayList(promotionCodes));
                    Validate.notEmpty((Collection)policyVoList, (String)"\u672a\u67e5\u8be2\u5230\u4fc3\u9500\u653f\u7b56\u4fe1\u606f,\u5173\u8054\u7684\u4fc3\u9500\u653f\u7b56\u53ef\u80fd\u5173\u8054\u88ab\u7981\u7528\u6216\u5220\u9664\u4e86,\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
                    Map policyVoMap = policyVoList.stream().collect(Collectors.toMap(PromotionPolicyVO::getPromotionCode, Function.identity()));
                    for (String code : promotionCodes) {
                        PromotionPolicyVO policyVo = (PromotionPolicyVO)policyVoMap.get(code);
                        Validate.notNull((Object)policyVo, (String)("\u672a\u67e5\u8be2\u5230\u8981\u5173\u8054\u7684\u4fc3\u9500\u653f\u7b56\u3010" + code + "\u3011\u4fe1\u606f,\u53ef\u80fd\u88ab\u7981\u7528\u6216\u5220\u9664\u4e86,\u8bf7\u68c0\u67e5"), (Object[])new Object[0]);
                    }
                }
                List channelVos = this.customerChannelVoService.findByCodes(new ArrayList(channelCodes));
                Map<Object, Object> channelMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty((Collection)channelVos)) {
                    channelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, CustomerChannelVo::getCustomerChannelName, (v1, v2) -> v2));
                }
                List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(salesInstitutionCodes);
                Map<String, SalesOrgVo> salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (v1, v2) -> v2));
                HashMap<String, ActivityDetailPlanItemVo> detailPlanItemVoMap = new HashMap();
                if (!CollectionUtil.isEmpty(associatedDateCodes)) {
                    List detailPlanItemVos = this.activityDetailPlanItemSdkService.findByItemCodes(associatedDateCodes);
                    Validate.notEmpty((Collection)detailPlanItemVos, (String)"\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u7ec6\u6848", (Object[])new Object[0]);
                    detailPlanItemVoMap = detailPlanItemVos.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
                }
                ArrayList<SubComActivityDesignDetailDto> designDetailDtos = new ArrayList<SubComActivityDesignDetailDto>(data.values().size());
                Map<Object, Object> finalChannelMap = channelMap;
                for (SubComActivityDesignDetailDisplayImportsVo detail : data.values()) {
                    SubComActivityDesignDetailDto subComActivityDesignDetailDto = this.conversion(detail, salesOrgVoMap, finalChannelMap);
                    this.validateDetailData(subComActivityDesignDetailDto, detailPlanItemVoMap);
                    designDetailDtos.add(subComActivityDesignDetailDto);
                    String errInfo = this.validateGetErrorInfo();
                    if (errInfo == null) continue;
                    if (errMap.containsKey(detail.getIndex())) {
                        errMap.put(detail.getIndex(), (String)errMap.get(detail.getIndex()) + "," + errInfo);
                        continue;
                    }
                    errMap.put(detail.getIndex(), errInfo);
                }
                this.validateIsSupplyAmountY(designDetailDtos);
                if (errMap.isEmpty()) {
                    this.subComActivityDesignDetailPageCacheHelper.importNewItem(cacheKey.toString(), designDetailDtos);
                }
            }
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u5206\u5b50\u516c\u53f8\u89c4\u5212\u660e\u7ec6\u5f02\u5e38,{}", (Throwable)e);
            if (StrUtil.isEmpty((CharSequence)e.getMessage())) {
                throw new IllegalArgumentException("\u7a7a\u6307\u9488\u5f02\u5e38", e);
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        return errMap;
    }

    private void validateIsSupplyAmountY(List<SubComActivityDesignDetailDto> designDetailDtos) {
        if (CollectionUtils.isEmpty(designDetailDtos)) {
            return;
        }
        List itemYList = designDetailDtos.stream().filter(k -> TotalQuantityOrNotEnum.Y.getCode().equals(k.getIsSupplyAmount())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(itemYList)) {
            return;
        }
        Map<String, List<SubComActivityDesignDetailDto>> detailMap = itemYList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailDto::getActivityNumber));
        for (String key : detailMap.keySet()) {
            List<SubComActivityDesignDetailDto> dtoList = detailMap.get(key);
            if (CollectionUtils.isEmpty(dtoList) || dtoList.size() <= 1) continue;
            dtoList.forEach(d -> Validate.isTrue((TotalQuantityOrNotEnum.Y.getCode().equals(d.getIsSupplyAmount()) || TotalQuantityOrNotEnum.Z.getCode().equals(d.getIsSupplyAmount()) ? 1 : 0) != 0, (String)"\u4fbf\u7b7e\u53f7\u76f8\u540c\u65f6\uff0c\u5171\u7528\u91cf\u53ea\u80fd\u4e3aY|Z", (Object[])new Object[0]));
            Set collect = dtoList.stream().map(SubComActivityDesignDetailDto::getIsSupplyAmount).filter(Objects::nonNull).collect(Collectors.toSet());
            Validate.isTrue((collect.size() == 1 ? 1 : 0) != 0, (String)"\u4fbf\u7b7e\u53f7\u76f8\u540c\u65f6\uff0c\u5171\u7528\u91cf\u4e5f\u5e94\u76f8\u540c!", (Object[])new Object[0]);
            if (!collect.contains(TotalQuantityOrNotEnum.Y.getCode()) || dtoList.size() <= 1) continue;
            Set vaStrSet = dtoList.stream().map(i -> i.getActivityFormCode() + DateUtil.format((Date)i.getActivityBeginTime(), (String)"yyyyMMdd") + DateUtil.format((Date)i.getActivityEndTime(), (String)"yyyyMMdd")).collect(Collectors.toSet());
            Validate.isTrue((vaStrSet.size() == 1 ? 1 : 0) != 0, (String)"'Y'\u7c7b\u578b\u5171\u7528\u91cf\u4e14\u4fbf\u7b7e\u53f7\u76f8\u540c\u7684\u6d3b\u52a8\uff0c\u6d3b\u52a8\u5f62\u5f0f\u3001\u6d3b\u52a8\u5f00\u59cb\u548c\u7ed3\u675f\u65f6\u95f4\uff0c\u987b\u76f8\u540c\uff0c\u8bf7\u6ce8\u610f\u3002", (Object[])new Object[0]);
        }
    }

    public Class<SubComActivityDesignDetailDisplayImportsVo> findCrmExcelVoClass() {
        return SubComActivityDesignDetailDisplayImportsVo.class;
    }

    public String getBusinessCode() {
        return "TPM_SUB_COM_ACTIVITY_DESIGN_DETAIL_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u5bfc\u5165";
    }

    public String getTemplateCode() {
        return "TPM_SUB_COM_ACTIVITY_DESIGN_DETAIL_DISPLAY_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u5bfc\u5165-\u9648\u5217\u7c7b\u6d3b\u52a8";
    }

    public SubComActivityDesignDetailDto conversion(SubComActivityDesignDetailDisplayImportsVo importsVo, Map<String, SalesOrgVo> salesOrgVoMap, Map<String, String> channelMap) {
        if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)((Object)importsVo))) {
            return null;
        }
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getPromoterPriceStr(), (String)"\u4fc3\u9500\u4fc3\u9500\u5458\u5de5\u8d44\u6807\u51c6", (boolean)false, importsVo::setPromoterPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getDisplayPriceStr(), (String)"\u9648\u5217\u5355\u4ef7", (boolean)false, importsVo::setDisplayPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getDisplayNumberStr(), (String)"\u9648\u5217\u6570\u91cf", (boolean)false, importsVo::setDisplayNumber, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getPromoteNumberStr(), (String)"\u63a8\u5e7f\u573a\u6b21", (boolean)false, importsVo::setPromoteNumber, Integer.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getSingleEstimatedCostStr(), (String)"\u5355\u573a\u9884\u4f30\u8d39\u7528", (boolean)false, importsVo::setSingleEstimatedCost, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getPersonNumberStr(), (String)"\u4eba\u5458\u6570\u91cf", (boolean)false, importsVo::setPersonNumber, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getTotalCostStr(), (String)"\u8d39\u7528\u5408\u8ba1", (boolean)false, importsVo::setTotalCost, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getPromoteSalesStr(), (String)"\u671f\u95f4\u4fc3\u9500\u91cf", (boolean)false, importsVo::setPromoteSales, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getPromotionAmountStr(), (String)"\u671f\u95f4\u4fc3\u9500\u989d\uff08\u5143\uff09", (boolean)false, importsVo::setPromotionAmount, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getStrengthStr(), (String)"\u529b\u5ea6", (boolean)false, importsVo::setStrength, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getTallyStr(), (String)"\u70b9\u6570", (boolean)false, importsVo::setTally, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getLevelTopStr(), (String)"\u574e\u7ea7\u4e0b\u9650", (boolean)false, importsVo::setLevelTop, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getLevelBottomStr(), (String)"\u574e\u7ea7\u4e0b\u9650", (boolean)false, importsVo::setLevelBottom, BigDecimal.class);
        SubComActivityDesignDetailDto detailDto = (SubComActivityDesignDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)importsVo, SubComActivityDesignDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        if (StrUtil.isNotBlank((CharSequence)importsVo.getActivityTypeCode())) {
            List serviceByCodes = this.activityTypeService.findByCodes((List)Lists.newArrayList((Object[])new String[]{importsVo.getActivityTypeCode()}));
            if (CollectionUtils.isEmpty((Collection)serviceByCodes)) {
                this.validateIsTrue(false, "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u9519\u8bef\uff01\uff01\uff01,\u7f16\u7801\uff1a" + importsVo.getActivityTypeCode());
            } else {
                detailDto.setActivityTypeName(((ActivityTypeVo)serviceByCodes.get(0)).getActivityTypeName());
            }
        }
        if (StrUtil.isNotBlank((CharSequence)importsVo.getBudgetItemCode())) {
            BudgetItemVo budgetItem = null;
            try {
                budgetItem = this.budgetItemService.findByCode(importsVo.getBudgetItemCode(), EnableStatusEnum.ENABLE.getCode());
                this.validateIsTrue(budgetItem != null, "\u9884\u7b97\u9879\u76ee\u7f16\u7801\u9519\u8bef\uff01\uff01\uff01,\u7f16\u7801\uff1a" + importsVo.getBudgetItemCode());
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u9884\u7b97\u9879\u76ee\u7f16\u7801\u9519\u8bef\uff01\uff01\uff01,\u7f16\u7801\uff1a" + importsVo.getBudgetItemCode());
            }
        }
        detailDto.setActivityTypeCode(importsVo.getActivityTypeCode());
        detailDto.setActivityFormName(importsVo.getActivityFormName());
        DateStringDealUtil.validateDateStrAndSet((String)importsVo.getYearMonthLyStr(), (String)"\u8d39\u7528\u6240\u5c5e\u5e74\u6708", (String)"yyyy-MM", arg_0 -> ((SubComActivityDesignDetailDto)detailDto).setFeeYearMonth(arg_0));
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getActivityBeginDateStr())) {
            if (DateTimeValidateUtil.validateDate((String)importsVo.getActivityBeginDateStr()).booleanValue()) {
                DateStringDealUtil.validateDateStrAndSet((String)importsVo.getActivityBeginDateStr(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailDto)detailDto).setActivityBeginTime(arg_0));
            } else {
                this.validateIsTrue(false, "\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\uff1a'yyyy-MM-dd'");
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getActivityEndDateStr())) {
            if (DateTimeValidateUtil.validateDate((String)importsVo.getActivityEndDateStr()).booleanValue()) {
                DateStringDealUtil.validateDateStrAndSet((String)importsVo.getActivityEndDateStr(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailDto)detailDto).setActivityEndTime(arg_0));
            } else {
                this.validateIsTrue(false, "\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\uff1a'yyyy-MM-dd'");
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getOrderEndDateStr())) {
            if (DateTimeValidateUtil.validateDate((String)importsVo.getOrderEndDateStr()).booleanValue()) {
                DateStringDealUtil.validateDateStrAndSet((String)importsVo.getOrderEndDateStr(), (String)"\u8ba2\u5355\u7ed3\u675f\u65e5\u671f", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailDto)detailDto).setOrderEndDate(arg_0));
            } else {
                this.validateIsTrue(false, "\u8ba2\u5355\u7ed3\u675f\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\uff1a'yyyy-MM-dd'");
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getOrderStartDateStr())) {
            if (DateTimeValidateUtil.validateDate((String)importsVo.getOrderStartDateStr()).booleanValue()) {
                DateStringDealUtil.validateDateStrAndSet((String)importsVo.getOrderStartDateStr(), (String)"\u8ba2\u5355\u5f00\u59cb\u65e5\u671f", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailDto)detailDto).setOrderStartDate(arg_0));
            } else {
                this.validateIsTrue(false, "\u8ba2\u5355\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\uff1a'yyyy-MM-dd'");
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getScheduleTimeStr())) {
            String[] times = importsVo.getScheduleTimeStr().split("\u81f3");
            if (DateTimeValidateUtil.validateDate((String)times[0]).booleanValue() && DateTimeValidateUtil.validateDate((String)times[1]).booleanValue()) {
                DateStringDealUtil.validateDateStrAndSet((String)times[0], (String)"\u6863\u671f\u65f6\u95f4", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailDto)detailDto).setScheduleStartTime(arg_0));
                DateStringDealUtil.validateDateStrAndSet((String)times[1], (String)"\u6863\u671f\u65f6\u95f4", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailDto)detailDto).setScheduleEndTime(arg_0));
            } else {
                this.validateIsTrue(false, "\u6863\u671f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\uff1a'yyyy-MM-dd\u81f3yyyy-MM-dd'");
            }
        }
        detailDto.setTotalCost(Optional.ofNullable(importsVo.getTotalCost()).orElse(BigDecimal.ZERO));
        if (BigDecimal.ZERO.compareTo(detailDto.getTotalCost()) > 0) {
            throw new IllegalArgumentException("\u8d39\u7528\u5408\u8ba1\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getAssociatedDateCode()) && (ActivityPlanRelationTypeEnum.up.getName().equals(importsVo.getRelationTypeCode()) || ActivityPlanRelationTypeEnum.region.getName().equals(importsVo.getRelationTypeCode()))) {
            String[] associatedDateCodes;
            ArrayList<SubComActivityDesignPlanDto> subComActivityDesignPlanDtos = new ArrayList<SubComActivityDesignPlanDto>();
            for (String code : associatedDateCodes = importsVo.getAssociatedDateCode().trim().split(",")) {
                SubComActivityDesignPlanDto subComActivityDesignPlanDto = new SubComActivityDesignPlanDto();
                if (ActivityPlanRelationTypeEnum.region.getName().equals(importsVo.getRelationTypeCode())) {
                    subComActivityDesignPlanDto.setAssociationType(ActivityPlanRelationTypeEnum.region.getCode());
                    detailDto.setAssociationType(ActivityPlanRelationTypeEnum.region.getCode());
                } else if (ActivityPlanRelationTypeEnum.up.getName().equals(importsVo.getRelationTypeCode())) {
                    subComActivityDesignPlanDto.setAssociationType(ActivityPlanRelationTypeEnum.up.getCode());
                    detailDto.setAssociationType(ActivityPlanRelationTypeEnum.up.getCode());
                }
                subComActivityDesignPlanDto.setPlanDetailCode(code);
                Page relationPlanListPage = this.comActivityDesignService.findCanRelationPlanListPage((Pageable)PageRequest.of((int)1, (int)50), subComActivityDesignPlanDto);
                if (CollectionUtils.isEmpty((Collection)relationPlanListPage.getRecords())) {
                    this.validateIsTrue(false, "\u67e5\u8be2\u4e0d\u5230\u5173\u8054\u7ec6\u6848/\u65b9\u6848");
                    continue;
                }
                SubComActivityDesignPlanVo subComActivityDesignPlanVo = (SubComActivityDesignPlanVo)relationPlanListPage.getRecords().get(0);
                subComActivityDesignPlanDto.setPlanCode(subComActivityDesignPlanVo.getPlanCode());
                subComActivityDesignPlanDto.setPlanName(subComActivityDesignPlanVo.getPlanName());
                subComActivityDesignPlanDto.setPlanDetailCode(subComActivityDesignPlanVo.getPlanDetailCode());
                subComActivityDesignPlanDtos.add(subComActivityDesignPlanDto);
            }
            detailDto.setPlanList(subComActivityDesignPlanDtos);
        } else {
            detailDto.setAssociationType(ActivityPlanRelationTypeEnum.non.getCode());
        }
        if (RelationTypeEnum.UP_SUB_PLAN.getDes().equals(importsVo.getRelationTypeCode())) {
            detailDto.setAssociationType(RelationTypeEnum.UP_SUB_PLAN.getCode());
            detailDto.setUndertakingMode(UndertakingModeTypeEnum.NO_ACCEPT.getCode());
        }
        if (StrUtil.isNotEmpty((CharSequence)detailDto.getActivityFormCode())) {
            ActivityFormVo activityFormVo = this.activityFormService.findOneByCode(detailDto.getActivityFormCode());
            if (activityFormVo == null) {
                this.validateIsTrue(false, "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u5f62\u5f0f" + detailDto.getActivityFormCode() + ",\u8bf7\u68c0\u67e5\u7f16\u7801\u662f\u5426\u6b63\u786e");
            } else {
                String projectTemplate = activityFormVo.getThinProjectTemplate();
                detailDto.setTemplateConfigCode(projectTemplate);
            }
            if (StrUtil.isEmpty((CharSequence)detailDto.getIsPriceRelation()) && activityFormVo.getIsRelatePrice() != null) {
                if (activityFormVo.getIsRelatePrice().booleanValue()) {
                    detailDto.setIsPriceRelation(IsPriceRelatedNoEnum.isPriceRelated.getCode());
                } else {
                    detailDto.setIsPriceRelation(IsPriceRelatedNoEnum.noPriceRelated.getCode());
                }
            }
            if (StrUtil.isEmpty((CharSequence)detailDto.getIsPatrolOperations()) && activityFormVo.getIsPushPatrolSystem() != null) {
                if (activityFormVo.getIsPushPatrolSystem().booleanValue()) {
                    detailDto.setIsPriceRelation(IsInspectionEnum.isInspection.getCode());
                } else {
                    detailDto.setIsPriceRelation(IsInspectionEnum.noInspection.getCode());
                }
            }
            if (Objects.equals(AuditConditionEnum.zdhx.getDes(), importsVo.getAuditCondition())) {
                detailDto.setAuditConditionCode(activityFormVo.getAuditCondition());
            }
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{ACCEPT_TYPE, TOTAL_QUANTITY_OR_NOT, YESORNO, ISTWENTYSTORE, WRITE_OFF_CONDITION_XA, ISBIGDATEORNO, WHETHERSCHEDULETIMENO, ISPRICERELATEDNO, ISPATROLOPERATIONSNO, AUDIT_TYPE, WHETHERFEEPOOLDEDUCTION, TPM_CONTRACT_STORE_TYPE, DIS_TYPE, SALES_PROMOTER_TYPE, IS_TYPE_OF_PURCHASE_NO, MATERIAL_BASE_UNIT, CUSTOMER_SOURCE, tpm_pay_type, tpm_audit_form}));
        detailDto.setUndertakingMode(this.findDictValue(mapDict, ACCEPT_TYPE, importsVo.getUndertakingMode()));
        detailDto.setIsSupplyAmount(this.findDictValue(mapDict, TOTAL_QUANTITY_OR_NOT, importsVo.getIsSupplyAmount()));
        detailDto.setIsAssPromotion(this.findDictValue(mapDict, YESORNO, importsVo.getIsAssPromotion()));
        detailDto.setIsPriceRelation(this.findDictValue(mapDict, ISPRICERELATEDNO, importsVo.getIsPriceRelation()));
        detailDto.setIsPatrolOperations(this.findDictValue(mapDict, ISPATROLOPERATIONSNO, importsVo.getIsPatrolOperations()));
        detailDto.setWhetherScheduleTime(this.findDictValue(mapDict, WHETHERSCHEDULETIMENO, importsVo.getWhetherScheduleTime()));
        detailDto.setAuditType(this.findDictValue(mapDict, AUDIT_TYPE, importsVo.getAuditMode()));
        detailDto.setStoreTypePromotion(this.findDictValue(mapDict, TPM_CONTRACT_STORE_TYPE, importsVo.getTerminalType()));
        detailDto.setDisplayType(this.findDictValue(mapDict, DIS_TYPE, importsVo.getDisplayType()));
        detailDto.setPromoterType(this.findDictValue(mapDict, SALES_PROMOTER_TYPE, importsVo.getPersonType()));
        detailDto.setProcurementType(this.findDictValue(mapDict, IS_TYPE_OF_PURCHASE_NO, importsVo.getProcurementType()));
        detailDto.setPaymentMethod(this.findDictValue(mapDict, tpm_pay_type, importsVo.getPaymentMethod()));
        if (StringUtils.isNotEmpty((CharSequence)importsVo.getAuditForm())) {
            String[] auditFormArr = importsVo.getAuditForm().split(",");
            ArrayList auditFormCodeList = Lists.newArrayList();
            for (String auditFormName : auditFormArr) {
                auditFormCodeList.add(this.findDictValue(mapDict, tpm_audit_form, auditFormName));
            }
            detailDto.setAuditForm(String.join((CharSequence)",", auditFormCodeList));
        }
        detailDto.setAuditCondition(AuditConditionEnum.findByDes((String)importsVo.getAuditCondition()));
        if (channelMap.containsKey(importsVo.getDistributionChannelCode())) {
            detailDto.setDistributionChannelCode(importsVo.getDistributionChannelCode());
            detailDto.setDistributionChannelName(channelMap.get(importsVo.getDistributionChannelCode()));
        } else {
            this.validateIsTrue(false, "\u5206\u9500\u6e20\u9053" + importsVo.getDistributionChannelCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String insCode = detailDto.getDistributionChannelCode() + BusinessFormatEnum.NORMAL.getCode() + importsVo.getSalesInstitutionCode();
        SalesOrgVo insVo = salesOrgVoMap.get(insCode);
        if (Objects.isNull(insVo)) {
            this.validateIsTrue(false, "\u9500\u552e\u673a\u6784" + importsVo.getSalesInstitutionCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        } else {
            detailDto.setSalesInstitutionName(insVo.getSalesOrgName());
            detailDto.setSalesInstitutionErpCode(insVo.getErpCode());
            detailDto.setSalesInstitutionCode(insCode);
        }
        if (StringUtils.isNotBlank((CharSequence)importsVo.getSalesOrgCode())) {
            String regionCode = insCode + importsVo.getSalesOrgCode();
            SalesOrgVo regVo = salesOrgVoMap.get(regionCode);
            if (Objects.isNull(regVo)) {
                this.validateIsTrue(false, "\u9500\u552e\u90e8\u95e8" + importsVo.getSalesOrgCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                detailDto.setSalesOrgName(regVo.getSalesOrgName());
                detailDto.setSalesOrgErpCode(regVo.getErpCode());
                detailDto.setSalesOrgCode(regionCode);
                if (StringUtils.isNotBlank((CharSequence)importsVo.getSalesGroupCode())) {
                    String salesOrgCode = regionCode + importsVo.getSalesGroupCode();
                    SalesOrgVo salesOrgVo = salesOrgVoMap.get(salesOrgCode);
                    if (Objects.isNull(salesOrgVo)) {
                        this.validateIsTrue(false, "\u9500\u552e\u7ec4" + importsVo.getSalesGroupCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    detailDto.setSalesGroupName(regVo.getSalesOrgName());
                    detailDto.setSalesGroupErpCode(regVo.getErpCode());
                    detailDto.setSalesGroupCode(salesOrgCode);
                }
            }
        }
        if (IsBigDateOrNoEnum.isbigdate.getCode().equals(detailDto.getIsBigDate())) {
            detailDto.setActivityTypeCode("Z0038");
            detailDto.setActivityTypeName("\u65e7\u8d27\u5904\u7406-\u5206\u5b50");
        }
        return detailDto;
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictValue().equals(code)).map(DictDataVo::getDictCode).findFirst();
        return first.orElse("");
    }

    private void validateDetailData(SubComActivityDesignDetailDto detail, Map<String, ActivityDetailPlanItemVo> detailPlanItemVoMap) {
        if (ObjectUtils.isEmpty((Object)detail)) {
            return;
        }
        String formCode = detail.getActivityFormCode();
        if (SubComActivityValidationFormCodeEnum.ZS01.name().equals(formCode)) {
            this.validateIsTrue(TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u662f\u5426\u516c\u7528\u91cf\u53ea\u80fd\u4e3a'N'");
            this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.AFTER_THE_EVENT.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u540e\u2018");
            this.validateIsTrue(detail.getPromoteSales() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u671f\u95f4\u4fc3\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(detail.getPromotionAmount() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u671f\u95f4\u4fc3\u9500\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if (!BooleanEnum.TRUE.getCapital().equals(detail.getIsAssPromotion())) {
                this.validateIsTrue(detail.getOriginalProductNumber() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u539f\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getGiftProductCode()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getGiftProductName()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(detail.getGiftProductPrice() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.validateIsTrue(Objects.isNull(detail.getActivityPrice()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u6d3b\u52a8\u4ef7\u4e0d\u80fd\u586b\uff01");
        } else if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(formCode)) {
            this.validateIsTrue(detail.getPromoteSales() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u671f\u95f4\u4fc3\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(detail.getPromotionAmount() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u671f\u95f4\u4fc3\u9500\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if (!BooleanEnum.TRUE.getCapital().equals(detail.getIsAssPromotion())) {
                this.validateIsTrue(detail.getOriginalProductNumber() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u539f\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getGiftProductCode()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getGiftProductName()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(detail.getGiftProductPrice() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getActivityPrice()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u4e0d\u53ef\u586b\u5199\u6d3b\u52a8\u4ef7\uff01");
            this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u4e2d\u2018");
            if (BooleanEnum.TRUE.getCapital().equals(detail.getIsAssPromotion())) {
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getPromotionCode()), "\u5173\u8054\u4fc3\u9500\u653f\u7b56\uff0c\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(!TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), "\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u5171\u7528\u91cf\u4e0d\u53ef\u4e3aN\u7c7b\u578b");
            }
        } else if (SubComActivityValidationFormCodeEnum.ZS03.name().equals(formCode)) {
            this.validateIsTrue(Objects.isNull(detail.getOriginalProductNumber()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u539f\u54c1\u6570\u91cf\uff01");
            this.validateIsTrue(StringUtils.isBlank((CharSequence)detail.getGiftProductCode()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u8d60\u54c1\u7f16\u7801\uff01");
            this.validateIsTrue(StringUtils.isBlank((CharSequence)detail.getGiftProductName()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u8d60\u54c1\u540d\u79f0\uff01");
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getGiftProductPrice()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u8d60\u54c1\u5355\u4ef7\uff01");
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getGiftProductNumber()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u8d60\u54c1\u6570\u91cf\uff01");
            if (TotalQuantityOrNotEnum.Z.getCode().equals(detail.getIsSupplyAmount())) {
                this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\uff0c\u2018Z\u2019\u516c\u7528\u91cf\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u4e2d\u2018");
            }
            if (BooleanEnum.TRUE.getCapital().equals(detail.getIsAssPromotion())) {
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getPromotionCode()), "\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(!TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), "\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u5171\u7528\u91cf\u4e0d\u53ef\u4e3aN\u7c7b\u578b");
            } else {
                this.validateIsTrue(detail.getPromoteSales() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u671f\u95f4\u4fc3\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(detail.getPromotionAmount() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u671f\u95f4\u4fc3\u9500\u989d\uff08\u5143\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else if (SubComActivityValidationFormCodeEnum.ZS11.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS12.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS13.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS14.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS15.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS16.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS30.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS42.name().equals(formCode)) {
            this.validateIsTrue(BooleanEnum.FALSE.getCapital().equals(detail.getIsAssPromotion()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u53ef\u5173\u8054\u4fc3\u9500\u653f\u7b56\uff01");
            this.validateIsTrue(TotalQuantityOrNotEnum.Y.getCode().equals(detail.getIsSupplyAmount()) || TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u5171\u7528\u91cf\u53ea\u80fd\u4e3aY/N");
            if (SubComActivityValidationFormCodeEnum.ZS42.name().equals(formCode)) {
                this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u4e2d\u2018");
            } else if (TotalQuantityOrNotEnum.Y.getCode().equals(detail.getIsSupplyAmount())) {
                this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u2018Y\u2019\u516c\u7528\u91cf\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u4e2d\u2018");
            }
        } else if (SubComActivityValidationFormCodeEnum.contains((String)formCode)) {
            this.validateIsTrue(BooleanEnum.FALSE.getCapital().equals(detail.getIsAssPromotion()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u53ef\u5173\u8054\u4fc3\u9500\u653f\u7b56\uff01");
            this.validateIsTrue(TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u662f\u5426\u516c\u7528\u91cf\u53ea\u80fd\u4e3a'N'");
            this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.AFTER_THE_EVENT.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u540e\u2018");
        }
        if (SubComActivityValidationFormCodeEnum.ZS42.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS11.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS30.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS15.name().equals(formCode)) {
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getPromoteSales()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u53ef\u586b\u5199\u671f\u95f4\u4fc3\u9500\u91cf\uff01");
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getPromotionAmount()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u53ef\u586b\u5199\u95f4\u4fc3\u9500\u989d\uff08\u5143\uff09\uff01");
        }
        if (!StringUtils.isBlank((CharSequence)detail.getAssociatedDateCode()) && !RelationTypeEnum.UP_SUB_PLAN.getCode().equals(detail.getAssociationType())) {
            ActivityDetailPlanItemVo detailPlanItemVo = detailPlanItemVoMap.get(detail.getAssociatedDateCode());
            this.validateIsTrue(detailPlanItemVo != null, "\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u7ec6\u6848[" + detail.getAssociatedDateCode() + "]!");
            ArrayList<String> formCodes = new ArrayList<String>();
            formCodes.add(detailPlanItemVo.getActivityFormCode());
            List subRelatedMainActivityFormList = this.activityFormService.findSubRelatedMainByCodes(formCodes);
            Validate.notEmpty((Collection)subRelatedMainActivityFormList, (String)("\u6d3b\u52a8\u7ec6\u6848[" + detail.getAssociatedDateCode() + "]\u7684\u6d3b\u52a8\u5f62\u5f0f[" + detailPlanItemVo.getActivityFormCode() + "],\u672a\u5173\u8054\u5206\u5b50\u6d3b\u52a8\u5f62\u5f0f\uff01"), (Object[])new Object[0]);
            SubRelatedMainActivityFormVo mainForm = subRelatedMainActivityFormList.stream().filter(k -> k.getMainFormCode().equals(detailPlanItemVo.getActivityFormCode())).findFirst().orElse(null);
            this.validateIsTrue(mainForm != null, "\u6d3b\u52a8\u5f62\u5f0f\u672a\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detail.getAssociatedDateCode() + "]\u7684\u6d3b\u52a8\u5f62\u5f0f");
            if (AcceptTypeEnum.FULL_ACCEPT.getCode().equals(detail.getUndertakingMode())) {
                String begeinTime = DateUtil.format((Date)detail.getActivityBeginTime(), (String)"yyyy-MM-dd");
                String endTime = DateUtil.format((Date)detail.getActivityEndTime(), (String)"yyyy-MM-dd");
                String begeinDate = DateUtil.format((Date)detailPlanItemVo.getActivityBeginDate(), (String)"yyyy-MM-dd");
                String endDate = DateUtil.format((Date)detailPlanItemVo.getActivityEndDate(), (String)"yyyy-MM-dd");
                this.validateIsTrue(begeinTime.equals(begeinDate), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detail.getAssociatedDateCode() + "]");
                this.validateIsTrue(endTime.equals(endDate), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detail.getAssociatedDateCode() + "]");
            }
        }
    }

    private void validateCommonColumn(SubComActivityDesignDetailDto detail) {
        Validate.notBlank((CharSequence)detail.getIsSupplyAmount(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u662f\u5426\u5171\u7528\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getActivityNumber(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u6d3b\u52a8\u4fbf\u7b7e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getActivityTypeCode(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getActivityFormName(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u6d3b\u52a8\u5f62\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getAuditType(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u6838\u9500\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getCustomerCode(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String[] customerCodes = detail.getCustomerCode().split(",");
        for (int i = 0; i < customerCodes.length; ++i) {
            Validate.isTrue((customerCodes[i].length() == 10 ? 1 : 0) != 0, (String)"\u8bf7\u586b\u5199\u672a\u62fc\u63a5\u7684\u5ba2\u6237\u7f16\u7801\uff01", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)detail.getSalesInstitutionCode(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getDistributionChannelCode(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)detail.getActivityBeginTime(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)detail.getActivityEndTime(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)detail.getOrderStartDate(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u8ba2\u5355\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)detail.getOrderEndDate(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u8ba2\u5355\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getProductBrandName(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u54c1\u724c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getProductCategoryName(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u54c1\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getProductItemName(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u54c1\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getProductName(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getProductCode(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)detail.getUnitCode(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u5355\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)detail.getTotalCost(), (String)"ZS02/ZS03\u6d3b\u52a8\u5f62\u5f0f,\u8d39\u7528\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(detail.getActivityFormCode()) || SubComActivityValidationFormCodeEnum.ZS03.name().equals(detail.getActivityFormCode())) {
            if (SubComActivityValidationFormCodeEnum.ZS03.name().equals(detail.getActivityFormCode()) && BooleanEnum.FALSE.getCapital().equals(detail.getIsAssPromotion())) {
                return;
            }
            Validate.notNull((Object)detail.getOriginalProductNumber(), (String)"ZS03\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6,\u539f\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getGiftProductName(), (String)"ZS03\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6,\u8d60\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getGiftProductCode(), (String)"ZS03\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6,\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getGiftProductNumber(), (String)"ZS03\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6,\u8d60\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getPromoteSales(), (String)"ZS03\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6,\u671f\u95f4\u4fc3\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)detail.getPromotionAmount(), (String)"ZS03\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6,\u671f\u95f4\u4fc3\u9500\u989d\uff08\u5143\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
    }
}

