/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.imports.service;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.utils.DateTimeValidateUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityPlanRelationTypeEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.form.sdk.enums.SubComActivityValidationFormCodeEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.SubRelatedMainActivityFormVo;
import com.biz.crm.tpm.business.activity.type.sdk.service.ActivityTypeService;
import com.biz.crm.tpm.business.activity.type.sdk.vo.ActivityTypeVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemVo;
import com.biz.crm.tpm.business.promotion.policy.sdk.service.PromotionPolicyService;
import com.biz.crm.tpm.business.promotion.policy.sdk.vo.PromotionPolicyVO;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.imports.model.SubComActivityDesignImportsVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.service.internal.SubComActivityDesignDetailPageCacheHelper;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.AcceptTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.AuditConditionEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsBigDateOrNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsInspectionEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsPriceRelatedNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.SubComActivityDesignDetailAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.UndertakingModeTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignPlanVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class SubComActivityDetailDesignImportsProcess
implements ImportProcess<SubComActivityDesignImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDetailDesignImportsProcess.class);
    @Autowired
    private SubComActivityDesignService comActivityDesignService;
    @Autowired
    private SubComActivityDesignDetailPageCacheHelper subComActivityDesignDetailPageCacheHelper;
    @Autowired
    private ActivityFormService activityFormService;
    @Autowired
    private OrgVoService orgVoService;
    @Autowired
    private DictDataVoService dictDataVoService;
    @Autowired
    private ActivityTypeService activityTypeService;
    @Resource
    private BudgetItemService budgetItemService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private PromotionPolicyService promotionPolicyService;
    private static final String ACCEPT_TYPE = "accept_type";
    private static final String TOTAL_QUANTITY_OR_NOT = "Total_quantity_or_not";
    private static final String YESORNO = "yesOrNo";
    private static final String ISTWENTYSTORE = "istwentystore";
    private static final String WRITE_OFF_CONDITION_XA = "write_off_condition_xa";
    private static final String ISBIGDATEORNO = "isBigDateOrNo";
    private static final String WHETHERSCHEDULETIMENO = "whetherScheduleTimeNo";
    private static final String ISPRICERELATEDNO = "isPriceRelatedNo";
    private static final String ISPATROLOPERATIONSNO = "isPatrolOperationsNo";
    private static final String AUDIT_TYPE = "audit_type";
    private static final String WHETHERFEEPOOLDEDUCTION = "whetherfeepooldeduction";
    private static final String TPM_CONTRACT_STORE_TYPE = "tpm_contract_store_type";
    private static final String DIS_TYPE = "dis_Type";
    private static final String SALES_PROMOTER_TYPE = "sales_promoter_type";
    private static final String IS_TYPE_OF_PURCHASE_NO = "isTypeOfPurchaseNo";
    private static final String MATERIAL_BASE_UNIT = "material_base_unit";
    private static final String CUSTOMER_SOURCE = "customer_source";
    private static final String tpm_pay_type = "tpm_pay_type";
    private static final String tpm_audit_form = "tpm_audit_form";
    protected static final String bigDateTypeCode = "Z0038";
    protected static final String bigDateTypeName = "\u65e7\u8d27\u5904\u7406-\u5206\u5b50";

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public boolean importBeforeValidationFlag() {
        return Boolean.TRUE;
    }

    public Map<Integer, String> tryVerify(LinkedHashMap<Integer, SubComActivityDesignImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        for (Map.Entry<Integer, SubComActivityDesignImportsVo> row : data.entrySet()) {
            int rowNum = row.getKey();
            SubComActivityDesignImportsVo vo = row.getValue();
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getDistributionChannelCode()), "\u5206\u9500\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesOrganizationCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityFormCode()), "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getActivityDesignName() != null, "\u6d3b\u52a8\u89c4\u5212\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getOrgCode()), "\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getOrgName()), "\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getFeeYearMonth() != null, "\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getIsSupplyAmount()), "\u662f\u5426\u5171\u7528\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityNumber()), "\u6d3b\u52a8\u4fbf\u7b7e\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getRelationTypeCode()), "\u5173\u8054\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getUndertakingMode()), "\u627f\u63a5\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityTypeCode()), "\u6d3b\u52a8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityFormCode()), "\u6d3b\u52a8\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getActivityFormDesc()), "\u6d3b\u52a8\u5f62\u5f0f\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getAuditCondition()), "\u6838\u9500\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getSalesOrganizationCode()), "\u9500\u552e\u673a\u6784\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getDistributionChannelCode()), "\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getActivityBeginDate() != null, "\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getActivityEndDate() != null, "\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getOrderStartDate() != null, "\u8ba2\u5355\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(vo.getOrderEndDate() != null, "\u8ba2\u5355\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getIsAssPromotion()), "\u662f\u5426\u5173\u8054\u4fc3\u9500\u653f\u7b56\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getLargeDateFlag()), "\u662f\u5426\u5927\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getWhetherScheduleTime()), "\u662f\u5426\u6863\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getIsPriceRelation()), "\u662f\u5426\u4ef7\u683c\u76f8\u5173\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getIsPatrolOperations()), "\u662f\u5426\u5de1\u67e5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)vo.getTotalCostStr()), "\u8d39\u7528\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            String errInfo = this.validateGetErrorInfo();
            if (errInfo == null) continue;
            errMap.put(rowNum, errInfo);
        }
        return errMap;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComActivityDesignImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            if (CollectionUtil.isEmpty(data)) {
                return null;
            }
            data.forEach((k, v) -> v.setIndex((Integer)k));
            for (SubComActivityDesignImportsVo subComActivityDesignImportsVo : data.values()) {
                subComActivityDesignImportsVo.setHeadquartersSupportedAmount(null);
            }
            Map<String, List<SubComActivityDesignImportsVo>> subComGroup = data.values().stream().collect(Collectors.groupingBy(SubComActivityDesignImportsVo::getActivityDesignName));
            for (Map.Entry<String, List<SubComActivityDesignImportsVo>> row : subComGroup.entrySet()) {
                List isSupplyAmountList;
                Set yearMonthLySet;
                String k2 = row.getKey();
                List<SubComActivityDesignImportsVo> v3 = row.getValue();
                if (StringUtils.isNotBlank((CharSequence)k2)) {
                    Validate.isTrue((k2.length() <= 60 ? 1 : 0) != 0, (String)"\u89c4\u5212\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc760\u5b57", (Object[])new Object[0]);
                }
                if (!CollectionUtils.isEmpty(yearMonthLySet = v3.stream().map(SubComActivityDesignImportsVo::getYearMonthLy).collect(Collectors.toSet()))) {
                    Validate.isTrue((yearMonthLySet.size() == 1 ? 1 : 0) != 0, (String)("\u89c4\u5212[" + k2 + "],\u540c\u4e00\u89c4\u5212\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u9700\u76f8\u540c"), (Object[])new Object[0]);
                }
                SubComActivityDesignDto subComActivityDesignDto = new SubComActivityDesignDto();
                String orgCode = v3.get(0).getOrgCode();
                String feeYearMonth = v3.get(0).getFeeYearMonth();
                subComActivityDesignDto.setFeeYearMonth((Date)cn.hutool.core.date.DateUtil.parse((CharSequence)feeYearMonth, (String)"yyyy-MM"));
                subComActivityDesignDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
                subComActivityDesignDto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
                List productCodes = v3.stream().map(SubComActivityDesignImportsVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                Map<Object, Object> productVoMap = Maps.newHashMap();
                if (CollectionUtil.isNotEmpty(productCodes)) {
                    List productVoList = this.productVoService.findByCodes(productCodes);
                    if (!CollectionUtils.isEmpty((Collection)productVoList)) {
                        productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
                    } else {
                        throw new IllegalArgumentException("\u89c4\u5212\u3010" + k2 + "\u3011,\u672a\u67e5\u8be2\u5230\u76f8\u5173\u4ea7\u54c1\u4fe1\u606f");
                    }
                }
                if (!CollectionUtils.isEmpty(isSupplyAmountList = v3.stream().filter(e -> BooleanEnum.TRUE.getCapital().equals(e.getIsSupplyAmount())).collect(Collectors.toList()))) {
                    Map<String, List<SubComActivityDesignImportsVo>> isSupplyAmountMap = isSupplyAmountList.stream().collect(Collectors.groupingBy(e -> e.getActivityNumber()));
                    isSupplyAmountMap.forEach((k1, v1) -> {
                        BigDecimal activityPrice = Optional.ofNullable(((SubComActivityDesignImportsVo)((Object)((Object)v1.get(0)))).getActivityPrice()).orElse(BigDecimal.ZERO);
                        BigDecimal giftProductNumber = Optional.ofNullable(((SubComActivityDesignImportsVo)((Object)((Object)v1.get(0)))).getGiftProductNumber()).orElse(BigDecimal.ZERO);
                        BigDecimal originalProductNumber = Optional.ofNullable(((SubComActivityDesignImportsVo)((Object)((Object)v1.get(0)))).getOriginalProductNumber()).orElse(BigDecimal.ZERO);
                        for (SubComActivityDesignImportsVo vo : v1) {
                            if ("ZS03".equals(vo.getActivityFormCode())) {
                                Validate.isTrue((activityPrice.compareTo(Optional.ofNullable(vo.getActivityPrice()).orElse(BigDecimal.ZERO)) == 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u4ef7\u5fc5\u987b\u76f8\u540c", (Object[])new Object[0]);
                                continue;
                            }
                            if (!"ZS02".equals(vo.getActivityFormCode())) continue;
                            Validate.isTrue((giftProductNumber.compareTo(Optional.ofNullable(vo.getGiftProductNumber()).orElse(BigDecimal.ZERO)) == 0 ? 1 : 0) != 0, (String)"\u8d60\u54c1\u6570\u91cf\u5fc5\u987b\u76f8\u540c", (Object[])new Object[0]);
                            Validate.isTrue((originalProductNumber.compareTo(Optional.ofNullable(vo.getOriginalProductNumber()).orElse(BigDecimal.ZERO)) == 0 ? 1 : 0) != 0, (String)"\u539f\u54c1\u6570\u91cf\u5fc5\u987b\u76f8\u540c", (Object[])new Object[0]);
                        }
                    });
                }
                ArrayList<String> salesInstitutionCodes = new ArrayList<String>();
                ArrayList<String> associatedDateCodes = new ArrayList<String>();
                HashSet<String> channelCodes = new HashSet<String>();
                HashSet<String> promotionCodes = new HashSet<String>();
                for (SubComActivityDesignImportsVo vo : v3) {
                    String errInfo;
                    this.validateIsTrue(vo.getSalesOrganizationCode().length() <= 4, "\u8bf7\u586b\u5199\u672a\u62fc\u63a5\u540e\u9500\u552e\u673a\u6784\u7f16\u7801\uff01");
                    channelCodes.add(vo.getDistributionChannelCode());
                    String insCode = vo.getDistributionChannelCode() + subComActivityDesignDto.getBusinessFormatCode() + vo.getSalesOrganizationCode();
                    salesInstitutionCodes.add(insCode);
                    if (StringUtils.isNotBlank((CharSequence)vo.getSalesOrgCode())) {
                        String regionCode = insCode + vo.getSalesOrgCode();
                        salesInstitutionCodes.add(regionCode);
                        if (StringUtils.isNotBlank((CharSequence)vo.getSalesGroupCode())) {
                            String salesOrgCode = regionCode + vo.getSalesGroupCode();
                            salesInstitutionCodes.add(salesOrgCode);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)vo.getAssociatedDateCode())) {
                        associatedDateCodes.add(vo.getAssociatedDateCode());
                    }
                    if (!StringUtils.isBlank((CharSequence)vo.getPromotionCode()) && BooleanEnum.TRUE.getSure().equals(vo.getIsAssPromotion().trim())) {
                        promotionCodes.add(vo.getPromotionCode());
                    }
                    if ((errInfo = this.validateGetErrorInfo()) == null) continue;
                    errMap.put(vo.getIndex(), errInfo);
                }
                List channelVos = this.customerChannelVoService.findByCodes(new ArrayList(channelCodes));
                Map<Object, Object> channelMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty((Collection)channelVos)) {
                    channelMap = channelVos.stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, CustomerChannelVo::getCustomerChannelName, (v1, v2) -> v2));
                }
                List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodesPost(salesInstitutionCodes);
                Map<Object, Object> salesOrgVoMap = Maps.newHashMap();
                if (!CollectionUtils.isEmpty((Collection)salesOrgVoList)) {
                    salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity(), (v1, v2) -> v2));
                }
                List detailPlanItemVos = this.activityDetailPlanItemSdkService.findByItemCodes(associatedDateCodes);
                Map<String, ActivityDetailPlanItemVo> detailPlanItemVoMap = detailPlanItemVos.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
                if (CollectionUtil.isNotEmpty(promotionCodes)) {
                    List policyVoList = this.promotionPolicyService.findPolicyByPromotionCodes((List)Lists.newArrayList(promotionCodes));
                    Validate.notEmpty((Collection)policyVoList, (String)("'" + k2 + "',\u672a\u67e5\u8be2\u7684\u4fc3\u9500\u653f\u7b56\u4fe1\u606f,\u5173\u8054\u7684\u4fc3\u9500\u653f\u7b56\u53ef\u80fd\u5173\u8054\u88ab\u7981\u7528\u6216\u5220\u9664\u4e86,\u8bf7\u68c0\u67e5"), (Object[])new Object[0]);
                    Map policyVoMap = policyVoList.stream().collect(Collectors.toMap(PromotionPolicyVO::getPromotionCode, Function.identity()));
                    for (String code : promotionCodes) {
                        PromotionPolicyVO policyVo = (PromotionPolicyVO)policyVoMap.get(code);
                        Validate.notNull((Object)policyVo, (String)("\u672a\u67e5\u8be2\u5230\u8981\u5173\u8054\u7684\u4fc3\u9500\u653f\u7b56\u3010" + code + "\u3011\u4fe1\u606f,\u53ef\u80fd\u88ab\u7981\u7528\u6216\u5220\u9664\u4e86,\u8bf7\u68c0\u67e5"), (Object[])new Object[0]);
                    }
                }
                ArrayList<SubComActivityDesignDetailDto> designDetailDtos = new ArrayList<SubComActivityDesignDetailDto>(v3.size());
                for (SubComActivityDesignImportsVo detail : v3) {
                    SubComActivityDesignDetailDto subComActivityDesignDetailDto = this.conversion(detail, productVoMap, salesOrgVoMap, detailPlanItemVoMap, channelMap);
                    this.validateDetailData(subComActivityDesignDetailDto);
                    designDetailDtos.add(subComActivityDesignDetailDto);
                    String errInfo = this.validateGetErrorInfo();
                    if (errInfo == null) continue;
                    if (errMap.containsKey(detail.getIndex())) {
                        errMap.put(detail.getIndex(), (String)errMap.get(detail.getIndex()) + "," + errInfo);
                        continue;
                    }
                    errMap.put(detail.getIndex(), errInfo);
                }
                if (CollectionUtil.isNotEmpty(designDetailDtos)) {
                    String templateConfigCode = designDetailDtos.stream().map(SubComActivityDesignDetailDto::getTemplateConfigCode).distinct().collect(Collectors.joining(","));
                    subComActivityDesignDto.setTemplateConfigCode(templateConfigCode);
                }
                designDetailDtos.forEach(x -> {
                    if (CollectionUtil.isNotEmpty((Collection)x.getPlanList())) {
                        x.getPlanList().forEach(plan -> {
                            if (x.getActivityBeginTime() != null) {
                                plan.setActivityBeginDate(cn.hutool.core.date.DateUtil.formatDate((Date)x.getActivityBeginTime()));
                            }
                            if (x.getActivityEndTime() != null) {
                                plan.setActivityEndDate(cn.hutool.core.date.DateUtil.formatDate((Date)x.getActivityEndTime()));
                            }
                        });
                    }
                });
                subComActivityDesignDto.setDetailList(designDetailDtos);
                OrgVo orgVo = null;
                SalesOrgVo salesVo = null;
                try {
                    orgVo = this.orgVoService.findByOrgCode(orgCode);
                    Validate.notNull((Object)orgVo, (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728\uff01\uff01\uff01", (Object[])new Object[0]);
                    if (StringUtils.isNotBlank((CharSequence)orgVo.getSalesOrgCode())) {
                        salesVo = this.salesOrgVoService.findBySalesOrgCode(orgVo.getSalesOrgCode());
                    }
                }
                catch (Exception e2) {
                    throw new IllegalArgumentException("\u67e5\u8be2\u7ec4\u7ec7\u5931\u8d25\uff01", e2);
                }
                subComActivityDesignDto.setActivityDesignName(k2);
                subComActivityDesignDto.setOrgCode(orgVo.getOrgCode());
                subComActivityDesignDto.setOrgName(orgVo.getOrgName());
                subComActivityDesignDto.setSalesOrgName(orgVo.getSalesOrgName());
                subComActivityDesignDto.setSalesOrgCode(orgVo.getSalesOrgCode());
                subComActivityDesignDto.setSalesInstitutionCode(orgVo.getSalesOrgCode());
                subComActivityDesignDto.setSalesInstitutionName(orgVo.getSalesOrgName());
                if (!Objects.isNull(salesVo)) {
                    subComActivityDesignDto.setSalesOrgErpCode(salesVo.getErpCode());
                }
                if (!errMap.isEmpty()) continue;
                this.subComActivityDesignDetailPageCacheHelper.updateItem(null, subComActivityDesignDto.getDetailList());
                log.info("\u5206\u5b50\u516c\u53f8\u89c4\u5212\u4e3b\u5217\u8868\u5bfc\u5165,\u4fdd\u5b58\u524d:detailList:{}", (Object)JSONObject.toJSONString((Object)subComActivityDesignDto.getDetailList()));
                this.comActivityDesignService.saveSubComActivityDesign(subComActivityDesignDto, null);
            }
        }
        catch (Exception e3) {
            log.error("\u5bfc\u5165\u5206\u5b50\u516c\u53f8\u89c4\u5212\u4e3b\u8868\u5f02\u5e38,{}", (Throwable)e3);
            if (StrUtil.isEmpty((CharSequence)e3.getMessage())) {
                throw new IllegalArgumentException("\u7a7a\u6307\u9488\u5f02\u5e38", e3);
            }
            throw new IllegalArgumentException(e3.getMessage(), e3);
        }
        return errMap;
    }

    public Class<SubComActivityDesignImportsVo> findCrmExcelVoClass() {
        return SubComActivityDesignImportsVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SUB_COM_ACTIVITY_DESIGNVO_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u5bfc\u5165";
    }

    public SubComActivityDesignDetailDto conversion(SubComActivityDesignImportsVo importsVo, Map<String, ProductVo> productVoMap, Map<String, SalesOrgVo> salesOrgVoMap, Map<String, ActivityDetailPlanItemVo> detailPlanItemVoMap, Map<String, String> channelMap) {
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getOriginalProductPriceStr(), (String)"\u539f\u54c1\u5355\u4ef7\uff08\u5143\uff09", (boolean)false, importsVo::setOriginalProductPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getActivityPriceStr(), (String)"\u6d3b\u52a8\u4ef7\uff08\u5143\uff09", (boolean)false, importsVo::setActivityPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getOriginalRetailPriceStr(), (String)"\u539f\u96f6\u552e\u4ef7\uff08\u5143\uff09", (boolean)false, importsVo::setOriginalRetailPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getActivityRetailPriceStr(), (String)"\u6d3b\u52a8\u96f6\u552e\u4ef7\uff08\u5143\uff09", (boolean)false, importsVo::setActivityRetailPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getOriginalProductNumberStr(), (String)"\u539f\u54c1\u6570\u91cf", (boolean)false, importsVo::setOriginalProductNumber, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getGiftProductPriceStr(), (String)"\u8d60\u54c1\u5355\u4ef7", (boolean)false, importsVo::setGiftProductPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getGiftProductNumberStr(), (String)"\u8d60\u54c1\u6570\u91cf", (boolean)false, importsVo::setGiftProductNumber, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getDisplayPriceStr(), (String)"\u9648\u5217\u5355\u4ef7", (boolean)false, importsVo::setDisplayPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getDisplayNumberStr(), (String)"\u9648\u5217\u6570\u91cf", (boolean)false, importsVo::setDisplayNumber, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getSingleEstimatedCostStr(), (String)"\u5355\u573a\u9884\u4f30\u8d39\u7528", (boolean)false, importsVo::setSingleEstimatedCost, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getPersonNumberStr(), (String)"\u4eba\u5458\u6570\u91cf", (boolean)false, importsVo::setPersonNumber, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getQuantityStr(), (String)"\u7269\u6599\u6570\u91cf", (boolean)false, importsVo::setQuantity, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getMaterialPriceStr(), (String)"\u7269\u6599\u5355\u4ef7", (boolean)false, importsVo::setMaterialPrice, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getHeadquartersSupportedAmountStr(), (String)"\u603b\u90e8\u652f\u6301\u91d1\u989d", (boolean)false, importsVo::setHeadquartersSupportedAmount, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getTotalCostStr(), (String)"\u8d39\u7528\u5408\u8ba1", (boolean)false, importsVo::setTotalCost, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getPromoteSalesStr(), (String)"\u671f\u95f4\u4fc3\u9500\u91cf", (boolean)false, importsVo::setPromoteSales, BigDecimal.class);
        NumberStringDealUtil.validateNumberStrAndSet((String)importsVo.getPromotionAmountStr(), (String)"\u671f\u95f4\u4fc3\u9500\u989d\uff08\u5143\uff09", (boolean)false, importsVo::setPromotionAmount, BigDecimal.class);
        this.validateCommonColumn(importsVo);
        SubComActivityDesignDetailDto detailDto = new SubComActivityDesignDetailDto();
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getAssociatedDateCode()) && (ActivityPlanRelationTypeEnum.up.getName().equals(importsVo.getRelationTypeCode()) || ActivityPlanRelationTypeEnum.region.getName().equals(importsVo.getRelationTypeCode()))) {
            String[] associatedDateCodes;
            ArrayList<SubComActivityDesignPlanDto> subComActivityDesignPlanDtos = new ArrayList<SubComActivityDesignPlanDto>();
            for (String code : associatedDateCodes = importsVo.getAssociatedDateCode().trim().split(",")) {
                SubComActivityDesignPlanDto subComActivityDesignPlanDto = new SubComActivityDesignPlanDto();
                if (ActivityPlanRelationTypeEnum.region.getName().equals(importsVo.getRelationTypeCode())) {
                    subComActivityDesignPlanDto.setAssociationType(ActivityPlanRelationTypeEnum.region.getCode());
                    detailDto.setAssociationType(ActivityPlanRelationTypeEnum.region.getCode());
                } else if (ActivityPlanRelationTypeEnum.up.getName().equals(importsVo.getRelationTypeCode())) {
                    subComActivityDesignPlanDto.setAssociationType(ActivityPlanRelationTypeEnum.up.getCode());
                    detailDto.setAssociationType(ActivityPlanRelationTypeEnum.up.getCode());
                }
                subComActivityDesignPlanDto.setPlanDetailCode(code);
                Page relationPlanListPage = this.comActivityDesignService.findCanRelationPlanListPage((Pageable)PageRequest.of((int)1, (int)50), subComActivityDesignPlanDto);
                if (CollectionUtils.isEmpty((Collection)relationPlanListPage.getRecords())) {
                    this.validateIsTrue(false, "\u67e5\u8be2\u4e0d\u5230\u5173\u8054\u7ec6\u6848/\u65b9\u6848");
                    continue;
                }
                SubComActivityDesignPlanVo subComActivityDesignPlanVo = (SubComActivityDesignPlanVo)relationPlanListPage.getRecords().get(0);
                subComActivityDesignPlanDto.setPlanCode(subComActivityDesignPlanVo.getPlanCode());
                subComActivityDesignPlanDto.setPlanName(subComActivityDesignPlanVo.getPlanName());
                subComActivityDesignPlanDto.setPlanDetailCode(subComActivityDesignPlanVo.getPlanDetailCode());
                subComActivityDesignPlanDtos.add(subComActivityDesignPlanDto);
            }
            detailDto.setPlanList(subComActivityDesignPlanDtos);
        } else {
            detailDto.setAssociationType(ActivityPlanRelationTypeEnum.non.getCode());
        }
        detailDto.setAssociatedDateCode(importsVo.getAssociatedDateCode());
        detailDto.setRemark(importsVo.getRemark());
        detailDto.setOrgCode(importsVo.getOrgCode());
        detailDto.setOrgName(importsVo.getOrgName());
        detailDto.setActivityNumber(importsVo.getActivityNumber());
        if (StrUtil.isNotBlank((CharSequence)importsVo.getBudgetItemCode())) {
            BudgetItemVo budgetItem = null;
            try {
                budgetItem = this.budgetItemService.findByCode(importsVo.getBudgetItemCode(), EnableStatusEnum.ENABLE.getCode());
                this.validateIsTrue(budgetItem != null, "\u9884\u7b97\u9879\u76ee\u7f16\u7801\u9519\u8bef\uff01\uff01\uff01,\u7f16\u7801\uff1a" + importsVo.getBudgetItemCode());
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u9884\u7b97\u9879\u76ee\u7f16\u7801\u9519\u8bef\uff01\uff01\uff01,\u7f16\u7801\uff1a" + importsVo.getBudgetItemCode());
            }
        }
        detailDto.setActivityFormCode(importsVo.getActivityFormCode());
        if (StrUtil.isNotBlank((CharSequence)importsVo.getActivityTypeCode())) {
            List serviceByCodes = this.activityTypeService.findByCodes((List)Lists.newArrayList((Object[])new String[]{importsVo.getActivityTypeCode()}));
            if (CollectionUtils.isEmpty((Collection)serviceByCodes)) {
                this.validateIsTrue(false, "\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u9519\u8bef\uff01\uff01\uff01,\u7f16\u7801\uff1a" + importsVo.getActivityTypeCode());
            } else {
                detailDto.setActivityTypeName(((ActivityTypeVo)serviceByCodes.get(0)).getActivityTypeName());
            }
        }
        detailDto.setActivityTypeCode(importsVo.getActivityTypeCode());
        detailDto.setActivityFormName(importsVo.getActivityFormName());
        if (StrUtil.isNotBlank((CharSequence)importsVo.getYearMonthLy())) {
            detailDto.setFeeYearMonth((Date)cn.hutool.core.date.DateUtil.parse((CharSequence)importsVo.getYearMonthLy(), (String)"yyyy-MM"));
        }
        detailDto.setCustomerCode(importsVo.getCustomerCode());
        detailDto.setCustomerName(importsVo.getCustomerName());
        detailDto.setProductBrandCode(importsVo.getProductBrandCode());
        detailDto.setProductBrandName(importsVo.getProductBrandName());
        detailDto.setProductCategoryCode(importsVo.getProductCategoryCode());
        detailDto.setProductCategoryName(importsVo.getProductCategoryName());
        detailDto.setProductItemCode(importsVo.getProductItemCode());
        detailDto.setProductItemName(importsVo.getProductItemName());
        if (!CollectionUtil.isEmpty(productVoMap) && !StringUtils.isBlank((CharSequence)importsVo.getProductCode())) {
            ProductVo productVo = productVoMap.get(importsVo.getProductCode());
            if (!Objects.isNull(productVo)) {
                detailDto.setProductBrandCode(productVo.getProductBrandCode());
                detailDto.setProductBrandName(productVo.getProductBrandName());
                detailDto.setProductCategoryCode(productVo.getProductCategoryCode());
                detailDto.setProductCategoryName(productVo.getProductCategoryName());
                detailDto.setProductItemCode(productVo.getProductLevelCode());
                detailDto.setProductItemName(productVo.getProductLevelName());
                detailDto.setProductCode(productVo.getProductCode());
                detailDto.setProductName(importsVo.getProductName());
            } else {
                this.validateIsTrue(false, "\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u6570\u636e! \u4ea7\u54c1:[" + importsVo.getProductName() + "],\u7f16\u7801[" + importsVo.getProductCode() + "]");
            }
        }
        detailDto.setSalesInstitutionCode(importsVo.getSalesOrganizationCode());
        detailDto.setSalesInstitutionName(importsVo.getSalesOrganizationName());
        detailDto.setPromoteNumber(importsVo.getPromoteNumber());
        detailDto.setSingleEstimatedCost(importsVo.getSingleEstimatedCost());
        detailDto.setTotalCost(importsVo.getTotalCost());
        detailDto.setSupplierCode(importsVo.getSupplierCode());
        detailDto.setSupplierName(importsVo.getSupplierName());
        detailDto.setMaterialCode(importsVo.getMaterialCode());
        detailDto.setMaterialName(importsVo.getMaterialName());
        detailDto.setQuantity(importsVo.getQuantity());
        detailDto.setContractNo(importsVo.getContractNo());
        detailDto.setAccountPeriod(importsVo.getAccountPeriod());
        detailDto.setMaterialUnitCode(importsVo.getMaterialUnitCode());
        detailDto.setMaterialPrice(importsVo.getMaterialPrice());
        detailDto.setDistributionChannelName(importsVo.getDistributionChannelName());
        detailDto.setDistributionChannelCode(importsVo.getDistributionChannelCode());
        detailDto.setDisplayType(importsVo.getDisplayType());
        detailDto.setDisplayPrice(importsVo.getDisplayPrice());
        detailDto.setDisplayNumber(importsVo.getDisplayNumber());
        detailDto.setUnitCode(importsVo.getUnitCode());
        detailDto.setUnit(importsVo.getUnit());
        detailDto.setOriginalProductPrice(importsVo.getOriginalProductPrice());
        detailDto.setActivityPrice(importsVo.getActivityPrice());
        detailDto.setOriginalRetailPrice(importsVo.getOriginalRetailPrice());
        detailDto.setActivityRetailPrice(importsVo.getActivityRetailPrice());
        detailDto.setOriginalProductNumber(importsVo.getOriginalProductNumber());
        detailDto.setGiftProductCode(importsVo.getGiftProductCode());
        detailDto.setGiftProductName(importsVo.getGiftProductName());
        detailDto.setGiftProductPrice(importsVo.getGiftProductPrice());
        detailDto.setGiftProductNumber(importsVo.getGiftProductNumber());
        detailDto.setPromotionCode(importsVo.getPromotionCode());
        detailDto.setPromoteSales(importsVo.getPromoteSales());
        detailDto.setPromotionAmount(importsVo.getPromotionAmount());
        detailDto.setSalesOrgCode(importsVo.getSalesOrgCode());
        detailDto.setSalesGroupCode(importsVo.getSalesGroupCode());
        detailDto.setCommonGroups(importsVo.getCommonGroups());
        detailDto.setProcurementType(importsVo.getProcurementType());
        detailDto.setPersonNumber(importsVo.getPersonNumber());
        detailDto.setPersonIdCard(importsVo.getPersonIdCard());
        detailDto.setPersonType(importsVo.getPersonType());
        detailDto.setPersonName(importsVo.getPersonName());
        detailDto.setPersonCode(importsVo.getPersonCode());
        detailDto.setActivityFormDesc(importsVo.getActivityFormDesc());
        detailDto.setBudgetItemCode(importsVo.getBudgetItemCode());
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getActivityBeginDate()) && DateTimeValidateUtil.validateDate((String)importsVo.getActivityBeginDate()).booleanValue()) {
            detailDto.setActivityBeginTime((Date)cn.hutool.core.date.DateUtil.parseDate((CharSequence)importsVo.getActivityBeginDate()));
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getActivityEndDate()) && DateTimeValidateUtil.validateDate((String)importsVo.getActivityEndDate()).booleanValue()) {
            detailDto.setActivityEndTime((Date)cn.hutool.core.date.DateUtil.parseDate((CharSequence)importsVo.getActivityEndDate()));
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getOrderEndDate()) && DateTimeValidateUtil.validateDate((String)importsVo.getOrderEndDate()).booleanValue()) {
            detailDto.setOrderEndDate((Date)cn.hutool.core.date.DateUtil.parseDate((CharSequence)importsVo.getOrderEndDate()));
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getOrderStartDate()) && DateTimeValidateUtil.validateDate((String)importsVo.getOrderStartDate()).booleanValue()) {
            detailDto.setOrderStartDate((Date)cn.hutool.core.date.DateUtil.parseDate((CharSequence)importsVo.getOrderStartDate()));
        }
        if (StrUtil.isNotEmpty((CharSequence)importsVo.getProductDateStr())) {
            try {
                detailDto.setProductDate(DateUtil.parse((String)importsVo.getProductDateStr(), (String)"yyyy-MM"));
            }
            catch (Exception e) {
                this.validateIsTrue(false, "\u4ea7\u54c1\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\uff1ayyyy-MM");
            }
        }
        detailDto.setManagementClassificationCode(importsVo.getManagementClassificationCode());
        detailDto.setManagementClassificationName(importsVo.getManagementClassificationName());
        detailDto.setPromoterPrice(StrUtil.isNotEmpty((CharSequence)importsVo.getPromoterPrice()) ? new BigDecimal(importsVo.getPromoterPrice()) : null);
        detailDto.setAssetNo(importsVo.getAssetNo());
        detailDto.setAssetBadgeNumber(importsVo.getAssetBadgeNumber());
        detailDto.setAssetAttributes(importsVo.getAssetAttributes());
        detailDto.setUseStatus(importsVo.getUseStatus());
        detailDto.setSpecModel(importsVo.getSpecModel());
        detailDto.setTerminalCode(importsVo.getTerminalCode());
        detailDto.setTerminalName(importsVo.getTerminalName());
        detailDto.setPurchaseAmount(StrUtil.isNotEmpty((CharSequence)importsVo.getPurchaseAmount()) ? new BigDecimal(importsVo.getPurchaseAmount()) : null);
        detailDto.setThisRefundAmount(StrUtil.isNotEmpty((CharSequence)importsVo.getThisRefundAmount()) ? new BigDecimal(importsVo.getThisRefundAmount()) : null);
        detailDto.setRefundAmount(StrUtil.isNotEmpty((CharSequence)importsVo.getRefundAmount()) ? new BigDecimal(importsVo.getRefundAmount()) : null);
        detailDto.setRemainingRefundAmount(StrUtil.isNotEmpty((CharSequence)importsVo.getRemainingRefundAmount()) ? new BigDecimal(importsVo.getRemainingRefundAmount()) : null);
        detailDto.setAddress(importsVo.getAddress());
        detailDto.setContact(importsVo.getContact());
        detailDto.setContactPhone(importsVo.getContactPhone());
        detailDto.setReleaseYear(importsVo.getReleaseYear());
        detailDto.setAuditConditionCode(importsVo.getAuditConditionCode());
        if (StrUtil.isNotEmpty((CharSequence)detailDto.getActivityFormCode())) {
            ActivityFormVo activityFormVo = this.activityFormService.findOneByCode(detailDto.getActivityFormCode());
            if (activityFormVo == null) {
                this.validateIsTrue(false, "\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u6d3b\u52a8\u5f62\u5f0f" + detailDto.getActivityFormCode() + ",\u8bf7\u68c0\u67e5\u7f16\u7801\u662f\u5426\u6b63\u786e");
            } else {
                String projectTemplate = activityFormVo.getThinProjectTemplate();
                detailDto.setTemplateConfigCode(projectTemplate);
            }
            if (StrUtil.isEmpty((CharSequence)detailDto.getIsPriceRelation()) && activityFormVo.getIsRelatePrice() != null) {
                if (activityFormVo.getIsRelatePrice().booleanValue()) {
                    detailDto.setIsPriceRelation(IsPriceRelatedNoEnum.isPriceRelated.getCode());
                } else {
                    detailDto.setIsPriceRelation(IsPriceRelatedNoEnum.noPriceRelated.getCode());
                }
            }
            if (StrUtil.isEmpty((CharSequence)detailDto.getIsPatrolOperations()) && activityFormVo.getIsPushPatrolSystem() != null) {
                if (activityFormVo.getIsPushPatrolSystem().booleanValue()) {
                    detailDto.setIsPatrolOperations(IsInspectionEnum.isInspection.getCode());
                } else {
                    detailDto.setIsPatrolOperations(IsInspectionEnum.noInspection.getCode());
                }
            }
            if (Objects.equals(AuditConditionEnum.zdhx.getDes(), importsVo.getAuditCondition())) {
                detailDto.setAuditConditionCode(activityFormVo.getAuditCondition());
            }
        }
        Map mapDict = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{ACCEPT_TYPE, TOTAL_QUANTITY_OR_NOT, YESORNO, ISTWENTYSTORE, WRITE_OFF_CONDITION_XA, ISBIGDATEORNO, WHETHERSCHEDULETIMENO, ISPRICERELATEDNO, ISPATROLOPERATIONSNO, AUDIT_TYPE, WHETHERFEEPOOLDEDUCTION, TPM_CONTRACT_STORE_TYPE, DIS_TYPE, SALES_PROMOTER_TYPE, IS_TYPE_OF_PURCHASE_NO, MATERIAL_BASE_UNIT, CUSTOMER_SOURCE, tpm_pay_type, tpm_audit_form}));
        detailDto.setUndertakingMode(this.findDictValue(mapDict, ACCEPT_TYPE, importsVo.getUndertakingMode()));
        detailDto.setIsSupplyAmount(this.findDictValue(mapDict, TOTAL_QUANTITY_OR_NOT, importsVo.getIsSupplyAmount()));
        detailDto.setIsAssPromotion(this.findDictValue(mapDict, YESORNO, importsVo.getIsAssPromotion()));
        detailDto.setIsPriceRelation(this.findDictValue(mapDict, ISPRICERELATEDNO, importsVo.getIsPriceRelation()));
        detailDto.setIsPatrolOperations(this.findDictValue(mapDict, ISPATROLOPERATIONSNO, importsVo.getIsPatrolOperations()));
        detailDto.setWhetherScheduleTime(this.findDictValue(mapDict, WHETHERSCHEDULETIMENO, importsVo.getWhetherScheduleTime()));
        detailDto.setAuditType(this.findDictValue(mapDict, AUDIT_TYPE, importsVo.getAuditMode()));
        detailDto.setIsFeePoolDeduction(this.findDictValue(mapDict, WHETHERFEEPOOLDEDUCTION, importsVo.getIsFeePoolDeduction()));
        detailDto.setIsBigDate(this.findDictValue(mapDict, ISBIGDATEORNO, importsVo.getLargeDateFlag()));
        detailDto.setStoreTypePromotion(this.findDictValue(mapDict, TPM_CONTRACT_STORE_TYPE, importsVo.getTerminalType()));
        detailDto.setDisplayType(this.findDictValue(mapDict, DIS_TYPE, importsVo.getDisplayType()));
        detailDto.setPromoterType(this.findDictValue(mapDict, SALES_PROMOTER_TYPE, importsVo.getPersonType()));
        detailDto.setProcurementType(this.findDictValue(mapDict, IS_TYPE_OF_PURCHASE_NO, importsVo.getProcurementType()));
        detailDto.setMaterialUnitCode(this.findDictValue(mapDict, MATERIAL_BASE_UNIT, importsVo.getMaterialUnitCode()));
        detailDto.setPaymentMethod(this.findDictValue(mapDict, tpm_pay_type, importsVo.getPaymentMethod()));
        if (StringUtils.isNotEmpty((CharSequence)importsVo.getAuditForm())) {
            String[] auditFormArr = importsVo.getAuditForm().split(",");
            ArrayList auditFormCodeList = Lists.newArrayList();
            for (String auditFormName : auditFormArr) {
                auditFormCodeList.add(this.findDictValue(mapDict, tpm_audit_form, auditFormName));
            }
            detailDto.setAuditForm(String.join((CharSequence)",", auditFormCodeList));
        }
        detailDto.setAuditCondition(AuditConditionEnum.findByDes((String)importsVo.getAuditCondition()));
        if (channelMap.containsKey(importsVo.getDistributionChannelCode())) {
            detailDto.setDistributionChannelCode(importsVo.getDistributionChannelCode());
            detailDto.setDistributionChannelName(channelMap.get(importsVo.getDistributionChannelCode()));
        } else {
            this.validateIsTrue(false, "\u5206\u9500\u6e20\u9053" + importsVo.getDistributionChannelCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        String insCode = detailDto.getDistributionChannelCode() + BusinessFormatEnum.NORMAL.getCode() + importsVo.getSalesOrganizationCode();
        SalesOrgVo insVo = salesOrgVoMap.get(insCode);
        if (Objects.isNull(insVo)) {
            this.validateIsTrue(false, "\u9500\u552e\u673a\u6784" + importsVo.getSalesOrganizationCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
        } else {
            detailDto.setSalesInstitutionName(insVo.getSalesOrgName());
            detailDto.setSalesInstitutionErpCode(insVo.getErpCode());
            detailDto.setSalesInstitutionCode(insCode);
        }
        if (StringUtils.isNotBlank((CharSequence)importsVo.getSalesOrgCode())) {
            String regionCode = insCode + importsVo.getSalesOrgCode();
            SalesOrgVo regVo = salesOrgVoMap.get(regionCode);
            if (Objects.isNull(regVo)) {
                this.validateIsTrue(false, "\u9500\u552e\u90e8\u95e8" + importsVo.getSalesOrgCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
            } else {
                detailDto.setSalesOrgName(regVo.getSalesOrgName());
                detailDto.setSalesOrgErpCode(regVo.getErpCode());
                detailDto.setSalesOrgCode(regionCode);
                if (StringUtils.isNotBlank((CharSequence)importsVo.getSalesGroupCode())) {
                    String salesOrgCode = regionCode + importsVo.getSalesGroupCode();
                    SalesOrgVo salesOrgVo = salesOrgVoMap.get(salesOrgCode);
                    if (Objects.isNull(salesOrgVo)) {
                        this.validateIsTrue(false, "\u9500\u552e\u7ec4" + importsVo.getSalesGroupCode() + "\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    detailDto.setSalesGroupName(regVo.getSalesOrgName());
                    detailDto.setSalesGroupErpCode(regVo.getErpCode());
                    detailDto.setSalesGroupCode(salesOrgCode);
                }
            }
        }
        this.validateUndertakingColumn(importsVo, detailDto, detailPlanItemVoMap);
        if (IsBigDateOrNoEnum.isbigdate.getCode().equals(detailDto.getIsBigDate())) {
            detailDto.setActivityTypeCode(bigDateTypeCode);
            detailDto.setActivityTypeName(bigDateTypeName);
        }
        return detailDto;
    }

    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)code)) {
            return "";
        }
        List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return "";
        }
        Optional<String> first = vos.stream().filter(a -> a.getDictValue().equals(code)).map(DictDataVo::getDictCode).findFirst();
        return first.orElse("");
    }

    private void validateDetailData(SubComActivityDesignDetailDto detail) {
        if (ObjectUtils.isEmpty((Object)detail)) {
            return;
        }
        String formCode = detail.getActivityFormCode();
        if (SubComActivityValidationFormCodeEnum.ZS01.name().equals(formCode)) {
            this.validateIsTrue(TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u662f\u5426\u516c\u7528\u91cf\u53ea\u80fd\u4e3a'N'");
            this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.AFTER_THE_EVENT.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u540e\u2018");
            this.validateIsTrue(detail.getPromoteSales() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u671f\u95f4\u4fc3\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(detail.getPromotionAmount() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u671f\u95f4\u4fc3\u9500\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if (!BooleanEnum.TRUE.getCapital().equals(detail.getIsAssPromotion())) {
                this.validateIsTrue(detail.getOriginalProductNumber() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u539f\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getGiftProductCode()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getGiftProductName()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(detail.getGiftProductPrice() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.validateIsTrue(Objects.isNull(detail.getActivityPrice()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u6d3b\u52a8\u4ef7\u4e0d\u80fd\u586b\uff01");
        } else if (SubComActivityValidationFormCodeEnum.ZS02.name().equals(formCode)) {
            this.validateIsTrue(detail.getPromoteSales() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u671f\u95f4\u4fc3\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a!");
            this.validateIsTrue(detail.getPromotionAmount() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u671f\u95f4\u4fc3\u9500\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if (!BooleanEnum.TRUE.getCapital().equals(detail.getIsAssPromotion())) {
                this.validateIsTrue(detail.getOriginalProductNumber() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u539f\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getGiftProductCode()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getGiftProductName()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(detail.getGiftProductPrice() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u8d60\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getActivityPrice()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u4e0d\u53ef\u586b\u5199\u6d3b\u52a8\u4ef7\uff01");
            this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u4e2d\u2018");
            if (BooleanEnum.TRUE.getCapital().equals(detail.getIsAssPromotion())) {
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getPromotionCode()), "\u5173\u8054\u4fc3\u9500\u653f\u7b56\uff0c\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(!TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), "\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u5171\u7528\u91cf\u4e0d\u53ef\u4e3aN\u7c7b\u578b");
            }
        } else if (SubComActivityValidationFormCodeEnum.ZS03.name().equals(formCode)) {
            this.validateIsTrue(Objects.isNull(detail.getOriginalProductNumber()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u539f\u54c1\u6570\u91cf\uff01");
            this.validateIsTrue(StringUtils.isBlank((CharSequence)detail.getGiftProductCode()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u8d60\u54c1\u7f16\u7801\uff01");
            this.validateIsTrue(StringUtils.isBlank((CharSequence)detail.getGiftProductName()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u8d60\u54c1\u540d\u79f0\uff01");
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getGiftProductPrice()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u8d60\u54c1\u5355\u4ef7\uff01");
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getGiftProductNumber()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u80fd\u586b\u5199\u8d60\u54c1\u6570\u91cf\uff01");
            if (TotalQuantityOrNotEnum.Z.getCode().equals(detail.getIsSupplyAmount())) {
                this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\uff0c\u2018Z\u2019\u516c\u7528\u91cf\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u4e2d\u2018");
            }
            if (BooleanEnum.TRUE.getCapital().equals(detail.getIsAssPromotion())) {
                this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getPromotionCode()), "\u4fc3\u9500\u653f\u7b56\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(!TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), "\u5173\u8054\u4fc3\u9500\u653f\u7b56\u65f6\uff0c\u5171\u7528\u91cf\u4e0d\u53ef\u4e3aN\u7c7b\u578b");
            } else {
                this.validateIsTrue(detail.getPromoteSales() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u671f\u95f4\u4fc3\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                this.validateIsTrue(detail.getPromotionAmount() != null, formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u671f\u95f4\u4fc3\u9500\u989d\uff08\u5143\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        } else if (SubComActivityValidationFormCodeEnum.ZS11.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS12.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS13.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS14.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS15.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS16.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS30.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS42.name().equals(formCode)) {
            this.validateIsTrue(BooleanEnum.FALSE.getCapital().equals(detail.getIsAssPromotion()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u53ef\u5173\u8054\u4fc3\u9500\u653f\u7b56\uff01");
            this.validateIsTrue(TotalQuantityOrNotEnum.Y.getCode().equals(detail.getIsSupplyAmount()) || TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u5171\u7528\u91cf\u53ea\u80fd\u4e3aY/N");
            if (SubComActivityValidationFormCodeEnum.ZS42.name().equals(formCode)) {
                this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u4e2d\u2018");
            } else if (TotalQuantityOrNotEnum.Y.getCode().equals(detail.getIsSupplyAmount())) {
                this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.THINGS.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u2018Y\u2019\u516c\u7528\u91cf\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u4e2d\u2018");
            }
        } else if (SubComActivityValidationFormCodeEnum.contains((String)formCode)) {
            this.validateIsTrue(BooleanEnum.FALSE.getCapital().equals(detail.getIsAssPromotion()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u53ef\u5173\u8054\u4fc3\u9500\u653f\u7b56\uff01");
            this.validateIsTrue(TotalQuantityOrNotEnum.N.getCode().equals(detail.getIsSupplyAmount()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u662f\u5426\u516c\u7528\u91cf\u53ea\u80fd\u4e3a'N'");
            this.validateIsTrue(SubComActivityDesignDetailAuditTypeEnum.AFTER_THE_EVENT.getCode().equals(detail.getAuditType()), formCode + "\u6d3b\u52a8\u5f62\u5f0f\uff0c\u6838\u9500\u65b9\u5f0f\u5fc5\u987b\u4e3a\u2019\u4e8b\u540e\u2018");
        }
        if (SubComActivityValidationFormCodeEnum.ZS42.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS11.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS30.name().equals(formCode) || SubComActivityValidationFormCodeEnum.ZS15.name().equals(formCode)) {
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getPromoteSales()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u53ef\u586b\u5199\u671f\u95f4\u4fc3\u9500\u91cf\uff01");
            this.validateIsTrue(ObjectUtils.isEmpty((Object)detail.getPromotionAmount()), formCode + "\u6d3b\u52a8\u5f62\u5f0f,\u4e0d\u53ef\u586b\u5199\u95f4\u4fc3\u9500\u989d\uff08\u5143\uff09\uff01");
        }
    }

    private void validateCommonColumn(SubComActivityDesignImportsVo detail) {
        if (UndertakingModeTypeEnum.NO_ACCEPT.getDes().equals(detail.getUndertakingMode())) {
            this.validateIsTrue(StringUtils.isNotEmpty((CharSequence)detail.getBudgetItemCode()), "\u627f\u63a5\u65b9\u5f0f\u4e3a\u4e0d\u627f\u63a5\u65f6\u9884\u7b97\u9879\u76ee\u5fc5\u586b");
            this.validateIsTrue(StringUtils.isEmpty((CharSequence)detail.getAssociatedDateCode()), "\u627f\u63a5\u65b9\u5f0f\u4e3a\u4e0d\u627f\u63a5\u65f6\u4e0d\u9700\u8981\u5173\u8054\u6570\u636e\u7f16\u7801");
        }
        if (AuditConditionEnum.whxtj.getDes().equals(detail.getAuditCondition())) {
            this.validateIsTrue(StringUtils.isBlank((CharSequence)detail.getAuditConditionCode()), "\u6838\u9500\u65b9\u5f0f\u4e3a\u65e0\u6838\u9500\u6761\u4ef6\u65f6\u65f6\uff0c\u6838\u9500\u7f16\u7801\u5fc5\u987b\u4e3a\u7a7a\uff01");
        }
        Validate.notBlank((CharSequence)detail.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String[] customerCodes = detail.getCustomerCode().split(",");
        for (int i = 0; i < customerCodes.length; ++i) {
            this.validateIsTrue(customerCodes[i].length() == 10, "\u8bf7\u586b\u5199\u672a\u62fc\u63a5\u7684\u5ba2\u6237\u7f16\u7801\uff01");
        }
    }

    private void validateUndertakingColumn(SubComActivityDesignImportsVo importsVo, SubComActivityDesignDetailDto detailDto, Map<String, ActivityDetailPlanItemVo> detailPlanItemVoMap) {
        if (Objects.isNull((Object)importsVo) || Objects.isNull(detailDto) || StringUtils.isBlank((CharSequence)detailDto.getAssociatedDateCode())) {
            return;
        }
        if (RelationTypeEnum.UP_SUB_PLAN.getCode().equals(detailDto.getAssociationType())) {
            return;
        }
        ActivityDetailPlanItemVo detailPlanItem = detailPlanItemVoMap.get(detailDto.getAssociatedDateCode());
        Validate.notNull((Object)detailPlanItem, (String)("\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]!"), (Object[])new Object[0]);
        ArrayList<String> formCodes = new ArrayList<String>();
        formCodes.add(detailPlanItem.getActivityFormCode());
        List subRelatedMainActivityFormList = this.activityFormService.findSubRelatedMainByCodes(formCodes);
        Validate.notEmpty((Collection)subRelatedMainActivityFormList, (String)("\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]\u7684\u6d3b\u52a8\u5f62\u5f0f[" + detailPlanItem.getActivityFormCode() + "],\u672a\u5173\u8054\u5206\u5b50\u6d3b\u52a8\u5f62\u5f0f\uff01"), (Object[])new Object[0]);
        SubRelatedMainActivityFormVo mainForm = subRelatedMainActivityFormList.stream().filter(k -> k.getMainFormCode().equals(detailPlanItem.getActivityFormCode())).findFirst().orElse(null);
        Validate.notNull((Object)mainForm, (String)("\u6d3b\u52a8\u5f62\u5f0f\u672a\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]\u7684\u6d3b\u52a8\u5f62\u5f0f"), (Object[])new Object[0]);
        if (AcceptTypeEnum.FULL_ACCEPT.getCode().equals(detailDto.getUndertakingMode())) {
            String begeinTime = DateUtil.format((Date)detailDto.getActivityBeginTime(), (String)"yyyy-MM-dd");
            String endTime = DateUtil.format((Date)detailDto.getActivityEndTime(), (String)"yyyy-MM-dd");
            String begeinDate = DateUtil.format((Date)detailPlanItem.getActivityBeginDate(), (String)"yyyy-MM-dd");
            String endDate = DateUtil.format((Date)detailPlanItem.getActivityEndDate(), (String)"yyyy-MM-dd");
            this.validateIsTrue(begeinTime.equals(begeinDate), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]");
            this.validateIsTrue(endTime.equals(endDate), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]");
            this.validateIsTrue(Optional.ofNullable(detailDto.getProductCode()).orElse("").equals(detailPlanItem.getProductCode()), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]");
            this.validateIsTrue(Optional.ofNullable(detailDto.getProductName()).orElse("").equals(Optional.ofNullable(detailPlanItem.getProductName()).orElse("")), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]");
            this.validateIsTrue(Optional.ofNullable(detailDto.getGiftProductCode()).orElse("").equals(Optional.ofNullable(detailPlanItem.getGiftCode()).orElse("")), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u8d60\u54c1\u7f16\u7801\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]");
            if ("ZS01".equals(detailDto.getActivityFormCode()) || "ZS02".equals(detailDto.getActivityFormCode())) {
                this.validateIsTrue(Optional.ofNullable(detailDto.getGiftProductNumber()).orElse(BigDecimal.ZERO).intValue() == Optional.ofNullable(detailPlanItem.getGiftQuantity()).orElse(0).intValue(), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u8d60\u54c1\u6570\u91cf\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]");
                this.validateIsTrue(Optional.ofNullable(detailDto.getOriginalProductNumber()).orElse(BigDecimal.ZERO).intValue() == Optional.ofNullable(detailPlanItem.getProductQuantity()).orElse(0).intValue(), "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u672c\u54c1\u6570\u91cf\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]");
            }
            if ("ZS03".equals(detailDto.getActivityFormCode())) {
                BigDecimal activityIntensity;
                BigDecimal thisIntensity = Optional.ofNullable(detailDto.getOriginalProductPrice()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(detailDto.getActivityPrice()).orElse(BigDecimal.ZERO));
                String activityIntensityStr = Optional.ofNullable(detailPlanItem.getActivityIntensity()).orElse("0");
                try {
                    activityIntensity = new BigDecimal(activityIntensityStr);
                }
                catch (Exception ignore) {
                    activityIntensity = BigDecimal.ZERO;
                }
                this.validateIsTrue(thisIntensity.compareTo(activityIntensity) == 0, "\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u539f\u4ef7-\u6d3b\u52a8\u4ef7\u4e0e\u529b\u5ea6\u4e0d\u4e00\u81f4\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]");
            }
        }
        List salesOrgSubComOrg = this.salesOrgSubComOrgService.findByOrgCode(importsVo.getOrgCode());
        Validate.notNull((Object)salesOrgSubComOrg, (String)("\u672a\u67e5\u8be2\u5230\u7ec4\u7ec7[" + importsVo.getOrgCode() + "]"), (Object[])new Object[0]);
        ArrayList customerCodes = Lists.newArrayList();
        customerCodes.add(detailPlanItem.getCustomerCode());
        List customers = this.customerVoService.findBaseByCustomerCodes((List)customerCodes);
        Validate.notEmpty((Collection)customers, (String)("\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]\uff0c\u7684\u5ba2\u6237\u4fe1\u606f[" + detailPlanItem.getCustomerCode() + "]"), (Object[])new Object[0]);
        this.validateIsTrue(((SalesOrgSubComOrgVo)salesOrgSubComOrg.get(0)).getSubComOrgCode().equals(((CustomerVo)customers.get(0)).getErpCode()), "\u90e8\u5206|\u5b8c\u5168\u627f\u63a5\u65f6\uff0c\u7ec4\u7ec7\u4e0d\u53ef\u4fee\u6539\uff01\u9700\u627f\u63a5\u6d3b\u52a8\u7ec6\u6848[" + detailDto.getAssociatedDateCode() + "]\u7684,\u5ba2\u6237[" + ((CustomerVo)customers.get(0)).getCustomerName() + "]");
    }
}

