/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignDetailModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.SubComActivityDesignModifyPassMqTagEnum;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@RocketMQMessageListener(topic="TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PROCESS_PASS_TOPIC${rocketmq.environment}", selectorExpression="TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PASS_UPDATE_PLAN", consumerGroup="TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PASS_UPDATE_PLAN${rocketmq.environment}", consumeMode=ConsumeMode.CONCURRENTLY, messageModel=MessageModel.CLUSTERING)
public class SubComActivityDesignModifyPassUpdateDesignConsumer
extends AbstractRocketMqConsumer {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignModifyPassUpdateDesignConsumer.class);
    @Autowired
    private SubComActivityDesignDetailModifyService subComActivityDesignDetailModifyService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;

    protected Object handleMessage(MqMessageVo message) {
        log.info(SubComActivityDesignModifyPassMqTagEnum.PASS_UPDATE_PLAN.getName() + " order mq message received  : {}", (Object)message);
        if (Objects.isNull(message) || StringUtils.isEmpty((CharSequence)message.getMsgBody())) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        try {
            String businessNo = message.getMsgBody();
            List<String> detailCodes = this.subComActivityDesignDetailModifyService.doUpdateDesignDataByModify(businessNo);
            this.passPushMq(detailCodes);
        }
        catch (Exception e) {
            log.error(SubComActivityDesignModifyPassMqTagEnum.PASS_UPDATE_PLAN.getName() + "\u5904\u7406\u5931\u8d25" + e.getMessage(), (Throwable)e);
            return "\u6d88\u8d39\u5931\u8d25." + e.getMessage();
        }
        return "\u6d88\u8d39\u6210\u529f.";
    }

    private void passPushMq(List<String> detailCodes) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return;
        }
        String businessNo = JSON.toJSONString(detailCodes);
        for (SubComActivityDesignModifyPassMqTagEnum mqTagEnum : SubComActivityDesignModifyPassMqTagEnum.values()) {
            if (!SubComActivityDesignModifyPassMqTagEnum.PushType.after_update_plan.equals((Object)mqTagEnum.getPushType())) continue;
            MqMessageVo mqMessageVo = new MqMessageVo();
            mqMessageVo.setMsgBody(businessNo);
            mqMessageVo.setTopic("TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessageVo.setTag(mqTagEnum.getCode());
            this.rocketMqProducer.sendMqMsg(mqMessageVo);
        }
    }
}

