/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignModifyDiffVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignModifyVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u53d8\u66f4"})
@RestController
@RequestMapping(value={"/v1/subComActivityDesignModify"})
public class SubComActivityDesignModifyController {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignModifyController.class);
    @Autowired(required=false)
    private SubComActivityDesignModifyService subComActivityDesignModifyService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping(value={"create"})
    public Result<?> create(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u53d8\u66f4\u8868\u5934") @RequestBody SubComActivityDesignModifyDto dto) {
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_CREATE:" + cacheKey, TimeUnit.HOURS, 1L);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e");
            }
            this.subComActivityDesignModifyService.create(cacheKey, dto);
            Result result = Result.ok();
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("TPM_SUB_COM_ACTIVITY_DETAIL_PLAN_MODIFY_CREATE:" + cacheKey);
            }
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u6570\u636e")
    @PatchMapping(value={"update"})
    public Result<?> update(@ApiParam(name="cacheKey", value="\u7f13\u5b58\u952e") @RequestParam String cacheKey, @ApiParam(name="dto", value="\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u53d8\u66f4\u8868\u5934") @RequestBody SubComActivityDesignModifyDto dto) {
        try {
            if (StringUtils.isEmpty((CharSequence)dto.getId())) {
                throw new RuntimeException("\u7f16\u8f91\u64cd\u4f5c\u53c2\u6570\u6709\u8bef");
            }
            this.subComActivityDesignModifyService.create(cacheKey, dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eid/\u6d41\u7a0b\u7f16\u7801 \u67e5\u8be2\u89c4\u5212\u53d8\u66f4\u6570\u636e\u53ca\u5dee\u5f02(\u65e0\u9884\u7b97\u548c\u660e\u7ec6\u884c\u4fe1\u606f\uff09")
    @GetMapping(value={"findByIdOrProcessNo"})
    public Result<SubComActivityDesignModifyVo> findByIdOrProcessNo(@ApiParam(value="id") @RequestParam String id) {
        try {
            SubComActivityDesignModifyVo vo = this.subComActivityDesignModifyService.findByIdOrProcessNo(id);
            return Result.ok((Object)((Object)vo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u63d0\u4ea4\u5ba1\u6279\u6d41")
    @PostMapping(value={"/submit"})
    public Result submit(@RequestBody SubComActivityDesignModifyDto dto) {
        boolean lockSuccess = false;
        try {
            if (StringUtils.isEmpty((CharSequence)dto.getId())) {
                throw new RuntimeException("id\u4e0d\u5b58\u5728");
            }
            lockSuccess = this.redisLockService.tryLock(dto.getId(), TimeUnit.HOURS, 1L);
            if (!lockSuccess) {
                throw new RuntimeException("\u6570\u636e\u5904\u7406\u4e2d,\u8bf7\u7a0d\u540e");
            }
            this.subComActivityDesignModifyService.submit(dto, false);
            Result result = Result.ok((String)"\u63d0\u4ea4\u6210\u529f");
            return result;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            this.redisLockService.unlock(dto.getId());
        }
    }

    @ApiOperation(value="\u903b\u8f91\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.subComActivityDesignModifyService.delete(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u53d8\u66f4\u524d\u540e\u5dee\u5f02\u8be6\u60c5")
    @GetMapping(value={"/sumDiffDetail"})
    public Result<SubComActivityDesignModifyDiffVo> sumDiffDetail(@RequestParam(value="cacheKey") String cacheKey) {
        try {
            SubComActivityDesignModifyDiffVo vo = this.subComActivityDesignModifyService.sumDiffDetail(cacheKey);
            return Result.ok((Object)((Object)vo));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

