/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.DateStringDealUtil;
import com.biz.crm.mn.common.base.util.NumberStringDealUtil;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignDetailModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignDetailModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignDetailModifyImportExportVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignDetailModifyImportProcess
implements ImportProcess<SubComActivityDesignDetailModifyImportExportVo> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignDetailModifyImportProcess.class);
    @Autowired(required=false)
    private SubComActivityDesignDetailModifyService subComActivityDesignDetailModifyService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> execute(LinkedHashMap<Integer, SubComActivityDesignDetailModifyImportExportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap errorMap = null;
        try {
            List productVoList;
            Object cacheKeyObj = params.get("cacheKey");
            if (null == cacheKeyObj) {
                throw new RuntimeException("cacheKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String cacheKey = String.valueOf(cacheKeyObj);
            errorMap = Maps.newHashMap();
            ArrayList saveList = Lists.newArrayList();
            List cacheList = this.subComActivityDesignDetailModifyService.findCacheList(cacheKey);
            Map cacheMap = cacheList.stream().collect(Collectors.toMap(SubComActivityDesignDetailDto::getActivityDesignDetailCode, Function.identity(), (o, n) -> n));
            ArrayList dataList = Lists.newArrayList(data.values());
            HashSet<String> customerCodeSet = new HashSet<String>();
            Map<Object, Object> customerVoMap = Maps.newHashMap();
            for (SubComActivityDesignDetailModifyImportExportVo vo : dataList) {
                String[] split;
                if (!StringUtil.isNotBlank((CharSequence)vo.getCustomerCode())) continue;
                for (String customerCode : split = vo.getCustomerCode().split(",")) {
                    String code = customerCode + vo.getSalesInstitutionErpCode() + vo.getDistributionChannelCode() + vo.getBusinessFormatCode();
                    customerCodeSet.add(code);
                }
            }
            if (!CollectionUtils.isEmpty(customerCodeSet)) {
                List customers = this.customerVoService.findBaseByCustomerCodes((List)Lists.newArrayList(customerCodeSet));
                if (!CollectionUtils.isEmpty((Collection)customers)) {
                    customerVoMap = customers.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                } else {
                    throw new IllegalArgumentException("\u66f4\u636e\u5ba2\u6237\u7f16\u7801\u672a\u67e5\u8be2\u5230\u4efb\u4f55\u5ba2\u6237\u4fe1\u606f\uff01");
                }
            }
            Set productCodeSet = dataList.stream().map(SubComActivityDesignDetailModifyImportExportVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<Object, Object> productVoMap = Maps.newHashMap();
            if (CollectionUtil.isNotEmpty(productCodeSet) && !CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findByCodes((List)Lists.newArrayList(productCodeSet))))) {
                productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            }
            for (Map.Entry<Integer, SubComActivityDesignDetailModifyImportExportVo> entry : data.entrySet()) {
                Integer key = entry.getKey();
                SubComActivityDesignDetailModifyImportExportVo importVo = entry.getValue();
                ArrayList errorList = Lists.newArrayList();
                try {
                    if (StringUtil.isEmpty((CharSequence)importVo.getActivityDesignDetailCode())) {
                        errorList.add("\u884c\u9879\u76ee\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                        continue;
                    }
                    SubComActivityDesignDetailModifyDto modifyDto = (SubComActivityDesignDetailModifyDto)((Object)cacheMap.get(importVo.getActivityDesignDetailCode()));
                    this.addExceptionToErrorList(errorList, () -> NumberStringDealUtil.validateNumberStrAndSet((String)importVo.getTotalCostStr(), (String)"\u8d39\u7528\u5408\u8ba1", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setTotalCost(arg_0), BigDecimal.class));
                    this.addExceptionToErrorList(errorList, () -> NumberStringDealUtil.validateNumberStrAndSet((String)importVo.getHeadquartersSupportedAmountStr(), (String)"\u603b\u90e8\u652f\u6301\u91d1\u989d", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setHeadquartersSupportedAmount(arg_0), BigDecimal.class));
                    this.addExceptionToErrorList(errorList, () -> NumberStringDealUtil.validateNumberStrAndSet((String)importVo.getSubComAutoAmountStr(), (String)"\u516c\u53f8\u81ea\u6295\u91d1\u989d", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setSubComAutoAmount(arg_0), BigDecimal.class));
                    this.addExceptionToErrorList(errorList, () -> NumberStringDealUtil.validateNumberStrAndSet((String)importVo.getPromoteSalesStr(), (String)"\u671f\u95f4\u4fc3\u9500\u91cf", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setPromoteSales(arg_0), BigDecimal.class));
                    this.addExceptionToErrorList(errorList, () -> NumberStringDealUtil.validateNumberStrAndSet((String)importVo.getPromotionAmountStr(), (String)"\u671f\u95f4\u4fc3\u9500\u989d", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setPromotionAmount(arg_0), BigDecimal.class));
                    this.addExceptionToErrorList(errorList, () -> DateStringDealUtil.validateDateStrAndSet((String)importVo.getOrderStartDateStr(), (String)"\u8ba2\u5355\u5f00\u59cb\u65f6\u95f4", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setOrderStartDate(arg_0)));
                    this.addExceptionToErrorList(errorList, () -> DateStringDealUtil.validateDateStrAndSet((String)importVo.getOrderEndDateStr(), (String)"\u8ba2\u5355\u7ed3\u675f\u65e5\u671f", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setOrderEndDate(arg_0)));
                    this.addExceptionToErrorList(errorList, () -> DateStringDealUtil.validateDateStrAndSet((String)importVo.getActivityBeginTimeStr(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setActivityBeginTime(arg_0)));
                    this.addExceptionToErrorList(errorList, () -> DateStringDealUtil.validateDateStrAndSet((String)importVo.getActivityEndTimeStr(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4", (String)"yyyy-MM-dd", arg_0 -> ((SubComActivityDesignDetailModifyDto)modifyDto).setActivityEndTime(arg_0)));
                    if (StringUtil.isNotEmpty((CharSequence)importVo.getCustomerCode())) {
                        String[] split = importVo.getCustomerCode().split(",");
                        ArrayList<String> customerCodeList = new ArrayList<String>();
                        ArrayList<String> customerNameList = new ArrayList<String>();
                        for (int i = 0; i < split.length; ++i) {
                            String customerCode = split[i] + modifyDto.getSalesInstitutionErpCode() + modifyDto.getDistributionChannelCode() + modifyDto.getBusinessFormatCode();
                            CustomerVo customerVo = (CustomerVo)customerVoMap.get(customerCode);
                            if (null == customerVo) {
                                errorList.add("\u5ba2\u6237[" + importVo.getCustomerCode() + "]\u6709\u8bef");
                                continue;
                            }
                            customerCodeList.add(customerVo.getErpCode());
                            customerNameList.add(customerVo.getCustomerName());
                        }
                        if (CollectionUtil.isNotEmpty(customerCodeList)) {
                            modifyDto.setCustomerCode(String.join((CharSequence)",", customerCodeList));
                        }
                        if (CollectionUtil.isNotEmpty(customerNameList)) {
                            modifyDto.setCustomerName(String.join((CharSequence)",", customerNameList));
                        }
                    }
                    if (StringUtil.isNotEmpty((CharSequence)importVo.getProductCode())) {
                        ProductVo productVo = (ProductVo)productVoMap.get(importVo.getProductCode());
                        if (null == productVo) {
                            errorList.add("\u4ea7\u54c1[" + importVo.getProductCode() + "]\u6709\u8bef");
                        } else {
                            modifyDto.setProductCode(productVo.getProductCode());
                            modifyDto.setProductName(productVo.getProductName());
                            modifyDto.setProductBrandCode(productVo.getProductBrandCode());
                            modifyDto.setProductBrandName(productVo.getProductBrandName());
                            modifyDto.setProductCategoryCode(productVo.getProductCategoryCode());
                            modifyDto.setProductCategoryName(productVo.getProductCategoryName());
                            modifyDto.setProductItemCode(productVo.getProductLevelCode());
                            modifyDto.setProductItemName(productVo.getProductLevelName());
                        }
                    }
                    saveList.add(modifyDto);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    errorList.add(Optional.ofNullable(e.getMessage()).orElse("\u7a7a\u6307\u9488"));
                }
                finally {
                    String errorInfo = this.validateGetErrorInfo();
                    if (CollectionUtils.isEmpty((Collection)errorList)) continue;
                    errorMap.put(key, errorInfo);
                }
            }
            if (errorMap.size() == 0) {
                this.subComActivityDesignDetailModifyService.saveCurrentPageCache(cacheKey, saveList);
            }
        }
        catch (RuntimeException e) {
            log.error("\u5206\u5b50\u53d8\u66f4\u7ec6\u6848\u660e\u7ec6\u5bfc\u5165\u5931\u8d25");
            throw e;
        }
        return errorMap;
    }

    public void addExceptionToErrorList(List<String> errorList, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            errorList.add(Optional.ofNullable(e.getMessage()).orElse("\u7a7a\u6307\u9488"));
        }
    }

    public Class<SubComActivityDesignDetailModifyImportExportVo> findCrmExcelVoClass() {
        return SubComActivityDesignDetailModifyImportExportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_SUB_COM_ACTIVITY_DESIGN_DETAIL_MODIFY_IMPORT";
    }

    public String getTemplateName() {
        return "\u5206\u5b50\u53d8\u66f4\u7ec6\u6848\u660e\u7ec6\u5bfc\u5165";
    }
}

