/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignDetailModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.entity.SubComActivityDesignDetailModify;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.mapper.SubComActivityDesignDetailModifyMapper;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SubComActivityDesignDetailModifyRepository
extends ServiceImpl<SubComActivityDesignDetailModifyMapper, SubComActivityDesignDetailModify> {
    @Autowired(required=false)
    private SubComActivityDesignDetailModifyMapper subComActivityDesignDetailModifyMapper;
    @Autowired(required=false)
    private SubComActivityDesignDetailRepository subComActivityDesignDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<SubComActivityDesignDetailVo> findToModifyList(Pageable pageable, SubComActivityDesignDetailDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<SubComActivityDesignDetailVo> pageList = this.subComActivityDesignDetailModifyMapper.findToModifyList((Page<SubComActivityDesignDetailVo>)page, dto);
        return pageList;
    }

    public List<SubComActivityDesignDetailModifyDto> findDtoAndAttachListByDetailPlanCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignDetailModify> modifyList = this.findListByModifyCode(modifyCode);
        List modifyDtoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(modifyList, SubComActivityDesignDetailModify.class, SubComActivityDesignDetailModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        List<String> activityDesignDetailCodeList = modifyDtoList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).collect(Collectors.toList());
        List<SubComActivityDesignDetailVo> detailList = this.subComActivityDesignDetailRepository.findDetailByDetailCodes(activityDesignDetailCodeList);
        Map detailDtoMap = detailList.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity()));
        for (SubComActivityDesignDetailModifyDto modifyDto : modifyDtoList) {
            SubComActivityDesignDetailModify modifyItem = (SubComActivityDesignDetailModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)modifyDto, SubComActivityDesignDetailModify.class, HashSet.class, ArrayList.class, new String[0]));
            SubComActivityDesignDetailVo detailVo = (SubComActivityDesignDetailVo)detailDtoMap.get(modifyDto.getActivityDesignDetailCode());
            BeanUtils.copyProperties((Object)detailVo, (Object)((Object)modifyDto));
            BeanUtils.copyProperties((Object)((Object)modifyItem), (Object)((Object)modifyDto));
        }
        return modifyDtoList;
    }

    public List<SubComActivityDesignDetailModify> findListByModifyCode(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(SubComActivityDesignDetailModify::getModifyCode, (Object)modifyCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public void deleteByModifyCodeList(List<String> modifyCodeList) {
        if (CollectionUtils.isEmpty(modifyCodeList)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(SubComActivityDesignDetailModify::getModifyCode, modifyCodeList);
        this.update((Wrapper)updateWrapper);
    }

    public void deleteByIds(ArrayList<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
        updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode());
        updateWrapper.in(UuidEntity::getId, ids);
        updateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        this.update((Wrapper)updateWrapper);
    }
}

