/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignBudgetModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignDetailModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.entity.SubComActivityDesignBudgetModify;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.entity.SubComActivityDesignModify;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.repository.SubComActivityDesignBudgetModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignBudgetModifyService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SubComActivityDesignBudgetModifyServiceImpl
implements SubComActivityDesignBudgetModifyService {
    @Autowired(required=false)
    private SubComActivityDesignBudgetModifyRepository subComActivityDesignBudgetModifyRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveSubComActivityDesignBudgetModifyList(SubComActivityDesignModify entity, boolean update, List<SubComActivityDesignDetailModifyDto> itemDtoList) {
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<SubComActivityDesignBudgetModify> oldList = this.subComActivityDesignBudgetModifyRepository.listByModifyCode(entity.getModifyCode());
            oldMap = oldList.stream().collect(Collectors.toMap(item -> item.getActivityDesignDetailCode() + item.getMonthBudgetCode(), Function.identity()));
        }
        for (SubComActivityDesignDetailModifyDto itemDto : itemDtoList) {
            if (CollectionUtils.isEmpty(itemDto.getBudgetModifyList())) continue;
            itemDto.getBudgetModifyList().forEach(item -> {
                item.setActivityDesignDetailCode(itemDto.getActivityDesignDetailCode());
                item.setActivityDesignCode(itemDto.getActivityDesignCode());
                item.setModifyCode(entity.getModifyCode());
            });
        }
        List budgetDtoList = itemDtoList.stream().map(SubComActivityDesignDetailModifyDto::getBudgetModifyList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetDtoList, SubComActivityDesignBudgetModifyDto.class, SubComActivityDesignBudgetModify.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDesignBudgetModify item2 : list) {
            String key = item2.getActivityDesignDetailCode() + item2.getMonthBudgetCode();
            if (oldMap.containsKey(key)) {
                item2.setId(((SubComActivityDesignBudgetModify)((Object)oldMap.get(key))).getId());
                updateList.add(item2);
                oldMap.remove(key);
                continue;
            }
            item2.setModifyCode(entity.getModifyCode());
            item2.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item2.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item2.setTenantCode(entity.getTenantCode());
            item2.setId(null);
            saveList.add(item2);
        }
        if (!CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDesignBudgetModifyRepository.saveBatch(saveList);
        }
        if (!CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDesignBudgetModifyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            List<String> deleteIds = oldMap.values().stream().map(UuidEntity::getId).collect(Collectors.toList());
            this.subComActivityDesignBudgetModifyRepository.deleteByIds(deleteIds);
        }
    }

    @Override
    public void deleteByModifyCodeList(List<String> modifyCodeList) {
        if (CollectionUtils.isEmpty(modifyCodeList)) {
            return;
        }
        this.subComActivityDesignBudgetModifyRepository.deleteByModifyCodeList(modifyCodeList);
    }
}

