/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignBudgetEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.entity.SubComActivityDesignFeeDetailEntity;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignDetailModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.entity.SubComActivityDesignBudgetModify;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.entity.SubComActivityDesignDetailModify;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.entity.SubComActivityDesignModify;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.repository.SubComActivityDesignBudgetModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.repository.SubComActivityDesignDetailModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignDetailModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignDetailModifyVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignBudgetRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignFeeDetailRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.repository.SubComActivityDesignRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignNetEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.event.SubComActivityDesignNetEventListener;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubComActivityDesignDetailModifyServiceImpl
extends MnPageCacheServiceImpl<SubComActivityDesignDetailModifyVo, SubComActivityDesignDetailModifyDto>
implements SubComActivityDesignDetailModifyService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignDetailModifyServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityDesignDetailModifyRepository subComActivityDesignDetailModifyRepository;
    @Autowired(required=false)
    private SubComActivityDesignDetailRepository subComActivityDesignDetailRepository;
    @Autowired(required=false)
    private SubComActivityDesignRepository subComActivityDesignRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignBudgetRepository subComActivityDesignBudgetRepository;
    @Autowired(required=false)
    private SubComActivityDesignBudgetModifyRepository subComActivityDesignBudgetModifyRepository;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private SubComActivityDesignFeeDetailRepository subComActivityDesignFeeDetailRepository;

    @Override
    public Page<SubComActivityDesignDetailVo> findToModifyList(Pageable pageable, SubComActivityDesignDetailDto dto) {
        return this.subComActivityDesignDetailModifyRepository.findToModifyList(pageable, dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveItemList(SubComActivityDesignModify entity, boolean update, List<SubComActivityDesignDetailModifyDto> itemList) {
        itemList.forEach(this::createValidate);
        this.backupInitVersionData(itemList);
        Map<Object, Object> oldMap = Maps.newHashMap();
        if (update) {
            List<SubComActivityDesignDetailModify> oldList = this.subComActivityDesignDetailModifyRepository.findListByModifyCode(entity.getModifyCode());
            oldMap = oldList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
        }
        ArrayList saveList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        for (SubComActivityDesignDetailModifyDto itemDto : itemList) {
            SubComActivityDesignDetailModify item = (SubComActivityDesignDetailModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)itemDto, SubComActivityDesignDetailModify.class, HashSet.class, ArrayList.class, new String[0]));
            if (oldMap.containsKey(item.getId())) {
                updateList.add(item);
                oldMap.remove(item.getId());
                continue;
            }
            item.setModifyCode(entity.getModifyCode());
            item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            item.setTenantCode(entity.getTenantCode());
            saveList.add(item);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)saveList)) {
            this.subComActivityDesignDetailModifyRepository.saveOrUpdateBatch(saveList);
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)updateList)) {
            this.subComActivityDesignDetailModifyRepository.updateBatchById(updateList);
        }
        if (oldMap.size() > 0) {
            this.subComActivityDesignDetailModifyRepository.deleteByIds(Lists.newArrayList(oldMap.keySet()));
        }
    }

    private void createValidate(SubComActivityDesignDetailModifyDto dto) {
    }

    private void backupInitVersionData(List<SubComActivityDesignDetailModifyDto> itemList) {
        List itemCodeList = itemList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).collect(Collectors.toList());
        List noModifyList = this.subComActivityDesignDetailRepository.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SubComActivityDesignDetailEntity::getConstituentDetailPlanItemCode, itemCodeList)).and(w -> {
            w.eq(SubComActivityDesignDetailEntity::getHasModify, (Object)BooleanEnum.FALSE.getCapital());
            w.or();
            w.isNull(SubComActivityDesignDetailEntity::getHasModify);
        }));
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)noModifyList)) {
            return;
        }
        List entityList = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)noModifyList, SubComActivityDesignDetailEntity.class, SubComActivityDesignDetailModify.class, HashSet.class, ArrayList.class, new String[0]);
        this.subComActivityDesignDetailModifyRepository.saveBatch(entityList);
        List<String> noModifyCodeList = noModifyList.stream().map(SubComActivityDesignDetailEntity::getActivityDesignDetailCode).collect(Collectors.toList());
        this.subComActivityDesignDetailRepository.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().set(SubComActivityDesignDetailEntity::getHasModify, (Object)BooleanEnum.TRUE.getCapital())).in(SubComActivityDesignDetailEntity::getConstituentDetailPlanItemCode, noModifyCodeList));
        List<SubComActivityDesignBudgetEntity> budgetList = this.subComActivityDesignBudgetRepository.listByActivityDetailCodes(noModifyCodeList);
        if (!org.springframework.util.CollectionUtils.isEmpty(budgetList)) {
            List budgetModifyList = (List)this.nebulaToolkitService.copyCollectionByBlankList(budgetList, SubComActivityDesignBudgetEntity.class, SubComActivityDesignBudgetModify.class, HashSet.class, ArrayList.class, new String[0]);
            this.subComActivityDesignBudgetModifyRepository.saveBatch(budgetModifyList);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<String> doUpdateDesignDataByModify(String modifyCode) {
        if (StringUtils.isBlank((CharSequence)modifyCode)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignDetailModify> detailModifyList = this.subComActivityDesignDetailModifyRepository.findListByModifyCode(modifyCode);
        Validate.notEmpty(detailModifyList, (String)"\u89c4\u5212\u53d8\u66f4\u5ba1\u6279\u901a\u8fc7\u540e\uff0c\u66f4\u636e\u53d8\u66f4\u7f16\u7801\uff0c\u672a\u67e5\u8be2\u5230\u53d8\u66f4\u660e\u7ec6\u4fe1\u606f", (Object[])new Object[0]);
        List<String> designCodes = detailModifyList.stream().map(SubComActivityDesignDetailModify::getActivityDesignCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<String> designDetailCodes = detailModifyList.stream().map(SubComActivityDesignDetailModify::getActivityDesignDetailCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SubComActivityDesignDetailVo> designDetailList = this.subComActivityDesignDetailRepository.findDetailByDetailCodes(designDetailCodes);
        List<SubComActivityDesignBudgetEntity> designBudgetEntityList = this.subComActivityDesignBudgetRepository.listByActivityCodes(designCodes);
        HashMap designBudgetEntityListMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(designBudgetEntityList)) {
            designBudgetEntityListMap.putAll(designBudgetEntityList.stream().collect(Collectors.toMap(SubComActivityDesignBudgetEntity::getActivityDesignDetailCode, v -> v, (n, o) -> n)));
        }
        List<SubComActivityDesignBudgetModify> subComActivityDesignBudgetModifies = this.subComActivityDesignBudgetModifyRepository.listByModifyCode(modifyCode);
        HashMap designBudgetModifyMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(subComActivityDesignBudgetModifies)) {
            designBudgetModifyMap.putAll(subComActivityDesignBudgetModifies.stream().collect(Collectors.toMap(k -> k.getActivityDesignDetailCode() + k.getFeeSourceCode(), v -> v, (n, o) -> n)));
        }
        Map designDetailMap = designDetailList.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity()));
        List<SubComActivityDesignFeeDetailEntity> feeDetailEntityList = this.subComActivityDesignFeeDetailRepository.listByDesignCodeList(designCodes);
        Map feeDetailMap = feeDetailEntityList.stream().collect(Collectors.toMap(SubComActivityDesignFeeDetailEntity::getActivityDesignDetailCode, Function.identity()));
        ArrayList<SubComActivityDesignDetailEntity> designUpdateList = new ArrayList<SubComActivityDesignDetailEntity>(detailModifyList.size());
        ArrayList<SubComActivityDesignDetailDto> detailPlanUpdateList = new ArrayList<SubComActivityDesignDetailDto>(detailModifyList.size());
        ArrayList<String> detailDesignCodeList = new ArrayList<String>();
        HashMap designDetailEntityMap = Maps.newHashMap();
        ArrayList updateFeeDetailEntityList = Lists.newArrayList();
        ArrayList updateDesignBudgetEntityList = Lists.newArrayList();
        if (CollectionUtil.isNotEmpty(designBudgetEntityList) && CollectionUtil.isNotEmpty((Map)designBudgetModifyMap)) {
            designBudgetEntityList.forEach(item -> {
                SubComActivityDesignBudgetModify modify = (SubComActivityDesignBudgetModify)((Object)((Object)designBudgetModifyMap.get(item.getActivityDesignDetailCode() + item.getFeeSourceCode())));
                if (Objects.nonNull((Object)modify) && Objects.nonNull(modify.getBudgetAmount()) && Objects.nonNull(item.getBudgetAmount())) {
                    item.setBudgetAmount(item.getBudgetAmount().add(modify.getBudgetAmount()));
                    updateDesignBudgetEntityList.add(item);
                }
            });
        }
        if (CollectionUtil.isNotEmpty((Collection)updateDesignBudgetEntityList)) {
            this.subComActivityDesignBudgetRepository.updateBatchById(updateDesignBudgetEntityList);
        }
        HashMap designBudgetEntityMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)updateDesignBudgetEntityList)) {
            designBudgetEntityMap.putAll(updateDesignBudgetEntityList.stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetEntity::getActivityDesignDetailCode)));
        }
        for (SubComActivityDesignDetailModify detailModify : detailModifyList) {
            List budgetEntities;
            SubComActivityDesignDetailVo designDetail = (SubComActivityDesignDetailVo)designDetailMap.get(detailModify.getActivityDesignDetailCode());
            if (Objects.isNull(designDetail)) {
                log.error("\u89c4\u5212\u53d8\u66f4\u660e\u7ec6\u3010" + detailModify.getModifyCode() + "\u3011,\u672a\u627e\u5230\u5bf9\u5e94\u8981\u53d8\u66f4\u7684\u89c4\u5212\u660e\u7ec6\u3010" + detailModify.getActivityDesignDetailCode() + "\u3011");
                continue;
            }
            SubComActivityDesignDetailEntity designDetailEntity = new SubComActivityDesignDetailEntity();
            designDetailEntity.setId(designDetail.getId());
            designDetailEntity.setActivityBeginTime(detailModify.getActivityBeginTime());
            designDetailEntity.setActivityEndTime(detailModify.getActivityEndTime());
            designDetailEntity.setOrderStartDate(detailModify.getOrderStartDate());
            designDetailEntity.setOrderEndDate(detailModify.getOrderEndDate());
            designDetailEntity.setCustomerCode(detailModify.getCustomerCode());
            designDetailEntity.setCustomerName(detailModify.getCustomerName());
            designDetailEntity.setPromoteSales(detailModify.getPromoteSales());
            designDetailEntity.setPromotionAmount(detailModify.getPromotionAmount());
            designDetailEntity.setTotalCost(detailModify.getTotalCost());
            designDetailEntity.setProductCode(detailModify.getProductCode());
            designDetailEntity.setProductName(detailModify.getProductName());
            designDetailEntity.setCurrModifyCode(detailModify.getModifyCode());
            SubComActivityDesignDetailDto designDetailDto = (SubComActivityDesignDetailDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)designDetailEntity, SubComActivityDesignDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
            designDetailDto.setActivityDesignDetailCode(designDetail.getActivityDesignDetailCode());
            detailPlanUpdateList.add(designDetailDto);
            String activityDesignDetailCode = designDetail.getActivityDesignDetailCode();
            detailDesignCodeList.add(activityDesignDetailCode);
            SubComActivityDesignFeeDetailEntity designFeeDetailEntity = (SubComActivityDesignFeeDetailEntity)((Object)feeDetailMap.get(activityDesignDetailCode));
            if (Objects.nonNull((Object)designFeeDetailEntity) && CollectionUtil.isNotEmpty((Collection)(budgetEntities = (List)designBudgetEntityMap.get(activityDesignDetailCode)))) {
                designFeeDetailEntity.setThisUseAmount(BigDecimal.ZERO);
                budgetEntities.forEach(designBudgetEntity -> {
                    FeeSourceEnum feeSourceEnum = FeeSourceEnum.codeToEnum((String)designBudgetEntity.getFeeSourceCode());
                    if (Objects.nonNull(feeSourceEnum)) {
                        designFeeDetailEntity.setThisUseAmount(designFeeDetailEntity.getThisUseAmount().add(designBudgetEntity.getBudgetAmount()));
                        switch (feeSourceEnum) {
                            case INTERNAL_POINT_FEE: {
                                if (Objects.isNull(designDetailEntity.getHeadquartersSupportedAmount())) {
                                    designDetailEntity.setHeadquartersSupportedAmount(BigDecimal.ZERO);
                                }
                                designDetailEntity.setHeadquartersSupportedAmount(designDetailEntity.getHeadquartersSupportedAmount().add(designBudgetEntity.getBudgetAmount()));
                                designFeeDetailEntity.setInternalAmount(designBudgetEntity.getBudgetAmount());
                                break;
                            }
                            case OFF_POINT_FEE: {
                                if (Objects.isNull(designDetailEntity.getHeadquartersSupportedAmount())) {
                                    designDetailEntity.setHeadquartersSupportedAmount(BigDecimal.ZERO);
                                }
                                designDetailEntity.setHeadquartersSupportedAmount(designDetailEntity.getHeadquartersSupportedAmount().add(designBudgetEntity.getBudgetAmount()));
                                designFeeDetailEntity.setOffAmount(designBudgetEntity.getBudgetAmount());
                                break;
                            }
                            case AUTO_FEE: {
                                if (Objects.isNull(designDetailEntity.getSubComAutoAmount())) {
                                    designDetailEntity.setSubComAutoAmount(BigDecimal.ZERO);
                                }
                                designDetailEntity.setSubComAutoAmount(designDetailEntity.getSubComAutoAmount().add(designBudgetEntity.getBudgetAmount()));
                                designFeeDetailEntity.setAutoAmount(designBudgetEntity.getBudgetAmount());
                                break;
                            }
                        }
                        updateFeeDetailEntityList.add(designFeeDetailEntity);
                    }
                });
            }
            designUpdateList.add(designDetailEntity);
            designDetailEntityMap.put(designDetailEntity.getId(), designDetailEntity);
        }
        if (CollectionUtil.isNotEmpty((Collection)updateFeeDetailEntityList)) {
            this.subComActivityDesignFeeDetailRepository.updateBatchById(updateFeeDetailEntityList);
        }
        List<SubComActivityDesignEntity> designEntityList = this.subComActivityDesignRepository.findByDesignCodes(designCodes);
        List<SubComActivityDesignDetailEntity> designBudgetEntityAllList = this.subComActivityDesignDetailRepository.findListByCodeList(designCodes);
        HashMap subComActivityDesignDetailMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(designBudgetEntityAllList) && CollectionUtil.isNotEmpty(designEntityList)) {
            subComActivityDesignDetailMap.putAll(designBudgetEntityAllList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailEntity::getActivityDesignCode)));
            designEntityList.forEach(item -> {
                List itemList = (List)subComActivityDesignDetailMap.get(item.getActivityDesignCode());
                if (CollectionUtil.isEmpty((Collection)itemList)) {
                    return;
                }
                AtomicReference<BigDecimal> subComAutoAmountTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> headquartersSupportedAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                AtomicReference<BigDecimal> totalCostTotal = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
                itemList.forEach(detailItem -> {
                    SubComActivityDesignDetailEntity thisOne = detailItem;
                    if (designDetailEntityMap.containsKey(detailItem.getId())) {
                        thisOne = (SubComActivityDesignDetailEntity)((Object)((Object)((Object)designDetailEntityMap.get(detailItem.getId()))));
                    }
                    subComAutoAmountTotal.set(((BigDecimal)subComAutoAmountTotal.get()).add(Optional.ofNullable(thisOne.getSubComAutoAmount()).orElse(BigDecimal.ZERO)));
                    headquartersSupportedAmount.set(((BigDecimal)headquartersSupportedAmount.get()).add(Optional.ofNullable(thisOne.getHeadquartersSupportedAmount()).orElse(BigDecimal.ZERO)));
                    totalCostTotal.set(((BigDecimal)totalCostTotal.get()).add(Optional.ofNullable(thisOne.getTotalCost()).orElse(BigDecimal.ZERO)));
                });
                item.setSubComAutoAmountTotal(subComAutoAmountTotal.get());
                item.setHeadquartersSupportedAmountTotal(headquartersSupportedAmount.get());
                item.setApplyAmount(totalCostTotal.get());
            });
            this.subComActivityDesignRepository.updateBatchById(designEntityList);
        }
        if (CollectionUtil.isNotEmpty(designUpdateList)) {
            this.subComActivityDesignDetailRepository.updateBatchById(designUpdateList);
        }
        this.reduceSubComBudgetForecast(subComActivityDesignBudgetModifies);
        if (CollectionUtil.isNotEmpty(detailPlanUpdateList)) {
            SerializableBiConsumer & Serializable onModify = SubComActivityDesignNetEventListener::onModify;
            SubComActivityDesignNetEventDto netEventDto = new SubComActivityDesignNetEventDto();
            netEventDto.setDesignDetailDtos(detailPlanUpdateList);
            this.nebulaNetEventClient.publish((NebulaEventDto)netEventDto, SubComActivityDesignNetEventListener.class, (SerializableBiConsumer)onModify);
        }
        return detailDesignCodeList;
    }

    @Override
    public void useSubComBudgetForecast(List<SubComActivityDesignBudgetModify> designBudgetEntities) {
        ArrayList operationBudgetForecastList = Lists.newArrayList();
        for (SubComActivityDesignBudgetModify designBudgetEntity : designBudgetEntities) {
            if (designBudgetEntity.getBudgetAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            SubComBudgetForecastDetailDto subComBudgetForecastDto = new SubComBudgetForecastDetailDto();
            subComBudgetForecastDto.setBudgetForecastCode(designBudgetEntity.getBudgetForecastCode());
            subComBudgetForecastDto.setOperationType(ForecastOperationTypeEnum.USE.getCode());
            subComBudgetForecastDto.setBusinessCode(designBudgetEntity.getActivityDesignDetailCode());
            subComBudgetForecastDto.setCurOperationAmount(designBudgetEntity.getBudgetAmount());
            operationBudgetForecastList.add(subComBudgetForecastDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)operationBudgetForecastList)) {
            this.subComBudgetForecastService.operationBudgetForecast((List)operationBudgetForecastList);
        }
    }

    @Override
    public void returnSubComBudgetForecast(List<SubComActivityDesignBudgetModify> designBudgetEntities) {
        ArrayList operationBudgetForecastList = Lists.newArrayList();
        for (SubComActivityDesignBudgetModify designBudgetEntity : designBudgetEntities) {
            if (designBudgetEntity.getBudgetAmount().compareTo(BigDecimal.ZERO) <= 0) continue;
            SubComBudgetForecastDetailDto subComBudgetForecastDto = new SubComBudgetForecastDetailDto();
            subComBudgetForecastDto.setBudgetForecastCode(designBudgetEntity.getBudgetForecastCode());
            subComBudgetForecastDto.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
            subComBudgetForecastDto.setBusinessCode(designBudgetEntity.getActivityDesignDetailCode());
            subComBudgetForecastDto.setCurOperationAmount(designBudgetEntity.getBudgetAmount());
            operationBudgetForecastList.add(subComBudgetForecastDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)operationBudgetForecastList)) {
            this.subComBudgetForecastService.operationBudgetForecast((List)operationBudgetForecastList);
        }
    }

    public void reduceSubComBudgetForecast(List<SubComActivityDesignBudgetModify> designBudgetEntities) {
        ArrayList operationBudgetForecastList = Lists.newArrayList();
        for (SubComActivityDesignBudgetModify designBudgetEntity : designBudgetEntities) {
            if (designBudgetEntity.getBudgetAmount().compareTo(BigDecimal.ZERO) >= 0) continue;
            SubComBudgetForecastDetailDto subComBudgetForecastDto = new SubComBudgetForecastDetailDto();
            subComBudgetForecastDto.setBudgetForecastCode(designBudgetEntity.getBudgetForecastCode());
            subComBudgetForecastDto.setOperationType(ForecastOperationTypeEnum.RETURN.getCode());
            subComBudgetForecastDto.setBusinessCode(designBudgetEntity.getActivityDesignDetailCode());
            subComBudgetForecastDto.setCurOperationAmount(designBudgetEntity.getBudgetAmount().negate());
            operationBudgetForecastList.add(subComBudgetForecastDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)operationBudgetForecastList)) {
            this.subComBudgetForecastService.operationBudgetForecast((List)operationBudgetForecastList);
        }
    }

    @Override
    public void deleteByModifyCodeList(List<String> modifyCodeList) {
        this.subComActivityDesignDetailModifyRepository.deleteByModifyCodeList(modifyCodeList);
    }

    @Override
    public void useMonthBudgetByModifyCode(String modifyCode) {
    }

    @Override
    public void returnMonthBudgetByModifyCode(String modifyCode) {
    }

    @Override
    public List<SubComActivityDesignDetailModifyVo> findSameModifyActivityByDesignDetailCode(List<String> activityDetailCodes) {
        if (org.springframework.util.CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        List<SubComActivityDesignDetailModifyVo> list = this.subComActivityDesignDetailRepository.findSameModifyActivityByDesignDetailCode(activityDetailCodes);
        if (org.springframework.util.CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }
}

