/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.month.budget.sdk.service.MonthBudgetService;
import com.biz.crm.tpm.business.month.budget.sdk.vo.MonthBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignBudgetModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignDetailModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.repository.SubComActivityDesignDetailModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignDetailModifyVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignFeeDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignPlanDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignPlanService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubComActivityDesignModifyPageCacheHelper
extends MnPageCacheHelper<SubComActivityDesignDetailModifyVo, SubComActivityDesignDetailModifyDto> {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignModifyPageCacheHelper.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SubComActivityDesignDetailModifyRepository subComActivityDesignDetailModifyRepository;
    @Autowired(required=false)
    private SubComActivityDesignDetailService subComActivityDesignDetailService;
    @Autowired(required=false)
    private SubComActivityDesignPlanService subComActivityDesignPlanService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private MonthBudgetService monthBudgetService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;

    public String getCacheKeyPrefix() {
        return "activity_const_design:detail_modify_cache:";
    }

    public Class<SubComActivityDesignDetailModifyDto> getDtoClass() {
        return SubComActivityDesignDetailModifyDto.class;
    }

    public Class<SubComActivityDesignDetailModifyVo> getVoClass() {
        return SubComActivityDesignDetailModifyVo.class;
    }

    public List<SubComActivityDesignDetailModifyDto> findDtoListFromRepository(SubComActivityDesignDetailModifyDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getModifyCode())) {
            return Lists.newArrayList();
        }
        return this.subComActivityDesignDetailModifyRepository.findDtoAndAttachListByDetailPlanCode(dto.getModifyCode());
    }

    public List<SubComActivityDesignDetailModifyDto> newItem(String cacheKey, List<SubComActivityDesignDetailModifyDto> itemList) {
        List<SubComActivityDesignDetailModifyDto> newItemList = new ArrayList<SubComActivityDesignDetailModifyDto>();
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List updateCodes = itemList.stream().filter(item -> idList.contains(this.getDtoKey((SubComActivityDesignDetailModifyDto)((Object)item)))).map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemList = itemList.stream().filter(item -> !updateCodes.contains(item.getActivityDesignDetailCode())).collect(Collectors.toList()))) {
            newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, SubComActivityDesignDetailModifyDto.class, SubComActivityDesignDetailModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
            for (SubComActivityDesignDetailModifyDto newItem : newItemList) {
                newItem.setId(UUID.randomUUID().toString().replace("-", ""));
                newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                newItem.setModifyCode(null);
            }
        }
        return newItemList;
    }

    public List<SubComActivityDesignDetailModifyDto> copyItem(String cacheKey, List<SubComActivityDesignDetailModifyDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, SubComActivityDesignDetailModifyDto.class, SubComActivityDesignDetailModifyDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (SubComActivityDesignDetailModifyDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setModifyCode(null);
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<SubComActivityDesignDetailModifyDto> itemList) {
        this.buildDownAmount(itemList);
    }

    public Object getDtoKey(SubComActivityDesignDetailModifyDto dto) {
        return dto.getId();
    }

    public String getCheckedStatus(SubComActivityDesignDetailModifyDto dto) {
        return dto.getChecked();
    }

    private void buildDownAmount(List<SubComActivityDesignDetailModifyDto> itemList) {
        List designDetailCodes = itemList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).distinct().collect(Collectors.toList());
        if (designDetailCodes.size() != itemList.size()) {
            throw new IllegalArgumentException("\u540c\u4e00\u89c4\u5212\u660e\u7ec6\uff0c\u4e0d\u53ef\u540c\u65f6\u6709\u591a\u4e2a\u53d8\u66f4\u660e\u7ec6");
        }
        List designDetailVos = this.subComActivityDesignDetailService.findDetailByDetailCodes(designDetailCodes);
        List relationUpDetailPlanVoList = designDetailVos.stream().filter(d -> RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(d.getAssociationType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(relationUpDetailPlanVoList)) {
            log.info("\u89c4\u5212\u53d8\u66f4,\u65e0\u2018\u5411\u4e0a\u5173\u8054\u7ec6\u6848\u2019\u89c4\u5212\u53d8\u66f4\u3002");
            return;
        }
        List relationUpDetailPlanList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(relationUpDetailPlanVoList, SubComActivityDesignDetailVo.class, SubComActivityDesignDetailDto.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList<SubComActivityDesignDetailDto> designDetailDtoList = new ArrayList<SubComActivityDesignDetailDto>();
        Map relationUpDetailPlanMap = relationUpDetailPlanList.stream().collect(Collectors.toMap(SubComActivityDesignDetailDto::getActivityDesignDetailCode, Function.identity()));
        for (SubComActivityDesignDetailModifyDto item : itemList) {
            Object totalCost;
            SubComActivityDesignDetailDto subComActivityDesignDetailDto = (SubComActivityDesignDetailDto)relationUpDetailPlanMap.get(item.getActivityDesignDetailCode());
            if (Objects.isNull(subComActivityDesignDetailDto)) continue;
            BigDecimal modifyTotalCost = Optional.ofNullable(item.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal diffAmount = modifyTotalCost.subtract((BigDecimal)(totalCost = Optional.ofNullable(subComActivityDesignDetailDto.getTotalCost()).orElse(BigDecimal.ZERO)));
            if (diffAmount.compareTo(BigDecimal.ZERO) == 0) {
                log.info("\u89c4\u5212\u53d8\u66f4,\u2018\u5411\u4e0a\u5173\u8054\u7ec6\u6848\u2019\u89c4\u5212,\u8d39\u7528\u672a\u53d8\u66f4,\u65e0\u9700\u5212\u5206\u8d39\u7528");
                continue;
            }
            if (diffAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            designDetailDtoList.add(subComActivityDesignDetailDto);
        }
        if (CollectionUtils.isEmpty(designDetailDtoList)) {
            log.info("\u89c4\u5212\u53d8\u66f4,\u65e0\u8d39\u7528\u53d8\u66f4\u7684\u2018\u5411\u4e0a\u5173\u8054\u7ec6\u6848\u2019\u89c4\u5212");
            return;
        }
        HashSet monthBudgetCodeSet = new HashSet();
        List codes = designDetailDtoList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).collect(Collectors.toList());
        List designPlanVos = this.subComActivityDesignPlanService.listByDesignDetailCodes(codes);
        if (CollectionUtils.isEmpty((Collection)designPlanVos)) {
            throw new IllegalArgumentException("\u89c4\u5212\u53d8\u66f4,\u2018\u5411\u4e0a\u5173\u8054\u7ec6\u6848\u2019\u89c4\u5212,\u672a\u67e5\u8be2\u5230\u5173\u8054\u7ec6\u6848\u660e\u7ec6\u3002\u89c4\u5212\u660e\u7ec6\u7f16\u7801:{" + codes + "}");
        }
        Map<String, List<SubComActivityDesignPlanDto>> subDesignPlanMap = designPlanVos.stream().collect(Collectors.groupingBy(SubComActivityDesignPlanDto::getActivityDesignDetailCode));
        for (SubComActivityDesignDetailDto designDetailDto : designDetailDtoList) {
            List<SubComActivityDesignPlanDto> planDtoList = subDesignPlanMap.get(designDetailDto.getActivityDesignDetailCode());
            if (CollectionUtils.isEmpty(planDtoList)) {
                throw new IllegalArgumentException("\u89c4\u5212\u53d8\u66f4\uff0c\u2018\u5411\u4e0a\u5173\u8054\u7ec6\u6848\u2019\u89c4\u5212[" + designDetailDto.getActivityDesignDetailCode() + "],\u672a\u83b7\u53d6\u5230\u5173\u8054\u7ec6\u6848\u8be6\u60c5\uff01");
            }
            designDetailDto.setPlanList(planDtoList);
        }
        List detailPlanItemCodeList = designPlanVos.stream().filter(plan -> RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(plan.getAssociationType())).map(SubComActivityDesignPlanDto::getPlanDetailCode).distinct().collect(Collectors.toList());
        List activityDetailPlanItemVos = this.activityDetailPlanItemSdkService.listByItemCodeList(new ArrayList(detailPlanItemCodeList));
        activityDetailPlanItemVos.forEach(activityDetailPlanItemVo -> monthBudgetCodeSet.addAll(((List)Optional.ofNullable(activityDetailPlanItemVo.getBudgetShares()).orElse(new ArrayList())).stream().map(ActivityDetailPlanBudgetVo::getMonthBudgetCode).collect(Collectors.toSet())));
        Map<String, ActivityDetailPlanItemVo> detailPlanItemMap = activityDetailPlanItemVos.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
        List monthBudgetVoList = this.monthBudgetService.listByCodes(new ArrayList(monthBudgetCodeSet));
        Map<String, MonthBudgetVo> monthBudgetVoMap = monthBudgetVoList.stream().collect(Collectors.toMap(MonthBudgetVo::getMonthBudgetCode, Function.identity()));
        Set customerCodeSet = monthBudgetVoList.stream().map(MonthBudgetVo::getCustomerCode).collect(Collectors.toSet());
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.listBySubComOrgCodeList(new ArrayList(customerCodeSet));
        Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap = salesOrgSubComOrgVos.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSubComOrgCode, Function.identity()));
        Map<String, SubComActivityDesignDetailModifyDto> modifyItemMap = itemList.stream().collect(Collectors.toMap(SubComActivityDesignDetailDto::getActivityDesignDetailCode, Function.identity()));
        this.refreshDownAmount(designDetailDtoList, modifyItemMap, detailPlanItemMap, monthBudgetVoMap, salesOrgSubComOrgVoMap);
    }

    private void refreshDownAmount(List<SubComActivityDesignDetailDto> designDetailList, Map<String, SubComActivityDesignDetailModifyDto> modifyItemMap, Map<String, ActivityDetailPlanItemVo> detailPlanItemMap, Map<String, MonthBudgetVo> monthBudgetVoMap, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        for (int index = designDetailList.size() - 1; index >= 0; --index) {
            if (!RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(designDetailList.get(index).getAssociationType())) continue;
            if (designDetailList.get(index).getTotalCost() == null) {
                throw new IllegalArgumentException("\u89c4\u5212\u53d8\u66f4\uff0c\u8981\u53d8\u66f4\u7684\u89c4\u5212[" + designDetailList.get(index).getActivityDesignDetailCode() + "],\u8d39\u7528\u5408\u8ba1\u4e0d\u80fd\u4e3a\u7a7a");
            }
            SubComActivityDesignDetailModifyDto modifyItemDto = modifyItemMap.get(designDetailList.get(index).getActivityDesignDetailCode());
            if (Objects.isNull((Object)modifyItemDto)) {
                throw new IllegalArgumentException("\u89c4\u5212\u53d8\u66f4,null,\u53d8\u66f4\u7684\u89c4\u5212\u672a\u5bf9\u5e94\u4e0a\u53d8\u66f4\u660e\u7ec6,\u89c4\u5212\u7f16\u7801\u3010" + designDetailList.get(index).getActivityDesignCode() + "\u3011\u3010" + designDetailList.get(index).getActivityDesignDetailCode() + "\u3011");
            }
            BigDecimal modifyTotalCost = Optional.ofNullable(modifyItemDto.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal totalCost = Optional.ofNullable(designDetailList.get(index).getTotalCost()).orElse(BigDecimal.ZERO);
            AtomicReference<BigDecimal> totalCostAmount = new AtomicReference<BigDecimal>(modifyTotalCost.subtract(totalCost));
            AtomicReference<BigDecimal> internalAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            AtomicReference<BigDecimal> offAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
            SubComActivityDesignFeeDetailDto designFeeDetailDto = new SubComActivityDesignFeeDetailDto();
            designFeeDetailDto.setThisUseAmount(totalCostAmount.get());
            designDetailList.get(index).setFeeDetail(designFeeDetailDto);
            designDetailList.get(index).getPlanList().forEach(plan -> {
                if (RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(plan.getAssociationType())) {
                    if (!detailPlanItemMap.containsKey(plan.getPlanDetailCode())) {
                        throw new RuntimeException("\u7ec6\u6848\u660e\u7ec6" + plan.getPlanDetailCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    ActivityDetailPlanItemVo activityDetailPlanItemVo = (ActivityDetailPlanItemVo)detailPlanItemMap.get(plan.getPlanDetailCode());
                    if (BooleanEnum.TRUE.getCapital().equals(activityDetailPlanItemVo.getIsAllDown())) {
                        return;
                    }
                    BigDecimal downAmount = Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal offPointAmount = Optional.ofNullable(activityDetailPlanItemVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(activityDetailPlanItemVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)).subtract(Optional.ofNullable(activityDetailPlanItemVo.getIntraCompanyAmount()).orElse(BigDecimal.ZERO));
                    BigDecimal intraCompanyAmount = Optional.ofNullable(activityDetailPlanItemVo.getIntraCompanyAmount()).orElse(BigDecimal.ZERO);
                    if (offPointAmount.compareTo(downAmount) >= 0) {
                        offAmount.set(((BigDecimal)offAmount.get()).add(offPointAmount.subtract(downAmount)));
                        internalAmount.set(((BigDecimal)internalAmount.get()).add(intraCompanyAmount));
                    } else {
                        internalAmount.set(((BigDecimal)internalAmount.get()).add(intraCompanyAmount).add(offPointAmount.subtract(downAmount)));
                    }
                }
            });
            this.refreshDownAmount(designDetailList, modifyItemMap, index, detailPlanItemMap, totalCostAmount, offAmount, internalAmount, salesOrgSubComOrgVoMap);
        }
    }

    private void refreshDownAmount(List<SubComActivityDesignDetailDto> designDetailList, Map<String, SubComActivityDesignDetailModifyDto> modifyItemMap, int index, Map<String, ActivityDetailPlanItemVo> detailPlanItemMap, AtomicReference<BigDecimal> totalCostAmount, AtomicReference<BigDecimal> offAmount, AtomicReference<BigDecimal> internalAmount, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        AtomicReference<BigDecimal> offOccAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> internalOccAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        AtomicReference<BigDecimal> autoOccAmount = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (totalCostAmount.get().compareTo(offAmount.get()) >= 0) {
            designDetailList.get(index).getFeeDetail().setOffAmount(offAmount.get());
            totalCostAmount.set(totalCostAmount.get().subtract(offAmount.get()));
        } else {
            designDetailList.get(index).getFeeDetail().setOffAmount(totalCostAmount.get());
            totalCostAmount.set(BigDecimal.ZERO);
        }
        offOccAmount.set(designDetailList.get(index).getFeeDetail().getOffAmount());
        if (totalCostAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            if (totalCostAmount.get().compareTo(internalAmount.get()) >= 0) {
                designDetailList.get(index).getFeeDetail().setInternalAmount(internalAmount.get());
                totalCostAmount.set(totalCostAmount.get().subtract(internalAmount.get()));
            } else {
                designDetailList.get(index).getFeeDetail().setInternalAmount(totalCostAmount.get());
                totalCostAmount.set(BigDecimal.ZERO);
            }
        } else {
            designDetailList.get(index).getFeeDetail().setInternalAmount(BigDecimal.ZERO);
        }
        internalOccAmount.set(designDetailList.get(index).getFeeDetail().getInternalAmount());
        if (totalCostAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            designDetailList.get(index).getFeeDetail().setAutoAmount(totalCostAmount.get());
        } else {
            designDetailList.get(index).getFeeDetail().setAutoAmount(BigDecimal.ZERO);
        }
        autoOccAmount.set(designDetailList.get(index).getFeeDetail().getAutoAmount());
        ArrayList<SubComActivityDesignBudgetModifyDto> budgetModifyList = new ArrayList<SubComActivityDesignBudgetModifyDto>();
        int finalIndex = index;
        designDetailList.get(index).getPlanList().forEach(plan -> {
            if (RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(plan.getAssociationType())) {
                this.refreshDownDetailPlanAmount(designDetailList, finalIndex, (SubComActivityDesignPlanDto)plan, detailPlanItemMap, (List<SubComActivityDesignBudgetModifyDto>)budgetModifyList, offOccAmount, internalOccAmount, autoOccAmount, salesOrgSubComOrgVoMap);
            }
        });
        SubComActivityDesignDetailModifyDto modifyItemDto = modifyItemMap.get(designDetailList.get(index).getActivityDesignDetailCode());
        modifyItemDto.setBudgetModifyList(budgetModifyList);
    }

    private void refreshDownDetailPlanAmount(List<SubComActivityDesignDetailDto> designDetailList, int finalIndex, SubComActivityDesignPlanDto plan, Map<String, ActivityDetailPlanItemVo> detailPlanItemMap, List<SubComActivityDesignBudgetModifyDto> budgetModifyList, AtomicReference<BigDecimal> offOccAmount, AtomicReference<BigDecimal> internalOccAmount, AtomicReference<BigDecimal> autoOccAmount, Map<String, SalesOrgSubComOrgVo> salesOrgSubComOrgVoMap) {
        SubComActivityDesignBudgetModifyDto budgetModifyDto;
        SubComActivityDesignBudgetModifyDto budgetModifyDto2;
        ActivityDetailPlanItemVo activityDetailPlanItemVo = detailPlanItemMap.get(plan.getPlanDetailCode());
        BigDecimal headFeeAmount = Optional.ofNullable(activityDetailPlanItemVo.getHeadFeeAmount()).orElse(BigDecimal.ZERO);
        plan.setApplyAmount(headFeeAmount.add(Optional.ofNullable(activityDetailPlanItemVo.getDepartmentFeeAmount()).orElse(BigDecimal.ZERO)));
        plan.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO));
        plan.setReminderDownAmount(plan.getApplyAmount().subtract(plan.getDownAmount()));
        BigDecimal planOffpointAmount = Optional.ofNullable(activityDetailPlanItemVo.getOffPointAmount()).orElse(BigDecimal.ZERO);
        if (offOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            if (offOccAmount.get().compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            if (headFeeAmount.compareTo(BigDecimal.ZERO) > 0) {
                budgetModifyDto2 = new SubComActivityDesignBudgetModifyDto();
                if (offOccAmount.get().compareTo(headFeeAmount) > 0) {
                    offOccAmount.set(offOccAmount.get().subtract(headFeeAmount));
                    budgetModifyDto2.setBudgetAmount(headFeeAmount);
                    activityDetailPlanItemVo.setIsAllDown(BooleanEnum.TRUE.getCapital());
                    activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(headFeeAmount));
                } else {
                    budgetModifyDto2.setBudgetAmount(offOccAmount.get());
                    budgetModifyDto2.setDownAmount(planOffpointAmount.add(offOccAmount.get()));
                    budgetModifyDto2.setIsAllDown(BooleanEnum.FALSE.getCapital());
                    offOccAmount.set(BigDecimal.ZERO);
                    activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(offOccAmount.get()));
                }
                budgetModifyDto2.setAssociationType(RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode());
                budgetModifyDto2.setFeeSourceCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
                budgetModifyDto2.setBudgetItemCode(activityDetailPlanItemVo.getHeadBudgetItemCode());
                budgetModifyDto2.setBudgetItemName(activityDetailPlanItemVo.getHeadBudgetItemName());
                budgetModifyDto2.setPlanCode(activityDetailPlanItemVo.getDetailPlanCode());
                budgetModifyDto2.setPlanName(plan.getPlanName());
                budgetModifyDto2.setPlanDetailCode(activityDetailPlanItemVo.getDetailPlanItemCode());
                budgetModifyDto2.setDownAmount(activityDetailPlanItemVo.getDownAmount());
                budgetModifyDto2.setIsAllDown(activityDetailPlanItemVo.getIsAllDown());
                budgetModifyList.add(budgetModifyDto2);
            }
        }
        if (offOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            if (offOccAmount.get().compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            if (planOffpointAmount.compareTo(BigDecimal.ZERO) > 0) {
                budgetModifyDto2 = new SubComActivityDesignBudgetModifyDto();
                if (offOccAmount.get().compareTo(planOffpointAmount) > 0) {
                    offOccAmount.set(offOccAmount.get().subtract(planOffpointAmount));
                    budgetModifyDto2.setBudgetAmount(planOffpointAmount);
                    activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(planOffpointAmount).orElse(BigDecimal.ZERO).add(planOffpointAmount));
                    activityDetailPlanItemVo.setIsAllDown(BooleanEnum.TRUE.getCapital());
                    activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(planOffpointAmount));
                } else {
                    budgetModifyDto2.setBudgetAmount(offOccAmount.get());
                    budgetModifyDto2.setDownAmount(Optional.ofNullable(planOffpointAmount).orElse(BigDecimal.ZERO).add(offOccAmount.get()));
                    budgetModifyDto2.setIsAllDown(BooleanEnum.FALSE.getCapital());
                    offOccAmount.set(BigDecimal.ZERO);
                    activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(offOccAmount.get()));
                }
                budgetModifyDto2.setAssociationType(RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode());
                budgetModifyDto2.setFeeSourceCode(FeeSourceEnum.OFF_POINT_FEE.getCode());
                budgetModifyDto2.setBudgetItemCode(activityDetailPlanItemVo.getBudgetItemCode());
                budgetModifyDto2.setBudgetItemName(activityDetailPlanItemVo.getBudgetItemName());
                budgetModifyDto2.setPlanCode(activityDetailPlanItemVo.getDetailPlanCode());
                budgetModifyDto2.setPlanName(plan.getPlanName());
                budgetModifyDto2.setPlanDetailCode(activityDetailPlanItemVo.getDetailPlanItemCode());
                budgetModifyDto2.setDownAmount(activityDetailPlanItemVo.getDownAmount());
                budgetModifyDto2.setIsAllDown(activityDetailPlanItemVo.getIsAllDown());
                budgetModifyList.add(budgetModifyDto2);
            }
        }
        BigDecimal planIntraCompanyAmount = Optional.ofNullable(activityDetailPlanItemVo.getIntraCompanyAmount()).orElse(BigDecimal.ZERO);
        if (internalOccAmount.get().compareTo(BigDecimal.ZERO) > 0 && planIntraCompanyAmount.compareTo(BigDecimal.ZERO) > 0) {
            budgetModifyDto = new SubComActivityDesignBudgetModifyDto();
            if (internalOccAmount.get().compareTo(planIntraCompanyAmount) > 0) {
                internalOccAmount.set(internalOccAmount.get().subtract(planIntraCompanyAmount));
                budgetModifyDto.setBudgetAmount(planIntraCompanyAmount);
                activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(planIntraCompanyAmount));
                activityDetailPlanItemVo.setIsAllDown(BooleanEnum.TRUE.getCapital());
            } else {
                budgetModifyDto.setBudgetAmount(internalOccAmount.get());
                activityDetailPlanItemVo.setDownAmount(Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO).add(internalOccAmount.get()));
                activityDetailPlanItemVo.setIsAllDown(BooleanEnum.FALSE.getCapital());
                internalOccAmount.set(BigDecimal.ZERO);
            }
            budgetModifyDto.setAssociationType(RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode());
            budgetModifyDto.setBudgetItemCode(activityDetailPlanItemVo.getBudgetItemCode());
            budgetModifyDto.setBudgetItemName(activityDetailPlanItemVo.getBudgetItemName());
            budgetModifyDto.setPlanCode(activityDetailPlanItemVo.getDetailPlanCode());
            budgetModifyDto.setPlanName(plan.getPlanName());
            budgetModifyDto.setPlanDetailCode(activityDetailPlanItemVo.getDetailPlanItemCode());
            budgetModifyDto.setDownAmount(activityDetailPlanItemVo.getDownAmount());
            budgetModifyDto.setIsAllDown(activityDetailPlanItemVo.getIsAllDown());
            budgetModifyDto.setFeeSourceCode(FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
            budgetModifyList.add(budgetModifyDto);
        }
        if (autoOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            budgetModifyDto = new SubComActivityDesignBudgetModifyDto();
            budgetModifyDto.setAssociationType(RelationTypeEnum.NO_RELATION.getCode());
            budgetModifyDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
            budgetModifyDto.setBudgetItemCode("A023");
            budgetModifyDto.setBudgetItemName("\u5206\u516c\u53f8\u81ea\u6295");
            budgetModifyDto.setBudgetAmount(autoOccAmount.get());
            budgetModifyList.add(budgetModifyDto);
        }
        String yearMonthLy = DateUtil.format((Date)designDetailList.get(finalIndex).getFeeYearMonth(), (String)"yyyy-MM");
        budgetModifyList.forEach(item -> item.setYearMonthLy(yearMonthLy));
        BigDecimal downAmount = Optional.ofNullable(activityDetailPlanItemVo.getDownAmount()).orElse(BigDecimal.ZERO);
        if (planOffpointAmount.add(planIntraCompanyAmount).compareTo(downAmount) <= 0) {
            activityDetailPlanItemVo.setIsAllDown(BooleanEnum.TRUE.getCapital());
        }
        if (offOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            throw new IllegalArgumentException("\u5173\u8054\u7ec6\u6848\u70b9\u5916\u8d39\u7528\u4e0d\u8db3\uff01");
        }
        if (internalOccAmount.get().compareTo(BigDecimal.ZERO) > 0) {
            throw new IllegalArgumentException("\u5173\u8054\u7ec6\u6848\u70b9\u5185\u8d39\u7528\u4e0d\u8db3\uff01");
        }
        detailPlanItemMap.put(plan.getPlanDetailCode(), activityDetailPlanItemVo);
    }
}

