/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.enums.ForecastOperationTypeEnum;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemMainItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignBudgetModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignDetailModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.dto.SubComActivityDesignModifyDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.entity.SubComActivityDesignBudgetModify;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.entity.SubComActivityDesignModify;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.repository.SubComActivityDesignBudgetModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.repository.SubComActivityDesignModifyRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignBudgetModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignDetailModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignModifyDiffService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.service.SubComActivityDesignModifyService;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignDetailModifyVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignModifyDiffVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.local.modify.vo.SubComActivityDesignModifyVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignBudgetDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.TotalQuantityOrNotEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.UndertakingModeTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.dto.SubComActivityPlanItemFeeDto;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.enums.SubPlanStatusEnum;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.service.SubComActivityPlanItemService;
import com.biz.crm.tpm.business.subsidiary.activity.plan.sdk.vo.SubComActivityPlanItemVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.enums.IndicatorNameEnum;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.vo.AuditExecuteIndicatorVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SubComActivityDesignModifyServiceImpl
implements SubComActivityDesignModifyService {
    private static final Logger log = LoggerFactory.getLogger(SubComActivityDesignModifyServiceImpl.class);
    @Autowired(required=false)
    private SubComActivityDesignModifyRepository subComActivityDesignModifyRepository;
    @Autowired(required=false)
    private SubComActivityDesignDetailModifyService subComActivityDesignDetailModifyService;
    @Autowired(required=false)
    private SubComActivityDesignBudgetModifyService subComActivityDesignBudgetModifyService;
    @Autowired(required=false)
    private SubComActivityDesignBudgetModifyRepository subComActivityDesignBudgetModifyRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private SubComActivityDesignDetailService subComActivityDesignDetailService;
    @Autowired(required=false)
    private SubComActivityDesignBudgetService subComActivityDesignBudgetService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private BudgetItemMainItemService budgetItemMainItemService;
    @Autowired(required=false)
    private SubComActivityPlanItemService subComActivityPlanItemService;
    @Autowired(required=false)
    private SubComActivityDesignModifyDiffService subComActivityDesignModifyDiffService;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    @Override
    public void create(String cacheKey, SubComActivityDesignModifyDto dto) {
        List itemList = this.subComActivityDesignDetailModifyService.findCacheList(cacheKey);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)itemList)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u53d8\u66f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        Map<String, SubComActivityDesignDetailVo> designDetailVoMap = this.createValidate(dto, itemList);
        this.buildNoRelationAmount(dto, itemList, designDetailVoMap);
        List<SubComActivityPlanItemFeeDto> subPlanItemFeeList = this.buildRelationSubPlanBudgetAmount(dto, itemList, designDetailVoMap);
        this.divideExpenses(dto, itemList, designDetailVoMap);
        boolean update = !StringUtils.isBlank((CharSequence)dto.getId());
        this.saveModifyData(dto, update, itemList);
        if (!Objects.isNull(dto.getProcessBusiness())) {
            this.submit(dto, true);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveModifyData(SubComActivityDesignModifyDto dto, boolean update, List<SubComActivityDesignDetailModifyDto> itemList) {
        if (Objects.isNull((Object)dto) || org.springframework.util.CollectionUtils.isEmpty(itemList)) {
            return;
        }
        SubComActivityDesignModify entity = null;
        if (!update) {
            entity = (SubComActivityDesignModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComActivityDesignModify.class, HashSet.class, ArrayList.class, new String[0]));
            String code = (String)this.generateCodeService.generateCode("FZGC", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            entity.setModifyCode(code);
            dto.setModifyCode(code);
            entity.setProcessStatus(ProcessStatusEnum.PREPARE.getKey());
            entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            entity.setTenantCode(TenantContextHolder.getTenantInfo().getTenantCode());
            this.subComActivityDesignModifyRepository.save((Object)entity);
        } else {
            SubComActivityDesignModify oldEntity = (SubComActivityDesignModify)((Object)this.subComActivityDesignModifyRepository.getById((Serializable)((Object)dto.getId())));
            entity = (SubComActivityDesignModify)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, SubComActivityDesignModify.class, HashSet.class, ArrayList.class, new String[0]));
            entity.setModifyCode(oldEntity.getModifyCode());
            entity.setTenantCode(oldEntity.getTenantCode());
            entity.setCreateName(oldEntity.getCreateName());
            entity.setPositionCode(oldEntity.getPositionCode());
            entity.setPositionName(oldEntity.getPositionName());
            entity.setOrgCode(oldEntity.getOrgCode());
            entity.setOrgName(oldEntity.getOrgName());
            this.subComActivityDesignModifyRepository.updateById((Object)entity);
        }
        this.subComActivityDesignDetailModifyService.saveItemList(entity, update, itemList);
        this.subComActivityDesignBudgetModifyService.saveSubComActivityDesignBudgetModifyList(entity, update, itemList);
        this.subComActivityDesignModifyDiffService.saveOrUpdateDiffList(entity, dto.getDiff());
    }

    private List<SubComActivityPlanItemFeeDto> buildRelationSubPlanBudgetAmount(SubComActivityDesignModifyDto dto, List<SubComActivityDesignDetailModifyDto> itemList, Map<String, SubComActivityDesignDetailVo> designDetailVoMap) {
        if (Objects.isNull((Object)dto) || org.springframework.util.CollectionUtils.isEmpty(itemList) || org.springframework.util.CollectionUtils.isEmpty(designDetailVoMap)) {
            return Lists.newArrayList();
        }
        ArrayList<SubComActivityDesignDetailVo> designDetailList = new ArrayList<SubComActivityDesignDetailVo>();
        HashMap<String, SubComActivityDesignDetailModifyDto> modifyDetailMap = new HashMap<String, SubComActivityDesignDetailModifyDto>();
        List relationModifyDto = itemList.stream().filter(i -> RelationTypeEnum.UP_SUB_PLAN.getCode().equals(i.getAssociationType()) && UndertakingModeTypeEnum.FULL_ACCEPT.getCode().equals(i.getUndertakingMode())).collect(Collectors.toList());
        for (SubComActivityDesignDetailModifyDto modifyDetailDto : relationModifyDto) {
            BigDecimal totalCost;
            SubComActivityDesignDetailVo designDetailVo = designDetailVoMap.get(modifyDetailDto.getActivityDesignDetailCode());
            if (Objects.isNull(designDetailVo) || !RelationTypeEnum.UP_SUB_PLAN.getCode().equals(designDetailVo.getAssociationType())) continue;
            BigDecimal modifyTotalCost = Optional.ofNullable(modifyDetailDto.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal diffAmount = modifyTotalCost.subtract(totalCost = Optional.ofNullable(designDetailVo.getTotalCost()).orElse(BigDecimal.ZERO));
            if (diffAmount.compareTo(BigDecimal.ZERO) == 0) {
                log.info("\u89c4\u5212\u53d8\u66f4,\u2018\u5411\u4e0a\u5173\u8054\u5206\u5b50\u65b9\u6848\u2019\u89c4\u5212,\u8d39\u7528\u672a\u53d8\u66f4,\u65e0\u9700\u5212\u5206\u8d39\u7528");
                continue;
            }
            if (diffAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            designDetailList.add(designDetailVo);
            modifyDetailMap.put(modifyDetailDto.getActivityDesignDetailCode(), modifyDetailDto);
        }
        if (org.springframework.util.CollectionUtils.isEmpty(designDetailList)) {
            return Lists.newArrayList();
        }
        List associatedDateCodes = designDetailList.stream().map(SubComActivityDesignDetailVo::getAssociatedDateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Validate.isTrue((designDetailList.size() == associatedDateCodes.size() ? 1 : 0) != 0, (String)"\u5411\u4e0a\u5173\u8054\u5206\u5b50\u65b9\u6848\u65f6,\u5173\u8054\u6570\u636e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List subActivityPlanItemList = this.subComActivityPlanItemService.findByItemCodes(associatedDateCodes);
        Validate.notEmpty((Collection)subActivityPlanItemList, (String)"\u672a\u67e5\u8be2\u5230\u5206\u5b50\u516c\u53f8\u65b9\u6848\u4fe1\u606f!", (Object[])new Object[0]);
        subActivityPlanItemList.forEach(planItem -> Validate.isTrue((boolean)SubPlanStatusEnum.EXECUTING.getCode().equals(planItem.getActivityStatus()), (String)("\u5206\u5b50\u65b9\u6848\u3010" + planItem.getSubActivityPlanCode() + "\u3011\u3010" + planItem.getSubActivityPlanItemCode() + "\u3011,\u72b6\u6001\u672a\u5728\u6267\u884c\u4e2d\uff01"), (Object[])new Object[0]));
        Map subPlanItemMap = subActivityPlanItemList.stream().collect(Collectors.toMap(SubComActivityPlanItemVo::getSubActivityPlanItemCode, Function.identity()));
        List budgetItemCodes = subActivityPlanItemList.stream().map(SubComActivityPlanItemVo::getBudgetItemCode).distinct().collect(Collectors.toList());
        List feeYearMonthList = subActivityPlanItemList.stream().map(SubComActivityPlanItemVo::getFeeYearMonth).distinct().collect(Collectors.toList());
        SubComBudgetForecastDto subBudgetDto = new SubComBudgetForecastDto();
        subBudgetDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subBudgetDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        subBudgetDto.setOrgCode(dto.getOrgCode());
        subBudgetDto.setYearMonthList(feeYearMonthList);
        subBudgetDto.setBudgetItemCodeList(budgetItemCodes);
        List subComBudgetForecastVos = this.subComBudgetForecastService.listByConditions(subBudgetDto);
        if (subComBudgetForecastVos == null || subComBudgetForecastVos.size() == 0) {
            log.info("\u5173\u8054\u5206\u5b50\u65b9\u6848\u65f6\uff0c\u67e5\u8be2\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9884\u7b97\u9884\u6d4b\uff01\u67e5\u8be2\u6761\u4ef6:{}", (Object)subBudgetDto);
            throw new RuntimeException("\u89c4\u5212\u5173\u8054\u5206\u5b50\u65b9\u6848\u67e5\u8be2\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u5931\u8d25,\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u9884\u7b97\u9884\u6d4b");
        }
        Map subComBudgetForecastMap = subComBudgetForecastVos.stream().collect(Collectors.toMap(b -> b.getYearMonthLy() + "-" + b.getFeeSourceCode() + "-" + b.getBudgetItemCode(), Function.identity()));
        HashMap<String, BigDecimal> planCostMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> forecastCostMap = new HashMap<String, BigDecimal>();
        ArrayList<SubComActivityPlanItemFeeDto> planItemFeeList = new ArrayList<SubComActivityPlanItemFeeDto>();
        for (SubComActivityDesignDetailVo designDetail : designDetailList) {
            SubComActivityDesignDetailModifyDto modifyDetailDto = (SubComActivityDesignDetailModifyDto)((Object)modifyDetailMap.get(designDetail.getActivityDesignDetailCode()));
            BigDecimal modifyTotalCost = Optional.ofNullable(modifyDetailDto.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal totalCost = Optional.ofNullable(designDetail.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal diffAmount = modifyTotalCost.subtract(totalCost);
            SubComActivityPlanItemVo subPlanItem = (SubComActivityPlanItemVo)subPlanItemMap.get(designDetail.getAssociatedDateCode());
            Validate.notNull((Object)subPlanItem, (String)"\u672a\u67e5\u8be2\u5230\u5173\u8054\u7684\u5206\u5b50\u516c\u53f8\u65b9\u6848\uff0c\u5173\u8054\u7f16\u7801:{}", (Object[])new Object[]{designDetail.getAssociatedDateCode()});
            BigDecimal planCost = BigDecimal.ZERO;
            if (planCostMap.containsKey(subPlanItem.getSubActivityPlanItemCode())) {
                planCost = (BigDecimal)planCostMap.get(subPlanItem.getSubActivityPlanItemCode());
            } else {
                planCostMap.put(subPlanItem.getSubActivityPlanItemCode(), subPlanItem.getResidueAmount());
                planCost = subPlanItem.getResidueAmount();
            }
            Validate.isTrue((diffAmount.compareTo(planCost) < 0 ? 1 : 0) != 0, (String)("\u89c4\u5212\u4f7f\u7528\u9884\u7b97\u9879\u76ee" + subPlanItem.getSubActivityPlanItemCode() + ",\u8d39\u7528\u8d85\u8fc7\u4e86\u5206\u5b50\u65b9\u6848\u3010" + subPlanItem.getSubActivityPlanCode() + "\u3011\u3010" + subPlanItem.getSubActivityPlanItemCode() + "\u3011\u89c4\u5b9a\u989d\u5ea6\uff01"), (Object[])new Object[0]);
            SubComBudgetForecastVo budgetForecast = (SubComBudgetForecastVo)subComBudgetForecastMap.get(subPlanItem.getFeeYearMonth() + "-" + subPlanItem.getFeeSourceCode() + "-" + designDetail.getBudgetItemCode());
            Validate.notNull((Object)budgetForecast, (String)("\u672a\u67e5\u8be2\u5230\u5206\u5b50\u9884\u7b97\u9884\u6d4b\u4fe1\u606f\uff0c\u5173\u8054\u9884\u7b97\u7f16\u7801:" + designDetail.getBudgetItemCode()), (Object[])new Object[0]);
            BigDecimal remainderAmount = BigDecimal.ZERO;
            if (forecastCostMap.containsKey(budgetForecast.getBudgetForecastCode())) {
                remainderAmount = (BigDecimal)forecastCostMap.get(budgetForecast.getBudgetForecastCode());
            } else {
                forecastCostMap.put(budgetForecast.getBudgetForecastCode(), budgetForecast.getRemainderAmount());
            }
            if (diffAmount.compareTo(budgetForecast.getRemainderAmount()) <= 0) {
                SubComActivityDesignBudgetModifyDto budgetModifyDto = new SubComActivityDesignBudgetModifyDto();
                budgetModifyDto.setBudgetForecastCode(budgetForecast.getBudgetForecastCode());
                budgetModifyDto.setBudgetAmount(diffAmount);
                budgetModifyDto.setIsAllDown(diffAmount.compareTo(budgetForecast.getRemainderAmount()) == 0 ? BooleanEnum.TRUE.getCapital() : BooleanEnum.FALSE.getCapital());
                budgetModifyDto.setBusinessFormatCode(budgetForecast.getBusinessFormatCode());
                budgetModifyDto.setYearMonthLy(budgetForecast.getYearMonthLy());
                budgetModifyDto.setBudgetItemCode(budgetForecast.getBudgetItemCode());
                budgetModifyDto.setBudgetItemName(budgetForecast.getBudgetItemName());
                budgetModifyDto.setFeeSourceCode(budgetForecast.getFeeSourceCode());
                ArrayList<SubComActivityDesignBudgetModifyDto> budgetModifyDtoList = new ArrayList<SubComActivityDesignBudgetModifyDto>();
                budgetModifyDtoList.add(budgetModifyDto);
                modifyDetailDto.setBudgetModifyList(budgetModifyDtoList);
                SubComActivityPlanItemFeeDto planFee = new SubComActivityPlanItemFeeDto();
                planFee.setSubActivityPlanItemCode(subPlanItem.getSubActivityPlanItemCode());
                planFee.setBusinessUnitCode(budgetForecast.getBusinessUnitCode());
                planFee.setBudgetItemCode(budgetForecast.getBudgetItemCode());
                planFee.setBudgetItemName(budgetForecast.getBudgetItemName());
                planFee.setInitialAmount(subPlanItem.getTotalCost());
                planFee.setBeforeAmount(planCost);
                planFee.setCurOperationAmount(diffAmount);
                BigDecimal balanceAmount = planCost.subtract(diffAmount);
                planFee.setBalanceAmount(balanceAmount);
                planFee.setBusinessCode(designDetail.getActivityDesignDetailCode());
                planFee.setOperationType(ForecastOperationTypeEnum.USE.getCode());
                planFee.setRemark("\u89c4\u5212\u53d8\u66f4");
                planItemFeeList.add(planFee);
                forecastCostMap.put(budgetForecast.getBudgetForecastCode(), budgetForecast.getRemainderAmount().subtract(diffAmount));
                planCostMap.put(subPlanItem.getSubActivityPlanItemCode(), balanceAmount);
                continue;
            }
            throw new IllegalArgumentException("\u9884\u7b97\u9879\u76ee[" + designDetail.getBudgetItemCode() + "]\uff0c\u5269\u4f59\u8d39\u7528\u4e0d\u8db3\uff01");
        }
        Date date = new Date();
        String sortAsc = DateUtil.format((Date)date, (String)"yyyyMMddHHmmss");
        for (int i2 = 0; i2 <= planItemFeeList.size(); ++i2) {
            ((SubComActivityPlanItemFeeDto)planItemFeeList.get(i2)).setSortAsc(Long.valueOf(Long.parseLong(sortAsc + i2)));
            ++i2;
        }
        return planItemFeeList;
    }

    private void buildNoRelationAmount(SubComActivityDesignModifyDto dto, List<SubComActivityDesignDetailModifyDto> itemList, Map<String, SubComActivityDesignDetailVo> designDetailVoMap) {
        if (Objects.isNull((Object)dto) || org.springframework.util.CollectionUtils.isEmpty(itemList) || org.springframework.util.CollectionUtils.isEmpty(designDetailVoMap)) {
            return;
        }
        ArrayList<SubComActivityDesignDetailVo> designDetailList = new ArrayList<SubComActivityDesignDetailVo>();
        HashMap<String, SubComActivityDesignDetailModifyDto> modifyDetailMap = new HashMap<String, SubComActivityDesignDetailModifyDto>();
        List relationModifyDtos = itemList.stream().filter(i -> RelationTypeEnum.NO_RELATION.getCode().equals(i.getAssociationType()) && UndertakingModeTypeEnum.NO_ACCEPT.getCode().equals(i.getUndertakingMode())).collect(Collectors.toList());
        for (SubComActivityDesignDetailModifyDto modifyDetailDto : relationModifyDtos) {
            BigDecimal totalCost;
            SubComActivityDesignDetailVo designDetailVo = designDetailVoMap.get(modifyDetailDto.getActivityDesignDetailCode());
            if (Objects.isNull(designDetailVo) || !RelationTypeEnum.NO_RELATION.getCode().equals(designDetailVo.getAssociationType())) continue;
            BigDecimal modifyTotalCost = Optional.ofNullable(modifyDetailDto.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal diffAmount = modifyTotalCost.subtract(totalCost = Optional.ofNullable(designDetailVo.getTotalCost()).orElse(BigDecimal.ZERO));
            if (diffAmount.compareTo(BigDecimal.ZERO) == 0) {
                log.info("\u89c4\u5212\u53d8\u66f4,\u2018\u4e0d\u5173\u8054\u2019\u89c4\u5212,\u8d39\u7528\u672a\u53d8\u66f4,\u65e0\u9700\u5212\u5206\u8d39\u7528");
                continue;
            }
            if (diffAmount.compareTo(BigDecimal.ZERO) == 0) continue;
            designDetailList.add(designDetailVo);
            modifyDetailMap.put(modifyDetailDto.getActivityDesignDetailCode(), modifyDetailDto);
        }
        if (org.springframework.util.CollectionUtils.isEmpty(designDetailList)) {
            return;
        }
        Set yearMonthSet = designDetailList.stream().map(i -> DateUtil.format((Date)i.getFeeYearMonth(), (String)"yyyy-MM")).collect(Collectors.toSet());
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setOrgCode(dto.getOrgCode());
        subComBudgetForecastDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComBudgetForecastDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        subComBudgetForecastDto.setYearMonthList(new ArrayList(yearMonthSet));
        List subComBudgetForecastVoList = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)subComBudgetForecastVoList)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u67e5\u8be2\u5931\u8d25\uff01");
        }
        Map<String, List<SubComBudgetForecastVo>> budgetForecastListMap = subComBudgetForecastVoList.stream().collect(Collectors.groupingBy(f -> f.getYearMonthLy() + f.getFeeSourceCode()));
        SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM");
        List designDetailCodeList = designDetailList.stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).collect(Collectors.toList());
        List subComActivityDesignBudgetVos = this.subComActivityDesignBudgetService.listByActivityDetailCodes(designDetailCodeList);
        Map<String, List<SubComActivityDesignBudgetVo>> budgetMap = subComActivityDesignBudgetVos.stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetVo::getActivityDesignDetailCode));
        designDetailList.forEach(detailDto -> {
            if (RelationTypeEnum.NO_RELATION.getCode().equals(detailDto.getAssociationType()) && UndertakingModeTypeEnum.NO_ACCEPT.getCode().equals(detailDto.getUndertakingMode())) {
                String autoKey;
                List autoForecastVos;
                String internalKey;
                List internalForecastVos;
                SubComActivityDesignDetailModifyDto modifyDetailDto = (SubComActivityDesignDetailModifyDto)((Object)((Object)modifyDetailMap.get(detailDto.getActivityDesignDetailCode())));
                Validate.notNull((Object)detailDto.getFeeYearMonth(), (String)"\u660e\u7ec6\u7684\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                String feeYearMonth = sif.format(detailDto.getFeeYearMonth());
                String beginTime = sif.format(detailDto.getActivityBeginTime());
                Validate.isTrue((boolean)feeYearMonth.equals(beginTime), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u548c\u8d39\u7528\u5e74\u6708\u3001\u4f7f\u7528\u9884\u7b97\u7684\u5e74\u6708\u5c5e\u4e8e\u540c\u4e00\u6708\uff01", (Object[])new Object[0]);
                SubComBudgetForecastVo offPointForecast = null;
                SubComBudgetForecastVo internalForecast = null;
                SubComBudgetForecastVo autoForecast = null;
                String offPointKey = feeYearMonth + FeeSourceEnum.OFF_POINT_FEE.getCode();
                List offPointForecastVos = (List)budgetForecastListMap.get(offPointKey);
                if (CollectionUtils.isNotEmpty((Collection)offPointForecastVos)) {
                    offPointForecast = offPointForecastVos.stream().filter(f -> detailDto.getBudgetItemCode().equals(f.getBudgetItemCode())).findFirst().orElse(null);
                }
                if (CollectionUtils.isNotEmpty((Collection)(internalForecastVos = (List)budgetForecastListMap.get(internalKey = feeYearMonth + FeeSourceEnum.INTERNAL_POINT_FEE.getCode())))) {
                    internalForecast = internalForecastVos.stream().filter(f -> detailDto.getBudgetItemCode().equals(f.getBudgetItemCode())).findFirst().orElse(null);
                }
                if (CollectionUtils.isNotEmpty((Collection)(autoForecastVos = (List)budgetForecastListMap.get(autoKey = feeYearMonth + FeeSourceEnum.AUTO_FEE.getCode())))) {
                    autoForecast = autoForecastVos.stream().filter(f -> FeeSourceEnum.AUTO_FEE.getCode().equals(f.getFeeSourceCode())).findFirst().orElse(null);
                }
                if (Objects.isNull(offPointForecast) && Objects.isNull(internalForecast) && Objects.isNull(autoForecast)) {
                    throw new IllegalArgumentException("\u6839\u636e[\u5e74\u6708/\u4e1a\u6001/\u4e1a\u52a1\u5355\u5143/\u7ec4\u7ec7\u7f16\u7801/\u9884\u7b97\u9879\u76ee\u7f16\u7801'" + detailDto.getBudgetItemCode() + "']\uff0c\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u5206\u5b50\u9884\u7b97\u9884\u6d4b");
                }
                BigDecimal modifyTotalCost = Optional.ofNullable(modifyDetailDto.getTotalCost()).orElse(BigDecimal.ZERO);
                BigDecimal totalCost = Optional.ofNullable(detailDto.getTotalCost()).orElse(BigDecimal.ZERO);
                AtomicReference<BigDecimal> totalCostAmount = new AtomicReference<BigDecimal>(modifyTotalCost.subtract(totalCost));
                ArrayList<SubComActivityDesignBudgetModifyDto> budgetModifyList = new ArrayList<SubComActivityDesignBudgetModifyDto>();
                if (modifyTotalCost.compareTo(totalCost) > 0) {
                    this.makeBudgetDto(offPointForecast, totalCostAmount, null, budgetModifyList);
                    this.makeBudgetDto(internalForecast, totalCostAmount, null, budgetModifyList);
                    this.makeBudgetDto(autoForecast, totalCostAmount, null, budgetModifyList);
                } else {
                    List budgetVoList = budgetMap.getOrDefault(detailDto.getActivityDesignDetailCode(), Lists.newArrayList());
                    BigDecimal autoAmount = budgetVoList.stream().filter(item -> FeeSourceEnum.AUTO_FEE.getCode().equals(item.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    this.makeBudgetDto(autoForecast, totalCostAmount, autoAmount, budgetModifyList);
                    BigDecimal internalAmount = budgetVoList.stream().filter(item -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(item.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    this.makeBudgetDto(internalForecast, totalCostAmount, internalAmount, budgetModifyList);
                    BigDecimal offPointAmount = budgetVoList.stream().filter(item -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(item.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                    this.makeBudgetDto(offPointForecast, totalCostAmount, offPointAmount, budgetModifyList);
                }
                if (totalCostAmount.get().compareTo(BigDecimal.ZERO) > 0) {
                    throw new IllegalArgumentException("\u5e74\u6708[" + feeYearMonth + "]\u4e1a\u6001[" + dto.getBusinessFormatCode() + "]\u4e1a\u52a1\u5355\u5143[" + dto.getBusinessUnitCode() + "]\u7ec4\u7ec7\u7f16\u7801[" + dto.getOrgCode() + "]\u7ef4\u5ea6\u53ef\u7528\u9884\u7b97\u4e0d\u8db3");
                }
                modifyDetailDto.setBudgetModifyList(budgetModifyList);
            }
        });
    }

    public void makeBudgetDto(SubComBudgetForecastVo budgetForecast, AtomicReference<BigDecimal> totalCostAmount, BigDecimal maxReturn, List<SubComActivityDesignBudgetModifyDto> budgetModifyList) {
        BigDecimal totalCostAmountDecimal = totalCostAmount.get();
        if (Objects.isNull(budgetForecast) || totalCostAmountDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        SubComActivityDesignBudgetModifyDto budgetModifyDto = new SubComActivityDesignBudgetModifyDto();
        budgetModifyDto.setBudgetForecastCode(budgetForecast.getBudgetForecastCode());
        BigDecimal remainderAmount = Optional.ofNullable(budgetForecast.getRemainderAmount()).orElse(BigDecimal.ZERO);
        BigDecimal surplusWholeUndertakeAmt = Optional.ofNullable(budgetForecast.getSurplusWholeUndertakeAmt()).orElse(BigDecimal.ZERO);
        BigDecimal surplusPartUndertakeAmt = Optional.ofNullable(budgetForecast.getSurplusPartUndertakeAmt()).orElse(BigDecimal.ZERO);
        BigDecimal surAmount = remainderAmount.subtract(surplusWholeUndertakeAmt).subtract(surplusPartUndertakeAmt);
        if (totalCostAmountDecimal.compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal returnAmount = totalCostAmountDecimal;
            if (null != maxReturn && returnAmount.negate().compareTo(maxReturn) > 0) {
                returnAmount = maxReturn.negate();
            }
            totalCostAmount.set(totalCostAmountDecimal.subtract(returnAmount));
            budgetForecast.setDesignAmount(Optional.ofNullable(budgetForecast.getDesignAmount()).orElse(BigDecimal.ZERO).add(returnAmount));
            budgetForecast.setRemainderAmount(remainderAmount.subtract(returnAmount));
            budgetModifyDto.setBudgetAmount(returnAmount);
            budgetModifyDto.setIsAllDown(BooleanEnum.TRUE.getCapital());
        } else if (totalCostAmountDecimal.compareTo(surAmount) >= 0) {
            if (FeeSourceEnum.AUTO_FEE.getCode().equals(budgetForecast.getFeeSourceCode()) && !"A023".equals(budgetForecast.getBudgetItemCode())) {
                throw new IllegalArgumentException("\u9884\u7b97\u9879\u76ee[" + budgetForecast.getBudgetItemCode() + "]\uff0c\u8d39\u7528\u4e0d\u8db3\uff01");
            }
            totalCostAmount.set(totalCostAmountDecimal.subtract(surAmount));
            budgetForecast.setDesignAmount(Optional.ofNullable(budgetForecast.getDesignAmount()).orElse(BigDecimal.ZERO).add(surAmount));
            budgetForecast.setRemainderAmount(remainderAmount.subtract(surAmount));
            budgetModifyDto.setBudgetAmount(surAmount);
            budgetModifyDto.setIsAllDown(BooleanEnum.TRUE.getCapital());
        } else {
            budgetForecast.setDesignAmount(Optional.ofNullable(budgetForecast.getDesignAmount()).orElse(BigDecimal.ZERO).add(totalCostAmountDecimal));
            budgetForecast.setRemainderAmount(remainderAmount.subtract(totalCostAmountDecimal));
            budgetModifyDto.setBudgetAmount(totalCostAmountDecimal);
            budgetModifyDto.setIsAllDown(BooleanEnum.FALSE.getCapital());
            totalCostAmount.set(BigDecimal.ZERO);
        }
        budgetModifyDto.setBusinessFormatCode(budgetForecast.getBusinessFormatCode());
        budgetModifyDto.setYearMonthLy(budgetForecast.getYearMonthLy());
        budgetModifyDto.setBudgetItemCode(budgetForecast.getBudgetItemCode());
        budgetModifyDto.setBudgetItemName(budgetForecast.getBudgetItemName());
        budgetModifyDto.setFeeSourceCode(budgetForecast.getFeeSourceCode());
        budgetModifyDto.setBudgetForecastCode(budgetForecast.getBudgetForecastCode());
        budgetModifyList.add(budgetModifyDto);
    }

    private void divideExpenses(SubComActivityDesignModifyDto dto, List<SubComActivityDesignDetailModifyDto> itemList, Map<String, SubComActivityDesignDetailVo> designDetailVoMap) {
        if (Objects.isNull((Object)dto) || org.springframework.util.CollectionUtils.isEmpty(itemList) || org.springframework.util.CollectionUtils.isEmpty(designDetailVoMap)) {
            return;
        }
        ArrayList<SubComActivityDesignDetailModifyDto> modifyDetailDtoList = new ArrayList<SubComActivityDesignDetailModifyDto>();
        List relationModifyDto = itemList.stream().filter(i -> RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(i.getAssociationType())).collect(Collectors.toList());
        for (SubComActivityDesignDetailModifyDto modifyDetailDto2 : relationModifyDto) {
            BigDecimal totalCost;
            SubComActivityDesignDetailVo designDetailVo = designDetailVoMap.get(modifyDetailDto2.getActivityDesignDetailCode());
            if (Objects.isNull(designDetailVo) || !RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(designDetailVo.getAssociationType())) continue;
            BigDecimal modifyTotalCost = Optional.ofNullable(modifyDetailDto2.getTotalCost()).orElse(BigDecimal.ZERO);
            BigDecimal diffAmount = modifyTotalCost.subtract(totalCost = Optional.ofNullable(designDetailVo.getTotalCost()).orElse(BigDecimal.ZERO));
            if (diffAmount.compareTo(BigDecimal.ZERO) == 0) {
                log.info("\u89c4\u5212\u53d8\u66f4,\u2018\u5411\u4e0a\u5173\u8054\u7ec6\u6848\u2019\u89c4\u5212,\u8d39\u7528\u672a\u53d8\u66f4,\u65e0\u9700\u5212\u5206\u8d39\u7528");
                continue;
            }
            if (diffAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            modifyDetailDtoList.add(modifyDetailDto2);
        }
        if (org.springframework.util.CollectionUtils.isEmpty(modifyDetailDtoList)) {
            return;
        }
        HashSet budgetItemCodeSet = new HashSet();
        modifyDetailDtoList.forEach(detail -> {
            if (CollectionUtils.isNotEmpty((Collection)detail.getBudgetList())) {
                Set budgetItemCodes = detail.getBudgetList().stream().map(SubComActivityDesignBudgetDto::getBudgetItemCode).filter(Objects::nonNull).collect(Collectors.toSet());
                budgetItemCodeSet.addAll(budgetItemCodes);
            }
        });
        Set yearMonthSet = modifyDetailDtoList.stream().map(i -> DateUtil.format((Date)i.getFeeYearMonth(), (String)"yyyy-MM")).collect(Collectors.toSet());
        List budgetItemMainItemVos = this.budgetItemMainItemService.listByMainBudgetItemCodeList(new ArrayList(budgetItemCodeSet));
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setYearMonthList(new ArrayList(yearMonthSet));
        subComBudgetForecastDto.setOrgCode(dto.getOrgCode());
        subComBudgetForecastDto.setBusinessFormatCode(dto.getBusinessFormatCode());
        subComBudgetForecastDto.setBusinessUnitCode(dto.getBusinessUnitCode());
        List subComBudgetForecastVoList = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        if (CollectionUtils.isEmpty((Collection)subComBudgetForecastVoList)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u9884\u7b97\u9884\u6d4b\u67e5\u8be2\u5931\u8d25\uff01");
        }
        Map<String, List<SubComBudgetForecastVo>> budgetForecastListMap = subComBudgetForecastVoList.stream().collect(Collectors.groupingBy(f -> f.getYearMonthLy() + f.getBudgetItemCode() + f.getFeeSourceCode()));
        modifyDetailDtoList.forEach(modifyDetailDto -> {
            SubComActivityDesignDetailVo designDetail = (SubComActivityDesignDetailVo)designDetailVoMap.get(modifyDetailDto.getActivityDesignDetailCode());
            String undertakingMode = designDetail.getUndertakingMode();
            Validate.isTrue((boolean)UndertakingModeTypeEnum.contains((String)undertakingMode), (String)"\u672a\u77e5\u7684\u627f\u63a5\u65b9\u5f0f", (Object[])new Object[0]);
            Validate.notNull((Object)designDetail.getActivityBeginTime(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            String beginTime = DateUtil.format((Date)designDetail.getActivityBeginTime(), (String)"yyyy-MM");
            if (org.springframework.util.CollectionUtils.isEmpty(modifyDetailDto.getBudgetModifyList())) {
                return;
            }
            modifyDetailDto.getBudgetModifyList().forEach(budget -> {
                boolean b2;
                BudgetItemMainItemVo budgetItemMainItemVo = budgetItemMainItemVos.stream().filter(b -> b.getMainBudgetItemCode().equals(budget.getBudgetItemCode())).findFirst().orElse(null);
                boolean bl = b2 = !FeeSourceEnum.AUTO_FEE.getCode().equals(budget.getFeeSourceCode());
                if (null == budgetItemMainItemVo && b2) {
                    throw new RuntimeException("\u672a\u67e5\u8be2\u5230,\u6d3b\u52a8\u7ec6\u6848" + budget.getPlanDetailCode() + "\u5173\u8054\u7684\u5206\u5b50\u9884\u7b97\u9879\u76ee");
                }
                String budgetItemCode = b2 ? budgetItemMainItemVo.getBudgetItemCode() : budget.getBudgetItemCode();
                String key = budget.getYearMonthLy() + budgetItemCode + budget.getFeeSourceCode();
                List subComBudgetForecastVos = (List)budgetForecastListMap.get(key);
                Validate.notEmpty((Collection)subComBudgetForecastVos, (String)("\u672a\u67e5\u8be2\u5230,\u6d3b\u52a8\u7ec6\u6848" + budget.getPlanDetailCode() + "\u5173\u8054\u7684\u9884\u7b97\u9884\u6d4b"), (Object[])new Object[0]);
                SubComBudgetForecastVo subComBudgetForecastVo = subComBudgetForecastVos.stream().filter(Objects::nonNull).findFirst().orElse(null);
                if (null == subComBudgetForecastVo) {
                    throw new RuntimeException("\u672a\u67e5\u8be2\u5230,\u6d3b\u52a8\u7ec6\u6848" + budget.getPlanDetailCode() + "\u5173\u8054\u7684\u9884\u7b97\u9884\u6d4b");
                }
                budget.setBudgetForecastCode(subComBudgetForecastVo.getBudgetForecastCode());
                Validate.isTrue((boolean)beginTime.equals(subComBudgetForecastVo.getYearMonthLy()), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u548c\u8d39\u7528\u6240\u5c5e\u5e74\u6708\u4e3a\u540c\u4e00\u6708\uff01", (Object[])new Object[0]);
                if (!FeeSourceEnum.AUTO_FEE.getCode().equals(subComBudgetForecastVo.getFeeSourceCode())) {
                    BigDecimal budgetAmount;
                    if (UndertakingModeTypeEnum.FULL_ACCEPT.getCode().equals(designDetail.getUndertakingMode())) {
                        BigDecimal surplusWholeUndertakeAmt = Optional.ofNullable(subComBudgetForecastVo.getSurplusWholeUndertakeAmt()).orElse(BigDecimal.ZERO);
                        if (surplusWholeUndertakeAmt.compareTo(budgetAmount = Optional.ofNullable(budget.getBudgetAmount()).orElse(BigDecimal.ZERO)) < 0) {
                            throw new IllegalArgumentException("\u6d3b\u52a8\u7ec6\u6848[" + budget.getPlanDetailCode() + "],\u5173\u8054\u7684\u9884\u7b97\u9884\u6d4b[" + budgetItemMainItemVo.getBudgetItemCode() + "]\uff0c\u5269\u4f59\u5b8c\u5168\u627f\u63a5\u8d39\u7528\u4e0d\u8db3");
                        }
                        subComBudgetForecastVo.setSurplusWholeUndertakeAmt(surplusWholeUndertakeAmt.subtract(budgetAmount));
                    }
                    if (UndertakingModeTypeEnum.PART_ACCEPT.getCode().equals(designDetail.getUndertakingMode())) {
                        BigDecimal surplusPartUndertakeAmt = Optional.ofNullable(subComBudgetForecastVo.getSurplusPartUndertakeAmt()).orElse(BigDecimal.ZERO);
                        if (surplusPartUndertakeAmt.compareTo(budgetAmount = Optional.ofNullable(budget.getBudgetAmount()).orElse(BigDecimal.ZERO)) < 0) {
                            throw new IllegalArgumentException("\u6d3b\u52a8\u7ec6\u6848[" + budget.getPlanDetailCode() + "],\u5173\u8054\u7684\u9884\u7b97\u9884\u6d4b[" + budgetItemMainItemVo.getBudgetItemCode() + "]\uff0c\u5269\u4f59\u90e8\u5206\u627f\u63a5\u8d39\u7528\u4e0d\u8db3");
                        }
                        subComBudgetForecastVo.setSurplusPartUndertakeAmt(surplusPartUndertakeAmt.subtract(budgetAmount));
                    }
                } else {
                    BigDecimal budgetAmount;
                    BigDecimal remainderAmount = Optional.ofNullable(subComBudgetForecastVo.getRemainderAmount()).orElse(BigDecimal.ZERO);
                    if (remainderAmount.compareTo(budgetAmount = Optional.ofNullable(budget.getBudgetAmount()).orElse(BigDecimal.ZERO)) < 0 && !"A023".equals(budget.getBudgetItemCode())) {
                        throw new IllegalArgumentException("\u9884\u7b97\u9884\u6d4b[" + budget.getBudgetItemCode() + "]\uff0c\u5269\u4f59\u8d39\u7528\u4e0d\u8db3");
                    }
                    subComBudgetForecastVo.setRemainderAmount(remainderAmount.subtract(budgetAmount));
                }
            });
        });
    }

    private Map<String, SubComActivityDesignDetailVo> createValidate(SubComActivityDesignModifyDto dto, List<SubComActivityDesignDetailModifyDto> itemList) {
        Validate.notEmpty(itemList, (String)"\u53d8\u66f4\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Map<String, List<SubComActivityDesignDetailModifyDto>> modifyItemDtoMap = itemList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailDto::getActivityDesignDetailCode));
        modifyItemDtoMap.forEach((k, v) -> Validate.isTrue((!org.springframework.util.CollectionUtils.isEmpty((Collection)v) && v.size() == 1 ? 1 : 0) != 0, (String)("[" + k + "]\u540c\u4e00\u6d3b\u52a8\uff0c\u4e0d\u53ef\u540c\u65f6\u5b58\u5728\u591a\u4e2a\u53d8\u66f4"), (Object[])new Object[0]));
        List<String> activityDetailCodes = itemList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).filter(Objects::nonNull).collect(Collectors.toList());
        Validate.notEmpty(activityDetailCodes, (String)"\u53d8\u66f4\u7684\u6d3b\u52a8\u89c4\u5212\u660e\u7ec6\u7f16\u7801\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<SubComActivityDesignDetailModifyVo> modifyEntityList = this.subComActivityDesignDetailModifyService.findSameModifyActivityByDesignDetailCode(activityDetailCodes);
        if (StringUtils.isNotEmpty((CharSequence)dto.getModifyCode())) {
            modifyEntityList = modifyEntityList.stream().filter(item -> !dto.getModifyCode().equals(item.getModifyCode())).collect(Collectors.toList());
        }
        if (!org.springframework.util.CollectionUtils.isEmpty(modifyEntityList)) {
            Map<String, List<SubComActivityDesignDetailModifyVo>> modifyEntityMap = modifyEntityList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailModifyVo::getModifyCode));
            StringBuilder str = new StringBuilder("");
            modifyEntityMap.forEach((k, v) -> {
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)v)) {
                    List codes = v.stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).distinct().collect(Collectors.toList());
                    str.append("\u5df2\u5b58\u5728\u53d8\u66f4\u9879\u3010" + k + "\u3011,\u672a\u5ba1\u6279\u901a\u8fc7\u89c4\u5212\u3010" + codes + "\u3011\u7684\u53d8\u66f4\u5185\u5bb9\u3002");
                }
            });
            str.append("\u8bf7\u5f85\u5ba1\u6279\u901a\u8fc7\u540e\u6216\u5220\u9664\u672a\u5b8c\u6210\u7684\u53d8\u66f4\u9879\u540e\uff0c\u624d\u53ef\u5f00\u542f\u65b0\u7684\u53d8\u66f4");
            throw new IllegalArgumentException(str.toString());
        }
        List designDetailCodes = itemList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).distinct().collect(Collectors.toList());
        List designDetailVos = this.subComActivityDesignDetailService.findDetailByDetailCodes(designDetailCodes);
        Validate.notEmpty((Collection)designDetailVos, (String)"\u67e5\u8be2\u8981\u53d8\u66f4\u7684\u6d3b\u52a8\u89c4\u5212\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Map<String, SubComActivityDesignDetailVo> designDetailVoMap = designDetailVos.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity()));
        List activityNumberList = itemList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).collect(Collectors.toList());
        List indicatorList = this.auditExecuteIndicatorService.findByCodeList(activityNumberList, IndicatorNameEnum.SAP_INCURRED.getCode());
        Map<String, BigDecimal> sapIncurredMap = indicatorList.stream().collect(Collectors.toMap(AuditExecuteIndicatorVo::getActiveNumber, AuditExecuteIndicatorVo::getIndicatorValue, (o, n) -> n));
        for (SubComActivityDesignDetailModifyDto modifyItem : itemList) {
            String activityDesignDetailCode = modifyItem.getActivityDesignDetailCode();
            SubComActivityDesignDetailVo designDetailVo = designDetailVoMap.get(activityDesignDetailCode);
            Validate.notNull((Object)designDetailVo, (String)("\u672a\u67e5\u8be2\u5230\u8981\u53d8\u66f4\u7684\u6d3b\u52a8\u3010" + activityDesignDetailCode + "\u3011"), (Object[])new Object[0]);
            if (UndertakingModeTypeEnum.FULL_ACCEPT.getCode().equals(designDetailVo.getUndertakingMode())) {
                if (!StringUtils.isBlank((CharSequence)designDetailVo.getProductCode())) {
                    Validate.isTrue((boolean)designDetailVo.getProductCode().equals(modifyItem.getProductCode()), (String)(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u4ea7\u54c1\u7f16\u7801\u4e0d\u53ef\u66f4\u6539"), (Object[])new Object[0]);
                    Validate.isTrue((boolean)designDetailVo.getProductName().equals(modifyItem.getProductName()), (String)(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u53ef\u66f4\u6539"), (Object[])new Object[0]);
                } else {
                    Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)modifyItem.getProductCode()), (String)(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u4ea7\u54c1\u4e0d\u53ef\u66f4\u6539"), (Object[])new Object[0]);
                    Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)modifyItem.getProductName()), (String)(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u4ea7\u54c1\u540d\u79f0\u4e0d\u53ef\u66f4\u6539"), (Object[])new Object[0]);
                }
                if (!Objects.isNull(designDetailVo.getActivityBeginTime())) {
                    Validate.isTrue((designDetailVo.getActivityBeginTime().compareTo(modifyItem.getActivityBeginTime()) == 0 ? 1 : 0) != 0, (String)(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u66f4\u6539"), (Object[])new Object[0]);
                } else if (!Objects.isNull(modifyItem.getActivityBeginTime())) {
                    throw new IllegalArgumentException(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u66f4\u6539");
                }
                if (!Objects.isNull(designDetailVo.getActivityEndTime())) {
                    Validate.isTrue((designDetailVo.getActivityEndTime().compareTo(modifyItem.getActivityEndTime()) == 0 ? 1 : 0) != 0, (String)(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u66f4\u6539"), (Object[])new Object[0]);
                } else if (!Objects.isNull(modifyItem.getActivityEndTime())) {
                    throw new IllegalArgumentException(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u66f4\u6539");
                }
                if (!Objects.isNull(designDetailVo.getOrderStartDate())) {
                    Validate.isTrue((designDetailVo.getOrderStartDate().compareTo(modifyItem.getOrderStartDate()) == 0 ? 1 : 0) != 0, (String)(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u8ba2\u5355\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u66f4\u6539"), (Object[])new Object[0]);
                } else if (!Objects.isNull(modifyItem.getActivityEndTime())) {
                    throw new IllegalArgumentException(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u8ba2\u5355\u5f00\u59cb \u65f6\u95f4\u4e0d\u53ef\u66f4\u6539");
                }
                if (!Objects.isNull(designDetailVo.getOrderEndDate())) {
                    Validate.isTrue((designDetailVo.getOrderStartDate().compareTo(modifyItem.getOrderEndDate()) == 0 ? 1 : 0) != 0, (String)(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u8ba2\u5355\u5f00\u59cb\u65f6\u95f4\u4e0d\u53ef\u66f4\u6539"), (Object[])new Object[0]);
                } else if (!Objects.isNull(modifyItem.getOrderEndDate())) {
                    throw new IllegalArgumentException(activityDesignDetailCode + "\u4e3a\u5b8c\u5168\u627f\u63a5\uff0c\u8ba2\u5355\u7ed3\u675f\u65f6\u95f4\u4e0d\u53ef\u66f4\u6539");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)designDetailVo.getCustomerCode())) {
                if (!designDetailVo.getCustomerCode().equals(modifyItem.getCustomerCode())) {
                    Validate.isTrue((boolean)TotalQuantityOrNotEnum.Z.getCode().equals(designDetailVo.getIsSupplyAmount()), (String)"\u516c\u7528\u91cf\u4e3a'Z'\u7c7b\u578b\uff0c\u624d\u53ef\u53d8\u66f4\u5ba2\u6237", (Object[])new Object[0]);
                }
            } else if (StringUtils.isNotBlank((CharSequence)modifyItem.getCustomerCode())) {
                Validate.isTrue((boolean)TotalQuantityOrNotEnum.Z.getCode().equals(designDetailVo.getIsSupplyAmount()), (String)"\u516c\u7528\u91cf\u4e3a'Z'\u7c7b\u578b\uff0c\u624d\u53ef\u53d8\u66f4\u5ba2\u6237", (Object[])new Object[0]);
            }
            BigDecimal sapIncurred = sapIncurredMap.getOrDefault(modifyItem.getActivityDesignDetailCode(), BigDecimal.ZERO);
            if (modifyItem.getTotalCost().compareTo(sapIncurred) >= 0) continue;
            throw new RuntimeException("[" + modifyItem.getActivityDesignDetailCode() + "]\u8d39\u7528\u5408\u8ba1\u201d\u53d8\u66f4\u540e\u7684\u503c\u4e0d\u5f97\u5c0f\u4e8e\u8be5\u6761\u6d3b\u52a8\u7684\u201c\u5df2\u53d1\u751f\u989d\u201d[" + sapIncurred + "]");
        }
        return designDetailVoMap;
    }

    @Override
    public SubComActivityDesignModifyVo findByIdOrProcessNo(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        SubComActivityDesignModify entity = null;
        entity = (SubComActivityDesignModify)((Object)this.subComActivityDesignModifyRepository.getById((Serializable)((Object)id)));
        if (Objects.isNull((Object)entity)) {
            entity = this.subComActivityDesignModifyRepository.findByProcessNo(id);
        }
        if (!Objects.isNull((Object)entity)) {
            SubComActivityDesignModifyVo modifyVo = (SubComActivityDesignModifyVo)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, SubComActivityDesignModifyVo.class, HashSet.class, ArrayList.class, new String[0]));
            SubComActivityDesignModifyDiffVo diffVo = this.subComActivityDesignModifyDiffService.findByModifyCode(modifyVo.getModifyCode());
            modifyVo.setDiff(diffVo);
            return modifyVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submit(SubComActivityDesignModifyDto dto, boolean saveSubmitFlag) {
        if (!saveSubmitFlag) {
            Validate.notNull((Object)((Object)dto), (String)"\u6d41\u7a0b\u8868\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            SubComActivityDesignModify entity = (SubComActivityDesignModify)((Object)this.subComActivityDesignModifyRepository.getById((Serializable)((Object)dto.getId())));
            Validate.notNull((Object)((Object)entity), (String)"\u5b9e\u4f8b\u5bf9\u8c61\u4e0d\u5b58\u5728\uff01\uff01", (Object[])new Object[0]);
            if (!(ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()))) {
                throw new RuntimeException("\u5206\u5b50\u53d8\u66f4\u89c4\u5212[" + entity.getModifyCode() + "]\u4e0d\u5904\u4e8e\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u3001\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
            }
            dto.setModifyCode(entity.getModifyCode());
            dto.setPlanModifyName(entity.getPlanModifyName());
        }
        Validate.notNull((Object)((Object)dto), (String)"\u63d0\u4ea4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getModifyCode(), (String)"\u53d8\u66f4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<SubComActivityDesignBudgetModify> subComActivityDesignBudgetModifies = this.subComActivityDesignBudgetModifyRepository.listByModifyCode(dto.getModifyCode());
        this.subComActivityDesignDetailModifyService.useSubComBudgetForecast(subComActivityDesignBudgetModifies);
        this.commitProcess(dto);
    }

    private void commitProcess(SubComActivityDesignModifyDto dto) {
        ProcessBusinessDto processBusiness = dto.getProcessBusiness();
        Validate.notNull((Object)processBusiness, (String)"\u63d0\u4ea4\u5de5\u4f5c\u6d41\u65f6\uff0c\u672a\u4f20\u5de5\u4f5c\u6d41\u5bf9\u8c61\u4fe1\u606f!", (Object[])new Object[0]);
        processBusiness.setBusinessNo(dto.getModifyCode());
        processBusiness.setBusinessFormJson(JsonUtils.obj2JsonString((Object)((Object)dto)));
        processBusiness.setBusinessCode("ACTIVITY_CONST_DESIGN_DETAIL_MODIFY_PROCESS_CODE");
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        dto.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        this.subComActivityDesignModifyRepository.updateProcessStatusAndProcessNo(dto.getModifyCode(), ProcessStatusEnum.COMMIT.getKey(), processBusinessVo.getProcessNo());
    }

    @Override
    public void processPass(ProcessStatusDto dto) {
        this.subComActivityDesignModifyRepository.updateProcessStatus(dto.getBusinessNo(), dto.getProcessStatus());
    }

    @Override
    public void processRejectAndRecover(ProcessStatusDto dto) {
        this.subComActivityDesignModifyRepository.updateProcessStatus(dto.getBusinessNo(), dto.getProcessStatus());
        List<SubComActivityDesignBudgetModify> subComActivityDesignBudgetModifies = this.subComActivityDesignBudgetModifyRepository.listByModifyCode(dto.getBusinessNo());
        this.subComActivityDesignDetailModifyService.returnSubComBudgetForecast(subComActivityDesignBudgetModifies);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = this.subComActivityDesignModifyRepository.listByIds(ids);
        for (SubComActivityDesignModify entity : list) {
            Validate.isTrue((ProcessStatusEnum.PREPARE.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(entity.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(entity.getProcessStatus()) ? 1 : 0) != 0, (String)("\u5206\u5b50\u516c\u53f8\u53d8\u66f4\u89c4\u5212[" + entity.getModifyCode() + "]\u4e0d\u662f\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u6216\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01"), (Object[])new Object[0]);
        }
        this.subComActivityDesignModifyRepository.deleteByIds(ids);
        List<String> modifyCodeList = list.stream().map(SubComActivityDesignModify::getModifyCode).collect(Collectors.toList());
        this.subComActivityDesignDetailModifyService.deleteByModifyCodeList(modifyCodeList);
        this.subComActivityDesignBudgetModifyService.deleteByModifyCodeList(modifyCodeList);
    }

    @Override
    public SubComActivityDesignModifyDiffVo sumDiffDetail(String cacheKey) {
        List itemList = this.subComActivityDesignDetailModifyService.findCacheList(cacheKey);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)itemList)) {
            throw new RuntimeException("\u5206\u5b50\u516c\u53f8\u6d3b\u52a8\u89c4\u5212\u53d8\u66f4\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List designDetailCodes = itemList.stream().map(SubComActivityDesignDetailDto::getActivityDesignDetailCode).filter(Objects::nonNull).collect(Collectors.toList());
        List designDetailVos = this.subComActivityDesignDetailService.findDetailByDetailCodes(designDetailCodes);
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)designDetailVos)) {
            throw new IllegalArgumentException("\u4e3a\u67e5\u8be2\u5230\u8981\u53d8\u66f4\u7684\u660e\u7ec6");
        }
        BigDecimal promoteSalesAfter = itemList.stream().map(SubComActivityDesignDetailDto::getPromoteSales).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal promoteSales = designDetailVos.stream().map(SubComActivityDesignDetailVo::getPromoteSales).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCostAfter = itemList.stream().map(SubComActivityDesignDetailDto::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalCost = designDetailVos.stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal promotionAmountAfter = itemList.stream().map(SubComActivityDesignDetailDto::getPromotionAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal promotionAmount = designDetailVos.stream().map(SubComActivityDesignDetailVo::getPromotionAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        SubComActivityDesignModifyDiffVo diffVo = new SubComActivityDesignModifyDiffVo();
        diffVo.setPromoteSales(promoteSales);
        diffVo.setPromoteSalesAfter(promoteSalesAfter);
        diffVo.setTotalCost(totalCost);
        diffVo.setTotalCostAfter(totalCostAfter);
        diffVo.setPromoteSalesDiff(promoteSales.subtract(promoteSalesAfter));
        diffVo.setTotalCostDiff(totalCost.subtract(totalCostAfter));
        diffVo.setCostEffectivenessRatio(BigDecimal.ZERO.compareTo(promotionAmount) != 0 ? totalCost.divide(promotionAmount, 2, 4) : BigDecimal.ZERO);
        diffVo.setCostEffectivenessRatioAfter(BigDecimal.ZERO.compareTo(promotionAmountAfter) != 0 ? totalCostAfter.divide(promotionAmountAfter, 2, 4) : BigDecimal.ZERO);
        diffVo.setCostEffectivenessRatioDiff(diffVo.getCostEffectivenessRatio().subtract(diffVo.getCostEffectivenessRatioAfter()));
        return diffVo;
    }
}

